/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring;

import java.util.Collection;
import java.util.List;
import org.activiti.api.model.shared.event.RuntimeEvent;
import org.activiti.api.process.model.ProcessDefinition;
import org.activiti.api.process.model.events.ProcessDeployedEvent;
import org.activiti.api.process.runtime.events.listener.ProcessRuntimeEventListener;
import org.activiti.api.runtime.event.impl.ProcessDeployedEventImpl;
import org.activiti.engine.RepositoryService;
import org.activiti.runtime.api.model.impl.APIProcessDefinitionConverter;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class ProcessDeployedEventProducer
implements ApplicationListener<ApplicationReadyEvent> {
    private RepositoryService repositoryService;
    private APIProcessDefinitionConverter converter;
    private List<ProcessRuntimeEventListener<ProcessDeployedEvent>> listeners;

    public ProcessDeployedEventProducer(RepositoryService repositoryService, APIProcessDefinitionConverter converter, List<ProcessRuntimeEventListener<ProcessDeployedEvent>> listeners) {
        this.repositoryService = repositoryService;
        this.converter = converter;
        this.listeners = listeners;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (!WebApplicationType.NONE.equals((Object)event.getSpringApplication().getWebApplicationType())) {
            List processDefinitions = this.converter.from((Collection)this.repositoryService.createProcessDefinitionQuery().list());
            for (ProcessDefinition processDefinition : processDefinitions) {
                ProcessDeployedEventImpl processDeployedEvent = new ProcessDeployedEventImpl(processDefinition);
                for (ProcessRuntimeEventListener<ProcessDeployedEvent> listener : this.listeners) {
                    listener.onEvent((RuntimeEvent)processDeployedEvent);
                }
            }
        }
    }
}

