/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.type.init;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.anyline.adapter.KeyAdapter;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.geometry.LineString;
import org.anyline.entity.geometry.MultiPoint;
import org.anyline.entity.geometry.MultiPolygon;
import org.anyline.entity.geometry.Point;
import org.anyline.entity.geometry.Polygon;
import org.anyline.entity.geometry.Ring;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.proxy.ConvertProxy;
import org.anyline.util.Base64Util;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.DateUtil;

public enum StandardTypeMetadata implements TypeMetadata
{
    CHAR(TypeMetadata.CATEGORY.CHAR, "CHAR", null, String.class, 0, 1, 1, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.PostgreSQL, DatabaseType.Informix, DatabaseType.HANA, DatabaseType.Derby, DatabaseType.Doris}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            String str;
            if (null == value) {
                value = def;
            }
            if (null != value && BasicUtil.checkEl(str = value.toString())) {
                value = str.substring(2, str.length() - 1);
                return value;
            }
            if (!(value instanceof String)) {
                value = value instanceof java.util.Date ? DateUtil.format((java.util.Date)value) : value.toString();
            }
            if (!placeholder.booleanValue()) {
                value = "'" + value + "'";
            }
            return value;
        }
    }
    ,
    NCHAR(TypeMetadata.CATEGORY.CHAR, "NCHAR", null, String.class, 0, 1, 1, new DatabaseType[]{DatabaseType.ORACLE, DatabaseType.MSSQL, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    CLOB(TypeMetadata.CATEGORY.TEXT, "CLOB", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ORACLE, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.Derby, DatabaseType.KingBase}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    NCLOB(TypeMetadata.CATEGORY.TEXT, "NCLOB", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ORACLE, DatabaseType.HANA}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    NVARCHAR(TypeMetadata.CATEGORY.CHAR, "NVARCHAR", null, String.class, 0, 1, 1, new DatabaseType[]{DatabaseType.MSSQL, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.HANA, DatabaseType.KingBase}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    LVARCHAR(TypeMetadata.CATEGORY.CHAR, "LVARCHAR", null, String.class, 0, 1, 1, new DatabaseType[]{DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.SinoDB}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    NVARCHAR2(TypeMetadata.CATEGORY.CHAR, "NVARCHAR2", (TypeMetadata)NVARCHAR, String.class, 0, 1, 1, new DatabaseType[]{DatabaseType.ORACLE}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    LONGTEXT(TypeMetadata.CATEGORY.TEXT, "LONGTEXT", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    MEDIUMTEXT(TypeMetadata.CATEGORY.TEXT, "MEDIUMTEXT", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    TEXT(TypeMetadata.CATEGORY.TEXT, "TEXT", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.PostgreSQL, DatabaseType.SQLite, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.IoTDB, DatabaseType.KingBase}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    MATCH_ONLY_TEXT(TypeMetadata.CATEGORY.TEXT, "match_only_text", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ElasticSearch}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    NTEXT(TypeMetadata.CATEGORY.TEXT, "NTEXT", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MSSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    TINYTEXT(TypeMetadata.CATEGORY.TEXT, "TINYTEXT", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    ACLITEM(TypeMetadata.CATEGORY.TEXT, "ACLITEM", null, String.class, 1, 1, 1, DatabaseType.KingBase),
    VARCHAR(TypeMetadata.CATEGORY.CHAR, "VARCHAR", null, String.class, 0, 1, 1, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.PostgreSQL, DatabaseType.ORACLE, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.HANA, DatabaseType.Derby, DatabaseType.KingBase, DatabaseType.Doris}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    VARCHAR2(TypeMetadata.CATEGORY.CHAR, "VARCHAR2", (TypeMetadata)VARCHAR, String.class, 0, 1, 1, new DatabaseType[]{DatabaseType.ORACLE, DatabaseType.KingBase, DatabaseType.DM, DatabaseType.oscar}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    SYSNAME(TypeMetadata.CATEGORY.TEXT, "SYSNAME", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MSSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    UUID(TypeMetadata.CATEGORY.TEXT, "UUID", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.PostgreSQL, DatabaseType.KingBase}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            if (null == value) {
                value = def;
            }
            if (null != value) {
                value = java.util.UUID.fromString(value.toString());
            }
            if (null == value) {
                value = def;
            }
            return value;
        }
    }
    ,
    UNIQUEIDENTIFIER(TypeMetadata.CATEGORY.TEXT, "UNIQUEIDENTIFIER", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MSSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    BINARY(TypeMetadata.CATEGORY.BYTES, "BINARY", null, byte[].class, 0, 1, 1, DatabaseType.MySQL, DatabaseType.MSSQL, DatabaseType.HANA, DatabaseType.ElasticSearch),
    VARBINARY(TypeMetadata.CATEGORY.BYTES, "VARBINARY", null, byte[].class, 0, 1, 1, DatabaseType.MySQL, DatabaseType.MSSQL, DatabaseType.HANA),
    STRING(TypeMetadata.CATEGORY.TEXT, "String", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.Doris, DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    FixedString(TypeMetadata.CATEGORY.TEXT, "FixedString", null, String.class, 0, 1, 1, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    FIXED_STRING(TypeMetadata.CATEGORY.TEXT, "FIXED_STRING", null, String.class, 0, 1, 1, new DatabaseType[]{DatabaseType.Nebula}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    HLL(TypeMetadata.CATEGORY.TEXT, "HLL", null, String.class, 0, 1, 1, new DatabaseType[]{DatabaseType.Doris}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return CHAR.write(value, def, placeholder);
        }
    }
    ,
    JSON(TypeMetadata.CATEGORY.TEXT, "JSON", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.PostgreSQL, DatabaseType.KingBase, DatabaseType.Doris}){

        @Override
        public Object convert(Object value, Class target, Object def) {
            if (null == value) {
                return def;
            }
            Class transfer = this.transfer();
            Class compatible = this.compatible();
            try {
                JsonNode node;
                value = null == target ? ((node = BeanUtil.JSON_MAPPER.readTree(value.toString())).isArray() ? DataSet.parseJson(KeyAdapter.KEY_CASE.SRC, node) : DataRow.parseJson(KeyAdapter.KEY_CASE.SRC, node)) : super.convert(value, target, def);
            }
            catch (Exception e) {
                value = super.convert(value, target, def);
            }
            return value;
        }

        @Override
        public Object read(Object value, Object def, Class clazz) {
            if (null == value) {
                return value;
            }
            if (value.getClass() == clazz) {
                return value;
            }
            String str = ((Object)value).toString().trim();
            try {
                JsonNode node = BeanUtil.JSON_MAPPER.readTree(str);
                if (null == clazz) {
                    if (node.isArray()) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        Iterator items = node.iterator();
                        boolean isDataRow = true;
                        while (items.hasNext()) {
                            JsonNode item = (JsonNode)items.next();
                            Object row = DataRow.parseJsonObject(KeyAdapter.KEY_CASE.SRC, item);
                            if (!(row instanceof DataRow)) {
                                isDataRow = false;
                            }
                            list.add(row);
                        }
                        value = isDataRow ? DataSet.parse(KeyAdapter.KEY_CASE.SRC, list, new String[0]) : list;
                    } else {
                        value = DataRow.parseJson(KeyAdapter.KEY_CASE.SRC, node);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return value;
        }
    }
    ,
    XML(TypeMetadata.CATEGORY.TEXT, "XML", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MSSQL, DatabaseType.KingBase}){}
    ,
    BIT_INT(TypeMetadata.CATEGORY.INT, "BIT", null, Integer.class, 1, 1, 1, DatabaseType.MSSQL),
    BIT_BOOLEAN(TypeMetadata.CATEGORY.BOOLEAN, "BIT", null, Boolean.class, 1, 1, 1, DatabaseType.MySQL),
    BITMAP(TypeMetadata.CATEGORY.BYTES, "BITMAP", null, Byte.class, 1, 1, 1, DatabaseType.Doris),
    VARBIT(TypeMetadata.CATEGORY.BOOLEAN, "VARBIT", null, Byte[].class, 1, 1, 1, DatabaseType.PostgreSQL),
    SHORT(TypeMetadata.CATEGORY.INT, "SHORT", null, Short.class, 1, 1, 1, new DatabaseType[0]),
    BYTE(TypeMetadata.CATEGORY.INT, "BYTE", null, Short.class, 1, 1, 1, new DatabaseType[0]),
    INT2(TypeMetadata.CATEGORY.INT, "INT2", null, Short.class, 1, 1, 1, new DatabaseType[0]),
    INT4(TypeMetadata.CATEGORY.INT, "INT4", null, Integer.class, 1, 1, 1, new DatabaseType[0]),
    INT8(TypeMetadata.CATEGORY.INT, "INT8", null, Short.class, 1, 1, 1, DatabaseType.MySQL, DatabaseType.MSSQL, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.Derby, DatabaseType.Doris),
    INT16(TypeMetadata.CATEGORY.INT, "INT16", null, Short.class, 1, 1, 1, DatabaseType.IoTDB, DatabaseType.ClickHouse),
    INT(TypeMetadata.CATEGORY.INT, "INT", null, Integer.class, 1, 1, 1, DatabaseType.IoTDB, DatabaseType.ClickHouse),
    INT32(TypeMetadata.CATEGORY.INT, "INT", null, Integer.class, 1, 1, 1, DatabaseType.IoTDB, DatabaseType.ClickHouse),
    INT64(TypeMetadata.CATEGORY.INT, "INT64", null, Long.class, 1, 1, 1, DatabaseType.IoTDB, DatabaseType.ClickHouse),
    INT128(TypeMetadata.CATEGORY.INT, "INT128", null, Long.class, 1, 1, 1, DatabaseType.ClickHouse),
    INT256(TypeMetadata.CATEGORY.INT, "INT256", null, Long.class, 1, 1, 1, DatabaseType.ClickHouse),
    LONG_TEXT(TypeMetadata.CATEGORY.TEXT, "LONG", null, String.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ORACLE, DatabaseType.ElasticSearch}){}
    ,
    BIGINT(TypeMetadata.CATEGORY.INT, "BIGINT", null, Long.class, 1, 1, 1, DatabaseType.MySQL, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.HANA, DatabaseType.Derby, DatabaseType.KingBase, DatabaseType.Doris),
    LONG(TypeMetadata.CATEGORY.INT, "LONG", null, Long.class, 1, 1, 1, DatabaseType.ElasticSearch),
    UNSIGNED_LONG(TypeMetadata.CATEGORY.INT, "UNSIGNED_LONG", null, Long.class, 1, 1, 1, DatabaseType.ElasticSearch),
    OID(TypeMetadata.CATEGORY.INT, "OID", null, Long.class, 1, 1, 1, DatabaseType.KingBase),
    LARGEINT(TypeMetadata.CATEGORY.INT, "LARGEINT", null, Long.class, 1, 1, 1, DatabaseType.Doris),
    MEDIUMINT(TypeMetadata.CATEGORY.INT, "MEDIUMINT", null, Integer.class, 1, 1, 1, DatabaseType.MySQL),
    INTEGER(TypeMetadata.CATEGORY.INT, "INTEGER", (TypeMetadata)INT32, Integer.class, 1, 1, 1, DatabaseType.MySQL, DatabaseType.SQLite, DatabaseType.HANA, DatabaseType.ElasticSearch, DatabaseType.Derby, DatabaseType.KingBase),
    SMALLINT(TypeMetadata.CATEGORY.INT, "SMALLINT", (TypeMetadata)INT16, Integer.class, 1, 1, 1, DatabaseType.MySQL, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.HANA, DatabaseType.Derby, DatabaseType.KingBase, DatabaseType.Doris),
    TINYINT(TypeMetadata.CATEGORY.INT, "TINYINT", (TypeMetadata)INT8, Integer.class, 1, 1, 1, DatabaseType.MySQL, DatabaseType.HANA, DatabaseType.KingBase, DatabaseType.Doris),
    SERIAL(TypeMetadata.CATEGORY.INT, "SERIAL", (TypeMetadata)INT32, Integer.class, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB),
    SERIAL2(TypeMetadata.CATEGORY.INT, "SERIAL2", (TypeMetadata)INT16, Integer.class, 1, 1, 1, DatabaseType.PostgreSQL),
    SERIAL4(TypeMetadata.CATEGORY.INT, "SERIAL4", (TypeMetadata)INT32, Integer.class, 1, 1, 1, DatabaseType.PostgreSQL),
    SERIAL8(TypeMetadata.CATEGORY.INT, "SERIAL8", (TypeMetadata)INT64, Long.class, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB),
    SMALLSERIAL(TypeMetadata.CATEGORY.INT, "SMALLSERIAL", (TypeMetadata)SMALLINT, Integer.class, 1, 1, 1, DatabaseType.PostgreSQL),
    BIGSERIAL(TypeMetadata.CATEGORY.INT, "BIGSERIAL", (TypeMetadata)BIGINT, Long.class, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB),
    BOOLEAN(TypeMetadata.CATEGORY.BOOLEAN, "BOOLEAN", null, Boolean.class, 1, 1, 1, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.HANA, DatabaseType.ElasticSearch, DatabaseType.KingBase),
    BOOL(TypeMetadata.CATEGORY.BOOLEAN, "BOOL", null, Boolean.class, 1, 1, 1, new DatabaseType[]{DatabaseType.PostgreSQL, DatabaseType.Doris}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return BOOLEAN.write(value, def, placeholder);
        }
    }
    ,
    DECIMAL(TypeMetadata.CATEGORY.FLOAT, "DECIMAL", null, BigDecimal.class, 1, 0, 0, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.PostgreSQL, DatabaseType.ORACLE, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.HANA, DatabaseType.Derby, DatabaseType.Doris}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            if (null == value) {
                value = def;
            }
            BigDecimal result = BasicUtil.parseDecimal(value, null);
            if (null != def && null == result) {
                result = BasicUtil.parseDecimal(def, null);
            }
            return result;
        }
    }
    ,
    DEC(TypeMetadata.CATEGORY.FLOAT, "DEC", null, BigDecimal.class, 1, 0, 0, new DatabaseType[]{DatabaseType.DM}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DECIMAL.write(value, def, array, placeholder);
        }
    }
    ,
    SMALLDECIMAL(TypeMetadata.CATEGORY.FLOAT, "SMALLDECIMAL", null, BigDecimal.class, 1, 0, 0, new DatabaseType[]{DatabaseType.HANA}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DECIMAL.write(value, def, placeholder);
        }
    }
    ,
    DOUBLE(TypeMetadata.CATEGORY.FLOAT, "DOUBLE", null, Double.class, 1, 0, 0, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.HANA, DatabaseType.IoTDB, DatabaseType.ElasticSearch, DatabaseType.Derby, DatabaseType.Doris}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            if (null == value) {
                value = def;
            }
            Double result = BasicUtil.parseDouble(value, null);
            if (null != def && null == result) {
                result = BasicUtil.parseDouble(def, null);
            }
            return result;
        }
    }
    ,
    DOUBLE_PRECISION(TypeMetadata.CATEGORY.FLOAT, "DOUBLE PRECISION", null, Double.class, 1, 1, 1, new DatabaseType[]{DatabaseType.H2}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    FLOAT(TypeMetadata.CATEGORY.FLOAT, "FLOAT", null, Float.class, 1, 2, 3, new DatabaseType[]{DatabaseType.MySQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            if (null == value) {
                value = def;
            }
            Float result = BasicUtil.parseFloat(value, null);
            if (null != def && null == result) {
                result = BasicUtil.parseFloat(def, null);
            }
            return result;
        }
    }
    ,
    SMALLFLOAT(TypeMetadata.CATEGORY.FLOAT, "SMALLFLOAT", null, Float.class, 1, 0, 1, new DatabaseType[]{DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    FLOAT4(TypeMetadata.CATEGORY.FLOAT, "FLOAT4", null, Float.class, 1, 2, 1, new DatabaseType[]{DatabaseType.PostgreSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    SCALED_FLOAT(TypeMetadata.CATEGORY.FLOAT, "SCALED_FLOAT", null, Float.class, 1, 2, 1, new DatabaseType[]{DatabaseType.ElasticSearch}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    HALF_FLOAT(TypeMetadata.CATEGORY.FLOAT, "HALF_FLOAT", null, Float.class, 1, 2, 1, new DatabaseType[]{DatabaseType.ElasticSearch}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    FLOAT8(TypeMetadata.CATEGORY.FLOAT, "FLOAT8", null, Double.class, 1, 2, 1, new DatabaseType[]{DatabaseType.PostgreSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DOUBLE.write(value, def, placeholder);
        }
    }
    ,
    DECFLOAT(TypeMetadata.CATEGORY.FLOAT, "DECFLOAT", null, Double.class, 1, 2, 1, new DatabaseType[]{DatabaseType.H2}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DOUBLE.write(value, def, placeholder);
        }
    }
    ,
    BINARY_DOUBLE(TypeMetadata.CATEGORY.FLOAT, "BINARY_DOUBLE", null, Double.class, 1, 0, 0, new DatabaseType[]{DatabaseType.ORACLE}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DOUBLE.write(value, def, placeholder);
        }
    }
    ,
    BINARY_FLOAT(TypeMetadata.CATEGORY.FLOAT, "BINARY_FLOAT", null, Float.class, 1, 0, 0, new DatabaseType[]{DatabaseType.ORACLE}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DOUBLE.write(value, def, placeholder);
        }
    }
    ,
    MONEY(TypeMetadata.CATEGORY.FLOAT, "MONEY", null, BigDecimal.class, 1, 1, 1, new DatabaseType[]{DatabaseType.PostgreSQL, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.KingBase}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DECIMAL.write(value, def, placeholder);
        }
    }
    ,
    SMALLMONEY(TypeMetadata.CATEGORY.FLOAT, "SMALLMONEY", null, BigDecimal.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MSSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DECIMAL.write(value, def, placeholder);
        }
    }
    ,
    NUMERIC(TypeMetadata.CATEGORY.FLOAT, "NUMERIC", null, BigDecimal.class, 1, 0, 0, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.SQLite, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.KingBase}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DECIMAL.write(value, def, placeholder);
        }
    }
    ,
    NUMBER(TypeMetadata.CATEGORY.FLOAT, "NUMBER", null, BigDecimal.class, 1, 2, 2, new DatabaseType[]{DatabaseType.ORACLE}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DECIMAL.write(value, def, placeholder);
        }
    }
    ,
    REAL(TypeMetadata.CATEGORY.FLOAT, "REAL", (TypeMetadata)DOUBLE, Double.class, 1, 0, 0, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.SQLite, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.HANA, DatabaseType.Derby, DatabaseType.KingBase}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    UINT8(TypeMetadata.CATEGORY.INT, "UInt8", (TypeMetadata)INTEGER, Short.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return INTEGER.write(value, def, placeholder);
        }
    }
    ,
    UINT16(TypeMetadata.CATEGORY.INT, "UInt16", (TypeMetadata)INTEGER, Short.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return INTEGER.write(value, def, placeholder);
        }
    }
    ,
    UINT32(TypeMetadata.CATEGORY.INT, "UInt32", (TypeMetadata)INTEGER, Integer.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return INTEGER.write(value, def, placeholder);
        }
    }
    ,
    UINT64(TypeMetadata.CATEGORY.INT, "UInt64", (TypeMetadata)INTEGER, Long.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return INTEGER.write(value, def, placeholder);
        }
    }
    ,
    UINT128(TypeMetadata.CATEGORY.INT, "UInt128", (TypeMetadata)INTEGER, Long.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return INTEGER.write(value, def, placeholder);
        }
    }
    ,
    UINT256(TypeMetadata.CATEGORY.INT, "UInt256", (TypeMetadata)INTEGER, Long.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return INTEGER.write(value, def, placeholder);
        }
    }
    ,
    FLOAT32(TypeMetadata.CATEGORY.FLOAT, "Float32", (TypeMetadata)FLOAT, Long.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    FLOAT64(TypeMetadata.CATEGORY.FLOAT, "Float64", (TypeMetadata)DOUBLE, Long.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    DECIMAL32(TypeMetadata.CATEGORY.FLOAT, "Decimal32", (TypeMetadata)DECIMAL, BigDecimal.class, 1, 0, 2, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    DECIMAL64(TypeMetadata.CATEGORY.FLOAT, "Decimal64", (TypeMetadata)DECIMAL, BigDecimal.class, 1, 0, 2, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    DECIMAL128(TypeMetadata.CATEGORY.FLOAT, "Decimal128", (TypeMetadata)DECIMAL, BigDecimal.class, 1, 0, 2, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    DECIMAL256(TypeMetadata.CATEGORY.FLOAT, "Decimal256", (TypeMetadata)DECIMAL, BigDecimal.class, 1, 0, 2, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return FLOAT.write(value, def, placeholder);
        }
    }
    ,
    DATE(TypeMetadata.CATEGORY.DATE, "DATE", null, Date.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.PostgreSQL, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.HANA, DatabaseType.Derby, DatabaseType.Doris, DatabaseType.ElasticSearch}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            java.util.Date date;
            if (null == value) {
                value = def;
            }
            if (null == (date = DateUtil.parse(value)) && null != def) {
                date = DateUtil.parse(def);
            }
            if (null != date) {
                value = placeholder != false ? new Date(date.getTime()) : "'" + DateUtil.format(date, "yyyy-MM-dd") + "'";
            }
            return value;
        }
    }
    ,
    DATEV2(TypeMetadata.CATEGORY.DATE, "DATEV2", null, Date.class, 1, 1, 1, new DatabaseType[]{DatabaseType.SelectDB}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATE.write(value, def, placeholder);
        }
    }
    ,
    DATE_NANOS(TypeMetadata.CATEGORY.DATE, "date_nanos", null, Date.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ElasticSearch}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            java.util.Date date;
            if (null == value) {
                value = def;
            }
            if (null == (date = DateUtil.parse(value)) && null != def) {
                date = DateUtil.parse(def);
            }
            if (null != date) {
                value = placeholder != false ? new Date(date.getTime()) : "'" + DateUtil.format(date, "yyyy-MM-dd") + "'";
            }
            return value;
        }
    }
    ,
    DATETIME(TypeMetadata.CATEGORY.DATETIME, "DATETIME", "DATETIME({S})", null, LocalDateTime.class, 1, 1, 2, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.Doris}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            java.util.Date date;
            if (null == value) {
                value = def;
            }
            if (null == (date = DateUtil.parse(value)) && null != def) {
                date = DateUtil.parse(def);
            }
            value = null != date ? (placeholder.booleanValue() ? new Timestamp(date.getTime()) : "'" + DateUtil.format(date) + "'") : null;
            return value;
        }
    }
    ,
    DATETIMEV2(TypeMetadata.CATEGORY.DATETIME, "DATETIMEV2", null, Timestamp.class, 1, 1, 1, new DatabaseType[]{DatabaseType.SelectDB}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    DATETIME2(TypeMetadata.CATEGORY.DATETIME, "DATETIME2", null, Timestamp.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MSSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    DATETIME_WITH_TIME_ZONE(TypeMetadata.CATEGORY.DATETIME, "DATETIME WITH TIME ZONE", "DATETIME({S}) WITH TIME ZONE", null, Timestamp.class, 1, 1, 2, new DatabaseType[]{DatabaseType.DM}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    DATETIMEOFFSET(TypeMetadata.CATEGORY.DATETIME, "DATETIMEOFFSET", null, Timestamp.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MSSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    SMALLDATETIME(TypeMetadata.CATEGORY.DATETIME, "SMALLDATETIME", null, Timestamp.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MSSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    SQL_DATETIMEOFFSET(TypeMetadata.CATEGORY.DATETIME, "SQL_DATETIMEOFFSET", null, Timestamp.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MSSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    SECONDDATE(TypeMetadata.CATEGORY.DATE, "SECONDDATE", null, java.util.Date.class, 1, 1, 1, new DatabaseType[]{DatabaseType.HANA}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    TIME(TypeMetadata.CATEGORY.TIME, "TIME", null, Time.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.PostgreSQL, DatabaseType.HANA, DatabaseType.Derby}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            java.util.Date date;
            if (null == value) {
                value = def;
            }
            if (null == (date = DateUtil.parse(value)) && null != def) {
                date = DateUtil.parse(def);
            }
            value = null != date ? (placeholder.booleanValue() ? new Time(date.getTime()) : "'" + DateUtil.format(date, "HH:mm:ss") + "'") : null;
            return value;
        }
    }
    ,
    TIME_WITH_TIME_ZONE(TypeMetadata.CATEGORY.TIME, "TIME WITH TIME ZONE", "TIME({S}) WITH TIME ZONE", null, Time.class, 1, 1, 2, new DatabaseType[]{DatabaseType.DM, DatabaseType.KingBase}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return TIME.write(value, def, placeholder);
        }
    }
    ,
    TIME_WITH_ZONE(TypeMetadata.CATEGORY.TIME, "TIME WITH TIME ZONE", "TIME({S}) WITH TIME ZONE", null, Time.class, 1, 1, 2, new DatabaseType[]{DatabaseType.DM, DatabaseType.KingBase}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return TIME.write(value, def, placeholder);
        }
    }
    ,
    TIMEZ(TypeMetadata.CATEGORY.TIME, "TIMEZ", null, Time.class, 1, 1, 1, new DatabaseType[]{DatabaseType.PostgreSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return TIME.write(value, def, placeholder);
        }
    }
    ,
    TIMETZ(TypeMetadata.CATEGORY.TIME, "TIMEZ", null, Time.class, 1, 1, 1, new DatabaseType[]{DatabaseType.Redshift}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return TIME.write(value, def, placeholder);
        }
    }
    ,
    TIMESTAMP(TypeMetadata.CATEGORY.TIMESTAMP, "TIMESTAMP", "TIMESTAMP({S})", null, Timestamp.class, 1, 1, 2, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.PostgreSQL, DatabaseType.ORACLE, DatabaseType.HANA, DatabaseType.Derby}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    TIMESTAMP_WITH_TIME_ZONE(TypeMetadata.CATEGORY.TIMESTAMP, "TIMESTAMP WITH TIME ZONE", "TIMESTAMP({S}) WITH TIME ZONE", null, Timestamp.class, 1, 1, 2, new DatabaseType[]{DatabaseType.PostgreSQL, DatabaseType.KingBase}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    TIMESTAMP_WITH_ZONE(TypeMetadata.CATEGORY.TIMESTAMP, "TIMESTAMP WITH TIME ZONE", "TIMESTAMP({S}) WITH TIME ZONE", null, Timestamp.class, 1, 1, 2, new DatabaseType[]{DatabaseType.PostgreSQL, DatabaseType.KingBase}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    TIMESTAMP_WITH_LOCAL_ZONE(TypeMetadata.CATEGORY.TIMESTAMP, "TIMESTAMP WITH LOCAL TIME ZONE", "TIMESTAMP({S}) WITH LOCAL TIME ZONE", null, Timestamp.class, 1, 1, 2, new DatabaseType[]{DatabaseType.PostgreSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    TIMESTAMP_WITH_LOCAL_TIME_ZONE(TypeMetadata.CATEGORY.TIMESTAMP, "TIMESTAMP WITH LOCAL TIME ZONE", "TIMESTAMP({S}) WITH LOCAL TIME ZONE", null, Timestamp.class, 1, 1, 2, new DatabaseType[]{DatabaseType.PostgreSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    TIMESTAMPTZ(TypeMetadata.CATEGORY.TIMESTAMP, "TIMESTAMPTZ", null, Timestamp.class, 1, 1, 1, new DatabaseType[]{DatabaseType.PostgreSQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    TIMESTAMP_NTZ(TypeMetadata.CATEGORY.TIMESTAMP, "TIMESTAMP_NTZ", null, Timestamp.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MaxCompute}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return TIMESTAMP.write(value, def, placeholder);
        }
    }
    ,
    YEAR(TypeMetadata.CATEGORY.DATE, "YEAR", null, Date.class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATE.write(value, def, placeholder);
        }
    }
    ,
    DATE32(TypeMetadata.CATEGORY.DATE, "DATE32", null, Date.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATE.write(value, def, placeholder);
        }
    }
    ,
    DATETIME64(TypeMetadata.CATEGORY.DATE, "DATETIME64", null, Timestamp.class, 1, 1, 1, new DatabaseType[]{DatabaseType.ClickHouse}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return DATETIME.write(value, def, placeholder);
        }
    }
    ,
    INTERVAL_DAY(TypeMetadata.CATEGORY.INTERVAL, "INTERVAL DAY", null, null, 1, 2, 2, DatabaseType.ORACLE, DatabaseType.KingBase),
    INTERVAL_DAY_HOUR(TypeMetadata.CATEGORY.INTERVAL, "INTERVAL DAY TO HOUR", "INTERVAL DAY({P}) TO HOUR({S})", null, null, 1, 2, 2, DatabaseType.ORACLE, DatabaseType.KingBase),
    INTERVAL_DAY_MINUTE(TypeMetadata.CATEGORY.INTERVAL, "INTERVAL DAY TO MINUTE", "INTERVAL DAY({P}) TO MINUTE({S})", null, null, 1, 2, 2, DatabaseType.ORACLE, DatabaseType.KingBase),
    INTERVAL_DAY_SECOND(TypeMetadata.CATEGORY.INTERVAL, "INTERVAL DAY TO SECOND", "INTERVAL DAY({P}) TO SECOND({S})", null, null, 1, 2, 2, DatabaseType.ORACLE, DatabaseType.KingBase),
    INTERVAL_HOUR(TypeMetadata.CATEGORY.INTERVAL, "INTERVAL HOUR", "INTERVAL HOUR({P})", null, null, 1, 2, 1, DatabaseType.ORACLE, DatabaseType.KingBase),
    INTERVAL_HOUR_MINUTE(TypeMetadata.CATEGORY.INTERVAL, "INTERVAL HOUR TO MINUTE", "INTERVAL HOUR({P}) TO MINUTE({S})", null, null, 1, 2, 2, DatabaseType.ORACLE, DatabaseType.KingBase),
    INTERVAL_HOUR_SECOND(TypeMetadata.CATEGORY.INTERVAL, "INTERVAL HOUR TO SECOND", "INTERVAL HOUR({P}) TO SECOND({S})", null, null, 1, 2, 2, DatabaseType.ORACLE, DatabaseType.KingBase),
    INTERVAL_MINUTE(TypeMetadata.CATEGORY.INTERVAL, "INTERVAL MINUTE", "INTERVAL MINUTE({P})", null, null, 1, 2, 1, DatabaseType.ORACLE, DatabaseType.KingBase),
    INTERVAL_MINUTE_SECOND(TypeMetadata.CATEGORY.INTERVAL, "INTERVAL MINUTE TO SECOND", "INTERVAL MINUTE({P}) TO SECOND({S})", null, null, 1, 2, 2, DatabaseType.ORACLE, DatabaseType.KingBase),
    INTERVAL_MONTH(TypeMetadata.CATEGORY.INTERVAL, "INTERVAL MONTH", "INTERVAL MONTH({P})", null, null, 1, 2, 1, DatabaseType.ORACLE, DatabaseType.KingBase),
    INTERVAL_SECOND(TypeMetadata.CATEGORY.INTERVAL, "INTERVAL SECOND", "INTERVAL SECOND({P})", null, null, 1, 2, 1, DatabaseType.ORACLE, DatabaseType.KingBase),
    INTERVAL_YEAR(TypeMetadata.CATEGORY.INTERVAL, "INTERVAL YEAR", "INTERVAL YEAR({P})", null, null, 1, 2, 1, DatabaseType.ORACLE, DatabaseType.KingBase),
    INTERVAL_YEAR_MONTH(TypeMetadata.CATEGORY.INTERVAL, "INTERVAL YEAR TO MONTH", "INTERVAL YEAR({P}) TO MONTH({S})", null, null, 1, 2, 2, DatabaseType.ORACLE, DatabaseType.KingBase),
    DURATION(TypeMetadata.CATEGORY.INTERVAL, "DURATION", null, null, 1, 1, 1, DatabaseType.Nebula),
    BLOB(TypeMetadata.CATEGORY.BLOB, "BLOB", null, byte[].class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.ORACLE, DatabaseType.SQLite, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB, DatabaseType.HANA, DatabaseType.Derby, DatabaseType.KingBase}){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            if (clazz != byte[].class && clazz == String.class) {
                value = new String((byte[])value);
            }
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            if (null == value) {
                value = def;
            }
            if (!(value instanceof byte[]) && value instanceof String) {
                String str = (String)value;
                if (Base64Util.verify(str)) {
                    try {
                        value = Base64Util.decode(str);
                    }
                    catch (Exception e) {
                        value = str.getBytes();
                    }
                } else {
                    value = str.getBytes();
                }
            }
            return value;
        }
    }
    ,
    VARBYTE(TypeMetadata.CATEGORY.BYTES, "VARBYTE", null, byte[].class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return BLOB.write(value, def, placeholder);
        }
    }
    ,
    BYTES(TypeMetadata.CATEGORY.BYTES, "BYTES", null, byte[].class, 1, 1, 1, new DatabaseType[]{DatabaseType.InfluxDB}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return BLOB.write(value, def, placeholder);
        }
    }
    ,
    LONGBLOB(TypeMetadata.CATEGORY.BYTES, "LONGBLOB", null, byte[].class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return BLOB.write(value, def, placeholder);
        }
    }
    ,
    MEDIUMBLOB(TypeMetadata.CATEGORY.BYTES, "MEDIUMBLOB", null, byte[].class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return BLOB.write(value, def, placeholder);
        }
    }
    ,
    TINYBLOB(TypeMetadata.CATEGORY.BYTES, "TINYBLOB", null, byte[].class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return BLOB.write(value, def, placeholder);
        }
    }
    ,
    MULTILINESTRING(TypeMetadata.CATEGORY.BYTES, "MULTILINESTRING", null, byte[].class, 1, 1, 1, DatabaseType.MySQL),
    BYTEA(TypeMetadata.CATEGORY.BYTES, "BYTEA", null, byte[].class, 1, 1, 1, DatabaseType.PostgreSQL),
    JSONB(TypeMetadata.CATEGORY.BYTES, "JSONB", null, byte[].class, 1, 1, 1, new DatabaseType[]{DatabaseType.PostgreSQL, DatabaseType.KingBase}){

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return BLOB.write(value, def, placeholder);
        }
    }
    ,
    IMAGE(TypeMetadata.CATEGORY.BYTES, "IMAGE", null, byte[].class, 1, 1, 1, DatabaseType.MSSQL, DatabaseType.DM),
    BFILE(TypeMetadata.CATEGORY.BYTES, "BFILE", null, byte[].class, 1, 1, 1, DatabaseType.ORACLE, DatabaseType.KingBase, DatabaseType.DM),
    POINT(TypeMetadata.CATEGORY.GEOMETRY, "POINT", null, Point.class, byte[].class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.PostgreSQL, DatabaseType.KingBase}){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            if (null == value) {
                return value;
            }
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            if (null == value) {
                value = def;
            }
            if (value instanceof byte[]) {
                return value;
            }
            return value;
        }
    }
    ,
    ST_POINT(TypeMetadata.CATEGORY.GEOMETRY, "ST_POINT", null, Point.class, byte[].class, 1, 1, 1, new DatabaseType[]{DatabaseType.MySQL, DatabaseType.PostgreSQL}){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return POINT.read(value, def, clazz);
        }

        @Override
        public Object write(Object value, Object def, boolean array, Boolean placeholder) {
            return POINT.write(value, def, placeholder);
        }
    }
    ,
    GEOGRAPHY_POINT(TypeMetadata.CATEGORY.GEOMETRY, "GEOGRAPHY_POINT", null, Point.class, byte[].class, 1, 1, 1, DatabaseType.VoltDB),
    MULTIPOLYGON(TypeMetadata.CATEGORY.GEOMETRY, "MULTIPOLYGON", null, MultiPolygon.class, byte[].class, 1, 1, 1, DatabaseType.MySQL),
    RING(TypeMetadata.CATEGORY.GEOMETRY, "RING", null, Ring.class, byte[].class, 1, 1, 1, DatabaseType.ClickHouse),
    MULTIPOINT(TypeMetadata.CATEGORY.GEOMETRY, "MULTIPOINT", null, MultiPoint.class, byte[].class, 1, 1, 1, DatabaseType.MySQL),
    POLYGON(TypeMetadata.CATEGORY.GEOMETRY, "POLYGON", null, Polygon.class, byte[].class, 1, 1, 1, DatabaseType.MySQL, DatabaseType.PostgreSQL, DatabaseType.KingBase),
    GEOMETRY(TypeMetadata.CATEGORY.GEOMETRY, "GEOMETRY", null, byte[].class, 1, 1, 1, DatabaseType.MySQL),
    ST_GEOMETRY(TypeMetadata.CATEGORY.GEOMETRY, "ST_GEOMETRY", null, byte[].class, 1, 1, 1, DatabaseType.HANA),
    GEOMETRYCOLLECTION(TypeMetadata.CATEGORY.GEOMETRY, "GEOMETRYCOLLECTION", null, byte[].class, 1, 1, 1, DatabaseType.MySQL),
    HIERARCHYID(TypeMetadata.CATEGORY.GEOMETRY, "HIERARCHYID", null, byte[].class, 1, 1, 1, DatabaseType.MSSQL),
    LINE(TypeMetadata.CATEGORY.GEOMETRY, "LINE", null, LineString.class, byte[].class, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.KingBase),
    LINESTRING(TypeMetadata.CATEGORY.GEOMETRY, "LINESTRING", null, LineString.class, byte[].class, 1, 1, 1, DatabaseType.MySQL),
    PATH(TypeMetadata.CATEGORY.GEOMETRY, "PATH", null, LineString.class, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.KingBase),
    LSEG(TypeMetadata.CATEGORY.GEOMETRY, "LSEG", null, byte[].class, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.KingBase),
    GEOGRAPHY(TypeMetadata.CATEGORY.GEOMETRY, "GEOGRAPHY", null, byte[].class, 1, 1, 1, DatabaseType.MSSQL, DatabaseType.PostgreSQL),
    BOX(TypeMetadata.CATEGORY.GEOMETRY, "BOX", null, byte[].class, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.KingBase),
    CIDR(TypeMetadata.CATEGORY.GEOMETRY, "CIDR", null, byte[].class, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.KingBase),
    CIRCLE(TypeMetadata.CATEGORY.GEOMETRY, "CIRCLE", null, byte[].class, 1, 1, 1, DatabaseType.PostgreSQL),
    INET(TypeMetadata.CATEGORY.GEOMETRY, "INET", null, byte[].class, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.KingBase),
    BINARY_VECTOR(TypeMetadata.CATEGORY.VECTOR, "BINARY_VECTOR", null, ArrayList.class, 1, 0, 1, DatabaseType.Milvus),
    FLOAT_VECTOR(TypeMetadata.CATEGORY.VECTOR, "FLOAT_VECTOR", null, ArrayList.class, 1, 0, 1, DatabaseType.Milvus),
    FLOAT16_VECTOR(TypeMetadata.CATEGORY.VECTOR, "FLOAT16_VECTOR", null, ArrayList.class, 1, 0, 1, DatabaseType.Milvus),
    BFLOAT16_VECTOR(TypeMetadata.CATEGORY.VECTOR, "BFLOAT16_VECTOR", null, ArrayList.class, 1, 0, 1, DatabaseType.Milvus),
    SPARSE_FLOAT_VECTOR(TypeMetadata.CATEGORY.VECTOR, "SPARSE_FLOAT_VECTOR", null, ArrayList.class, 1, 0, 1, DatabaseType.Milvus),
    GTSVECTOR(TypeMetadata.CATEGORY.VECTOR, "GTSVECTOR", null, ArrayList.class, 1, 1, 1, DatabaseType.KingBase),
    TSVECTOR(TypeMetadata.CATEGORY.VECTOR, "TSVECTOR", null, ArrayList.class, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.KingBase),
    DENSE_VECTOR(TypeMetadata.CATEGORY.VECTOR, "dense_vector", null, ArrayList.class, 1, 1, 1, DatabaseType.ElasticSearch),
    VECTOR(TypeMetadata.CATEGORY.VECTOR, "vector", null, ArrayList.class, 1, 0, 1, new DatabaseType[0]),
    SPARSE_VECTOR(TypeMetadata.CATEGORY.VECTOR, "sparse_vector", null, ArrayList.class, 1, 1, 1, DatabaseType.ElasticSearch),
    BINARY_INTEGER(TypeMetadata.CATEGORY.NONE, "BINARY_INTEGER", null, null, 1, 1, 1, DatabaseType.KingBase),
    BIT_VARYING(TypeMetadata.CATEGORY.NONE, "BIT VARYING", null, null, 1, 1, 1, DatabaseType.KingBase),
    BPCHAR(TypeMetadata.CATEGORY.NONE, "BPCHAR", null, null, 1, 1, 1, DatabaseType.KingBase),
    BPCHARBYTE(TypeMetadata.CATEGORY.NONE, "BPCHARBYTE", null, null, 1, 1, 1, DatabaseType.KingBase),
    CHARACTER(TypeMetadata.CATEGORY.NONE, "CHARACTER", null, null, 1, 1, 1, DatabaseType.KingBase),
    CID(TypeMetadata.CATEGORY.NONE, "CID", null, null, 1, 1, 1, DatabaseType.KingBase),
    DATERANGE(TypeMetadata.CATEGORY.NONE, "DATERANGE", null, null, 1, 1, 1, DatabaseType.KingBase),
    DSINTERVAL(TypeMetadata.CATEGORY.NONE, "DSINTERVAL", null, null, 1, 1, 1, DatabaseType.KingBase),
    INT4RANGE(TypeMetadata.CATEGORY.NONE, "INT4RANGE", null, null, 1, 1, 1, DatabaseType.KingBase),
    INT8RANGE(TypeMetadata.CATEGORY.NONE, "INT8RANGE", null, null, 1, 1, 1, DatabaseType.KingBase),
    JSONPATH(TypeMetadata.CATEGORY.NONE, "JSONPATH", null, null, 1, 1, 1, DatabaseType.KingBase),
    MACADDR8(TypeMetadata.CATEGORY.NONE, "MACADDR8", null, null, 1, 1, 1, DatabaseType.KingBase),
    NATURALN(TypeMetadata.CATEGORY.NONE, "NATURALN", null, null, 1, 1, 1, DatabaseType.KingBase),
    NUMRANGE(TypeMetadata.CATEGORY.NONE, "NUMRANGE", null, null, 1, 1, 1, DatabaseType.KingBase),
    ORA_DATE(TypeMetadata.CATEGORY.NONE, "ORA_DATE", null, null, 1, 1, 1, DatabaseType.KingBase),
    POSITIVE(TypeMetadata.CATEGORY.NONE, "POSITIVE", null, null, 1, 1, 1, DatabaseType.KingBase),
    POSITIVEN(TypeMetadata.CATEGORY.NONE, "POSITIVEN", null, null, 1, 1, 1, DatabaseType.KingBase),
    REFCURSOR(TypeMetadata.CATEGORY.NONE, "REFCURSOR", null, null, 1, 1, 1, DatabaseType.KingBase),
    REGCLASS(TypeMetadata.CATEGORY.NONE, "REGCLASS", null, null, 1, 1, 1, DatabaseType.KingBase),
    REGCONFIG(TypeMetadata.CATEGORY.NONE, "REGCONFIG", null, null, 1, 1, 1, DatabaseType.KingBase),
    REGDICTIONARY(TypeMetadata.CATEGORY.NONE, "REGDICTIONARY", null, null, 1, 1, 1, DatabaseType.KingBase),
    REGNAMESPACE(TypeMetadata.CATEGORY.NONE, "REGNAMESPACE", null, null, 1, 1, 1, DatabaseType.KingBase),
    REGOPER(TypeMetadata.CATEGORY.NONE, "REGOPER", null, null, 1, 1, 1, DatabaseType.KingBase),
    REGOPERATOR(TypeMetadata.CATEGORY.NONE, "REGOPERATOR", null, null, 1, 1, 1, DatabaseType.KingBase),
    REGPROC(TypeMetadata.CATEGORY.NONE, "REGPROC", null, null, 1, 1, 1, DatabaseType.KingBase),
    REGPROCEDURE(TypeMetadata.CATEGORY.NONE, "REGPROCEDURE", null, null, 1, 1, 1, DatabaseType.KingBase),
    REGTYPE(TypeMetadata.CATEGORY.NONE, "REGTYPE", null, null, 1, 1, 1, DatabaseType.KingBase),
    REGROLE(TypeMetadata.CATEGORY.NONE, "REGROLE", null, null, 1, 1, 1, DatabaseType.KingBase),
    SIGNTYPE(TypeMetadata.CATEGORY.NONE, "SIGNTYPE", null, null, 1, 1, 1, DatabaseType.KingBase),
    SIMPLE_DOUBLE(TypeMetadata.CATEGORY.NONE, "SIMPLE_DOUBLE", null, null, 1, 1, 1, DatabaseType.KingBase),
    SIMPLE_INTEGER(TypeMetadata.CATEGORY.NONE, "SIMPLE_INTEGER", null, null, 1, 1, 1, DatabaseType.KingBase),
    SIMPLE_FLOAT(TypeMetadata.CATEGORY.NONE, "SIMPLE_FLOAT", null, null, 1, 1, 1, DatabaseType.KingBase),
    TID(TypeMetadata.CATEGORY.NONE, "TID", null, null, 1, 1, 1, DatabaseType.KingBase),
    TIME_WITHOUT_TIME_ZONE(TypeMetadata.CATEGORY.NONE, "TIME WITHOUT TIME ZONE", null, null, 1, 1, 1, DatabaseType.KingBase),
    TIME_TZ_UNCONSTRAINED(TypeMetadata.CATEGORY.NONE, "TIME TZ UNCONSTRAINED", null, null, 1, 1, 1, DatabaseType.KingBase),
    TIME_UNCONSTRAINED(TypeMetadata.CATEGORY.NONE, "TIME_UNCONSTRAINED", null, null, 1, 1, 1, DatabaseType.KingBase),
    TIMESTAMP_WITHOUT_TIME_ZONE(TypeMetadata.CATEGORY.NONE, "TIMESTAMP WITHOUT TIME ZONE", null, null, 1, 1, 1, DatabaseType.KingBase),
    TSRANGE(TypeMetadata.CATEGORY.NONE, "TSRANGE", null, null, 1, 1, 1, DatabaseType.KingBase),
    TSTZRANGE(TypeMetadata.CATEGORY.NONE, "TSTZRANGE", null, null, 1, 1, 1, DatabaseType.KingBase),
    VARCHARBYTE(TypeMetadata.CATEGORY.NONE, "VARCHARBYTE", null, null, 1, 1, 1, DatabaseType.KingBase),
    XID(TypeMetadata.CATEGORY.NONE, "XID", null, null, 1, 1, 1, DatabaseType.KingBase),
    YMINTERVAL(TypeMetadata.CATEGORY.NONE, "YMINTERVAL", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    RANGE(TypeMetadata.CATEGORY.NONE, "RANGE", null, null, 1, 1, 1, DatabaseType.KingBase),
    CURSOR(TypeMetadata.CATEGORY.NONE, "CURSOR", null, null, 1, 1, 1, DatabaseType.XuGu),
    ENUM(TypeMetadata.CATEGORY.NONE, "ENUM", null, String.class, 1, 1, 1, DatabaseType.MySQL),
    INTERVAL(TypeMetadata.CATEGORY.NONE, "INTERVAL", null, null, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.Informix, DatabaseType.GBase8S, DatabaseType.SinoDB),
    GUID(TypeMetadata.CATEGORY.NONE, "GUID", null, null, 1, 1, 1, DatabaseType.XuGu),
    MACADDR(TypeMetadata.CATEGORY.NONE, "MACADDR", null, null, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.KingBase),
    MULTISET(TypeMetadata.CATEGORY.NONE, "MULTISET", null, String.class, 1, 1, 1, DatabaseType.SinoDB),
    JAVA_OBJECT(TypeMetadata.CATEGORY.NONE, "JAVA_OBJECT", null, String.class, 1, 1, 1, DatabaseType.H2),
    RAW(TypeMetadata.CATEGORY.NONE, "RAW", null, byte[].class, 1, 1, 1, DatabaseType.ORACLE),
    ROW(TypeMetadata.CATEGORY.NONE, "ROW", null, null, 1, 1, 1, DatabaseType.H2),
    ROWID(TypeMetadata.CATEGORY.NONE, "ROWID", null, null, 1, 1, 1, DatabaseType.ORACLE),
    SYS_REFCURSOR(TypeMetadata.CATEGORY.NONE, "SYS_REFCURSOR", null, null, 1, 1, 1, DatabaseType.XuGu),
    SET(TypeMetadata.CATEGORY.NONE, "SET", null, String.class, 1, 1, 1, DatabaseType.MySQL, DatabaseType.SinoDB),
    LIST(TypeMetadata.CATEGORY.NONE, "LIST", null, String.class, 1, 1, 1, DatabaseType.SinoDB),
    TSQUERY(TypeMetadata.CATEGORY.NONE, "TSQUERY", null, null, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.KingBase),
    PG_SNAPSHOT(TypeMetadata.CATEGORY.NONE, "PG_SNAPSHOT", null, null, 1, 1, 1, DatabaseType.PostgreSQL),
    TXID_SNAPSHOT(TypeMetadata.CATEGORY.NONE, "TXID_SNAPSHOT", null, null, 1, 1, 1, DatabaseType.PostgreSQL, DatabaseType.KingBase),
    UROWID(TypeMetadata.CATEGORY.NONE, "UROWID", null, null, 1, 1, 1, DatabaseType.ORACLE),
    SQL_VARIANT(TypeMetadata.CATEGORY.NONE, "SQL_VARIANT", null, null, 1, 1, 1, DatabaseType.MSSQL),
    KEYWORD(TypeMetadata.CATEGORY.NONE, "KEYWORD", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    OBJECT(TypeMetadata.CATEGORY.NONE, "OBJECT", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    ARRAY(TypeMetadata.CATEGORY.NONE, "ARRAY", null, null, 2, 2, 2, DatabaseType.Doris),
    MAP(TypeMetadata.CATEGORY.NONE, "MAP", null, null, 1, 1, 1, DatabaseType.Doris),
    STRUCT(TypeMetadata.CATEGORY.NONE, "STRUCT", null, null, 1, 1, 1, DatabaseType.Doris),
    STRUCTS(TypeMetadata.CATEGORY.NONE, "STRUCTS", null, null, 1, 1, 1, DatabaseType.Hive),
    AGG_STATE(TypeMetadata.CATEGORY.NONE, "AGG_STATE", null, null, 1, 1, 1, DatabaseType.Doris),
    LowCardinality(TypeMetadata.CATEGORY.NONE, "LowCardinality", null, null, 1, 1, 1, DatabaseType.ClickHouse),
    SimpleAggregateFunction(TypeMetadata.CATEGORY.NONE, "SimpleAggregateFunction", null, null, 1, 1, 1, DatabaseType.ClickHouse),
    TUPLE(TypeMetadata.CATEGORY.NONE, "TUPLE", null, null, 1, 1, 1, DatabaseType.ClickHouse),
    IP(TypeMetadata.CATEGORY.NONE, "ip", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    IPV4(TypeMetadata.CATEGORY.NONE, "IPV4", null, null, 1, 1, 1, DatabaseType.ClickHouse),
    IPV6(TypeMetadata.CATEGORY.NONE, "IPV6", null, null, 1, 1, 1, DatabaseType.ClickHouse),
    ALIAS(TypeMetadata.CATEGORY.NONE, "alias", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    COMPLETION(TypeMetadata.CATEGORY.NONE, "completion", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    FLATTENED(TypeMetadata.CATEGORY.NONE, "flattened", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    JOIN(TypeMetadata.CATEGORY.NONE, "join", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    GEO_POINT(TypeMetadata.CATEGORY.NONE, "geo_point", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    GEO_SHAPE(TypeMetadata.CATEGORY.NONE, "geo_shape", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    HISTOGRAM(TypeMetadata.CATEGORY.NONE, "histogram", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    PERCOLATOR(TypeMetadata.CATEGORY.NONE, "percolator", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    NESTED(TypeMetadata.CATEGORY.NONE, "nested", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    RANK_FEATURES(TypeMetadata.CATEGORY.NONE, "rank_features", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    RANK_FEATURE(TypeMetadata.CATEGORY.NONE, "rank_feature", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    SHAPE(TypeMetadata.CATEGORY.NONE, "shape", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    TOKEN_COUNT(TypeMetadata.CATEGORY.NONE, "token_count", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    VERSION(TypeMetadata.CATEGORY.NONE, "version", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    AGGREGATE_METRIC_DOUBLE(TypeMetadata.CATEGORY.NONE, "aggregate_metric_double", null, null, 1, 1, 1, DatabaseType.ElasticSearch),
    SUPER(TypeMetadata.CATEGORY.NONE, "aggregate_metric_double", null, null, 1, 1, 1, DatabaseType.Redshift);

    private final List<DatabaseType> dbs = new ArrayList<DatabaseType>();
    private final TypeMetadata.CATEGORY category;
    private final TypeMetadata origin;
    private final String name;
    private String formula;
    private Class transfer;
    private Class compatible;
    private final int ignoreLength;
    private final int ignorePrecision;
    private final int ignoreScale;
    private int maxLength = -1;
    private int maxPrecision = -1;
    private int maxScale = -1;
    private boolean array;
    private TypeMetadata.Refer refer;

    private StandardTypeMetadata(TypeMetadata.CATEGORY category, String name, String formula, TypeMetadata origin, Class transfer, Class compatible, int ignoreLength, int ignorePrecision, int ignoreScale, DatabaseType ... dbs) {
        this.category = category;
        this.origin = null != origin ? origin : this;
        if (null != dbs) {
            for (DatabaseType db : dbs) {
                this.dbs.add(db);
            }
        }
        this.name = name;
        this.transfer = transfer;
        this.compatible = compatible;
        this.ignoreLength = ignoreLength;
        this.ignorePrecision = ignorePrecision;
        this.ignoreScale = ignoreScale;
        this.formula = formula;
    }

    private StandardTypeMetadata(TypeMetadata.CATEGORY category, String name, TypeMetadata origin, Class transfer, Class compatible, int ignoreLength, int ignorePrecision, int ignoreScale, DatabaseType ... dbs) {
        this(category, name, null, origin, transfer, compatible, ignoreLength, ignorePrecision, ignoreScale, dbs);
    }

    private StandardTypeMetadata(TypeMetadata.CATEGORY category, String name, TypeMetadata origin, Class compatible, int ignoreLength, int ignorePrecision, int ignoreScale, DatabaseType ... dbs) {
        this(category, name, null, origin, null, compatible, ignoreLength, ignorePrecision, ignoreScale, dbs);
    }

    private StandardTypeMetadata(TypeMetadata.CATEGORY category, String name, String formula, TypeMetadata origin, Class compatible, int ignoreLength, int ignorePrecision, int ignoreScale, DatabaseType ... dbs) {
        this(category, name, formula, origin, null, compatible, ignoreLength, ignorePrecision, ignoreScale, dbs);
    }

    @Override
    public TypeMetadata getOrigin() {
        return this.origin;
    }

    @Override
    public TypeMetadata.CATEGORY getCategory() {
        return this.category;
    }

    @Override
    public TypeMetadata.CATEGORY_GROUP getCategoryGroup() {
        if (null != this.category) {
            return this.category.group();
        }
        return TypeMetadata.CATEGORY_GROUP.NONE;
    }

    public void compatible(Class compatible) {
        this.compatible = compatible;
    }

    @Override
    public Object convert(Object value, Object def) {
        return this.convert(value, null, def);
    }

    @Override
    public Object convert(Object value, Class target, boolean array) {
        Object def = null;
        return this.convert(value, target, array, def);
    }

    @Override
    public Object convert(Object value, Class target, boolean array, Object def) {
        if (null == target) {
            target = this.compatible;
        }
        if (null != value) {
            if (value.getClass() == target) {
                return value;
            }
            if (null != this.transfer) {
                value = ConvertProxy.convert(value, this.transfer, array, def);
            }
            value = ConvertProxy.convert(value, target, array, def);
        }
        return value;
    }

    @Override
    public Object convert(Object value, Object obj, Field field) {
        return this.convert(value, field.getType());
    }

    @Override
    public Object read(Object value, Object def, Class clazz, boolean array) {
        if (null == clazz) {
            clazz = this.transfer;
        }
        if (null == clazz) {
            clazz = this.compatible;
        }
        value = ConvertProxy.convert(value, clazz, array, def, false);
        return value;
    }

    @Override
    public Object write(Object value, Object def, boolean array, Boolean placeholder) {
        if (null != value) {
            if (value.getClass() != this.compatible) {
                if (null != this.transfer) {
                    value = ConvertProxy.convert(value, this.transfer, array, def);
                }
                value = ConvertProxy.convert(value, this.compatible, array, def);
            }
            if (null != value && this.compatible == String.class && !placeholder.booleanValue()) {
                value = "'" + value + "'";
            }
        }
        return value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int ignoreLength() {
        return this.ignoreLength;
    }

    @Override
    public int ignorePrecision() {
        return this.ignorePrecision;
    }

    @Override
    public int ignoreScale() {
        return this.ignoreScale;
    }

    @Override
    public int maxLength() {
        return this.maxLength;
    }

    @Override
    public int maxPrecision() {
        return this.maxPrecision;
    }

    @Override
    public int maxScale() {
        return this.maxScale;
    }

    @Override
    public boolean support() {
        return true;
    }

    @Override
    public String formula() {
        return this.formula;
    }

    @Override
    public Class compatible() {
        return this.compatible;
    }

    @Override
    public Class transfer() {
        return this.transfer;
    }

    @Override
    public List<DatabaseType> databaseTypes() {
        return this.dbs;
    }

    @Override
    public boolean isArray() {
        return this.array;
    }

    @Override
    public void setArray(boolean array) {
        this.array = array;
    }

    @Override
    public TypeMetadata.Refer refer() {
        if (null == this.refer) {
            this.refer = new TypeMetadata.Refer();
            this.refer.ignoreLength(this.ignoreLength).ignorePrecision(this.ignorePrecision).ignoreScale(this.ignoreScale);
        }
        return this.refer;
    }
}

