/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import org.apache.arrow.memory.BoundsChecking;
import org.apache.arrow.util.Preconditions;

public final class LargeMemoryUtil {
    private LargeMemoryUtil() {
    }

    public static int checkedCastToInt(long length) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            Preconditions.checkArgument(length <= Integer.MAX_VALUE || length >= Integer.MIN_VALUE, "Can't cast long to int: %s", length);
        }
        return (int)length;
    }

    public static int capAtMaxInt(long length) {
        return (int)Math.min(length, Integer.MAX_VALUE);
    }
}

