/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support;

import java.util.stream.StreamSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.consumer.CommitManager;
import org.apache.camel.component.kafka.consumer.KafkaManualCommit;
import org.apache.camel.component.kafka.consumer.support.ProcessingResult;
import org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRecordProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaRecordProcessor.class);
    private final boolean autoCommitEnabled;
    private final KafkaConfiguration configuration;
    private final Processor processor;
    private final CommitManager commitManager;

    public KafkaRecordProcessor(KafkaConfiguration configuration, Processor processor, CommitManager commitManager) {
        this.autoCommitEnabled = configuration.isAutoCommitEnable();
        this.configuration = configuration;
        this.processor = processor;
        this.commitManager = commitManager;
    }

    private void setupExchangeMessage(Message message, ConsumerRecord record) {
        message.setHeader("kafka.PARTITION", (Object)record.partition());
        message.setHeader("kafka.TOPIC", (Object)record.topic());
        message.setHeader("kafka.OFFSET", (Object)record.offset());
        message.setHeader("kafka.HEADERS", (Object)record.headers());
        message.setHeader("kafka.TIMESTAMP", (Object)record.timestamp());
        message.setHeader("CamelMessageTimestamp", (Object)record.timestamp());
        if (record.key() != null) {
            message.setHeader("kafka.KEY", record.key());
        }
        message.setBody(record.value());
    }

    private boolean shouldBeFiltered(Header header, Exchange exchange, HeaderFilterStrategy headerFilterStrategy) {
        return !headerFilterStrategy.applyFilterToExternalHeaders(header.key(), (Object)header.value(), exchange);
    }

    private void propagateHeaders(ConsumerRecord<Object, Object> record, Exchange exchange) {
        HeaderFilterStrategy headerFilterStrategy = this.configuration.getHeaderFilterStrategy();
        KafkaHeaderDeserializer headerDeserializer = this.configuration.getHeaderDeserializer();
        StreamSupport.stream(record.headers().spliterator(), false).filter(header -> this.shouldBeFiltered((Header)header, exchange, headerFilterStrategy)).forEach(header -> exchange.getIn().setHeader(header.key(), headerDeserializer.deserialize(header.key(), header.value())));
    }

    public ProcessingResult processExchange(Exchange exchange, TopicPartition partition, boolean partitionHasNext, boolean recordHasNext, ConsumerRecord<Object, Object> record, ProcessingResult lastResult, ExceptionHandler exceptionHandler) {
        Message message = exchange.getMessage();
        this.setupExchangeMessage(message, record);
        this.propagateHeaders(record, exchange);
        if (!this.autoCommitEnabled) {
            message.setHeader("kafka.LAST_RECORD_BEFORE_COMMIT", (Object)(!recordHasNext ? 1 : 0));
            message.setHeader("kafka.LAST_POLL_RECORD", (Object)(!recordHasNext && !partitionHasNext ? 1 : 0));
        }
        if (this.configuration.isAllowManualCommit()) {
            KafkaManualCommit manual = this.commitManager.getManualCommit(exchange, partition, record);
            message.setHeader("CamelKafkaManualCommit", (Object)manual);
            message.setHeader("kafka.LAST_POLL_RECORD", (Object)(!recordHasNext && !partitionHasNext ? 1 : 0));
        }
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            boolean breakOnErrorExit = this.processException(exchange, partition, lastResult.getPartitionLastOffset(), exceptionHandler);
            return new ProcessingResult(breakOnErrorExit, lastResult.getPartitionLastOffset(), true);
        }
        return new ProcessingResult(false, record.offset(), exchange.getException() != null);
    }

    private boolean processException(Exchange exchange, TopicPartition partition, long partitionLastOffset, ExceptionHandler exceptionHandler) {
        if (this.configuration.isBreakOnFirstError()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Error during processing {} from topic: {}", new Object[]{exchange, partition.topic(), exchange.getException()});
                LOG.warn("Will seek consumer to offset {} and start polling again.", (Object)partitionLastOffset);
            }
            this.commitManager.forceCommit(partition, partitionLastOffset);
            return true;
        }
        exceptionHandler.handleException("Error during processing", exchange, (Throwable)exchange.getException());
        return false;
    }

    public static String serializeOffsetKey(TopicPartition topicPartition) {
        return topicPartition.topic() + "/" + topicPartition.partition();
    }

    public static long deserializeOffsetValue(String offset) {
        return Long.parseLong(offset);
    }
}

