/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.producer.support;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.utils.Bytes;

public final class ProducerUtil {
    private ProducerUtil() {
    }

    public static Object tryConvertToSerializedType(Exchange exchange, Object object, String valueSerializer) {
        byte[] array;
        Object answer = null;
        if (exchange == null) {
            return object;
        }
        if ("org.apache.kafka.common.serialization.StringSerializer".equals(valueSerializer)) {
            answer = exchange.getContext().getTypeConverter().tryConvertTo(String.class, exchange, object);
        } else if ("org.apache.kafka.common.serialization.ByteArraySerializer".equals(valueSerializer)) {
            answer = exchange.getContext().getTypeConverter().tryConvertTo(byte[].class, exchange, object);
        } else if ("org.apache.kafka.common.serialization.ByteBufferSerializer".equals(valueSerializer)) {
            answer = exchange.getContext().getTypeConverter().tryConvertTo(ByteBuffer.class, exchange, object);
        } else if ("org.apache.kafka.common.serialization.BytesSerializer".equals(valueSerializer) && (array = (byte[])exchange.getContext().getTypeConverter().tryConvertTo(byte[].class, exchange, object)) != null) {
            answer = new Bytes(array);
        }
        return answer != null ? answer : object;
    }

    static void setException(Object body, Exception e) {
        if (e != null) {
            if (body instanceof Exchange) {
                ((Exchange)body).setException((Throwable)e);
            }
            if (body instanceof Message && ((Message)body).getExchange() != null) {
                ((Message)body).getExchange().setException((Throwable)e);
            }
        }
    }

    static void setRecordMetadata(Object body, RecordMetadata recordMetadata) {
        List<RecordMetadata> recordMetadataList = Collections.singletonList(recordMetadata);
        ProducerUtil.setRecordMetadata(body, recordMetadataList);
    }

    public static void setRecordMetadata(Object body, List<RecordMetadata> recordMetadataList) {
        if (body instanceof Exchange) {
            Exchange ex = (Exchange)body;
            ex.getMessage().setHeader("org.apache.kafka.clients.producer.RecordMetadata", recordMetadataList);
        }
        if (body instanceof Message) {
            Message msg = (Message)body;
            msg.setHeader("org.apache.kafka.clients.producer.RecordMetadata", recordMetadataList);
        }
    }
}

