/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OffsetCache {
    private static final Logger LOG = LoggerFactory.getLogger(OffsetCache.class);
    private final Map<TopicPartition, Long> lastProcessedOffset = new ConcurrentHashMap<TopicPartition, Long>();

    OffsetCache() {
    }

    public void recordOffset(TopicPartition partition, long partitionLastOffset) {
        this.lastProcessedOffset.put(partition, partitionLastOffset);
    }

    public void removeCommittedEntries(Map<TopicPartition, OffsetAndMetadata> committed, Exception exception) {
        if (exception == null) {
            committed.forEach(this::removeCommittedEntry);
        } else {
            LOG.error("Failed to commit offset: {}", (Object)exception.getMessage(), (Object)exception);
        }
    }

    private void removeCommittedEntry(TopicPartition topicPartition, OffsetAndMetadata offsetAndMetadata) {
        LOG.debug("Offset {} from topic {} from partition {} has been successfully committed and is being removed from tracking", new Object[]{offsetAndMetadata.offset(), topicPartition.topic(), topicPartition.partition()});
        this.lastProcessedOffset.remove(topicPartition);
    }

    public Long getOffset(TopicPartition partition) {
        return this.lastProcessedOffset.get(partition);
    }

    public long cacheSize() {
        return this.lastProcessedOffset.size();
    }

    public boolean contains(TopicPartition topicPartition) {
        return this.lastProcessedOffset.containsKey(topicPartition);
    }
}

