/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class MiloClientEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":endpointUri";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "milo-client".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "endpointUri", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(34);
        props.add("allowedSecurityPolicies");
        props.add("applicationName");
        props.add("applicationUri");
        props.add("bridgeErrorHandler");
        props.add("channelLifetime");
        props.add("clientId");
        props.add("dataChangeFilterDeadbandType");
        props.add("dataChangeFilterDeadbandValue");
        props.add("dataChangeFilterTrigger");
        props.add("defaultAwaitWrites");
        props.add("discoveryEndpointSuffix");
        props.add("discoveryEndpointUri");
        props.add("endpointUri");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("keyAlias");
        props.add("keyPassword");
        props.add("keyStorePassword");
        props.add("keyStoreType");
        props.add("keyStoreUrl");
        props.add("lazyStartProducer");
        props.add("maxPendingPublishRequests");
        props.add("maxResponseMessageSize");
        props.add("method");
        props.add("monitorFilterType");
        props.add("node");
        props.add("omitNullValues");
        props.add("overrideHost");
        props.add("productUri");
        props.add("requestTimeout");
        props.add("requestedPublishingInterval");
        props.add("samplingInterval");
        props.add("sessionName");
        props.add("sessionTimeout");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("keyPassword");
        secretProps.add("keyStorePassword");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

