/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.plc4x;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.plc4x.Plc4XEndpoint;
import org.apache.camel.support.EventDrivenPollingConsumer;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plc4XPollingConsumer
extends EventDrivenPollingConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Plc4XPollingConsumer.class);
    private final Plc4XEndpoint plc4XEndpoint;

    public Plc4XPollingConsumer(Plc4XEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.plc4XEndpoint = endpoint;
    }

    public String toString() {
        return "Plc4XPollingConsumer[" + this.plc4XEndpoint + "]";
    }

    public Endpoint getEndpoint() {
        return this.plc4XEndpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        try {
            this.plc4XEndpoint.setupConnection();
        }
        catch (PlcConnectionException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.error("Connection setup failed, stopping PollingConsumer", (Throwable)e);
            } else {
                LOGGER.error("Connection setup failed, stopping PollingConsumer");
            }
            this.doStop();
        }
    }

    public Exchange receive() {
        return this.doReceive(-1L);
    }

    public Exchange receiveNoWait() {
        return this.doReceive(0L);
    }

    public Exchange receive(long timeout) {
        return this.doReceive(timeout);
    }

    protected Exchange doReceive(long timeout) {
        Exchange exchange = this.plc4XEndpoint.createExchange();
        try {
            this.plc4XEndpoint.reconnectIfNeeded();
            PlcReadRequest request = this.plc4XEndpoint.buildPlcReadRequest();
            CompletionStage future = request.execute().whenComplete((plcReadResponse, throwable) -> {});
            PlcReadResponse response = timeout >= 0L ? (PlcReadResponse)((CompletableFuture)future).get(timeout, TimeUnit.MILLISECONDS) : (PlcReadResponse)((CompletableFuture)future).get();
            HashMap<String, Object> rsp = new HashMap<String, Object>();
            for (String field : response.getFieldNames()) {
                rsp.put(field, response.getObject(field));
            }
            exchange.getIn().setBody(rsp);
        }
        catch (ExecutionException | TimeoutException e) {
            this.getExceptionHandler().handleException((Throwable)e);
            exchange.getIn().setBody(new HashMap());
        }
        catch (InterruptedException e) {
            this.getExceptionHandler().handleException((Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (PlcConnectionException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.warn("Unable to reconnect, skipping request", (Throwable)e);
            } else {
                LOGGER.warn("Unable to reconnect, skipping request");
            }
            exchange.getIn().setBody(new HashMap());
        }
        return exchange;
    }
}

