/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLRUCacheFactory
extends LRUCacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLRUCacheFactory.class);

    @Override
    public <K, V> Map<K, V> createLRUCache(int maximumCacheSize) {
        LOG.trace("Creating LRUCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new SimpleLRUCache(maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUCache(int maximumCacheSize, Consumer<V> onEvict) {
        LOG.trace("Creating LRUCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new SimpleLRUCache(16, maximumCacheSize, onEvict);
    }

    @Override
    public <K, V> Map<K, V> createLRUCache(int initialCapacity, int maximumCacheSize) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}", (Object)initialCapacity, (Object)maximumCacheSize);
        return new SimpleLRUCache(initialCapacity, maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", new Object[]{initialCapacity, maximumCacheSize, stopOnEviction});
        return new SimpleLRUCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    @Override
    public <K, V> Map<K, V> createLRUSoftCache(int maximumCacheSize) {
        LOG.trace("Creating LRUSoftCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new SimpleLRUCache(maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUSoftCache(int initialCapacity, int maximumCacheSize) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}", (Object)initialCapacity, (Object)maximumCacheSize);
        return new SimpleLRUCache(initialCapacity, maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUSoftCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", new Object[]{initialCapacity, maximumCacheSize, stopOnEviction});
        return new SimpleLRUCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    @Override
    public <K, V> Map<K, V> createLRUWeakCache(int maximumCacheSize) {
        LOG.trace("Creating LRUWeakCache with maximumCacheSize: {}", (Object)maximumCacheSize);
        return new SimpleLRUCache(maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUWeakCache(int initialCapacity, int maximumCacheSize) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}", (Object)initialCapacity, (Object)maximumCacheSize);
        return new SimpleLRUCache(initialCapacity, maximumCacheSize);
    }

    @Override
    public <K, V> Map<K, V> createLRUWeakCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
        LOG.trace("Creating LRUCache with initialCapacity: {}, maximumCacheSize: {}, stopOnEviction: {}", new Object[]{initialCapacity, maximumCacheSize, stopOnEviction});
        return new SimpleLRUCache(initialCapacity, maximumCacheSize, stopOnEviction);
    }

    <V> void doNothing(V value) {
    }

    <V> void doStop(V value) {
        try {
            ServiceHelper.stopService(value);
        }
        catch (Exception e) {
            LOG.warn("Error stopping service: {}. This exception will be ignored.", value, (Object)e);
        }
    }

    class SimpleLRUCache<K, V>
    extends ConcurrentHashMap<K, V> {
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private final AtomicBoolean eviction;
        private final int maximumCacheSize;
        private final Queue<Map.Entry<K, V>> lastChanges;
        private final LongAdder totalChanges;
        private final Consumer<V> evict;

        public SimpleLRUCache(int maximumCacheSize) {
            this(16, maximumCacheSize, maximumCacheSize > 0);
        }

        public SimpleLRUCache(int initialCapacity, int maximumCacheSize) {
            this(initialCapacity, maximumCacheSize, maximumCacheSize > 0);
        }

        public SimpleLRUCache(int initialCapacity, int maximumCacheSize, boolean stopOnEviction) {
            this(initialCapacity, maximumCacheSize, stopOnEviction ? this$0::doStop : this$0::doNothing);
        }

        public SimpleLRUCache(int initialCapacity, int maximumCacheSize, Consumer<V> evicted) {
            super(initialCapacity, 0.75f);
            this.eviction = new AtomicBoolean();
            this.lastChanges = new ConcurrentLinkedQueue<Map.Entry<K, V>>();
            this.totalChanges = new LongAdder();
            this.maximumCacheSize = maximumCacheSize;
            this.evict = Objects.requireNonNull(evicted);
        }

        private V addChange(OperationContext<K, V> context, Function<? super K, ? extends V> mappingFunction) {
            Object key = context.key;
            V value = mappingFunction.apply(key);
            if (value == null) {
                return null;
            }
            this.lastChanges.add(Map.entry(key, value));
            this.totalChanges.increment();
            return value;
        }

        @Override
        public V put(K key, V value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            try (OperationContext context = new OperationContext(this, key);){
                super.compute(key, (k, v) -> {
                    context.result = v;
                    return this.addChange(context, x -> value);
                });
                Object v2 = context.result;
                return v2;
            }
        }

        @Override
        public V putIfAbsent(K key, V value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            try (OperationContext context = new OperationContext(this, key);){
                super.compute(key, (k, v) -> {
                    context.result = v;
                    if (v != null) {
                        return v;
                    }
                    return this.addChange(context, x -> value);
                });
                Object v2 = context.result;
                return v2;
            }
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            if (key == null || mappingFunction == null) {
                throw new NullPointerException();
            }
            try (OperationContext context = new OperationContext(this, key);){
                Object object = super.computeIfAbsent(key, k -> this.addChange(context, mappingFunction));
                return (V)object;
            }
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            if (key == null || remappingFunction == null) {
                throw new NullPointerException();
            }
            try (OperationContext context = new OperationContext(this, key);){
                Object object = super.computeIfPresent(key, (k, v) -> this.addChange(context, x -> remappingFunction.apply((Object)x, (Object)v)));
                return (V)object;
            }
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            if (key == null || remappingFunction == null) {
                throw new NullPointerException();
            }
            try (OperationContext context = new OperationContext(this, key);){
                Object object = super.compute(key, (k, v) -> this.addChange(context, x -> remappingFunction.apply((Object)x, (Object)v)));
                return (V)object;
            }
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            if (key == null || value == null || remappingFunction == null) {
                throw new NullPointerException();
            }
            try (OperationContext context = new OperationContext(this, key);){
                Object object = super.compute(key, (k, oldValue) -> {
                    Object newValue = oldValue == null ? value : remappingFunction.apply((V)oldValue, (V)value);
                    return this.addChange(context, x -> newValue);
                });
                return (V)object;
            }
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            if (key == null || oldValue == null || newValue == null) {
                throw new NullPointerException();
            }
            try (OperationContext context = new OperationContext(this, key);){
                super.computeIfPresent(key, (k, v) -> {
                    if (Objects.equals(oldValue, v)) {
                        context.result = this.addChange(context, x -> newValue);
                        return context.result;
                    }
                    return v;
                });
                boolean bl = context.result != null && Objects.equals(context.result, newValue);
                return bl;
            }
        }

        @Override
        public V replace(K key, V value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            try (OperationContext context = new OperationContext(this, key);){
                super.computeIfPresent(key, (k, v) -> {
                    context.result = v;
                    return this.addChange(context, x -> value);
                });
                Object v2 = context.result;
                return v2;
            }
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> e : m.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            for (Map.Entry<K, V> e : this.entrySet()) {
                this.replace(e.getKey(), e.getValue(), function.apply(e.getKey(), e.getValue()));
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.unmodifiableSet(super.entrySet());
        }

        int getQueueSize() {
            return this.totalChanges.intValue();
        }

        private boolean evictionNeeded() {
            return this.size() > this.maximumCacheSize || this.getQueueSize() > 2 * this.maximumCacheSize;
        }

        private Map.Entry<K, V> nextOldestChange() {
            Map.Entry<K, V> oldest = this.lastChanges.poll();
            if (oldest != null) {
                this.totalChanges.decrement();
            }
            return oldest;
        }
    }

    private static class OperationContext<K, V>
    implements AutoCloseable {
        V result;
        final K key;
        private final SimpleLRUCache<K, V> cache;

        OperationContext(SimpleLRUCache<K, V> cache, K key) {
            this.cache = cache;
            this.key = key;
        }

        @Override
        public void close() {
            if (this.cache.evictionNeeded() && this.cache.eviction.compareAndSet(false, true)) {
                try {
                    while (this.cache.evictionNeeded()) {
                        Map.Entry<K, V> oldest = this.cache.nextOldestChange();
                        if (oldest == null || !this.cache.remove(oldest.getKey(), oldest.getValue())) continue;
                        this.cache.evict.accept(oldest.getValue());
                    }
                }
                finally {
                    this.cache.eviction.set(false);
                }
            }
        }
    }
}

