/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.policy.MetadataConstants;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.wss4j.common.derivedKey.ConversationConstants;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.token.SecurityContextToken;
import org.apache.wss4j.policy.model.AbstractBinding;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.policy.model.Trust10;
import org.apache.wss4j.policy.model.Trust13;

final class NegotiationUtils {
    private NegotiationUtils() {
    }

    static Trust10 getTrust10(AssertionInfoMap aim) {
        AssertionInfo ai = NegotiationUtils.getFirstAssertionByLocalname(aim, "Trust10");
        if (ai == null) {
            return null;
        }
        return (Trust10)ai.getAssertion();
    }

    static Trust13 getTrust13(AssertionInfoMap aim) {
        AssertionInfo ai = NegotiationUtils.getFirstAssertionByLocalname(aim, "Trust13");
        if (ai == null) {
            return null;
        }
        return (Trust13)ai.getAssertion();
    }

    static TokenStore getTokenStore(Message message) {
        return WSS4JUtils.getTokenStore(message);
    }

    static Assertion getAddressingPolicy(AssertionInfoMap aim, boolean optional) {
        Collection lst = (Collection)aim.get((Object)MetadataConstants.USING_ADDRESSING_2004_QNAME);
        Assertion assertion = null;
        if (null != lst && !lst.isEmpty()) {
            assertion = ((AssertionInfo)lst.iterator().next()).getAssertion();
        }
        if (assertion == null && null != (lst = (Collection)aim.get((Object)MetadataConstants.USING_ADDRESSING_2005_QNAME)) && !lst.isEmpty()) {
            assertion = ((AssertionInfo)lst.iterator().next()).getAssertion();
        }
        if (assertion == null && null != (lst = (Collection)aim.get((Object)MetadataConstants.USING_ADDRESSING_2006_QNAME)) && !lst.isEmpty()) {
            assertion = ((AssertionInfo)lst.iterator().next()).getAssertion();
        }
        if (assertion == null) {
            return new PrimitiveAssertion(MetadataConstants.USING_ADDRESSING_2006_QNAME, optional);
        }
        if (optional) {
            return new PrimitiveAssertion(assertion.getName(), optional);
        }
        return assertion;
    }

    static AlgorithmSuite getAlgorithmSuite(AssertionInfoMap aim) {
        AbstractBinding transport = null;
        Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "TransportBinding");
        if (!ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                transport = (AbstractBinding)ai.getAssertion();
            }
        } else {
            ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "AsymmetricBinding");
            if (!ais.isEmpty()) {
                for (AssertionInfo ai : ais) {
                    transport = (AbstractBinding)ai.getAssertion();
                }
            } else {
                ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "SymmetricBinding");
                if (!ais.isEmpty()) {
                    for (AssertionInfo ai : ais) {
                        transport = (AbstractBinding)ai.getAssertion();
                    }
                }
            }
        }
        if (transport != null) {
            return transport.getAlgorithmSuite();
        }
        return null;
    }

    static int getWSCVersion(String tokenTypeValue) throws WSSecurityException {
        if (tokenTypeValue == null) {
            return 2;
        }
        if (tokenTypeValue.startsWith("http://schemas.xmlsoap.org/ws/2005/02/sc")) {
            return ConversationConstants.getWSTVersion((String)"http://schemas.xmlsoap.org/ws/2005/02/sc");
        }
        if (tokenTypeValue.startsWith("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512")) {
            return ConversationConstants.getWSTVersion((String)"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512");
        }
        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "unsupportedSecConvVersion", new Object[0]);
    }

    static void recalcEffectivePolicy(SoapMessage message, String namespace, Policy policy, Invoker invoker, boolean secConv) {
        Exchange ex = message.getExchange();
        Bus bus = ex.getBus();
        PolicyEngine pe = (PolicyEngine)bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            return;
        }
        Destination destination = ex.getDestination();
        try {
            Endpoint endpoint = message.getExchange().getEndpoint();
            TokenStore store = NegotiationUtils.getTokenStore((Message)message);
            endpoint = secConv ? STSUtils.createSCEndpoint(bus, namespace, endpoint.getEndpointInfo().getTransportId(), destination.getAddress().getAddress().getValue(), message.getVersion().getBindingId(), policy) : STSUtils.createSTSEndpoint(bus, namespace, endpoint.getEndpointInfo().getTransportId(), destination.getAddress().getAddress().getValue(), message.getVersion().getBindingId(), policy, null);
            endpoint.getEndpointInfo().setProperty(TokenStore.class.getName(), (Object)store);
            message.getExchange().put((Object)TokenStore.class.getName(), (Object)store);
            EndpointPolicy ep = pe.getServerEndpointPolicy(endpoint.getEndpointInfo(), destination, (Message)message);
            List interceptors = ep.getInterceptors((Message)message);
            for (Interceptor i : interceptors) {
                message.getInterceptorChain().add(i);
            }
            Collection assertions = ep.getVocabulary((Message)message);
            if (null != assertions) {
                message.put(AssertionInfoMap.class, (Object)new AssertionInfoMap(assertions));
            }
            endpoint.getService().setInvoker(invoker);
            ex.put(Endpoint.class, (Object)endpoint);
            ex.put(Service.class, (Object)endpoint.getService());
            ex.put(Binding.class, (Object)endpoint.getBinding());
            ex.remove(BindingOperationInfo.class);
            message.put(MAPAggregator.ACTION_VERIFIED, (Object)Boolean.TRUE);
        }
        catch (Exception exc) {
            throw new Fault((Throwable)exc);
        }
    }

    static boolean parseSCTResult(SoapMessage message) {
        List results = CastUtils.cast((List)((List)message.get((Object)"RECV_RESULTS")));
        if (results == null) {
            return false;
        }
        for (WSHandlerResult rResult : results) {
            List wsSecEngineResults = rResult.getResults();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                SecurityContext sc;
                byte[] secret;
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 1024) continue;
                SecurityContextToken tok = (SecurityContextToken)wser.get((Object)"security-context-token");
                message.getExchange().put((Object)"ws-security.token.id", (Object)tok.getIdentifier());
                SecurityToken token = NegotiationUtils.getTokenStore((Message)message).getToken(tok.getIdentifier());
                if ((token == null || token.isExpired()) && (secret = (byte[])wser.get((Object)"secret")) != null) {
                    token = new SecurityToken(tok.getIdentifier());
                    token.setToken(tok.getElement());
                    token.setSecret(secret);
                    token.setTokenType(tok.getTokenType());
                    NegotiationUtils.getTokenStore((Message)message).add(token);
                }
                if ((sc = token.getSecurityContext()) != null) {
                    message.put(SecurityContext.class, (Object)sc);
                }
                return true;
            }
        }
        return false;
    }

    static CallbackHandler getCallbackHandler(Object o, Class<?> clazz) {
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), clazz).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        return handler;
    }

    static boolean assertPolicy(AssertionInfoMap aim, QName name) {
        Collection ais = aim.getAssertionInfo(name);
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
            return true;
        }
        return false;
    }

    static boolean assertPolicy(AssertionInfoMap aim, String localname) {
        Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, localname);
        if (!ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
            return true;
        }
        return false;
    }

    static Collection<AssertionInfo> getAllAssertionsByLocalname(AssertionInfoMap aim, String localname) {
        Collection sp11Ais = (Collection)aim.get((Object)new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", localname));
        Collection sp12Ais = (Collection)aim.get((Object)new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", localname));
        if (sp11Ais != null && !sp11Ais.isEmpty() || sp12Ais != null && !sp12Ais.isEmpty()) {
            HashSet<AssertionInfo> ais = new HashSet<AssertionInfo>();
            if (sp11Ais != null) {
                ais.addAll(sp11Ais);
            }
            if (sp12Ais != null) {
                ais.addAll(sp12Ais);
            }
            return ais;
        }
        return Collections.emptySet();
    }

    static AssertionInfo getFirstAssertionByLocalname(AssertionInfoMap aim, String localname) {
        Collection sp11Ais = (Collection)aim.get((Object)new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", localname));
        if (sp11Ais != null && !sp11Ais.isEmpty()) {
            return (AssertionInfo)sp11Ais.iterator().next();
        }
        Collection sp12Ais = (Collection)aim.get((Object)new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", localname));
        if (sp12Ais != null && !sp12Ais.isEmpty()) {
            return (AssertionInfo)sp12Ais.iterator().next();
        }
        return null;
    }

    static boolean isThereAnAssertionByLocalname(AssertionInfoMap aim, String localname) {
        Collection sp11Ais = (Collection)aim.get((Object)new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", localname));
        Collection sp12Ais = (Collection)aim.get((Object)new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", localname));
        return sp11Ais != null && !sp11Ais.isEmpty() || sp12Ais != null && !sp12Ais.isEmpty();
    }
}

