/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.trust;

import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.VersionTransformer;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.neethi.Policy;
import org.apache.wss4j.policy.model.IssuedToken;
import org.w3c.dom.Element;

public final class STSUtils {
    public static final String WST_NS_05_02 = "http://schemas.xmlsoap.org/ws/2005/02/trust";
    public static final String WST_NS_05_12 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    public static final String WST_NS_08_02 = "http://docs.oasis-open.org/ws-sx/ws-trust/200802";
    public static final String SCT_NS_05_02 = "http://schemas.xmlsoap.org/ws/2005/02/sc";
    public static final String SCT_NS_05_12 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512";
    public static final String TOKEN_TYPE_SCT_05_02 = "http://schemas.xmlsoap.org/ws/2005/02/sc/sct";
    public static final String TOKEN_TYPE_SCT_05_12 = "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct";

    private STSUtils() {
    }

    public static String getTokenTypeSCT(String trustNs) {
        if (WST_NS_05_02.equals(trustNs)) {
            return TOKEN_TYPE_SCT_05_02;
        }
        return TOKEN_TYPE_SCT_05_12;
    }

    public static STSClient getClient(Message message, String type) {
        return STSUtils.getClient(message, type, null);
    }

    public static STSClient getClient(Message message, String type, IssuedToken itok) {
        STSClient client = (STSClient)message.getContextualProperty("ws-security.sts.client");
        if (client == null) {
            type = type == null ? "" : "." + type + "-client";
            client = new STSClient((Bus)message.getExchange().get(Bus.class));
            Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
            client.setEndpointName(ep.getEndpointInfo().getName().toString() + type);
            client.setBeanName(ep.getEndpointInfo().getName().toString() + type);
            if (MessageUtils.getContextualBoolean((Message)message, (String)"ws-security.sts.client-soap12-binding", (boolean)false)) {
                client.setSoap12();
            }
        }
        if (client.getLocation() == null && client.getWsdlLocation() == null && itok != null && itok.getIssuer() != null) {
            EndpointReferenceType epr = null;
            try {
                epr = VersionTransformer.parseEndpointReference((Element)itok.getIssuer());
            }
            catch (JAXBException e) {
                throw new IllegalArgumentException(e);
            }
            boolean useEPRWSAAddrAsMEXLocation = Boolean.valueOf((String)message.getContextualProperty("ws-security.sts.disable-wsmex-call-using-epr-address")) == false;
            client.configureViaEPR(epr, useEPRWSAAddrAsMEXLocation);
        }
        return client;
    }

    public static Endpoint createSTSEndpoint(Bus bus, String namespace, String transportId, String location, String soapVersion, Policy policy, QName epName) throws BusException, EndpointException {
        return STSUtils.createSTSEndpoint(bus, namespace, transportId, location, soapVersion, policy, epName, false);
    }

    public static Endpoint createSCEndpoint(Bus bus, String namespace, String transportId, String location, String soapVersion, Policy policy) throws BusException, EndpointException {
        return STSUtils.createSTSEndpoint(bus, namespace, transportId, location, soapVersion, policy, null, true);
    }

    private static Endpoint createSTSEndpoint(Bus bus, String namespace, String transportId, String location, String soapVersion, Policy policy, QName epName, boolean sc) throws BusException, EndpointException {
        BindingOperationInfo boi;
        SoapOperationInfo soi;
        ServiceImpl service = null;
        String ns = namespace + "/wsdl";
        ServiceInfo si = new ServiceInfo();
        QName iName = new QName(ns, sc ? "SecureConversationTokenService" : "SecurityTokenService");
        si.setName(iName);
        InterfaceInfo ii = new InterfaceInfo(si, iName);
        OperationInfo ioi = STSUtils.addIssueOperation(ii, namespace, ns);
        OperationInfo coi = STSUtils.addCancelOperation(ii, namespace, ns);
        si.setInterface(ii);
        service = new ServiceImpl(si);
        BindingFactoryManager bfm = (BindingFactoryManager)bus.getExtension(BindingFactoryManager.class);
        BindingFactory bindingFactory = bfm.getBindingFactory(soapVersion);
        BindingInfo bi = bindingFactory.createBindingInfo((Service)service, soapVersion, null);
        si.addBinding(bi);
        if (transportId == null) {
            ConduitInitiatorManager cim = (ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class);
            ConduitInitiator ci = cim.getConduitInitiatorForUri(location);
            transportId = (String)ci.getTransportIds().get(0);
        }
        EndpointInfo ei = new EndpointInfo(si, transportId);
        ei.setBinding(bi);
        ei.setName(epName == null ? iName : epName);
        ei.setAddress(location);
        si.addEndpoint(ei);
        if (policy != null) {
            ei.addExtensor((Object)policy);
        }
        if ((soi = (SoapOperationInfo)(boi = bi.getOperation(ioi)).getExtensor(SoapOperationInfo.class)) == null) {
            soi = new SoapOperationInfo();
            boi.addExtensor((Object)soi);
        }
        soi.setAction(namespace + (sc ? "/RST/SCT" : "/RST/Issue"));
        boi = bi.getOperation(coi);
        soi = (SoapOperationInfo)boi.getExtensor(SoapOperationInfo.class);
        if (soi == null) {
            soi = new SoapOperationInfo();
            boi.addExtensor((Object)soi);
        }
        soi.setAction(namespace + (sc ? "/RST/SCT/Cancel" : "/RST/Cancel"));
        service.setDataBinding((DataBinding)new SourceDataBinding());
        return new EndpointImpl(bus, (Service)service, ei);
    }

    private static OperationInfo addIssueOperation(InterfaceInfo ii, String namespace, String servNamespace) {
        OperationInfo oi = ii.addOperation(new QName(servNamespace, "RequestSecurityToken"));
        MessageInfo mii = oi.createMessage(new QName(servNamespace, "RequestSecurityTokenMsg"), MessageInfo.Type.INPUT);
        oi.setInput("RequestSecurityTokenMsg", mii);
        MessagePartInfo mpi = mii.addMessagePart("request");
        mpi.setElementQName(new QName(namespace, "RequestSecurityToken"));
        MessageInfo mio = oi.createMessage(new QName(servNamespace, "RequestSecurityTokenResponseMsg"), MessageInfo.Type.OUTPUT);
        oi.setOutput("RequestSecurityTokenResponseMsg", mio);
        mpi = mio.addMessagePart("response");
        if (WST_NS_05_02.equals(namespace)) {
            mpi.setElementQName(new QName(namespace, "RequestSecurityTokenResponse"));
        } else {
            mpi.setElementQName(new QName(namespace, "RequestSecurityTokenResponseCollection"));
        }
        return oi;
    }

    private static OperationInfo addCancelOperation(InterfaceInfo ii, String namespace, String servNamespace) {
        OperationInfo oi = ii.addOperation(new QName(servNamespace, "CancelSecurityToken"));
        MessageInfo mii = oi.createMessage(new QName(servNamespace, "CancelSecurityTokenMsg"), MessageInfo.Type.INPUT);
        oi.setInput("CancelSecurityTokenMsg", mii);
        MessagePartInfo mpi = mii.addMessagePart("request");
        mpi.setElementQName(new QName(namespace, "RequestSecurityToken"));
        MessageInfo mio = oi.createMessage(new QName(servNamespace, "CancelSecurityTokenResponseMsg"), MessageInfo.Type.OUTPUT);
        oi.setOutput("CancelSecurityTokenResponseMsg", mio);
        mpi = mio.addMessagePart("response");
        if (WST_NS_05_02.equals(namespace)) {
            mpi.setElementQName(new QName(namespace, "RequestSecurityTokenResponse"));
        } else {
            mpi.setElementQName(new QName(namespace, "RequestSecurityTokenResponseCollection"));
        }
        return oi;
    }
}

