/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.common.url.component.URLParam;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.client.InstanceAddressURL;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ServiceModel;

public class OverrideInstanceAddressURL
extends InstanceAddressURL {
    private static final long serialVersionUID = 1373220432794558426L;
    private final URLParam overrideParams;
    private final InstanceAddressURL originUrl;

    public OverrideInstanceAddressURL(InstanceAddressURL originUrl) {
        this.originUrl = originUrl;
        this.overrideParams = URLParam.parse((String)"");
    }

    public OverrideInstanceAddressURL(InstanceAddressURL originUrl, URLParam overrideParams) {
        this.originUrl = originUrl;
        this.overrideParams = overrideParams;
    }

    @Override
    public ServiceInstance getInstance() {
        return this.originUrl.getInstance();
    }

    @Override
    public MetadataInfo getMetadataInfo() {
        return this.originUrl.getMetadataInfo();
    }

    @Override
    public String getServiceInterface() {
        return this.originUrl.getServiceInterface();
    }

    @Override
    public String getGroup() {
        return this.originUrl.getGroup();
    }

    @Override
    public String getVersion() {
        return this.originUrl.getVersion();
    }

    @Override
    public String getProtocol() {
        return this.originUrl.getProtocol();
    }

    @Override
    public String getProtocolServiceKey() {
        return this.originUrl.getProtocolServiceKey();
    }

    @Override
    public String getServiceKey() {
        return this.originUrl.getServiceKey();
    }

    @Override
    public String getAddress() {
        return this.originUrl.getAddress();
    }

    @Override
    public String getHost() {
        return this.originUrl.getHost();
    }

    @Override
    public int getPort() {
        return this.originUrl.getPort();
    }

    @Override
    public String getIp() {
        return this.originUrl.getIp();
    }

    @Override
    public String getPath() {
        return this.originUrl.getPath();
    }

    @Override
    public String getParameter(String key) {
        String overrideParam = this.overrideParams.getParameter(key);
        return StringUtils.isNotEmpty((String)overrideParam) ? overrideParam : this.originUrl.getParameter(key);
    }

    @Override
    public String getServiceParameter(String service, String key) {
        String overrideParam = this.overrideParams.getParameter(key);
        return StringUtils.isNotEmpty((String)overrideParam) ? overrideParam : this.originUrl.getServiceParameter(service, key);
    }

    @Override
    public String getServiceMethodParameter(String protocolServiceKey, String method, String key) {
        String overrideParam = this.overrideParams.getMethodParameter(method, key);
        return StringUtils.isNotEmpty((String)overrideParam) ? overrideParam : this.originUrl.getServiceMethodParameter(protocolServiceKey, method, key);
    }

    @Override
    public String getMethodParameter(String method, String key) {
        String overrideParam = this.overrideParams.getMethodParameter(method, key);
        return StringUtils.isNotEmpty((String)overrideParam) ? overrideParam : this.originUrl.getMethodParameter(method, key);
    }

    @Override
    public boolean hasServiceMethodParameter(String protocolServiceKey, String method, String key) {
        return StringUtils.isNotEmpty((String)this.overrideParams.getMethodParameter(method, key)) || this.originUrl.hasServiceMethodParameter(protocolServiceKey, method, key);
    }

    @Override
    public boolean hasMethodParameter(String method, String key) {
        return StringUtils.isNotEmpty((String)this.overrideParams.getMethodParameter(method, key)) || this.originUrl.hasMethodParameter(method, key);
    }

    @Override
    public boolean hasServiceMethodParameter(String protocolServiceKey, String method) {
        return this.overrideParams.hasMethodParameter(method) || this.originUrl.hasServiceMethodParameter(protocolServiceKey, method);
    }

    @Override
    public boolean hasMethodParameter(String method) {
        return this.overrideParams.hasMethodParameter(method) || this.originUrl.hasMethodParameter(method);
    }

    @Override
    public Map<String, String> getServiceParameters(String protocolServiceKey) {
        Map<String, String> parameters = this.originUrl.getServiceParameters(protocolServiceKey);
        Map overrideParameters = this.overrideParams.getParameters();
        HashMap<String, String> result = new HashMap<String, String>((int)((float)parameters.size() + (float)overrideParameters.size() / 0.75f) + 1);
        result.putAll(parameters);
        result.putAll(overrideParameters);
        return result;
    }

    @Override
    public Map<String, String> getParameters() {
        Map<String, String> parameters = this.originUrl.getParameters();
        Map overrideParameters = this.overrideParams.getParameters();
        HashMap<String, String> result = new HashMap<String, String>((int)((float)parameters.size() + (float)overrideParameters.size() / 0.75f) + 1);
        result.putAll(parameters);
        result.putAll(overrideParameters);
        return result;
    }

    @Override
    public URL addParameter(String key, String value) {
        return new OverrideInstanceAddressURL(this.originUrl, this.overrideParams.addParameter(key, value));
    }

    @Override
    public URL addParameterIfAbsent(String key, String value) {
        return new OverrideInstanceAddressURL(this.originUrl, this.overrideParams.addParameterIfAbsent(key, value));
    }

    @Override
    public URL addServiceParameter(String protocolServiceKey, String key, String value) {
        return this.originUrl.addServiceParameter(protocolServiceKey, key, value);
    }

    @Override
    public URL addServiceParameterIfAbsent(String protocolServiceKey, String key, String value) {
        return this.originUrl.addServiceParameterIfAbsent(protocolServiceKey, key, value);
    }

    @Override
    public URL addConsumerParams(String protocolServiceKey, Map<String, String> params) {
        return this.originUrl.addConsumerParams(protocolServiceKey, params);
    }

    @Override
    public String getAnyMethodParameter(String key) {
        String overrideParam = this.overrideParams.getAnyMethodParameter(key);
        return StringUtils.isNotEmpty((String)overrideParam) ? overrideParam : this.originUrl.getAnyMethodParameter(key);
    }

    public URL addParameters(Map<String, String> parameters) {
        return new OverrideInstanceAddressURL(this.originUrl, this.overrideParams.addParameters(parameters));
    }

    public URL addParametersIfAbsent(Map<String, String> parameters) {
        return new OverrideInstanceAddressURL(this.originUrl, this.overrideParams.addParametersIfAbsent(parameters));
    }

    @Override
    public URLParam getUrlParam() {
        return this.originUrl.getUrlParam();
    }

    @Override
    public URLAddress getUrlAddress() {
        return this.originUrl.getUrlAddress();
    }

    public URLParam getOverrideParams() {
        return this.overrideParams;
    }

    @Override
    public String getRemoteApplication() {
        return this.originUrl.getRemoteApplication();
    }

    @Override
    public String getSide() {
        return this.originUrl.getSide();
    }

    @Override
    public ScopeModel getScopeModel() {
        return this.originUrl.getScopeModel();
    }

    @Override
    public FrameworkModel getOrDefaultFrameworkModel() {
        return this.originUrl.getOrDefaultFrameworkModel();
    }

    @Override
    public ApplicationModel getOrDefaultApplicationModel() {
        return this.originUrl.getOrDefaultApplicationModel();
    }

    @Override
    public ApplicationModel getApplicationModel() {
        return this.originUrl.getApplicationModel();
    }

    public ModuleModel getOrDefaultModuleModel() {
        return this.originUrl.getOrDefaultModuleModel();
    }

    @Override
    public ServiceModel getServiceModel() {
        return this.originUrl.getServiceModel();
    }

    @Override
    public Set<String> getProviderFirstParams() {
        return this.originUrl.getProviderFirstParams();
    }

    @Override
    public void setProviderFirstParams(Set<String> providerFirstParams) {
        this.originUrl.setProviderFirstParams(providerFirstParams);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OverrideInstanceAddressURL that = (OverrideInstanceAddressURL)((Object)o);
        return Objects.equals(this.overrideParams, that.overrideParams) && Objects.equals((Object)this.originUrl, (Object)that.originUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.overrideParams, this.originUrl});
    }

    @Override
    public String toString() {
        return this.originUrl.toString() + ", overrideParams: " + this.overrideParams.toString();
    }

    private Object readResolve() {
        return new OverrideInstanceAddressURL(this.originUrl, this.overrideParams);
    }

    protected OverrideInstanceAddressURL newURL(URLAddress urlAddress, URLParam urlParam) {
        return new OverrideInstanceAddressURL(this.originUrl, this.overrideParams);
    }
}

