/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.Disposable;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.InstanceMetadataChangedListener;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.support.RegistryManager;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class MetadataServiceDelegation
implements MetadataService,
Disposable {
    ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private final ApplicationModel applicationModel;
    private final RegistryManager registryManager;
    private ConcurrentMap<String, InstanceMetadataChangedListener> instanceMetadataChangedListenerMap = new ConcurrentHashMap<String, InstanceMetadataChangedListener>();
    private URL url;
    private String instanceMetadata;

    public MetadataServiceDelegation(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.registryManager = RegistryManager.getInstance(applicationModel);
    }

    public String serviceName() {
        return ApplicationModel.ofNullable((ApplicationModel)this.applicationModel).getApplicationName();
    }

    public URL getMetadataURL() {
        return this.url;
    }

    public void setMetadataURL(URL url) {
        this.url = url;
    }

    public SortedSet<String> getSubscribedURLs() {
        return this.getAllUnmodifiableSubscribedURLs();
    }

    private SortedSet<String> getAllUnmodifiableServiceURLs() {
        TreeSet<URL> bizURLs = new TreeSet<URL>(URLComparator.INSTANCE);
        List<ServiceDiscovery> serviceDiscoveries = this.registryManager.getServiceDiscoveries();
        for (ServiceDiscovery sd : serviceDiscoveries) {
            MetadataInfo metadataInfo = sd.getLocalMetadata();
            ConcurrentNavigableMap serviceURLs = metadataInfo.getExportedServiceURLs();
            for (Map.Entry entry : serviceURLs.entrySet()) {
                SortedSet urls = (SortedSet)entry.getValue();
                if (urls == null) continue;
                for (URL url : urls) {
                    if (MetadataService.class.getName().equals(url.getServiceInterface())) continue;
                    bizURLs.add(url);
                }
            }
        }
        return MetadataService.toSortedStrings(bizURLs);
    }

    private SortedSet<String> getAllUnmodifiableSubscribedURLs() {
        TreeSet<URL> bizURLs = new TreeSet<URL>(URLComparator.INSTANCE);
        List<ServiceDiscovery> serviceDiscoveries = this.registryManager.getServiceDiscoveries();
        for (ServiceDiscovery sd : serviceDiscoveries) {
            MetadataInfo metadataInfo = sd.getLocalMetadata();
            ConcurrentNavigableMap serviceURLs = metadataInfo.getSubscribedServiceURLs();
            for (Map.Entry entry : serviceURLs.entrySet()) {
                SortedSet urls = (SortedSet)entry.getValue();
                if (urls == null) continue;
                for (URL url : urls) {
                    if (MetadataService.class.getName().equals(url.getServiceInterface())) continue;
                    bizURLs.add(url);
                }
            }
        }
        return MetadataService.toSortedStrings(bizURLs);
    }

    public SortedSet<String> getExportedURLs(String serviceInterface, String group, String version, String protocol) {
        if ("*".equals(serviceInterface)) {
            return this.getAllUnmodifiableServiceURLs();
        }
        String serviceKey = URL.buildKey((String)serviceInterface, (String)group, (String)version);
        return Collections.unmodifiableSortedSet(this.getServiceURLs(this.getAllServiceURLs(), serviceKey, protocol));
    }

    private Map<String, SortedSet<URL>> getAllServiceURLs() {
        List<ServiceDiscovery> serviceDiscoveries = this.registryManager.getServiceDiscoveries();
        HashMap<String, SortedSet<URL>> allServiceURLs = new HashMap<String, SortedSet<URL>>();
        for (ServiceDiscovery sd : serviceDiscoveries) {
            MetadataInfo metadataInfo = sd.getLocalMetadata();
            ConcurrentNavigableMap serviceURLs = metadataInfo.getExportedServiceURLs();
            allServiceURLs.putAll(serviceURLs);
        }
        return allServiceURLs;
    }

    public Set<URL> getExportedServiceURLs() {
        HashSet<URL> set = new HashSet<URL>();
        this.registryManager.getRegistries();
        for (Map.Entry<String, SortedSet<URL>> entry : this.getAllServiceURLs().entrySet()) {
            set.addAll((Collection<URL>)entry.getValue());
        }
        return set;
    }

    public String getServiceDefinition(String interfaceName, String version, String group) {
        return "";
    }

    public String getServiceDefinition(String serviceKey) {
        return "";
    }

    public MetadataInfo getMetadataInfo(String revision) {
        if (StringUtils.isEmpty((String)revision)) {
            return null;
        }
        for (ServiceDiscovery sd : this.registryManager.getServiceDiscoveries()) {
            MetadataInfo metadataInfo = sd.getLocalMetadata();
            if (!revision.equals(metadataInfo.getRevision())) continue;
            return metadataInfo;
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("1-39", "", "", "metadata not found for revision: " + revision);
        }
        return null;
    }

    public List<MetadataInfo> getMetadataInfos() {
        ArrayList<MetadataInfo> metadataInfos = new ArrayList<MetadataInfo>();
        for (ServiceDiscovery sd : this.registryManager.getServiceDiscoveries()) {
            metadataInfos.add(sd.getLocalMetadata());
        }
        return metadataInfos;
    }

    public void exportInstanceMetadata(String instanceMetadata) {
        this.instanceMetadata = instanceMetadata;
    }

    public Map<String, InstanceMetadataChangedListener> getInstanceMetadataChangedListenerMap() {
        return this.instanceMetadataChangedListenerMap;
    }

    public String getAndListenInstanceMetadata(String consumerId, InstanceMetadataChangedListener listener) {
        this.instanceMetadataChangedListenerMap.put(consumerId, listener);
        return this.instanceMetadata;
    }

    private SortedSet<String> getServiceURLs(Map<String, SortedSet<URL>> exportedServiceURLs, String serviceKey, String protocol) {
        SortedSet<URL> serviceURLs = exportedServiceURLs.get(serviceKey);
        if (CollectionUtils.isEmpty(serviceURLs)) {
            return Collections.emptySortedSet();
        }
        return MetadataService.toSortedStrings(serviceURLs.stream().filter(url -> this.isAcceptableProtocol(protocol, (URL)url)));
    }

    private boolean isAcceptableProtocol(String protocol, URL url) {
        return protocol == null || protocol.equals(url.getParameter("protocol")) || protocol.equals(url.getProtocol());
    }

    public void destroy() {
    }

    static class URLComparator
    implements Comparator<URL> {
        public static final URLComparator INSTANCE = new URLComparator();

        URLComparator() {
        }

        @Override
        public int compare(URL o1, URL o2) {
            return o1.toFullString().compareTo(o2.toFullString());
        }
    }
}

