/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.interceptor;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.rpc.RpcContext;
import org.springframework.web.servlet.HandlerInterceptor;

public class DubboTagCookieInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String tag = DubboTagCookieInterceptor.getSingleCookieValue(request.getCookies(), "dubbo.tag");
        RpcContext.getClientAttachment().setAttachment("dubbo.tag", tag);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        RpcContext.getClientAttachment().removeAttachment("dubbo.tag");
    }

    private static String getSingleCookieValue(Cookie[] cookies, String name) {
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }
}

