/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.com.caucho.hessian.io.socket;

import com.alibaba.com.caucho.hessian.io.AbstractDeserializer;
import com.alibaba.com.caucho.hessian.io.AbstractHessianInput;
import com.alibaba.com.caucho.hessian.io.IOExceptionWrapper;
import java.io.IOException;
import java.lang.reflect.Method;

public class UnixDomainSocketAddressSerDeserializer
extends AbstractDeserializer {
    private static Method UnixDomainSocketAddressOf = null;

    @Override
    public Object readObject(AbstractHessianInput in, Object[] fields) throws IOException {
        try {
            return this.readObject(in, (String[])fields);
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper("java.net.UnixDomainSocketAddress:" + e, e);
        }
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        try {
            String pathname = null;
            for (String fieldName : fieldNames) {
                if ("pathname".equals(fieldName)) {
                    pathname = in.readString();
                    continue;
                }
                in.readObject();
            }
            Object obj = UnixDomainSocketAddressOf.invoke(null, pathname);
            in.addRef(obj);
            return obj;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper("java.net.UnixDomainSocketAddress:" + e, e);
        }
    }

    static {
        try {
            Class<?> cl = Class.forName("java.net.UnixDomainSocketAddress");
            UnixDomainSocketAddressOf = cl.getMethod("of", String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

