/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.avro.AvroRowDeserializationSchema;
import org.apache.flink.formats.avro.AvroRowSerializationSchema;
import org.apache.flink.table.descriptors.AvroValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.DeserializationSchemaFactory;
import org.apache.flink.table.factories.SerializationSchemaFactory;
import org.apache.flink.table.factories.TableFormatFactoryBase;
import org.apache.flink.types.Row;

public class AvroRowFormatFactory
extends TableFormatFactoryBase<Row>
implements SerializationSchemaFactory<Row>,
DeserializationSchemaFactory<Row> {
    public AvroRowFormatFactory() {
        super("avro", 1, false);
    }

    protected List<String> supportedFormatProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("format.record-class");
        properties.add("format.avro-schema");
        return properties;
    }

    public DeserializationSchema<Row> createDeserializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = AvroRowFormatFactory.getValidatedProperties(properties);
        if (descriptorProperties.containsKey("format.record-class")) {
            return new AvroRowDeserializationSchema(descriptorProperties.getClass("format.record-class", SpecificRecord.class));
        }
        return new AvroRowDeserializationSchema(descriptorProperties.getString("format.avro-schema"));
    }

    public SerializationSchema<Row> createSerializationSchema(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = AvroRowFormatFactory.getValidatedProperties(properties);
        if (descriptorProperties.containsKey("format.record-class")) {
            return new AvroRowSerializationSchema(descriptorProperties.getClass("format.record-class", SpecificRecord.class));
        }
        return new AvroRowSerializationSchema(descriptorProperties.getString("format.avro-schema"));
    }

    private static DescriptorProperties getValidatedProperties(Map<String, String> propertiesMap) {
        DescriptorProperties descriptorProperties = new DescriptorProperties();
        descriptorProperties.putProperties(propertiesMap);
        new AvroValidator().validate(descriptorProperties);
        return descriptorProperties;
    }
}

