/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.formats.avro.typeutils.AvroFactory;
import org.apache.flink.formats.avro.typeutils.AvroSerializer;
import org.apache.flink.formats.avro.typeutils.SerializableAvroSchema;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class AvroSerializerSnapshot<T>
implements TypeSerializerSnapshot<T> {
    private Class<T> runtimeType;
    private Schema schema;
    private Schema runtimeSchema;

    public AvroSerializerSnapshot() {
    }

    AvroSerializerSnapshot(Schema schema, Class<T> runtimeType) {
        this.schema = schema;
        this.runtimeType = runtimeType;
    }

    public int getCurrentVersion() {
        return 3;
    }

    public void writeSnapshot(DataOutputView out) throws IOException {
        Preconditions.checkNotNull(this.runtimeType);
        Preconditions.checkNotNull((Object)this.schema);
        StringUtils.writeString((String)this.runtimeType.getName(), (DataOutputView)out);
        StringUtils.writeString((String)this.schema.toString(false), (DataOutputView)out);
    }

    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        switch (readVersion) {
            case 1: {
                this.readV1(in, userCodeClassLoader);
                return;
            }
            case 2: {
                this.readV2(in, userCodeClassLoader);
                return;
            }
            case 3: {
                this.readV3(in, userCodeClassLoader);
                return;
            }
        }
        throw new IllegalArgumentException("unknown snapshot version for AvroSerializerSnapshot " + readVersion);
    }

    private void readV1(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        String previousSchemaDefinition = in.readUTF();
        this.schema = AvroSerializerSnapshot.parseAvroSchema(previousSchemaDefinition);
        this.runtimeType = AvroSerializerSnapshot.findClassOrFallbackToGeneric(userCodeClassLoader, this.schema.getFullName());
        this.runtimeSchema = AvroSerializerSnapshot.tryExtractAvroSchema(userCodeClassLoader, this.runtimeType);
    }

    private void readV2(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        String previousRuntimeTypeName = in.readUTF();
        String previousSchemaDefinition = in.readUTF();
        this.runtimeType = AvroSerializerSnapshot.findClassOrThrow(userCodeClassLoader, previousRuntimeTypeName);
        this.schema = AvroSerializerSnapshot.parseAvroSchema(previousSchemaDefinition);
        this.runtimeSchema = AvroSerializerSnapshot.tryExtractAvroSchema(userCodeClassLoader, this.runtimeType);
    }

    private void readV3(DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        String previousRuntimeTypeName = StringUtils.readString((DataInputView)in);
        String previousSchemaDefinition = StringUtils.readString((DataInputView)in);
        this.runtimeType = AvroSerializerSnapshot.findClassOrThrow(userCodeClassLoader, previousRuntimeTypeName);
        this.schema = AvroSerializerSnapshot.parseAvroSchema(previousSchemaDefinition);
        this.runtimeSchema = AvroSerializerSnapshot.tryExtractAvroSchema(userCodeClassLoader, this.runtimeType);
    }

    public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
        if (!(newSerializer instanceof AvroSerializer)) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        AvroSerializer newAvroSerializer = (AvroSerializer)newSerializer;
        return AvroSerializerSnapshot.resolveSchemaCompatibility(this.schema, newAvroSerializer.getAvroSchema());
    }

    public TypeSerializer<T> restoreSerializer() {
        Preconditions.checkNotNull(this.runtimeType);
        Preconditions.checkNotNull((Object)this.schema);
        if (this.runtimeSchema != null) {
            return new AvroSerializer<T>(this.runtimeType, new SerializableAvroSchema(this.runtimeSchema), new SerializableAvroSchema(this.schema));
        }
        return new AvroSerializer<T>(this.runtimeType, new SerializableAvroSchema(this.schema), new SerializableAvroSchema(this.schema));
    }

    @VisibleForTesting
    static <T> TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(Schema writerSchema, Schema readerSchema) {
        if (Objects.equals(writerSchema, readerSchema)) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
        SchemaCompatibility.SchemaPairCompatibility compatibility = SchemaCompatibility.checkReaderWriterCompatibility((Schema)readerSchema, (Schema)writerSchema);
        return AvroSerializerSnapshot.avroCompatibilityToFlinkCompatibility(compatibility);
    }

    private static <T> TypeSerializerSchemaCompatibility<T> avroCompatibilityToFlinkCompatibility(SchemaCompatibility.SchemaPairCompatibility compatibility) {
        switch (compatibility.getType()) {
            case COMPATIBLE: {
                return TypeSerializerSchemaCompatibility.compatibleAfterMigration();
            }
            case INCOMPATIBLE: {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
        }
        return TypeSerializerSchemaCompatibility.incompatible();
    }

    private static Schema parseAvroSchema(String previousSchemaDefinition) {
        Schema.Parser parser = new Schema.Parser();
        return parser.parse(previousSchemaDefinition);
    }

    private static Schema tryExtractAvroSchema(ClassLoader cl, Class<?> runtimeType) {
        if (AvroSerializer.isGenericRecord(runtimeType)) {
            return null;
        }
        if (AvroSerializerSnapshot.isSpecificRecord(runtimeType)) {
            SpecificData d = AvroFactory.getSpecificDataForClass(runtimeType, cl);
            return AvroFactory.extractAvroSpecificSchema(runtimeType, d);
        }
        ReflectData d = new ReflectData(cl);
        return d.getSchema(runtimeType);
    }

    @Nonnull
    private static <T> Class<T> findClassOrThrow(ClassLoader userCodeClassLoader, String className) {
        try {
            Class<?> runtimeTarget = Class.forName(className, false, userCodeClassLoader);
            return runtimeTarget;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to find the class '" + className + "' which is used to deserialize the elements of this serializer. Were the class was moved or renamed?", e);
        }
    }

    @Nonnull
    private static <T> Class<T> findClassOrFallbackToGeneric(ClassLoader userCodeClassLoader, String className) {
        try {
            Class<?> runtimeTarget = Class.forName(className, false, userCodeClassLoader);
            return runtimeTarget;
        }
        catch (ClassNotFoundException e) {
            return GenericRecord.class;
        }
    }

    private static boolean isSpecificRecord(Class<?> runtimeType) {
        return SpecificRecord.class.isAssignableFrom(runtimeType);
    }
}

