/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.BufferWritingResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

public class BoundedBlockingResultPartition
extends BufferWritingResultPartition {
    public BoundedBlockingResultPartition(String owningTaskName, int partitionIndex, ResultPartitionID partitionId, ResultPartitionType partitionType, ResultSubpartition[] subpartitions, int numTargetKeyGroups, ResultPartitionManager partitionManager, @Nullable BufferCompressor bufferCompressor, SupplierWithException<BufferPool, IOException> bufferPoolFactory) {
        super(owningTaskName, partitionIndex, partitionId, BoundedBlockingResultPartition.checkResultPartitionType(partitionType), subpartitions, numTargetKeyGroups, partitionManager, bufferCompressor, bufferPoolFactory);
    }

    @Override
    public void flush(int targetSubpartition) {
        this.flushSubpartition(targetSubpartition, true);
    }

    @Override
    public void flushAll() {
        this.flushAllSubpartitions(true);
    }

    private static ResultPartitionType checkResultPartitionType(ResultPartitionType type) {
        Preconditions.checkArgument((type == ResultPartitionType.BLOCKING || type == ResultPartitionType.BLOCKING_PERSISTENT ? 1 : 0) != 0);
        return type;
    }
}

