/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.concurrent.Callable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.function.RunnableWithException;
import org.apache.flink.util.function.ThrowingRunnable;

@Internal
public interface StreamTaskActionExecutor {
    public static final StreamTaskActionExecutor IMMEDIATE = new StreamTaskActionExecutor(){

        @Override
        public void run(RunnableWithException runnable) throws Exception {
            runnable.run();
        }

        @Override
        public <E extends Throwable> void runThrowing(ThrowingRunnable<E> runnable) throws E {
            runnable.run();
        }

        @Override
        public <R> R call(Callable<R> callable) throws Exception {
            return callable.call();
        }
    };

    public void run(RunnableWithException var1) throws Exception;

    public <E extends Throwable> void runThrowing(ThrowingRunnable<E> var1) throws E;

    public <R> R call(Callable<R> var1) throws Exception;

    public static SynchronizedStreamTaskActionExecutor synchronizedExecutor() {
        return StreamTaskActionExecutor.synchronizedExecutor(new Object());
    }

    public static SynchronizedStreamTaskActionExecutor synchronizedExecutor(Object mutex) {
        return new SynchronizedStreamTaskActionExecutor(mutex);
    }

    @Deprecated
    public static class SynchronizedStreamTaskActionExecutor
    implements StreamTaskActionExecutor {
        private final Object mutex;

        public SynchronizedStreamTaskActionExecutor(Object mutex) {
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(RunnableWithException runnable) throws Exception {
            Object object = this.mutex;
            synchronized (object) {
                runnable.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <E extends Throwable> void runThrowing(ThrowingRunnable<E> runnable) throws E {
            Object object = this.mutex;
            synchronized (object) {
                runnable.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <R> R call(Callable<R> callable) throws Exception {
            Object object = this.mutex;
            synchronized (object) {
                return callable.call();
            }
        }

        public Object getMutex() {
            return this.mutex;
        }
    }
}

