/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.StreamTransformation;

@Internal
public class SplitTransformation<T>
extends StreamTransformation<T> {
    private final StreamTransformation<T> input;
    private final OutputSelector<T> outputSelector;

    public SplitTransformation(StreamTransformation<T> input, OutputSelector<T> outputSelector) {
        super("Split", input.getOutputType(), input.getParallelism());
        this.input = input;
        this.outputSelector = outputSelector;
    }

    public StreamTransformation<T> getInput() {
        return this.input;
    }

    public OutputSelector<T> getOutputSelector() {
        return this.outputSelector;
    }

    @Override
    public Collection<StreamTransformation<?>> getTransitivePredecessors() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        throw new UnsupportedOperationException("Cannot set chaining strategy on Split Transformation.");
    }
}

