/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;

public final class TestDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "test-connector";
    public static final ConfigOption<String> TARGET = ConfigOptions.key((String)"target").stringType().noDefaultValue();
    public static final ConfigOption<Long> BUFFER_SIZE = ConfigOptions.key((String)"buffer-size").longType().defaultValue((Object)100L);
    public static final ConfigOption<String> KEY_FORMAT = ConfigOptions.key((String)"key.format").stringType().noDefaultValue();
    public static final ConfigOption<String> VALUE_FORMAT = ConfigOptions.key((String)"value.format").stringType().noDefaultValue();

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        Optional keyFormat = helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, KEY_FORMAT);
        DecodingFormat valueFormat = helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverDecodingFormat(DeserializationFormatFactory.class, VALUE_FORMAT));
        helper.validate();
        return new DynamicTableSourceMock((String)helper.getOptions().get(TARGET), (DecodingFormat<DeserializationSchema<RowData>>)((DecodingFormat)keyFormat.orElse(null)), (DecodingFormat<DeserializationSchema<RowData>>)valueFormat);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        Optional keyFormat = helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, KEY_FORMAT);
        EncodingFormat valueFormat = helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverEncodingFormat(SerializationFormatFactory.class, VALUE_FORMAT));
        helper.validate();
        return new DynamicTableSinkMock((String)helper.getOptions().get(TARGET), (Long)helper.getOptions().get(BUFFER_SIZE), (EncodingFormat<SerializationSchema<RowData>>)((EncodingFormat)keyFormat.orElse(null)), (EncodingFormat<SerializationSchema<RowData>>)valueFormat);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(TARGET);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(BUFFER_SIZE);
        options.add(KEY_FORMAT);
        options.add(FactoryUtil.FORMAT);
        options.add(VALUE_FORMAT);
        return options;
    }

    public static class DynamicTableSinkMock
    implements DynamicTableSink {
        public final String target;
        public final Long bufferSize;
        @Nullable
        public final EncodingFormat<SerializationSchema<RowData>> keyFormat;
        public final EncodingFormat<SerializationSchema<RowData>> valueFormat;

        DynamicTableSinkMock(String target, Long bufferSize, @Nullable EncodingFormat<SerializationSchema<RowData>> keyFormat, EncodingFormat<SerializationSchema<RowData>> valueFormat) {
            this.target = target;
            this.bufferSize = bufferSize;
            this.keyFormat = keyFormat;
            this.valueFormat = valueFormat;
        }

        public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
            return null;
        }

        public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
            return null;
        }

        public DynamicTableSink copy() {
            return null;
        }

        public String asSummaryString() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicTableSinkMock that = (DynamicTableSinkMock)o;
            return this.target.equals(that.target) && this.bufferSize.equals(that.bufferSize) && Objects.equals(this.keyFormat, that.keyFormat) && this.valueFormat.equals(that.valueFormat);
        }

        public int hashCode() {
            return Objects.hash(this.target, this.bufferSize, this.keyFormat, this.valueFormat);
        }
    }

    public static class DynamicTableSourceMock
    implements ScanTableSource {
        public final String target;
        @Nullable
        public final DecodingFormat<DeserializationSchema<RowData>> keyFormat;
        public final DecodingFormat<DeserializationSchema<RowData>> valueFormat;

        DynamicTableSourceMock(String target, @Nullable DecodingFormat<DeserializationSchema<RowData>> keyFormat, DecodingFormat<DeserializationSchema<RowData>> valueFormat) {
            this.target = target;
            this.keyFormat = keyFormat;
            this.valueFormat = valueFormat;
        }

        public ChangelogMode getChangelogMode() {
            return null;
        }

        public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
            return null;
        }

        public DynamicTableSource copy() {
            return null;
        }

        public String asSummaryString() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicTableSourceMock that = (DynamicTableSourceMock)o;
            return this.target.equals(that.target) && Objects.equals(this.keyFormat, that.keyFormat) && this.valueFormat.equals(that.valueFormat);
        }

        public int hashCode() {
            return Objects.hash(this.target, this.keyFormat, this.valueFormat);
        }
    }
}

