/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.MultisetTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.utils.TypeStringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TypeStringUtilsTest {
    @Test
    public void testPrimitiveTypes() {
        this.testReadAndWrite("VARCHAR", Types.STRING);
        this.testReadAndWrite("BOOLEAN", Types.BOOLEAN);
        this.testReadAndWrite("TINYINT", Types.BYTE);
        this.testReadAndWrite("SMALLINT", Types.SHORT);
        this.testReadAndWrite("INT", Types.INT);
        this.testReadAndWrite("BIGINT", Types.LONG);
        this.testReadAndWrite("FLOAT", Types.FLOAT);
        this.testReadAndWrite("DOUBLE", Types.DOUBLE);
        this.testReadAndWrite("DECIMAL", Types.BIG_DEC);
        this.testReadAndWrite("DATE", Types.SQL_DATE);
        this.testReadAndWrite("TIME", Types.SQL_TIME);
        this.testReadAndWrite("TIMESTAMP", Types.SQL_TIMESTAMP);
        this.testWrite("DATE", Types.LOCAL_DATE);
        this.testWrite("TIME", Types.LOCAL_TIME);
        this.testWrite("TIMESTAMP", Types.LOCAL_DATE_TIME);
        this.testReadAndWrite("ANY<java.lang.Void, rO0ABXNyADJvcmcuYXBhY2hlLmZsaW5rLmFwaS5jb21tb24udHlwZWluZm8uQmFzaWNUeXBlSW5mb_oE8IKlad0GAgAETAAFY2xhenp0ABFMamF2YS9sYW5nL0NsYXNzO0wAD2NvbXBhcmF0b3JDbGFzc3EAfgABWwAXcG9zc2libGVDYXN0VGFyZ2V0VHlwZXN0ABJbTGphdmEvbGFuZy9DbGFzcztMAApzZXJpYWxpemVydAA2TG9yZy9hcGFjaGUvZmxpbmsvYXBpL2NvbW1vbi90eXBldXRpbHMvVHlwZVNlcmlhbGl6ZXI7eHIANG9yZy5hcGFjaGUuZmxpbmsuYXBpLmNvbW1vbi50eXBlaW5mby5UeXBlSW5mb3JtYXRpb26UjchIurN66wIAAHhwdnIADmphdmEubGFuZy5Wb2lkAAAAAAAAAAAAAAB4cHB1cgASW0xqYXZhLmxhbmcuQ2xhc3M7qxbXrsvNWpkCAAB4cAAAAABzcgA5b3JnLmFwYWNoZS5mbGluay5hcGkuY29tbW9uLnR5cGV1dGlscy5iYXNlLlZvaWRTZXJpYWxpemVyAAAAAAAAAAECAAB4cgBCb3JnLmFwYWNoZS5mbGluay5hcGkuY29tbW9uLnR5cGV1dGlscy5iYXNlLlR5cGVTZXJpYWxpemVyU2luZ2xldG9ueamHqscud0UCAAB4cgA0b3JnLmFwYWNoZS5mbGluay5hcGkuY29tbW9uLnR5cGV1dGlscy5UeXBlU2VyaWFsaXplcgAAAAAAAAABAgAAeHA>", Types.VOID);
    }

    @Test
    public void testWriteComplexTypes() {
        this.testReadAndWrite("ROW<f0 DECIMAL, f1 TINYINT>", Types.ROW((TypeInformation[])new TypeInformation[]{Types.BIG_DEC, Types.BYTE}));
        this.testReadAndWrite("ROW<hello DECIMAL, world TINYINT>", Types.ROW_NAMED((String[])new String[]{"hello", "world"}, (TypeInformation[])new TypeInformation[]{Types.BIG_DEC, Types.BYTE}));
        this.testReadAndWrite("POJO<org.apache.flink.table.utils.TypeStringUtilsTest$TestPojo>", TypeExtractor.createTypeInfo(TestPojo.class));
        this.testReadAndWrite("ANY<org.apache.flink.table.utils.TypeStringUtilsTest$TestNoPojo>", TypeExtractor.createTypeInfo(TestNoPojo.class));
        this.testReadAndWrite("MAP<VARCHAR, ROW<f0 DECIMAL, f1 TINYINT>>", Types.MAP((TypeInformation)Types.STRING, (TypeInformation)Types.ROW((TypeInformation[])new TypeInformation[]{Types.BIG_DEC, Types.BYTE})));
        this.testReadAndWrite("MULTISET<ROW<f0 DECIMAL, f1 TINYINT>>", (TypeInformation<?>)new MultisetTypeInfo(Types.ROW((TypeInformation[])new TypeInformation[]{Types.BIG_DEC, Types.BYTE})));
        this.testReadAndWrite("PRIMITIVE_ARRAY<TINYINT>", Types.PRIMITIVE_ARRAY((TypeInformation)Types.BYTE));
        this.testReadAndWrite("OBJECT_ARRAY<POJO<org.apache.flink.table.utils.TypeStringUtilsTest$TestPojo>>", Types.OBJECT_ARRAY((TypeInformation)TypeExtractor.createTypeInfo(TestPojo.class)));
        Assert.assertEquals((Object)Types.ROW_NAMED((String[])new String[]{"he         \nllo", "world"}, (TypeInformation[])new TypeInformation[]{Types.BIG_DEC, Types.BYTE}), (Object)TypeStringUtils.readTypeInfo((String)"ROW<`he         \nllo` DECIMAL, world TINYINT>"));
        Assert.assertEquals((Object)Types.ROW_NAMED((String[])new String[]{"he`llo", "world"}, (TypeInformation[])new TypeInformation[]{Types.BIG_DEC, Types.BYTE}), (Object)TypeStringUtils.readTypeInfo((String)"ROW<`he``llo` DECIMAL, world TINYINT>"));
        Assert.assertEquals((Object)Types.ROW_NAMED((String[])new String[]{"he         \nllo", "world"}, (TypeInformation[])new TypeInformation[]{Types.BIG_DEC, Types.BYTE}), (Object)TypeStringUtils.readTypeInfo((String)"ROW(`he         \nllo` DECIMAL, world TINYINT)"));
        this.testReadAndWrite("ROW<singleton ROW<f0 INT>, twoField ROW<`Field 1` ROW<f0 DECIMAL>, `Field``s 2` VARCHAR>>", Types.ROW_NAMED((String[])new String[]{"singleton", "twoField"}, (TypeInformation[])new TypeInformation[]{Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT}), Types.ROW_NAMED((String[])new String[]{"Field 1", "Field`s 2"}, (TypeInformation[])new TypeInformation[]{Types.ROW((TypeInformation[])new TypeInformation[]{Types.BIG_DEC}), Types.STRING})}));
        this.testWrite("ROW<f0 DECIMAL, f1 TIMESTAMP, f2 TIME, f3 DATE>", Types.ROW_NAMED((String[])new String[]{"f0", "f1", "f2", "f3"}, (TypeInformation[])new TypeInformation[]{Types.BIG_DEC, Types.LOCAL_DATE_TIME, Types.LOCAL_TIME, Types.LOCAL_DATE}));
    }

    @Test(expected=ValidationException.class)
    public void testSyntaxError1() {
        TypeStringUtils.readTypeInfo((String)"ROW<<f0 DECIMAL, f1 TINYINT>");
    }

    @Test(expected=ValidationException.class)
    public void testSyntaxError2() {
        TypeStringUtils.readTypeInfo((String)"ROW<f0 DECIMAL DECIMAL, f1 TINYINT>");
    }

    @Test(expected=ValidationException.class)
    public void testSyntaxError3() {
        TypeStringUtils.readTypeInfo((String)"ROW<f0 INVALID, f1 TINYINT>");
    }

    private void testReadAndWrite(String expected, TypeInformation<?> type) {
        Assert.assertEquals(type, (Object)TypeStringUtils.readTypeInfo((String)expected));
        Assert.assertEquals((Object)expected, (Object)TypeStringUtils.writeTypeInfo(type));
    }

    private void testWrite(String expected, TypeInformation<?> type) {
        Assert.assertEquals((Object)expected, (Object)TypeStringUtils.writeTypeInfo(type));
    }

    public static class TestNoPojo {
        public int field1;
        public String field2;

        public TestNoPojo(int field1, String field2) {
            this.field1 = field1;
            this.field2 = field2;
        }
    }

    public static class TestPojo {
        public int field1;
        public String field2;
    }
}

