/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.TableSymbol;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.SymbolType;

@Internal
public class SymbolArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final Class<? extends Enum<? extends TableSymbol>> symbolClass;

    public SymbolArgumentTypeStrategy(Class<? extends Enum<? extends TableSymbol>> symbolClass) {
        this.symbolClass = symbolClass;
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        DataType argumentType = callContext.getArgumentDataTypes().get(argumentPos);
        if (argumentType.getLogicalType().getTypeRoot() != LogicalTypeRoot.SYMBOL) {
            if (throwOnFailure) {
                throw callContext.newValidationError("Unsupported argument type. Expected symbol type '%s' but actual type was '%s'.", this.symbolClass.getSimpleName(), argumentType);
            }
            return Optional.empty();
        }
        SymbolType symbolType = (SymbolType)argumentType.getLogicalType();
        if (symbolType.getSymbolClass() != this.symbolClass) {
            if (throwOnFailure) {
                throw callContext.newValidationError("Unsupported argument symbol type. Expected symbol '%s' but actual symbol was '%s'.", this.symbolClass.getSimpleName(), symbolType.getDefaultConversion().getSimpleName());
            }
            return Optional.empty();
        }
        return Optional.of(argumentType);
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.of(String.format("<%s>", this.symbolClass.getSimpleName()));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SymbolArgumentTypeStrategy that = (SymbolArgumentTypeStrategy)other;
        return Objects.equals(this.symbolClass, that.symbolClass);
    }

    public int hashCode() {
        return Objects.hash(this.symbolClass);
    }
}

