/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;

public final class LogicalSort
extends Sort {
    private LogicalSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
        this(cluster, traitSet, Collections.emptyList(), input, collation, offset, fetch);
    }

    private LogicalSort(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, hints, input, collation, offset, fetch);
        assert (traitSet.containsIfApplicable(Convention.NONE));
    }

    public LogicalSort(RelInput input) {
        super(input);
    }

    public static LogicalSort create(RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
        RelOptCluster cluster = input.getCluster();
        collation = RelCollationTraitDef.INSTANCE.canonize(collation);
        RelTraitSet traitSet = input.getTraitSet().replace(Convention.NONE).replace(collation);
        return new LogicalSort(cluster, traitSet, input, collation, offset, fetch);
    }

    @Override
    public Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new LogicalSort(this.getCluster(), traitSet, this.hints, newInput, newCollation, offset, fetch);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelNode withHints(List<RelHint> hintList) {
        return new LogicalSort(this.getCluster(), this.traitSet, hintList, this.input, this.collation, this.offset, this.fetch);
    }
}

