/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.hint;

import java.util.List;

public enum JoinStrategy {
    BROADCAST("BROADCAST"),
    SHUFFLE_HASH("SHUFFLE_HASH"),
    SHUFFLE_MERGE("SHUFFLE_MERGE"),
    NEST_LOOP("NEST_LOOP"),
    LOOKUP("LOOKUP");

    private final String joinHintName;
    public static final String LEFT_INPUT = "LEFT";
    public static final String RIGHT_INPUT = "RIGHT";

    private JoinStrategy(String joinHintName) {
        this.joinHintName = joinHintName;
    }

    public static boolean isJoinStrategy(String hintName) {
        try {
            JoinStrategy.valueOf(hintName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getJoinHintName() {
        return this.joinHintName;
    }

    public static boolean validOptions(String hintName, List<String> options) {
        if (!JoinStrategy.isJoinStrategy(hintName)) {
            return false;
        }
        JoinStrategy strategy = JoinStrategy.valueOf(hintName);
        switch (strategy) {
            case SHUFFLE_HASH: 
            case SHUFFLE_MERGE: 
            case BROADCAST: 
            case NEST_LOOP: {
                return options.size() > 0;
            }
            case LOOKUP: {
                return null == options || options.size() == 0;
            }
        }
        return false;
    }

    public static boolean isLookupHint(String hintName) {
        return JoinStrategy.isJoinStrategy(hintName) && JoinStrategy.valueOf(hintName) == LOOKUP;
    }
}

