/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsFilterPushDown;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpecBase;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import org.apache.flink.table.planner.plan.utils.RexNodeToExpressionConverter;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import scala.Option;

@JsonTypeName(value="FilterPushDown")
public final class FilterPushDownSpec
extends SourceAbilitySpecBase {
    public static final String FIELD_NAME_PREDICATES = "predicates";
    @JsonProperty(value="predicates")
    private final List<RexNode> predicates;
    @JsonIgnore
    private final boolean allPredicatesRetained;

    public FilterPushDownSpec(List<RexNode> predicates, boolean allPredicatesRetained) {
        this.predicates = new ArrayList<RexNode>((Collection)Preconditions.checkNotNull(predicates));
        this.allPredicatesRetained = allPredicatesRetained;
    }

    @JsonCreator
    public FilterPushDownSpec(@JsonProperty(value="predicates") List<RexNode> predicates) {
        this(predicates, true);
    }

    @JsonIgnore
    public boolean isAllPredicatesRetained() {
        return this.allPredicatesRetained;
    }

    public List<RexNode> getPredicates() {
        return this.predicates;
    }

    @Override
    public void apply(DynamicTableSource tableSource, SourceAbilityContext context) {
        SupportsFilterPushDown.Result result = FilterPushDownSpec.apply(this.predicates, tableSource, context);
        if (result.getAcceptedFilters().size() != this.predicates.size()) {
            throw new TableException("All predicates should be accepted here.");
        }
    }

    public static SupportsFilterPushDown.Result apply(List<RexNode> predicates, DynamicTableSource tableSource, SourceAbilityContext context) {
        if (tableSource instanceof SupportsFilterPushDown) {
            RexNodeToExpressionConverter converter = new RexNodeToExpressionConverter(new RexBuilder(context.getTypeFactory()), context.getSourceRowType().getFieldNames().toArray(new String[0]), context.getFunctionCatalog(), context.getCatalogManager(), TimeZone.getTimeZone(TableConfigUtils.getLocalTimeZone((ReadableConfig)context.getTableConfig())));
            List filters = predicates.stream().map(p -> {
                Option<ResolvedExpression> expr = p.accept(converter);
                if (expr.isDefined()) {
                    return (ResolvedExpression)expr.get();
                }
                throw new TableException(String.format("%s can not be converted to Expression, please make sure %s can accept %s.", p.toString(), tableSource.getClass().getSimpleName(), p.toString()));
            }).collect(Collectors.toList());
            ExpressionResolver resolver = ExpressionResolver.resolverFor((TableConfig)context.getTableConfig(), (ClassLoader)context.getClassLoader(), name -> Optional.empty(), (FunctionLookup)context.getFunctionCatalog().asLookup(str -> {
                throw new TableException("We should not need to lookup any expressions at this point");
            }), (DataTypeFactory)context.getCatalogManager().getDataTypeFactory(), (sqlExpression, inputRowType, outputType) -> {
                throw new TableException("SQL expression parsing is not supported at this location.");
            }, (QueryOperation[])new QueryOperation[0]).build();
            return ((SupportsFilterPushDown)tableSource).applyFilters(resolver.resolve(filters));
        }
        throw new TableException(String.format("%s does not support SupportsFilterPushDown.", tableSource.getClass().getName()));
    }

    @Override
    public String getDigests(SourceAbilityContext context) {
        ArrayList<String> expressionStrs = new ArrayList<String>();
        RowType sourceRowType = context.getSourceRowType();
        for (RexNode rexNode : this.predicates) {
            expressionStrs.add(FlinkRexUtil.getExpressionString(rexNode, JavaScalaConversionUtil.toScala(sourceRowType.getFieldNames())));
        }
        return String.format("filter=[%s]", expressionStrs.stream().reduce((l, r) -> String.format("and(%s, %s)", l, r)).orElse(""));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilterPushDownSpec that = (FilterPushDownSpec)o;
        return Objects.equals(this.predicates, that.predicates);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.predicates);
    }
}

