/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.Optional;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.RexNodeExpression;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
final class ResolvedExpressionJsonDeserializer
extends StdDeserializer<ResolvedExpression> {
    ResolvedExpressionJsonDeserializer() {
        super(ResolvedExpression.class);
    }

    public ResolvedExpression deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        ObjectNode jsonNode = (ObjectNode)jsonParser.readValueAsTree();
        String expressionType = Optional.ofNullable(jsonNode.get("type")).map(JsonNode::asText).orElse("rexNodeExpression");
        if ("rexNodeExpression".equals(expressionType)) {
            return this.deserializeRexNodeExpression(jsonNode, jsonParser.getCodec(), ctx);
        }
        throw new ValidationException(String.format("Expression '%s' cannot be deserialized. Currently, only SQL expressions can be deserialized from the persisted plan.", jsonNode));
    }

    private ResolvedExpression deserializeRexNodeExpression(ObjectNode jsonNode, ObjectCodec codec, DeserializationContext ctx) throws IOException {
        RexNode node = (RexNode)ctx.readValue(jsonNode.get("rexNode").traverse(codec), RexNode.class);
        String serializableString = jsonNode.get("serializableString").asText();
        return new RexNodeExpression(node, DataTypes.of((LogicalType)FlinkTypeFactory.toLogicalType(node.getType())), node.toString(), serializableString);
    }
}

