/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGenerator;
import org.apache.flink.table.runtime.operators.wmassigners.WatermarkAssignerOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="stream-exec-watermark-assigner", version=1, producedTransformations={"watermark-assigner"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecWatermarkAssigner
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String WATERMARK_ASSIGNER_TRANSFORMATION = "watermark-assigner";
    public static final String FIELD_NAME_WATERMARK_EXPR = "watermarkExpr";
    public static final String FIELD_NAME_ROWTIME_FIELD_INDEX = "rowtimeFieldIndex";
    @JsonProperty(value="watermarkExpr")
    private final RexNode watermarkExpr;
    @JsonProperty(value="rowtimeFieldIndex")
    private final int rowtimeFieldIndex;

    public StreamExecWatermarkAssigner(ReadableConfig tableConfig, RexNode watermarkExpr, int rowtimeFieldIndex, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecWatermarkAssigner.class), ExecNodeContext.newPersistedConfig(StreamExecWatermarkAssigner.class, tableConfig), watermarkExpr, rowtimeFieldIndex, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecWatermarkAssigner(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="watermarkExpr") RexNode watermarkExpr, @JsonProperty(value="rowtimeFieldIndex") int rowtimeFieldIndex, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.watermarkExpr = (RexNode)Preconditions.checkNotNull((Object)watermarkExpr);
        this.rowtimeFieldIndex = rowtimeFieldIndex;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        GeneratedWatermarkGenerator watermarkGenerator = WatermarkGeneratorCodeGenerator.generateWatermarkGenerator(config, planner.getFlinkContext().getClassLoader(), (RowType)inputEdge.getOutputType(), this.watermarkExpr, JavaScalaConversionUtil.toScala(Optional.empty()));
        long idleTimeout = ((Duration)config.get(ExecutionConfigOptions.TABLE_EXEC_SOURCE_IDLE_TIMEOUT)).toMillis();
        WatermarkAssignerOperatorFactory operatorFactory = new WatermarkAssignerOperatorFactory(this.rowtimeFieldIndex, idleTimeout, watermarkGenerator);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(WATERMARK_ASSIGNER_TRANSFORMATION, config), operatorFactory, InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism());
    }
}

