/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableEnvironmentITCase$;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\tuc\u0001B\u0001\u0003\u00015\u0011a\u0003V1cY\u0016,eN^5s_:lWM\u001c;J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\t)a!A\u0003uC\ndWM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001B;uS2T!a\u0005\u0004\u0002\tQ,7\u000f^\u0005\u0003+A\u0011\u0001#\u00112tiJ\f7\r\u001e+fgR\u0014\u0015m]3\t\u0011]\u0001!\u0011!Q\u0001\na\tA\u0002^1cY\u0016,eN\u001e(b[\u0016\u0004\"!\u0007\u0012\u000f\u0005i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"BA\u000f\r\u0003\u0019a$o\\8u})\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\u00051\u0001K]3eK\u001aL!a\t\u0013\u0003\rM#(/\u001b8h\u0015\t\tc\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0003-I7o\u0015;sK\u0006l\u0017N\\4\u0011\u0005!JS\"\u0001\u0010\n\u0005)r\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079\u0002\u0014\u0007\u0005\u00020\u00015\t!\u0001C\u0003\u0018W\u0001\u0007\u0001\u0004C\u0003'W\u0001\u0007q\u0005C\u00044\u0001\t\u0007I\u0011\u0001\u001b\u0002\u0015Q,W\u000e\u001d$pY\u0012,'/F\u00016!\t14(D\u00018\u0015\tA\u0014(A\u0003sk2,7O\u0003\u0002;\u0015\u0005)!.\u001e8ji&\u0011Ah\u000e\u0002\u0010)\u0016l\u0007o\u001c:bef4u\u000e\u001c3fe\"\u0012!G\u0010\u0016\u0003\u007f\r\u0003\"\u0001Q!\u000e\u0003eJ!AQ\u001d\u0003\tI+H.Z\u0016\u0002\tB\u0011QIS\u0007\u0002\r*\u0011q\tS\u0001\u0005[\u0016$\u0018M\u0003\u0002J=\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005-3%AB4fiR,'\u000f\u0003\u0004N\u0001\u0001\u0006I!N\u0001\fi\u0016l\u0007OR8mI\u0016\u0014\b\u0005C\u0005P\u0001\u0001\u0007\t\u0019!C\u0001!\u0006!A/\u00128w+\u0005\t\u0006CA\u0018S\u0013\t\u0019&A\u0001\tUC\ndW-\u00128wSJ|g.\\3oi\"IQ\u000b\u0001a\u0001\u0002\u0004%\tAV\u0001\ti\u0016sgo\u0018\u0013fcR\u0011qK\u0017\t\u0003QaK!!\u0017\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b7R\u000b\t\u00111\u0001R\u0003\rAH%\r\u0005\n;\u0002\u0001\r\u0011!Q!\nE\u000bQ\u0001^#om\u0002Bqa\u0018\u0001C\u0002\u0013%\u0001-\u0001\u0005tKR$\u0018N\\4t+\u0005\t\u0007CA\u0018c\u0013\t\u0019'AA\nF]ZL'o\u001c8nK:$8+\u001a;uS:<7\u000f\u0003\u0004f\u0001\u0001\u0006I!Y\u0001\ng\u0016$H/\u001b8hg\u0002BQa\u001a\u0001\u0005\u0002!\fQa]3ukB$\u0012a\u0016\u0015\u0003M*\u0004\"\u0001Q6\n\u00051L$A\u0002\"fM>\u0014X\rC\u0003o\u0001\u0011\u0005\u0001.A\u0011uKN$X\t_3dkR,Gk^5dKV\u001b\u0018N\\4TC6,G+\u00192mK\u0016sg\u000f\u000b\u0002naB\u0011\u0001)]\u0005\u0003ef\u0012A\u0001V3ti\")A\u000f\u0001C\u0001Q\u0006yB/Z:u\u000bb\u0004H.Y5o\u0003:$W\t_3dkR,7+\u001b8hY\u0016\u001c\u0016N\\6)\u0005M\u0004\b\"B<\u0001\t\u0003A\u0017\u0001\b;fgR,\u00050Z2vi\u0016\u001c\u0016\u000f\\,ji\"Len]3si&sGo\u001c\u0015\u0003mBDQA\u001f\u0001\u0005\u0002!\f\u0011\u0005^3ti\u0016CXmY;uKN\u000bHnV5uQ&s7/\u001a:u\u001fZ,'o\u001e:ji\u0016D#!\u001f9\t\u000bu\u0004A\u0011\u00015\u0002=Q,7\u000f^#yK\u000e,H/Z*rY\u0006sG-\u0012=fGV$X-\u00138tKJ$\bF\u0001?q\u0011\u0019\t\t\u0001\u0001C\u0001Q\u0006iB/Z:u\u000bb,7-\u001e;f'Fd\u0017I\u001c3U_\u0012\u000bG/Y*ue\u0016\fW\u000e\u000b\u0002\u0000a\"1\u0011q\u0001\u0001\u0005\u0002!\fQ\u0004^3tiR{G)\u0019;b'R\u0014X-Y7B]\u0012,\u00050Z2vi\u0016\u001c\u0016\u000f\u001c\u0015\u0004\u0003\u000b\u0001\bBBA\u0007\u0001\u0011\u0005\u0001.A\u0011uKN$hI]8n)>$\u0015\r^1TiJ,\u0017-\\!oI\u0016CXmY;uKN\u000bH\u000eK\u0002\u0002\fADa!a\u0005\u0001\t\u0003A\u0017!\u0005;fgR,\u00050Z2vi\u0016Len]3si\"\u001a\u0011\u0011\u00039\t\r\u0005e\u0001\u0001\"\u0001i\u0003I!Xm\u001d;Fq\u0016\u001cW\u000f^3J]N,'\u000f\u001e\u001a)\u0007\u0005]\u0001\u000f\u0003\u0004\u0002 \u0001!\t\u0001[\u0001\u001bi\u0016\u001cH/\u0012=fGV$X-\u00138tKJ$xJ^3soJLG/\u001a\u0015\u0004\u0003;\u0001\bBBA\u0013\u0001\u0011\u0005\u0001.\u0001\tuKN$H+\u00192mK\u0012kEjU=oG\"\u001a\u00111\u00059\t\r\u0005-\u0002\u0001\"\u0001i\u0003A!Xm\u001d;Ti\u0006$X-\\3oiN+G\u000fK\u0002\u0002*ADa!!\r\u0001\t\u0003A\u0017a\u0006;fgR,\u00050Z2vi\u0016\u001cF/\u0019;f[\u0016tGoU3uQ\r\ty\u0003\u001d\u0005\u0007\u0003o\u0001A\u0011\u00015\u0002;Q,7\u000f^*uCR,W.\u001a8u'\u0016$x+\u001b;i\u001fZ,'o\u001e:ji\u0016D3!!\u000eq\u0011\u0019\ti\u0004\u0001C\u0001Q\u00061C/Z:u'R\fG/Z7f]R\u001cV\r^,ji\"\u001c\u0016-\\3TS:\\G+\u00192mK:\u000bW.Z:)\u0007\u0005m\u0002\u000f\u0003\u0004\u0002D\u0001!\t\u0001[\u0001\u0012i\u0016\u001cH/\u0012=fGV$XmU3mK\u000e$\bfAA!a\"9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0013!\u0007;fgR,\u00050Z2vi\u0016\u001cV\r\\3di&sG/\u001a:oC2$2aVA'\u0011\u001d\ty%a\u0012A\u0002a\tQ!];fefDa!a\u0015\u0001\t\u0003A\u0017A\t;fgR,\u00050Z2vi\u0016\u001cV\r\\3di^KG\u000f[+qI\u0006$Xm\u00115b]\u001e,7\u000fK\u0002\u0002RADa!!\u0017\u0001\t\u0003A\u0017A\t;fgR,\u00050Z2vi\u0016\u001cV\r\\3di^KG\u000f\u001b+j[\u0016\fE\u000f\u001e:jEV$X\rK\u0002\u0002XADa!a\u0018\u0001\t\u0003A\u0017A\u0005;fgR\u001cE.Z1s\u001fB,'/\u0019;j_:D3!!\u0018q\u0011\u001d\t)\u0007\u0001C\u0001\u0003O\nQbZ3u!\u0016\u00148o\u001c8ECR\fWCAA5!\u0019\tY'!\u001e\u0002|9!\u0011QNA9\u001d\rY\u0012qN\u0005\u0002?%\u0019\u00111\u000f\u0010\u0002\u000fA\f7m[1hK&!\u0011qOA=\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005Md\u0004E\u0005)\u0003{B\u0012\u0011QAD1%\u0019\u0011q\u0010\u0010\u0003\rQ+\b\u000f\\35!\rA\u00131Q\u0005\u0004\u0003\u000bs\"aA%oiB\u0019\u0001&!#\n\u0007\u0005-eD\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003\u001f\u0003A\u0011BAI\u0003E\t7o]3si\u001aK'o\u001d;WC2,Xm\u001d\u000b\u0004/\u0006M\u0005bBAK\u0003\u001b\u0003\r\u0001G\u0001\fGN4h)\u001b7f!\u0006$\b\u000eC\u0004\u0002\u001a\u0002!I!a'\u0002!\u0005\u001c8/\u001a:u\u0019\u0006\u001cHOV1mk\u0016\u001cHcA,\u0002\u001e\"9\u0011QSAL\u0001\u0004A\u0002bBAQ\u0001\u0011%\u00111U\u0001\u0016O\u0016$X\t\u001f9fGR,G\rT1tiZ\u000bG.^3t+\t\t)\u000bE\u0003\u0002l\u0005U\u0004\u0004C\u0004\u0002*\u0002!I!a+\u0002\u001d\rDWmY6F[B$\u0018PR5mKR\u0019q+!,\t\u000f\u0005U\u0015q\u0015a\u00011!9\u0011\u0011\u0017\u0001\u0005\n\u0005M\u0016A\u00033fY\u0016$XMR5mKR\u0019q+!.\t\u000f\u0005]\u0016q\u0016a\u00011\u0005!\u0001/\u0019;i\u0011\u001d\tY\f\u0001C\u0005\u0003{\u000b!#Y:tKJ$h)\u001b7f\u001d>$X\t_5tiR\u0019q+a0\t\u000f\u0005]\u0016\u0011\u0018a\u00011!9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0017AF2iK\u000e\\\u0017J\\:feR$\u0016M\u00197f%\u0016\u001cX\u000f\u001c;\u0015\u000b]\u000b9-!5\t\u0011\u0005%\u0017\u0011\u0019a\u0001\u0003\u0017\f1\u0002^1cY\u0016\u0014Vm];miB\u0019q&!4\n\u0007\u0005='AA\u0006UC\ndWMU3tk2$\b\u0002CAj\u0003\u0003\u0004\r!!6\u0002\u0015\u0019LW\r\u001c3OC6,7\u000f\u0005\u0003)\u0003/D\u0012bAAm=\tQAH]3qK\u0006$X\r\u001a \t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\u0006A!/Z1e\r&dW\r\u0006\u0003\u0002&\u0006\u0005\bbBAK\u00037\u0004\r\u0001\u0007\u0015\b\u0001\u0005\u0015\u0018\u0011_Az!\u0011\t9/!<\u000e\u0005\u0005%(bAAvs\u00051!/\u001e8oKJLA!a<\u0002j\n9!+\u001e8XSRD\u0017!\u0002<bYV,7EAA{!\u0011\t90!@\u000e\u0005\u0005e(bAA~s\u00059!/\u001e8oKJ\u001c\u0018\u0002BA\u0000\u0003s\u0014Q\u0002U1sC6,G/\u001a:ju\u0016$wa\u0002B\u0002\u0005!\u0005!QA\u0001\u0017)\u0006\u0014G.Z#om&\u0014xN\\7f]RLEkQ1tKB\u0019qFa\u0002\u0007\r\u0005\u0011\u0001\u0012\u0001B\u0005'\u0011\u00119Aa\u0003\u0011\u0007!\u0012i!C\u0002\u0003\u0010y\u0011a!\u00118z%\u00164\u0007b\u0002\u0017\u0003\b\u0011\u0005!1\u0003\u000b\u0003\u0005\u000bA\u0001Ba\u0006\u0003\b\u0011\u0005!\u0011D\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHC\u0001B\u000e!\u0019\u0011iB!\n\u0003*5\u0011!q\u0004\u0006\u0004#\t\u0005\"B\u0001B\u0012\u0003\u0011Q\u0017M^1\n\t\t\u001d\"q\u0004\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0007\u0002B\u0016\u0005k\u0001R\u0001\u000bB\u0017\u0005cI1Aa\f\u001f\u0005\u0015\t%O]1z!\u0011\u0011\u0019D!\u000e\r\u0001\u0011a!q\u0007B\u000b\u0003\u0003\u0005\tQ!\u0001\u0003:\t\u0019q\fJ\u0019\u0012\t\tm\"\u0011\t\t\u0004Q\tu\u0012b\u0001B =\t9aj\u001c;iS:<\u0007c\u0001\u0015\u0003D%\u0019!Q\t\u0010\u0003\u0007\u0005s\u0017\u0010\u000b\u0005\u0003\u0016\t%#q\u000bB-!\u0011\u0011YE!\u0015\u000f\t\u0005](QJ\u0005\u0005\u0005\u001f\nI0A\u0007QCJ\fW.\u001a;fe&TX\rZ\u0005\u0005\u0005'\u0012)F\u0001\u0006QCJ\fW.\u001a;feNTAAa\u0014\u0002z\u0006!a.Y7fC\t\u0011Y&\u0001\t|auT\u0014n]*ue\u0016\fW.P>2{\u0002")
public class TableEnvironmentITCase
extends AbstractTestBase {
    private final String tableEnvName;
    private final boolean isStreaming;
    private final TemporaryFolder tempFolder;
    private TableEnvironment tEnv;
    private final EnvironmentSettings settings;

    @Parameterized.Parameters(name="{0}:isStream={1}")
    public static Collection<Object> parameters() {
        return TableEnvironmentITCase$.MODULE$.parameters();
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this.tempFolder;
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    @Before
    public void setup() {
        String string = this.tableEnvName;
        if ("TableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)TableEnvironmentImpl.create((EnvironmentSettings)this.settings()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("StreamTableEnvironment".equals(string)) {
            this.tEnv_$eq((TableEnvironment)StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)this.settings()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(26).append("unsupported tableEnvName: ").append(this.tableEnvName).toString());
        }
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable(this.tEnv(), "MyTable");
    }

    @Test
    public void testExecuteTwiceUsingSameTableEnv() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        this.checkEmptyFile(sink2Path);
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        table1.executeInsert("MySink1").await();
        this.assertFirstValues(sink1Path);
        this.checkEmptyFile(sink2Path);
        new File(sink1Path).delete();
        Assert.assertFalse((boolean)new File(sink1Path).exists());
        Table table2 = this.tEnv().sqlQuery("select last from MyTable");
        table2.executeInsert("MySink2").await();
        Assert.assertFalse((boolean)new File(sink1Path).exists());
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testExplainAndExecuteSingleSink() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        table1.executeInsert("MySink1").await();
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testExecuteSqlWithInsertInto() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sinkPath);
        TableResult tableResult = this.tEnv().executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testExecuteSqlWithInsertOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = this.tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sinkPath).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        TableResult tableResult1 = this.tEnv().executeSql("insert overwrite MySink select first from MyTable");
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
        TableResult tableResult2 = this.tEnv().executeSql("insert overwrite MySink select first from MyTable");
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testExecuteSqlAndExecuteInsert() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"last"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        this.checkEmptyFile(sink2Path);
        TableResult tableResult = this.tEnv().executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues(sink1Path);
        this.checkEmptyFile(sink2Path);
        new File(sink1Path).delete();
        Assert.assertFalse((boolean)new File(sink1Path).exists());
        this.tEnv().sqlQuery("select last from MyTable").executeInsert("MySink2").await();
        Assert.assertFalse((boolean)new File(sink1Path).exists());
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testExecuteSqlAndToDataStream() {
        if (!this.tableEnvName.equals("StreamTableEnvironment")) {
            return;
        }
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment streamEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment streamTableEnv = StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)streamEnv, (EnvironmentSettings)this.settings());
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)streamTableEnv, "MyTable");
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
        DataStream resultSet = streamTableEnv.toAppendStream(table, Row.class);
        TestingAppendSink sink = new TestingAppendSink();
        resultSet.addSink((SinkFunction)sink);
        TableResult tableResult = streamTableEnv.executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues(sink1Path);
        Assert.assertFalse((boolean)sink.isInitialized());
        this.deleteFile(sink1Path);
        streamEnv.execute("test2");
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        this.assertFileNotExist(sink1Path);
    }

    @Test
    public void testToDataStreamAndExecuteSql() {
        if (!this.tableEnvName.equals("StreamTableEnvironment")) {
            return;
        }
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment streamEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment streamTableEnv = StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)streamEnv, (EnvironmentSettings)this.settings());
        TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)streamTableEnv, "MyTable");
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
        DataStream resultSet = streamTableEnv.toAppendStream(table, Row.class);
        TestingAppendSink sink = new TestingAppendSink();
        resultSet.addSink((SinkFunction)sink);
        String insertStmt = "insert into MySink1 select first from MyTable";
        String explain = streamTableEnv.explainSql(insertStmt, new ExplainDetail[0]);
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testSqlUpdateAndToDataStream.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(explain));
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testSqlUpdateAndToDataStreamWithPlanAdvice.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(streamTableEnv.explainSql(insertStmt, new ExplainDetail[]{ExplainDetail.PLAN_ADVICE})));
        streamEnv.execute("test2");
        this.checkEmptyFile(sink1Path);
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        streamTableEnv.executeSql(insertStmt).await();
        this.assertFirstValues(sink1Path);
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testFromToDataStreamAndExecuteSql() {
        if (!this.tableEnvName.equals("StreamTableEnvironment")) {
            return;
        }
        StreamExecutionEnvironment streamEnv = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        org.apache.flink.table.api.bridge.scala.StreamTableEnvironment streamTableEnv = StreamTableEnvironment$.MODULE$.create(streamEnv, this.settings());
        Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(streamEnv.fromCollection(this.getPersonData(), (TypeInformation)new CaseClassTypeInfo<Tuple4<String, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<String, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<String, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple4<String, Object, Object, String>>(this, fieldSerializers){

                    public Tuple4<String, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.TableEnvironmentITCase$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        })).toTable(streamTableEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "first")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "id")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "score")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "last"))}));
        streamTableEnv.registerTable("MyTable", t);
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
        org.apache.flink.streaming.api.scala.DataStream resultSet = streamTableEnv.toAppendStream(table, TypeExtractor.createTypeInfo(Row.class));
        TestingAppendSink sink = new TestingAppendSink();
        resultSet.addSink((SinkFunction)sink);
        String insertStmt = "insert into MySink1 select first from MyTable";
        String explain = streamTableEnv.explainSql(insertStmt, new ExplainDetail[0]);
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testFromToDataStreamAndSqlUpdate.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(explain));
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testFromToDataStreamAndSqlUpdateWithPlanAdvice.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(streamTableEnv.explainSql(insertStmt, new ExplainDetail[]{ExplainDetail.PLAN_ADVICE})));
        streamEnv.execute("test2");
        this.checkEmptyFile(sink1Path);
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
        streamTableEnv.executeSql(insertStmt).await();
        this.assertFirstValues(sink1Path);
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testExecuteInsert() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sinkPath);
        Table table = this.tEnv().sqlQuery("select first from MyTable");
        TableResult tableResult = table.executeInsert("MySink");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testExecuteInsert2() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sinkPath);
        TableResult tableResult = this.tEnv().executeSql("execute insert into MySink select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testExecuteInsertOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = this.tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sinkPath).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        TableResult tableResult1 = this.tEnv().sqlQuery("select first from MyTable").executeInsert("MySink", true);
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
        TableResult tableResult2 = this.tEnv().sqlQuery("select first from MyTable").executeInsert("MySink", true);
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testTableDMLSync() {
        this.tEnv().getConfig().set(TableConfigOptions.TABLE_DML_SYNC, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sink1Path = this.tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("\n         |create table MySink1 (\n         |  first string,\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink1Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        String sink2Path = this.tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(195).append("\n         |create table MySink2 (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink2Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        String sink3Path = this.tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink3 (\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink3Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        TableResult tableResult1 = this.tEnv().sqlQuery("select first, last from MyTable").executeInsert("MySink1", false);
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO MySink2 select first from MySink1");
        stmtSet.addInsertSql("INSERT INTO MySink3 select last from MySink1");
        TableResult tableResult2 = stmtSet.execute();
        this.assertFirstValues(sink2Path);
        this.assertLastValues(sink3Path);
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink2", "default_catalog.default_database.MySink3"}));
        tableResult1.await();
        tableResult2.await();
    }

    @Test
    public void testStatementSet() {
        Boolean bl;
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"last"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable")).addInsertSql("insert into MySink2 select last from MyTable");
        String actual = stmtSet.explain(new ExplainDetail[0]);
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testStatementSet.out");
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(expected), (Object)TableTestUtil$.MODULE$.replaceStageId(actual));
        if (this.isStreaming) {
            Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testStatementSetWithPlanAdvice.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(stmtSet.explain(new ExplainDetail[]{ExplainDetail.PLAN_ADVICE})));
            bl = BoxedUnit.UNIT;
        } else {
            bl = BoxesRunTime.boxToBoolean((boolean)(Assertions.assertThatThrownBy(() -> stmtSet.explain(new ExplainDetail[]{ExplainDetail.PLAN_ADVICE})).hasMessageContaining("EXPLAIN PLAN_ADVICE is not supported under batch mode.") instanceof UnsupportedOperationException));
        }
        TableResult tableResult = stmtSet.execute();
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testExecuteStatementSet() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"last"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        TableResult tableResult = this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("execute statement set begin\n                                        |insert into MySink1 select first from MyTable;\n                                        |insert into MySink2 select last from MyTable;\n                                        |end")).stripMargin());
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testStatementSetWithOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sink1Path = this.tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(195).append("\n         |create table MySink1 (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink1Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        String sink2Path = this.tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink2 (\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sink2Path).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable"), true);
        stmtSet.addInsertSql("insert overwrite MySink2 select last from MyTable");
        TableResult tableResult1 = stmtSet.execute();
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable"), true).addInsertSql("insert overwrite MySink2 select last from MyTable");
        TableResult tableResult2 = stmtSet.execute();
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testStatementSetWithSameSinkTableNames() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = this.tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '").append(sinkPath).append("',\n         |  'format' = 'testcsv'\n         |)\n       ").toString())).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink", this.tEnv().sqlQuery("select first from MyTable"), true);
        stmtSet.addInsertSql("insert overwrite MySink select last from MyTable");
        TableResult tableResult = stmtSet.execute();
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink_1", "default_catalog.default_database.MySink_2"}));
    }

    @Test
    public void testExecuteSelect() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        this.testExecuteSelectInternal(query);
        String query2 = new StringOps(Predef$.MODULE$.augmentString("\n        |execute select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        this.testExecuteSelectInternal(query2);
    }

    public void testExecuteSelectInternal(String query) {
        TableResult tableResult = this.tEnv().executeSql(query);
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"full name", (DataType)DataTypes.STRING())}), (Object)tableResult.getResolvedSchema());
        java.util.List<Object> expected = Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{2, "Bob Taylor"}), Row.of((Object[])new Object[]{4, "Peter Smith"}), Row.of((Object[])new Object[]{6, "Sally Miller"}), Row.of((Object[])new Object[]{8, "Kelly Williams"})});
        java.util.List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        actual.sort(new Comparator<Row>(null){

            public Comparator<Row> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<Row> thenComparing(Comparator<? super Row> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<Row> thenComparing(Function<? super Row, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<Row> thenComparingInt(ToIntFunction<? super Row> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<Row> thenComparingLong(ToLongFunction<? super Row> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<Row> thenComparingDouble(ToDoubleFunction<? super Row> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(Row o1, Row o2) {
                return Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o1.getField(0))).compareTo(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o2.getField(0))));
            }
        });
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testExecuteSelectWithUpdateChanges() {
        TableResult tableResult = this.tEnv().sqlQuery("select count(*) as c from MyTable").execute();
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"c", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (Object)tableResult.getResolvedSchema());
        java.util.List<Object> expected = this.isStreaming ? Arrays.asList((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{8L})}) : Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{8L})});
        java.util.List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testExecuteSelectWithTimeAttribute() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary"}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"name", "pt"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.LOCAL_DATE_TIME()}));
        TypeInformation sourceType = Types.STRING();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(true, schema, sourceType, data, null, "pt", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("T", tableSource);
        TableResult tableResult = this.tEnv().executeSql("select * from T");
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.physical((String)"pt", (DataType)DataTypes.TIMESTAMP_LTZ((int)3))}), (Object)tableResult.getResolvedSchema());
        CloseableIterator it = tableResult.collect();
        Assert.assertTrue((boolean)it.hasNext());
        Row row = (Row)it.next();
        Assert.assertEquals((long)2L, (long)row.getArity());
        Assert.assertEquals((Object)"Mary", (Object)row.getField(0));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testClearOperation() {
        TestCollectionTableFactory$.MODULE$.reset();
        TableEnvironmentImpl tableEnv = TableEnvironmentImpl.create((EnvironmentSettings)this.settings());
        tableEnv.executeSql("create table dest1(x map<int,bigint>) with('connector' = 'COLLECTION')");
        tableEnv.executeSql("create table dest2(x int) with('connector' = 'COLLECTION')");
        tableEnv.executeSql("create table src(x int) with('connector' = 'COLLECTION')");
        try {
            tableEnv.executeSql("insert into dest1 select count(*) from src");
            Assert.fail((String)"insert is expected to fail due to type mismatch");
        }
        catch (Exception exception) {}
        tableEnv.executeSql("drop table dest1");
        tableEnv.executeSql("insert into dest2 select x from src").await();
    }

    public List<Tuple4<String, Object, Object, String>> getPersonData() {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"Mike", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToDouble((double)12.3), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Bob", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)45.6), (Object)"Taylor"));
        data.$plus$eq((Object)new Tuple4((Object)"Sam", (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToDouble((double)7.89), (Object)"Miller"));
        data.$plus$eq((Object)new Tuple4((Object)"Peter", (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToDouble((double)0.12), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Liz", (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToDouble((double)34.5), (Object)"Williams"));
        data.$plus$eq((Object)new Tuple4((Object)"Sally", (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToDouble((double)6.78), (Object)"Miller"));
        data.$plus$eq((Object)new Tuple4((Object)"Alice", (Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToDouble((double)90.1), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Kelly", (Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToDouble((double)2.34), (Object)"Williams"));
        return data.toList();
    }

    private void assertFirstValues(String csvFilePath) {
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mike", "Bob", "Sam", "Peter", "Liz", "Sally", "Alice", "Kelly"}));
        List<String> actual = this.readFile(csvFilePath);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)actual.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private void assertLastValues(String csvFilePath) {
        List<String> actual = this.readFile(csvFilePath);
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)actual.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private List<String> getExpectedLastValues() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Smith", "Taylor", "Miller", "Smith", "Williams", "Miller", "Smith", "Williams"}));
    }

    private void checkEmptyFile(String csvFilePath) {
        Assert.assertTrue((boolean)FileUtils.readFileUtf8((File)new File(csvFilePath)).isEmpty());
    }

    private void deleteFile(String path) {
        new File(path).delete();
        Assert.assertFalse((boolean)new File(path).exists());
    }

    private void assertFileNotExist(String path) {
        Assert.assertFalse((boolean)new File(path).exists());
    }

    private void checkInsertTableResult(TableResult tableResult, Seq<String> fieldNames) {
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals(Arrays.asList((Object[])fieldNames.toArray(ClassTag$.MODULE$.apply(String.class))), (Object)tableResult.getResolvedSchema().getColumnNames());
        CloseableIterator it = tableResult.collect();
        Assert.assertTrue((boolean)it.hasNext());
        Seq affectedRowCounts = (Seq)fieldNames.map((Function1 & Serializable & scala.Serializable)x$1 -> -1L, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)Row.of((Object[])((Object[])affectedRowCounts.toArray(ClassTag$.MODULE$.apply(Long.class)))), (Object)it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    private List<String> readFile(String csvFilePath) {
        File file = new File(csvFilePath);
        return file.isDirectory() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles(new FileFilter(null){

            public boolean accept(File f) {
                return f.isFile();
            }
        }))).map((Function1 & Serializable & scala.Serializable)x$1 -> FileUtils.readFileUtf8((File)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.split("\n"))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])FileUtils.readFileUtf8((File)file).split("\n"))).toList();
    }

    public TableEnvironmentITCase(String tableEnvName, boolean isStreaming) {
        this.tableEnvName = tableEnvName;
        this.isStreaming = isStreaming;
        this.tempFolder = new TemporaryFolder();
        this.settings = isStreaming ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
    }
}

