/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.batch.sql.validation;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MatchRecognizeValidationTest
extends TableTestBase {
    private static final String STREAM = "stream";
    private static final String BATCH = "batch";
    @Parameterized.Parameter
    public String mode;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private TableTestUtil util;
    private TableEnvironment tEnv;

    @Parameterized.Parameters(name="mode = {0}")
    public static Collection<String> parameters() {
        return Arrays.asList(STREAM, BATCH);
    }

    @Before
    public void setup() {
        this.util = STREAM.equals(this.mode) ? this.streamTestUtil(TableConfig.getDefault()) : this.batchTestUtil(TableConfig.getDefault());
        this.tEnv = this.util.getTableEnv();
        this.tEnv.executeSql("CREATE TABLE Ticker (\n  `symbol` VARCHAR,\n  `price` INT,\n  `tax` INT,\n  `proctime` as PROCTIME()\n) with (\n  'connector' = 'values',\n  'bounded' = 'true'\n)");
        this.tEnv.executeSql("CREATE TABLE MyTable (\n  a BIGINT,\n  b INT,\n  proctime as PROCTIME()\n) with (\n  'connector' = 'values',\n  'bounded' = 'true'\n)");
    }

    @After
    public void after() {
        this.util.getTableEnv().executeSql("DROP TABLE Ticker");
        this.util.getTableEnv().executeSql("DROP TABLE MyTable");
    }

    @Test(expected=ValidationException.class)
    public void testMatchRowTimeInSelect() {
        String sql = "SELECT MATCH_ROWTIME() FROM MyTable";
        this.util.verifyExplain(sql);
    }

    @Test(expected=ValidationException.class)
    public void testMatchProcTimeInSelect() {
        String sql = "SELECT MATCH_PROCTIME() FROM MyTable";
        this.util.verifyExplain(sql);
    }

    @Test
    public void testSortProcessingTimeDesc() {
        if (STREAM.equals(this.mode)) {
            this.expectedException.expect(TableException.class);
            this.expectedException.expectMessage("Primary sort order of a streaming table must be ascending on time.");
            String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime DESC\n  MEASURES\n    A.symbol AS aSymbol\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
            this.tEnv.executeSql(sqlQuery);
        }
    }

    @Test
    public void testSortProcessingTimeSecondaryField() {
        if (STREAM.equals(this.mode)) {
            this.expectedException.expect(TableException.class);
            this.expectedException.expectMessage("You must specify either rowtime or proctime for order by as the first one.");
            String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY price, proctime\n  MEASURES\n    A.symbol AS aSymbol\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
            this.tEnv.executeSql(sqlQuery);
        }
    }

    @Test
    public void testSortNoOrder() {
        if (STREAM.equals(this.mode)) {
            this.expectedException.expect(TableException.class);
            this.expectedException.expectMessage("You must specify either rowtime or proctime for order by.");
            String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  MEASURES\n    A.symbol AS aSymbol\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
            this.tEnv.executeSql(sqlQuery);
        }
    }

    @Test
    public void testUpdatesInUpstreamOperatorNotSupported() {
        if (STREAM.equals(this.mode)) {
            this.expectedException.expect(TableException.class);
            this.expectedException.expectMessage("Match Recognize doesn't support consuming update changes which is produced by node GroupAggregate(");
            String sqlQuery = "SELECT *\nFROM (SELECT DISTINCT * FROM Ticker)\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    A.symbol AS aSymbol\n   ONE ROW PER MATCH  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
            this.tEnv.executeSql(sqlQuery);
        }
    }

    @Test
    public void testAggregatesOnMultiplePatternVariablesNotSupported() {
        this.expectedException.expect(ValidationException.class);
        this.expectedException.expectMessage("SQL validation failed.");
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    SUM(A.price + B.tax) AS taxedPrice\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        this.tEnv.executeSql(sqlQuery);
    }

    @Test
    public void testAggregatesOnMultiplePatternVariablesNotSupportedInUDAGs() {
        this.expectedException.expect(ValidationException.class);
        this.expectedException.expectMessage("Aggregation must be applied to a single pattern variable");
        this.util.addTemporarySystemFunction("weightedAvg", (UserDefinedFunction)new JavaUserDefinedAggFunctions.WeightedAvg());
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    weightedAvg(A.price, B.tax) AS weightedAvg\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        this.tEnv.executeSql(sqlQuery);
    }

    @Test
    public void testValidatingAmbiguousColumns() {
        this.expectedException.expect(ValidationException.class);
        this.expectedException.expectMessage("Columns ambiguously defined: {symbol, price}");
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  PARTITION BY symbol, price\n  ORDER BY proctime\n  MEASURES\n    A.symbol AS symbol,\n    A.price AS price\n  PATTERN (A)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        this.tEnv.executeSql(sqlQuery);
    }

    @Test
    public void testMatchPythonFunction() {
        this.expectedException.expect(TableException.class);
        this.expectedException.expectMessage("Python Function can not be used in MATCH_RECOGNIZE for now.");
        this.util.addTemporarySystemFunction("pyFunc", (UserDefinedFunction)new JavaUserDefinedScalarFunctions.PythonScalarFunction("pyFunc"));
        String sql = "SELECT T.aa as ta\nFROM MyTable\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    A.a as aa,\n    pyFunc(1,2) as bb\n  PATTERN (A B)\n  DEFINE\n    A AS a = 1,\n    B AS b = 'b'\n) AS T";
        this.util.verifyExplain(sql);
    }

    @Test
    public void testAllRowsPerMatch() {
        this.expectedException.expect(TableException.class);
        this.expectedException.expectMessage("All rows per match mode is not supported yet.");
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    A.symbol AS aSymbol\n  ALL ROWS PER MATCH\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        this.tEnv.executeSql(sqlQuery);
    }

    @Test
    public void testGreedyQuantifierAtTheEndIsNotSupported() {
        this.expectedException.expect(TableException.class);
        this.expectedException.expectMessage("Greedy quantifiers are not allowed as the last element of a Pattern yet. Finish your pattern with either a simple variable or reluctant quantifier.");
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    A.symbol AS aSymbol\n  PATTERN (A B+)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        this.tEnv.executeSql(sqlQuery);
    }

    @Test
    public void testPatternsProducingEmptyMatchesAreNotSupported() {
        this.expectedException.expect(TableException.class);
        this.expectedException.expectMessage("Patterns that can produce empty matches are not supported. There must be at least one non-optional state.");
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    A.symbol AS aSymbol\n  PATTERN (A*)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        this.tEnv.executeSql(sqlQuery);
    }

    @Test
    public void testDistinctAggregationsNotSupported() {
        this.expectedException.expect(ValidationException.class);
        this.expectedException.expectMessage("SQL validation failed.");
        String sqlQuery = "SELECT *\nFROM Ticker\nMATCH_RECOGNIZE (\n  ORDER BY proctime\n  MEASURES\n    COUNT(DISTINCT A.price) AS price\n  PATTERN (A B)\n  DEFINE\n    A AS A.symbol = 'a'\n) AS T";
        this.tEnv.executeSql(sqlQuery);
    }
}

