/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.alias;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.alias.ClearJoinHintWithInvalidPropagationShuttleTestBase;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Test;

public class ClearJoinHintWithInvalidPropagationShuttleTest
extends ClearJoinHintWithInvalidPropagationShuttleTestBase {
    @Override
    TableTestUtil getTableTestUtil() {
        return this.batchTestUtil(TableConfig.getDefault());
    }

    @Override
    boolean isBatchMode() {
        return true;
    }

    @Test
    public void testNoNeedToClearJoinHint() {
        RelHint joinHintInView = RelHint.builder((String)JoinStrategy.BROADCAST.getJoinHintName()).hintOption("t1").build();
        RelNode root = this.builder.scan(new String[]{"t1"}).scan(new String[]{"t2"}).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{joinHintInView}).build();
        this.verifyRelPlan(root);
    }

    @Test
    public void testClearJoinHintWithInvalidPropagationToViewWhileViewHasJoinHints() {
        RelHint joinHintInView = RelHint.builder((String)JoinStrategy.BROADCAST.getJoinHintName()).hintOption("t1").build();
        RelHint joinHintRoot = RelHint.builder((String)JoinStrategy.BROADCAST.getJoinHintName()).hintOption("t3").build();
        RelHint aliasHint = RelHint.builder((String)"ALIAS").hintOption("t4").build();
        RelNode root = this.builder.scan(new String[]{"t1"}).scan(new String[]{"t2"}).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{joinHintInView, aliasHint}).scan(new String[]{"t3"}).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{joinHintRoot}).build();
        this.verifyRelPlan(root);
    }

    @Test
    public void testClearJoinHintWithInvalidPropagationToViewWhileViewHasNoJoinHints() {
        RelHint joinHintRoot = RelHint.builder((String)JoinStrategy.BROADCAST.getJoinHintName()).hintOption("t3").build();
        RelHint aliasHint = RelHint.builder((String)"ALIAS").hintOption("t4").build();
        RelNode root = this.builder.scan(new String[]{"t1"}).scan(new String[]{"t2"}).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{aliasHint}).scan(new String[]{"t3"}).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{joinHintRoot}).build();
        this.verifyRelPlan(root);
    }

    @Test
    public void testClearJoinHintWithoutPropagatingToView() {
        RelHint joinHintRoot = RelHint.builder((String)JoinStrategy.BROADCAST.getJoinHintName()).hintOption("t1").build();
        RelHint aliasHint = RelHint.builder((String)"ALIAS").hintOption("t4").build();
        RelNode root = this.builder.scan(new String[]{"t1"}).scan(new String[]{"t2"}).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{aliasHint}).scan(new String[]{"t3"}).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{joinHintRoot}).build();
        this.verifyRelPlan(root);
    }
}

