/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.alias;

import java.util.Collections;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.SqlCollectionTableOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.alias.ClearJoinHintWithInvalidPropagationShuttleTestBase;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.nodes.exec.spec.LookupJoinHintTestUtil;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Before;
import org.junit.Test;

public class ClearLookupJoinHintWithInvalidPropagationShuttleTest
extends ClearJoinHintWithInvalidPropagationShuttleTestBase {
    @Override
    TableTestUtil getTableTestUtil() {
        return this.streamTestUtil(TableConfig.getDefault());
    }

    @Override
    boolean isBatchMode() {
        return false;
    }

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.util.tableEnv().executeSql("CREATE TABLE src (\n  a BIGINT,  ds ARRAY<BIGINT>,  pts AS PROCTIME()\n) WITH (\n 'connector' = 'values'\n)");
        this.util.tableEnv().executeSql("CREATE TABLE lookup (\n  a BIGINT\n) WITH (\n 'connector' = 'values'\n)");
        this.util.tableEnv().createTemporarySystemFunction("MockOffset", (UserDefinedFunction)new MockOffsetTableFunction());
    }

    @Test
    public void testNoNeedToClearLookupHint() {
        CorrelationId cid = this.builder.getCluster().createCorrel();
        RelDataType aType = this.builder.getTypeFactory().createStructType(Collections.singletonList(this.builder.getTypeFactory().createSqlType(SqlTypeName.BIGINT)), Collections.singletonList("a"));
        RelDataType ptsType = this.builder.getTypeFactory().createStructType(Collections.singletonList(this.builder.getTypeFactory().createProctimeIndicatorType(false)), Collections.singletonList("pts"));
        RelNode root = this.builder.scan(new String[]{"src"}).scan(new String[]{"lookup"}).snapshot(this.builder.getRexBuilder().makeCall((SqlOperator)FlinkSqlOperatorTable.PROCTIME, new RexNode[0])).filter(new RexNode[]{this.builder.equals(this.builder.field(this.builder.getRexBuilder().makeCorrel(aType, cid), "a"), (RexNode)this.builder.getRexBuilder().makeInputRef(aType, 0))}).correlate(JoinRelType.INNER, cid, new RexNode[]{this.builder.getRexBuilder().makeInputRef(aType, 0), this.builder.getRexBuilder().makeInputRef(ptsType, 1)}).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{RelHint.builder((String)"ALIAS").hintOption("t1").build()}).hints(new RelHint[]{LookupJoinHintTestUtil.getLookupJoinHint("d", true, false)}).build();
        this.verifyRelPlan(root);
    }

    @Test
    public void testClearLookupHintWithInvalidPropagationToSubQuery() {
        CorrelationId cid = this.builder.getCluster().createCorrel();
        RelDataType aType = this.builder.getTypeFactory().createStructType(Collections.singletonList(this.builder.getTypeFactory().createSqlType(SqlTypeName.BIGINT)), Collections.singletonList("a"));
        RelDataType ptsType = this.builder.getTypeFactory().createStructType(Collections.singletonList(this.builder.getTypeFactory().createProctimeIndicatorType(false)), Collections.singletonList("pts"));
        RelNode root = this.builder.scan(new String[]{"src"}).scan(new String[]{"lookup"}).snapshot(this.builder.getRexBuilder().makeCall((SqlOperator)FlinkSqlOperatorTable.PROCTIME, new RexNode[0])).filter(new RexNode[]{this.builder.equals(this.builder.field(this.builder.getRexBuilder().makeCorrel(aType, cid), "a"), (RexNode)this.builder.getRexBuilder().makeInputRef(aType, 0))}).correlate(JoinRelType.INNER, cid, new RexNode[]{this.builder.getRexBuilder().makeInputRef(aType, 0), this.builder.getRexBuilder().makeInputRef(ptsType, 1)}).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{RelHint.builder((String)"ALIAS").hintOption("t1").build()}).hints(new RelHint[]{LookupJoinHintTestUtil.getLookupJoinHint("d", true, false)}).scan(new String[]{"src"}).hints(new RelHint[]{RelHint.builder((String)"ALIAS").hintOption("t2").build()}).join(JoinRelType.INNER, this.builder.equals((RexNode)this.builder.field(2, 0, "a"), (RexNode)this.builder.field(2, 1, "a"))).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{LookupJoinHintTestUtil.getLookupJoinHint("src", true, true)}).build();
        this.verifyRelPlan(root);
    }

    @Test
    public void testNoNeedToClearLookupHintWhileJoinWithUnnest() {
        CorrelationId cid = this.builder.getCluster().createCorrel();
        RelDataType dsType = this.builder.getTypeFactory().createStructType(Collections.singletonList(this.builder.getTypeFactory().createArrayType(this.builder.getTypeFactory().createSqlType(SqlTypeName.BIGINT), -1L)), Collections.singletonList("ds"));
        RelOptCluster cluster = this.util.getPlanner().plannerContext().getCluster();
        RelNode root = this.builder.scan(new String[]{"src"}).project(new RexNode[]{this.builder.field(1, 0, "a")}).push((RelNode)LogicalValues.createOneRow((RelOptCluster)cluster)).project(new RexNode[]{this.builder.field(this.builder.getRexBuilder().makeCorrel(dsType, cid), "ds")}).uncollect(Collections.singletonList("a"), false).project(new RexNode[]{this.builder.field(1, 0, "a")}).correlate(JoinRelType.INNER, cid, new RexNode[0]).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{LookupJoinHintTestUtil.getLookupJoinHint("d", true, false)}).build();
        this.verifyRelPlan(root);
    }

    @Test
    public void testNoNeedToClearLookupHintWhileJoinWithUDTF() {
        CorrelationId cid = this.builder.getCluster().createCorrel();
        final RelDataType bType = this.builder.getTypeFactory().createStructType(Collections.singletonList(this.builder.getTypeFactory().createSqlType(SqlTypeName.BIGINT)), Collections.singletonList("b"));
        RelNode root = this.builder.scan(new String[]{"src"}).project(new RexNode[]{this.builder.field(1, 0, "a")}).functionScan((SqlOperator)new SqlCollectionTableOperator("TABLE", SqlModality.RELATION){

            public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
                return bType;
            }
        }, 0, new RexNode[]{this.builder.getRexBuilder().makeFieldAccess(this.builder.getRexBuilder().makeCorrel(bType, cid), 0)}).correlate(JoinRelType.INNER, cid, new RexNode[0]).project(new RexNode[]{this.builder.field(1, 0, "a")}).hints(new RelHint[]{LookupJoinHintTestUtil.getLookupJoinHint("d", true, false)}).build();
        this.verifyRelPlan(root);
    }

    @FunctionHint(output=@DataTypeHint(value="ROW< b BIGINT >"))
    public static class MockOffsetTableFunction
    extends TableFunction<Long> {
        public void eval(Long arg) {
            this.collect(arg + 10L);
        }
    }
}

