/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.analyze;

import java.time.Duration;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;
import org.apache.flink.table.planner.utils.PlanKind;
import org.apache.flink.table.planner.utils.StreamTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Enumeration;
import scala.Function0;
import scala.runtime.BoxedUnit;

@RunWith(value=Parameterized.class)
public class GroupAggregationAnalyzerTest
extends TableTestBase {
    private final StreamTableTestUtil util = this.streamTestUtil(TableConfig.getDefault());
    @Parameterized.Parameter
    public boolean isMiniBatchEnabled;
    @Parameterized.Parameter(value=1)
    public AggregatePhaseStrategy strategy;
    @Parameterized.Parameter(value=2)
    public long miniBatchLatency;
    @Parameterized.Parameter(value=3)
    public long miniBatchSize;
    private final String query = "SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM MyTable";

    @Before
    public void before() {
        this.util.getTableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED, (Object)this.isMiniBatchEnabled).set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)this.strategy.toString()).set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY, (Object)Duration.ofSeconds(this.miniBatchLatency)).set(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_SIZE, (Object)this.miniBatchSize);
        this.util.getTableEnv().executeSql("CREATE TABLE MyTable (\n  a BIGINT,\n  b INT NOT NULL,\n  c VARCHAR,\n  d BIGINT\n) WITH (\n  'connector' = 'values',\n  'bounded' = 'false')");
        this.util.getTableEnv().executeSql("CREATE TABLE MySink (\n  avg_a DOUBLE,\n  cnt BIGINT,\n  cnt_b BIGINT,\n  min_b BIGINT,\n  max_c VARCHAR\n) WITH (\n  'connector' = 'values',\n  'sink-insert-only' = 'false')");
    }

    @Test
    public void testSelect() {
        this.util.doVerifyPlan("SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM MyTable", new ExplainDetail[]{ExplainDetail.PLAN_ADVICE}, false, new Enumeration.Value[]{PlanKind.OPT_REL_WITH_ADVICE()}, false);
    }

    @Test
    public void testInsertInto() {
        this.util.doVerifyPlanInsert(String.format("INSERT INTO MySink\n%s", "SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM MyTable"), new ExplainDetail[]{ExplainDetail.PLAN_ADVICE}, false, new Enumeration.Value[]{PlanKind.OPT_REL_WITH_ADVICE()});
    }

    @Test
    public void testStatementSet() {
        StatementSet stmtSet = this.util.getTableEnv().createStatementSet();
        this.util.getTableEnv().executeSql("CREATE TABLE MySink2 LIKE MySink");
        this.util.getTableEnv().executeSql("CREATE TABLE MySink3 (\n  b INT NOT NULL,\n  sum_a BIGINT,\n  cnt_c BIGINT\n  ) WITH (\n  'connector' = 'values',\n  'sink-insert-only' = 'false')");
        stmtSet.addInsertSql(String.format("INSERT INTO MySink\n%s", "SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM MyTable"));
        stmtSet.addInsertSql(String.format("INSERT INTO MySink2\n%s", "SELECT\n  AVG(a) AS avg_a,\n  COUNT(*) AS cnt,\n  count(b) AS cnt_b,\n  min(b) AS min_b,\n  MAX(c) FILTER (WHERE a > 1) AS max_c\nFROM MyTable"));
        stmtSet.addInsertSql("INSERT INTO MySink3\nSELECT \n  b, \n  SUM(a) AS sum_a,\n  COUNT(c) AS cnt_c\nFROM MyTable\nGROUP BY b");
        this.util.doVerifyPlan(stmtSet, new ExplainDetail[]{ExplainDetail.PLAN_ADVICE}, false, new Enumeration.Value[]{PlanKind.OPT_REL_WITH_ADVICE()}, (Function0<BoxedUnit>)((Function0)() -> BoxedUnit.UNIT), false);
    }

    @Test
    public void testSubplanReuse() {
        this.util.doVerifyPlan("WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM MyTable GROUP BY c)\nSELECT * FROM r r1, r r2 WHERE r1.a = CAST(r2.b AS BIGINT) AND r2.a > 1", new ExplainDetail[]{ExplainDetail.PLAN_ADVICE}, false, new Enumeration.Value[]{PlanKind.OPT_REL_WITH_ADVICE()}, false);
    }

    @Test
    public void testUserDefinedAggCalls() {
        StatementSet stmtSet = this.util.getTableEnv().createStatementSet();
        this.util.addTemporarySystemFunction("weightedAvg", JavaUserDefinedAggFunctions.WeightedAvgWithMerge.class);
        this.util.addTemporarySystemFunction("weightedAvgWithoutMerge", JavaUserDefinedAggFunctions.WeightedAvg.class);
        this.util.getTableEnv().executeSql("CREATE TABLE MySink1 (\n  avg_a_1 DOUBLE\n) WITH (\n  'connector' = 'values',\n  'sink-insert-only' = 'false')");
        this.util.getTableEnv().executeSql("CREATE TABLE MySink2 (avg_a_2 DOUBLE) LIKE MySink1");
        stmtSet.addInsertSql("INSERT INTO MySink1\nSELECT \n  weightedAvg(a, d) AS avg_a_1\nFROM MyTable");
        stmtSet.addInsertSql("INSERT INTO MySink2\nSELECT \n  weightedAvg(a, d) AS avg_a_1,\n  weightedAvgWithoutMerge(a, d) AS avg_a_2\nFROM MyTable");
        this.util.doVerifyPlan(stmtSet, new ExplainDetail[]{ExplainDetail.PLAN_ADVICE}, false, new Enumeration.Value[]{PlanKind.OPT_REL_WITH_ADVICE()}, (Function0<BoxedUnit>)((Function0)() -> BoxedUnit.UNIT), false);
    }

    @Parameterized.Parameters(name="isMiniBatchEnabled={0}, strategy={1}, miniBatchLatency={2}, miniBatchSize={3}")
    public static Object[][] data() {
        return new Object[][]{{true, AggregatePhaseStrategy.ONE_PHASE, 10L, 5L}, {true, AggregatePhaseStrategy.AUTO, 10L, 5L}, {false, AggregatePhaseStrategy.ONE_PHASE, 0L, -1L}, {false, AggregatePhaseStrategy.AUTO, 10L, 5L}};
    }
}

