/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import java.util.Collection;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.util.MockStreamingRuntimeContext;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.SqlToRexConverter;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenTest$;
import org.apache.flink.table.planner.codegen.WatermarkGeneratorCodeGenerator$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.PlannerMocks;
import org.apache.flink.table.runtime.generated.GeneratedWatermarkGenerator;
import org.apache.flink.table.runtime.generated.WatermarkGenerator;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.utils.CatalogManagerMocks;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001=\u0011QdV1uKJl\u0017M]6HK:,'/\u0019;pe\u000e{G-Z$f]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tqaY8eK\u001e,gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002+U\u001cX\rR3gS:,GmQ8ogR\u0014Xo\u0019;peB\u0011\u0011#G\u0005\u00035I\u0011qAQ8pY\u0016\fg\u000eC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0003=\u0001\u0002\"a\b\u0001\u000e\u0003\tAQaF\u000eA\u0002aAqA\t\u0001C\u0002\u0013\u00051%\u0001\u0007qY\u0006tg.\u001a:N_\u000e\\7/F\u0001%!\t)\u0003&D\u0001'\u0015\t9C!A\u0003vi&d7/\u0003\u0002*M\ta\u0001\u000b\\1o]\u0016\u0014Xj\\2lg\"11\u0006\u0001Q\u0001\n\u0011\nQ\u0002\u001d7b]:,'/T8dWN\u0004\u0003\"B\u0017\u0001\t\u0003q\u0013AC4fiBc\u0017M\u001c8feV\tq\u0006\u0005\u00021g5\t\u0011G\u0003\u00023\t\u000591-\u00197dSR,\u0017B\u0001\u001b2\u0005A1E.\u001b8l!2\fgN\\3s\u00136\u0004H\u000eC\u00047\u0001\t\u0007I\u0011A\u001c\u0002\t\u0011\fG/Y\u000b\u0002qA\u0019\u0011H\u0010!\u000e\u0003iR!a\u000f\u001f\u0002\u0013%lW.\u001e;bE2,'BA\u001f\u0013\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u007fi\u0012A\u0001T5tiB\u0011\u0011iQ\u0007\u0002\u0005*\u0011aGB\u0005\u0003\t\n\u0013abR3oKJL7MU8x\t\u0006$\u0018\r\u0003\u0004G\u0001\u0001\u0006I\u0001O\u0001\u0006I\u0006$\u0018\r\t\u0005\u0006\u0011\u0002!\t!S\u0001\u0017i\u0016\u001cH/Q:dK:$\u0017N\\4XCR,'/\\1sWR\t!\n\u0005\u0002\u0012\u0017&\u0011AJ\u0005\u0002\u0005+:LG\u000f\u000b\u0002H\u001dB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bD\u0001\u0006UVt\u0017\u000e^\u0005\u0003'B\u0013A\u0001V3ti\")Q\u000b\u0001C\u0001\u0013\u0006qB/Z:u\u0005>,h\u000eZ3e\u001fV$xJZ(sI\u0016\u0014x+\u0019;fe6\f'o\u001b\u0015\u0003):CQ\u0001\u0017\u0001\u0005\u0002%\u000bQ\u0004^3ti2+w-Y2z\u0007V\u001cHo\\7ju\u0016$w+\u0019;fe6\f'o\u001b\u0015\u0003/:CQa\u0017\u0001\u0005\u0002%\u000bq\u0003^3ti\u000e+8\u000f^8nSj,GmV1uKJl\u0017M]6)\u0005is\u0005\"B.\u0001\t\u0013qFC\u0001&`\u0011\u0015\u0001W\f1\u0001\u0019\u0003!I7\u000fT3hC\u000eL\b\"\u00022\u0001\t\u0013\u0019\u0017AG4f]\u0016\u0014\u0018\r^3XCR,'/\\1sW\u001e+g.\u001a:bi>\u0014Hc\u00013msB\u0011QM[\u0007\u0002M*\u0011q\r[\u0001\nO\u0016tWM]1uK\u0012T!!\u001b\u0004\u0002\u000fI,h\u000e^5nK&\u00111N\u001a\u0002\u0013/\u0006$XM]7be.<UM\\3sCR|'\u000fC\u0003nC\u0002\u0007a.\u0001\u0003fqB\u0014\bCA8w\u001d\t\u0001H\u000f\u0005\u0002r%5\t!O\u0003\u0002t\u001d\u00051AH]8pizJ!!\u001e\n\u0002\rA\u0013X\rZ3g\u0013\t9\bP\u0001\u0004TiJLgn\u001a\u0006\u0003kJAQaF1A\u0002aAc\u0001A>\u0002\u0004\u0005\u0015\u0001C\u0001?\u0000\u001b\u0005i(B\u0001@Q\u0003\u0019\u0011XO\u001c8fe&\u0019\u0011\u0011A?\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\u0012\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002)\u0002\u000fI,hN\\3sg&!\u0011\u0011CA\u0006\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u001e9\u0011Q\u0003\u0002\t\u0002\u0005]\u0011!H,bi\u0016\u0014X.\u0019:l\u000f\u0016tWM]1u_J\u001cu\u000eZ3HK:$Vm\u001d;\u0011\u0007}\tIB\u0002\u0004\u0002\u0005!\u0005\u00111D\n\u0004\u00033\u0001\u0002b\u0002\u000f\u0002\u001a\u0011\u0005\u0011q\u0004\u000b\u0003\u0003/A\u0001\"a\t\u0002\u001a\u0011\u0005\u0011QE\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHCAA\u0014!\u0015\tI#a\r\u0019\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012\u0001B;uS2T!!!\r\u0002\t)\fg/Y\u0005\u0005\u0003k\tYC\u0001\u0006D_2dWm\u0019;j_:D\u0003\"!\t\u0002:\u0005\u001d\u0013\u0011\n\t\u0005\u0003w\t\tE\u0004\u0003\u0002\n\u0005u\u0012\u0002BA \u0003\u0017\tQ\u0002U1sC6,G/\u001a:ju\u0016$\u0017\u0002BA\"\u0003\u000b\u0012!\u0002U1sC6,G/\u001a:t\u0015\u0011\ty$a\u0003\u0002\t9\fW.Z\u0011\u0003\u0003\u0017\n\u0011$^:f\t\u00164\u0017N\\3e\u0007>t7\u000f\u001e:vGR|'/P>1{\u0002")
public class WatermarkGeneratorCodeGenTest {
    private final boolean useDefinedConstructor;
    private final PlannerMocks plannerMocks;
    private final List<GenericRowData> data;

    @Parameterized.Parameters(name="useDefinedConstructor={0}")
    public static Collection<Object> parameters() {
        return WatermarkGeneratorCodeGenTest$.MODULE$.parameters();
    }

    public PlannerMocks plannerMocks() {
        return this.plannerMocks;
    }

    public FlinkPlannerImpl getPlanner() {
        return this.plannerMocks().getPlanner();
    }

    public List<GenericRowData> data() {
        return this.data;
    }

    @Test
    public void testAscendingWatermark() {
        WatermarkGenerator generator = this.generateWatermarkGenerator("ts - INTERVAL '0.001' SECOND", this.useDefinedConstructor);
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        .colon.colon expected = new .colon.colon((Object)999L, (List)new .colon.colon(null, (List)new .colon.colon((Object)2999L, (List)new .colon.colon((Object)4999L, (List)new .colon.colon((Object)3999L, (List)new .colon.colon((Object)5999L, (List)Nil$.MODULE$))))));
        Assert.assertEquals((Object)expected, (Object)results);
    }

    @Test
    public void testBoundedOutOfOrderWatermark() {
        WatermarkGenerator generator = this.generateWatermarkGenerator("ts - INTERVAL '5' SECOND", this.useDefinedConstructor);
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        .colon.colon expected = new .colon.colon((Object)-4000L, (List)new .colon.colon(null, (List)new .colon.colon((Object)-2000L, (List)new .colon.colon((Object)0L, (List)new .colon.colon((Object)-1000L, (List)new .colon.colon((Object)1000L, (List)Nil$.MODULE$))))));
        Assert.assertEquals((Object)expected, (Object)results);
    }

    @Test
    public void testLegacyCustomizedWatermark() {
        this.testCustomizedWatermark(true);
    }

    @Test
    public void testCustomizedWatermark() {
        this.testCustomizedWatermark(false);
    }

    private void testCustomizedWatermark(boolean isLegacy) {
        JavaUserDefinedScalarFunctions.JavaFunc5.openCalled = false;
        JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled = false;
        if (isLegacy) {
            this.plannerMocks().getFunctionCatalog().registerTempCatalogScalarFunction(ObjectIdentifier.of((String)CatalogManagerMocks.DEFAULT_CATALOG, (String)CatalogManagerMocks.DEFAULT_DATABASE, (String)"myFunc"), (ScalarFunction)new JavaUserDefinedScalarFunctions.JavaFunc5());
        } else {
            this.plannerMocks().getFunctionCatalog().registerTemporaryCatalogFunction(UnresolvedIdentifier.of((String[])new String[]{CatalogManagerMocks.DEFAULT_CATALOG, CatalogManagerMocks.DEFAULT_DATABASE, "myFunc"}), (FunctionDefinition)new JavaUserDefinedScalarFunctions.JavaFunc5(), false);
        }
        WatermarkGenerator generator = this.generateWatermarkGenerator("myFunc(ts, `offset`)", this.useDefinedConstructor);
        if (!this.useDefinedConstructor) {
            generator.setRuntimeContext((RuntimeContext)new MockStreamingRuntimeContext(false, 1, 1));
        }
        generator.open(new Configuration());
        List results = (List)this.data().map((Function1 & Serializable & scala.Serializable)d -> generator.currentWatermark((RowData)d), List$.MODULE$.canBuildFrom());
        generator.close();
        .colon.colon expected = new .colon.colon((Object)995L, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon((Object)4997L, (List)new .colon.colon((Object)3990L, (List)new .colon.colon((Object)5992L, (List)Nil$.MODULE$))))));
        Assert.assertEquals((Object)expected, (Object)results);
        Assert.assertTrue((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.openCalled);
        Assert.assertTrue((boolean)JavaUserDefinedScalarFunctions.JavaFunc5.closeCalled);
    }

    private WatermarkGenerator generateWatermarkGenerator(String expr, boolean useDefinedConstructor) {
        WatermarkGenerator watermarkGenerator;
        RelDataType tableRowType = this.plannerMocks().getPlannerContext().getTypeFactory().buildRelNodeRowType((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ts", "offset"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogicalType[]{new TimestampType(3), new IntType()})));
        RowType rowType = FlinkTypeFactory$.MODULE$.toLogicalRowType(tableRowType);
        SqlToRexConverter converter = ((FlinkContext)this.plannerMocks().getPlanner().createToRelContext().getCluster().getPlanner().getContext().unwrap(FlinkContext.class)).getRexFactory().createSqlToRexConverter(tableRowType, null);
        RexNode rexNode = converter.convertToRexNode(expr);
        if (useDefinedConstructor) {
            GeneratedWatermarkGenerator generated = WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader(), rowType, rexNode, Option$.MODULE$.apply((Object)"context"));
            Object[] newReferences = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(generated.getReferences())).$colon$plus((Object)new WatermarkGeneratorSupplier.Context(null){

                public MetricGroup getMetricGroup() {
                    return null;
                }
            }, ClassTag$.MODULE$.Object());
            watermarkGenerator = (WatermarkGenerator)generated.newInstance(Thread.currentThread().getContextClassLoader(), new Object[]{newReferences});
        } else {
            GeneratedWatermarkGenerator generated = WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader(), rowType, rexNode, WatermarkGeneratorCodeGenerator$.MODULE$.generateWatermarkGenerator$default$5());
            watermarkGenerator = (WatermarkGenerator)generated.newInstance(Thread.currentThread().getContextClassLoader());
        }
        return watermarkGenerator;
    }

    public WatermarkGeneratorCodeGenTest(boolean useDefinedConstructor) {
        this.useDefinedConstructor = useDefinedConstructor;
        this.plannerMocks = PlannerMocks.create();
        this.data = new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)1000L), 5}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{null, 4}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)3000L), null}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)5000L), 3}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)4000L), 10}), (List)new .colon.colon((Object)GenericRowData.of((Object[])new Object[]{TimestampData.fromEpochMillis((long)6000L), 8}), (List)Nil$.MODULE$))))));
    }
}

