/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.validation;

import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.ArrayTypeTestBase;
import org.junit.Test;
import scala.Symbol;
import scala.reflect.ScalaSignature;
import scala.runtime.SymbolLiteral;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001#\t9\u0012I\u001d:bsRK\b/\u001a,bY&$\u0017\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t!B^1mS\u0012\fG/[8o\u0015\t)a!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0004\t\u0003\u001d\u0001H.\u00198oKJT!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0006kRLGn]\u0005\u0003/Q\u0011\u0011#\u0011:sCf$\u0016\u0010]3UKN$()Y:f\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0003\u001f\u0001\u0011\u0005q$\u0001\u000fuKN$\u0018*\u001c9mS\u000eLG\u000fV=qK\u000e\u000b7\u000f^!se\u0006L8+\u001d7\u0015\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012A!\u00168ji\"\"QdJ\u0017/!\tA3&D\u0001*\u0015\tQc\"A\u0003kk:LG/\u0003\u0002-S\t!A+Z:u\u0003!)\u0007\u0010]3di\u0016$7%A\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0005IB\u0011aA1qS&\u0011A'\r\u0002\u0014-\u0006d\u0017\u000eZ1uS>tW\t_2faRLwN\u001c\u0005\u0006m\u0001!\taH\u0001 i\u0016\u001cHo\u00142wS>,8/\u00138wC2LG-\u00138eKb$\u0016M\u00197f\u0003BL\u0007\u0006B\u001b([9BQ!\u000f\u0001\u0005\u0002}\t\u0011\u0003^3ti\u0016k\u0007\u000f^=BeJ\f\u0017pU9mQ\u0011At%\f\u0018\t\u000bq\u0002A\u0011A\u0010\u0002!Q,7\u000f\u001e(vY2\f%O]1z'Fd\u0007\u0006B\u001e([9BQa\u0010\u0001\u0005\u0002}\t!\u0004^3ti\u0012KgMZ3sK:$H+\u001f9fg\u0006\u0013(/Y=Tc2DCAP\u0014.]!)!\t\u0001C\u0001?\u0005\u0019B/Z:u\u000b2,W.\u001a8u\u001d>t\u0017I\u001d:bs\"\"\u0011iJ\u0017/\u0011\u0015)\u0005\u0001\"\u0001 \u0003Y!Xm\u001d;FY\u0016lWM\u001c;O_:\f%O]1z'Fd\u0007\u0006\u0002#([9BQ\u0001\u0013\u0001\u0005\u0002}\t\u0011\u0004^3ti\u000e\u000b'\u000fZ5oC2LG/_(o\u001d>t\u0017I\u001d:bs\"\"qiJ\u0017/\u0011\u0015Y\u0005\u0001\"\u0001 \u0003q!Xm\u001d;DCJ$\u0017N\\1mSRLxJ\u001c(p]\u0006\u0013(/Y=Tc2DCAS\u0014.]\u0001")
public class ArrayTypeValidationTest
extends ArrayTypeTestBase {
    @Test(expected=ValidationException.class)
    public void testImplicitTypeCastArraySql() {
        this.testSqlApi("ARRAY['string', 12]", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testObviousInvalidIndexTableApi() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f2")).at((Object)package$.MODULE$.int2Literal(0)), "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testEmptyArraySql() {
        this.testSqlApi("ARRAY[]", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testNullArraySql() {
        this.testSqlApi("ARRAY[NULL]", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testDifferentTypesArraySql() {
        this.testSqlApi("ARRAY[1, TRUE]", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testElementNonArray() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).element(), "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testElementNonArraySql() {
        this.testSqlApi("ELEMENT(f0)", "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testCardinalityOnNonArray() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f0")).cardinality(), "FAIL");
    }

    @Test(expected=ValidationException.class)
    public void testCardinalityOnNonArraySql() {
        this.testSqlApi("CARDINALITY(f0)", "FAIL");
    }
}

