/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.CollectionUtil;

public class MapFunctionITCase
extends BuiltInFunctionTestBase {
    private static final LocalDate TEST_DATE_1 = LocalDate.of(1985, 11, 4);
    private static final LocalDate TEST_DATE_2 = LocalDate.of(2018, 7, 26);
    private static final LocalTime TEST_TIME_1 = LocalTime.of(17, 18, 19);
    private static final LocalTime TEST_TIME_2 = LocalTime.of(14, 15, 16);
    private static final LocalDateTime TEST_DATE_TIME_1 = LocalDateTime.of(1985, 11, 4, 17, 18, 19);
    private static final LocalDateTime TEST_DATE_TIME_2 = LocalDateTime.of(2018, 7, 26, 14, 15, 16);
    private static final String A = "a";
    private static final String B = "b";
    private static final int INTERVAL_1 = -123;
    private static final Integer INTERVAL_NULL = null;

    @Override
    Stream<BuiltInFunctionTestBase.TestSetSpec> getTestSetSpecs() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.MAP).onFieldsWithData(1, 2, 3, 4, new BigDecimal("1.2345"), new BigDecimal("1.2346"), true).andDataTypes(DataTypes.INT().notNull(), DataTypes.INT().notNull(), DataTypes.INT().notNull(), DataTypes.INT().notNull(), DataTypes.DECIMAL((int)10, (int)4).notNull(), DataTypes.DECIMAL((int)10, (int)4).notNull(), DataTypes.BOOLEAN().notNull()).testResult(MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f0"), (Object[])new Object[]{Expressions.$((String)"f0"), Expressions.$((String)"f1")}), "MAP[f0, f1]", Collections.singletonMap(1, 2), DataTypes.MAP((DataType)((DataType)DataTypes.INT().notNull()), (DataType)((DataType)DataTypes.INT().notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f4"), (Object)Expressions.$((String)"f5"), (Object[])new Object[0]), "MAP[f4, f5]", Collections.singletonMap(new BigDecimal("1.2345"), new BigDecimal("1.2346")), DataTypes.MAP((DataType)((DataType)DataTypes.DECIMAL((int)10, (int)4).notNull()), (DataType)((DataType)DataTypes.DECIMAL((int)10, (int)4).notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f0").plus((Object)Expressions.$((String)"f1")), (Object)Expressions.$((String)"f2").times((Object)Expressions.$((String)"f2")), (Object[])new Object[]{Expressions.$((String)"f2").minus((Object)Expressions.$((String)"f1")), Expressions.$((String)"f3").minus((Object)Expressions.$((String)"f0"))}), "MAP[f0 + f1, f2 * f2, f2 - f1, f3 - f0]", CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)3, (Object)9), CollectionUtil.entry((Object)1, (Object)3)}), DataTypes.MAP((DataType)((DataType)DataTypes.INT().notNull()), (DataType)((DataType)DataTypes.INT().notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1").cast((DataType)DataTypes.BIGINT().notNull()), (Object[])new Object[]{Expressions.$((String)"f2"), Expressions.$((String)"f3").cast((DataType)DataTypes.BIGINT().notNull())}), "MAP[f0, CAST(f1 AS BIGINT), f2, CAST(f3 AS BIGINT)]", CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)2L), CollectionUtil.entry((Object)3, (Object)4L)}), DataTypes.MAP((DataType)((DataType)DataTypes.INT().notNull()), (DataType)((DataType)DataTypes.BIGINT().notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f6"), (Object)Expressions.$((String)"f6"), (Object[])new Object[0]), "MAP[f6, f6]", Collections.singletonMap(true, true), DataTypes.MAP((DataType)((DataType)DataTypes.BOOLEAN().notNull()), (DataType)((DataType)DataTypes.BOOLEAN().notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1").cast((DataType)DataTypes.DOUBLE().notNull()), (Object[])new Object[]{Expressions.$((String)"f2"), Expressions.$((String)"f3").cast((DataType)DataTypes.FLOAT().notNull())}), "MAP[f0, CAST(f1 AS DOUBLE), f2, CAST(f3 AS FLOAT)]", CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)1, (Object)2.0), CollectionUtil.entry((Object)3, (Object)4.0)}), DataTypes.MAP((DataType)((DataType)DataTypes.INT().notNull()), (DataType)((DataType)DataTypes.DOUBLE().notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f4"), (Object)Expressions.$((String)"f5"), (Object[])new Object[0]), "MAP[f4, f5]", Collections.singletonMap(new BigDecimal("1.2345"), new BigDecimal("1.2346")), DataTypes.MAP((DataType)((DataType)DataTypes.DECIMAL((int)10, (int)4).notNull()), (DataType)((DataType)DataTypes.DECIMAL((int)10, (int)4).notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.map((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"), (Object[])new Object[0]), (Object)Expressions.map((Object)Expressions.$((String)"f2"), (Object)Expressions.$((String)"f3"), (Object[])new Object[0]), (Object[])new Object[0]), "MAP[MAP[f0, f1], MAP[f2, f3]]", Collections.singletonMap(Collections.singletonMap(1, 2), Collections.singletonMap(3, 4)), DataTypes.MAP((DataType)((DataType)DataTypes.MAP((DataType)((DataType)DataTypes.INT().notNull()), (DataType)((DataType)DataTypes.INT().notNull())).notNull()), (DataType)((DataType)DataTypes.MAP((DataType)((DataType)DataTypes.INT().notNull()), (DataType)((DataType)DataTypes.INT().notNull())).notNull())).notNull())), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.MAP).onFieldsWithData(TEST_DATE_1, TEST_DATE_2, TEST_TIME_1, TEST_TIME_2, TEST_DATE_TIME_1, TEST_DATE_TIME_2).andDataTypes(DataTypes.DATE().notNull(), DataTypes.DATE().notNull(), DataTypes.TIME().notNull(), DataTypes.TIME().notNull(), DataTypes.TIMESTAMP().notNull(), DataTypes.TIMESTAMP().notNull()).testResult(MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f2"), (Object[])new Object[]{Expressions.$((String)"f1"), Expressions.$((String)"f3")}), "MAP[f0, f2, f1, f3]", CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)TEST_DATE_1, (Object)TEST_TIME_1), CollectionUtil.entry((Object)TEST_DATE_2, (Object)TEST_TIME_2)}), DataTypes.MAP((DataType)((DataType)DataTypes.DATE().notNull()), (DataType)((DataType)DataTypes.TIME().notNull())).notNull()), MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f2"), (Object)Expressions.$((String)"f4"), (Object[])new Object[]{Expressions.$((String)"f3"), Expressions.$((String)"f5")}), "MAP[f2, f4, f3, f5]", CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)TEST_TIME_1, (Object)TEST_DATE_TIME_1), CollectionUtil.entry((Object)TEST_TIME_2, (Object)TEST_DATE_TIME_2)}), DataTypes.MAP((DataType)((DataType)DataTypes.TIME().notNull()), (DataType)((DataType)DataTypes.TIMESTAMP().notNull())).notNull())), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.MAP).onFieldsWithData(A, B, -123, INTERVAL_NULL).andDataTypes(new AbstractDataType[]{DataTypes.STRING().notNull(), DataTypes.STRING().notNull(), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).nullable()}).testResult(MapFunctionITCase.resultSpec((Expression)Expressions.map((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f2"), (Object[])new Object[]{Expressions.$((String)"f1"), Expressions.$((String)"f3")}), "MAP[f0, f2, f1, f3]", CollectionUtil.map((Map.Entry[])new Map.Entry[]{CollectionUtil.entry((Object)A, (Object)Period.ofMonths(-123)), CollectionUtil.entry((Object)B, (Object)INTERVAL_NULL)}), DataTypes.MAP((DataType)((DataType)DataTypes.STRING().notNull()), (DataType)((DataType)DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.MONTH()).nullable())).notNull())));
    }
}

