/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.JsonExistsOnError;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.BuiltInFunctionTestBase;
import org.apache.flink.table.types.AbstractDataType;

class TimeFunctionsITCase
extends BuiltInFunctionTestBase {
    TimeFunctionsITCase() {
    }

    @Override
    Stream<BuiltInFunctionTestBase.TestSetSpec> getTestSetSpecs() {
        return Stream.of(this.extractTestCases(), this.temporalOverlapsTestCases(), this.ceilTestCases(), this.floorTestCases()).flatMap(s -> s);
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> extractTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.EXTRACT).onFieldsWithData(LocalDateTime.of(2000, 1, 31, 11, 22, 33, 123456789), LocalDateTime.of(2020, 2, 29, 1, 56, 59, 987654321), null, LocalDate.of(1990, 10, 14), Instant.ofEpochMilli(100000012L), true).andDataTypes(new AbstractDataType[]{DataTypes.TIMESTAMP(), DataTypes.TIMESTAMP(), DataTypes.TIMESTAMP(), DataTypes.DATE(), DataTypes.TIMESTAMP_LTZ((int)3), DataTypes.BOOLEAN()}).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.NANOSECOND), "EXTRACT(NANOSECOND FROM f0)", 123456000L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.NANOSECOND), "EXTRACT(NANOSECOND FROM f1)", 987654000L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.NANOSECOND), "EXTRACT(NANOSECOND FROM f2)", null, DataTypes.BIGINT().nullable()).testSqlValidationError("EXTRACT(NANOSECOND FROM f3)", "NANOSECOND can not be applied").testResult((Expression)Expressions.$((String)"f4").extract(TimeIntervalUnit.NANOSECOND), "EXTRACT(NANOSECOND FROM f4)", 12000000L, (AbstractDataType<?>)DataTypes.BIGINT()).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.MICROSECOND), "EXTRACT(MICROSECOND FROM f0)", 123456L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.MICROSECOND), "EXTRACT(MICROSECOND FROM f1)", 987654L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.MICROSECOND), "EXTRACT(MICROSECOND FROM f2)", null, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.MILLISECOND), "EXTRACT(MILLISECOND FROM f0)", 123L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.MILLISECOND), "EXTRACT(MILLISECOND FROM f1)", 987L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.MILLISECOND), "EXTRACT(MILLISECOND FROM f2)", null, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f4").extract(TimeIntervalUnit.MILLISECOND), "EXTRACT(MILLISECOND FROM f4)", 12L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.SECOND), "EXTRACT(SECOND FROM f0)", 33L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.SECOND), "EXTRACT(SECOND FROM f1)", 59L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.SECOND), "EXTRACT(SECOND FROM f2)", null, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.MINUTE), "EXTRACT(MINUTE FROM f0)", 22L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.MINUTE), "EXTRACT(MINUTE FROM f1)", 56L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.MINUTE), "EXTRACT(MINUTE FROM f2)", null, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.HOUR), "EXTRACT(HOUR FROM f0)", 11L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.HOUR), "EXTRACT(HOUR FROM f1)", 1L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.HOUR), "EXTRACT(HOUR FROM f2)", null, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.DAY), "EXTRACT(DAY FROM f0)", 31L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.DAY), "EXTRACT(DAY FROM f1)", 29L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.DAY), "EXTRACT(DAY FROM f2)", null, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f3").extract(TimeIntervalUnit.DAY), "EXTRACT(DAY FROM f3)", 14L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.WEEK), "EXTRACT(WEEK FROM f0)", 5L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.WEEK), "EXTRACT(WEEK FROM f1)", 9L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.WEEK), "EXTRACT(WEEK FROM f2)", null, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.MONTH), "EXTRACT(MONTH FROM f0)", 1L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.MONTH), "EXTRACT(MONTH FROM f1)", 2L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.MONTH), "EXTRACT(MONTH FROM f2)", null, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.QUARTER), "EXTRACT(QUARTER FROM f0)", 1L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.QUARTER), "EXTRACT(QUARTER FROM f1)", 1L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.QUARTER), "EXTRACT(QUARTER FROM f2)", null, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.YEAR), "EXTRACT(YEAR FROM f0)", 2000L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.YEAR), "EXTRACT(YEAR FROM f1)", 2020L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.YEAR), "EXTRACT(YEAR FROM f2)", null, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.DECADE), "EXTRACT(DECADE FROM f0)", 200L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.DECADE), "EXTRACT(DECADE FROM f1)", 202L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.DECADE), "EXTRACT(DECADE FROM f2)", null, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.CENTURY), "EXTRACT(CENTURY FROM f0)", 20L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.CENTURY), "EXTRACT(CENTURY FROM f1)", 21L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.CENTURY), "EXTRACT(CENTURY FROM f2)", null, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f0").extract(TimeIntervalUnit.MILLENNIUM), "EXTRACT(MILLENNIUM FROM f0)", 2L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f1").extract(TimeIntervalUnit.MILLENNIUM), "EXTRACT(MILLENNIUM FROM f1)", 3L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.$((String)"f2").extract(TimeIntervalUnit.MILLENNIUM), "EXTRACT(MILLENNIUM FROM f2)", null, DataTypes.BIGINT().nullable()).testSqlResult("EXTRACT(DOW FROM f0)", 2L, DataTypes.BIGINT().nullable()).testSqlResult("EXTRACT(DOW FROM f1)", 7L, DataTypes.BIGINT().nullable()).testSqlResult("EXTRACT(DOW FROM f2)", null, DataTypes.BIGINT().nullable()).testSqlResult("EXTRACT(ISODOW FROM f0)", 1L, DataTypes.BIGINT().nullable()).testSqlResult("EXTRACT(ISODOW FROM f1)", 6L, DataTypes.BIGINT().nullable()).testSqlResult("EXTRACT(ISODOW FROM f2)", null, DataTypes.BIGINT().nullable()).testSqlResult("EXTRACT(DOY FROM f0)", 31L, DataTypes.BIGINT().nullable()).testSqlResult("EXTRACT(DOY FROM f1)", 60L, DataTypes.BIGINT().nullable()).testSqlResult("EXTRACT(DOY FROM f2)", null, DataTypes.BIGINT().nullable()).testSqlResult("EXTRACT(ISOYEAR FROM f0)", 2000L, DataTypes.BIGINT().nullable()).testSqlResult("EXTRACT(ISOYEAR FROM f1)", 2020L, DataTypes.BIGINT().nullable()).testSqlResult("EXTRACT(ISOYEAR FROM f2)", null, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.call((String)"EXTRACT", (Object[])new Object[]{TimeIntervalUnit.EPOCH, Expressions.$((String)"f0")}), "EXTRACT(EPOCH FROM f0)", 949317753L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.call((String)"EXTRACT", (Object[])new Object[]{TimeIntervalUnit.EPOCH, Expressions.$((String)"f1")}), "EXTRACT(EPOCH FROM f1)", 1582941419L, DataTypes.BIGINT().nullable()).testResult((Expression)Expressions.call((String)"EXTRACT", (Object[])new Object[]{TimeIntervalUnit.EPOCH, Expressions.$((String)"f2")}), "EXTRACT(EPOCH FROM f2)", null, DataTypes.BIGINT().nullable()).testTableApiValidationError((Expression)Expressions.call((String)"EXTRACT", (Object[])new Object[]{TimeIntervalUnit.EPOCH, Expressions.$((String)"f5")}), "EXTRACT requires 2nd argument to be a temporal type, but type is BOOLEAN").testTableApiValidationError((Expression)Expressions.call((String)"EXTRACT", (Object[])new Object[]{JsonExistsOnError.ERROR, Expressions.$((String)"f2")}), "EXTRACT requires 1st argument to be a TimeIntervalUnit literal"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> temporalOverlapsTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.TEMPORAL_OVERLAPS).onFieldsWithData(LocalTime.of(2, 55, 0), Duration.ofHours(1L), LocalTime.of(3, 30, 0), Duration.ofHours(2L)).andDataTypes(new AbstractDataType[]{DataTypes.TIME(), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.HOUR()), DataTypes.TIME(), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.HOUR())}).testResult((Expression)Expressions.temporalOverlaps((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f2"), (Object)Expressions.$((String)"f3")), "(f0, f1) OVERLAPS (f2, f3)", true, (AbstractDataType<?>)DataTypes.BOOLEAN()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.TEMPORAL_OVERLAPS).onFieldsWithData(LocalTime.of(9, 0, 0), LocalTime.of(9, 30, 0), LocalTime.of(9, 29, 0), LocalTime.of(9, 31, 0), LocalTime.of(10, 0, 0), LocalTime.of(10, 15, 0), Duration.ofHours(3L)).andDataTypes(new AbstractDataType[]{DataTypes.TIME(), DataTypes.TIME(), DataTypes.TIME(), DataTypes.TIME(), DataTypes.TIME(), DataTypes.TIME(), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.HOUR())}).testResult((Expression)Expressions.temporalOverlaps((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f2"), (Object)Expressions.$((String)"f3")), "(f0, f1) OVERLAPS (f2, f3)", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.temporalOverlaps((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f4"), (Object)Expressions.$((String)"f5"), (Object)Expressions.$((String)"f6")), "(f0, f4) OVERLAPS (f5, f6)", false, (AbstractDataType<?>)DataTypes.BOOLEAN()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.TEMPORAL_OVERLAPS).onFieldsWithData(LocalDate.of(2011, 3, 10), Duration.ofDays(10L), LocalDate.of(2011, 3, 19), Duration.ofDays(10L)).andDataTypes(new AbstractDataType[]{DataTypes.DATE(), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY()), DataTypes.DATE(), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.DAY())}).testResult((Expression)Expressions.temporalOverlaps((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f2"), (Object)Expressions.$((String)"f3")), "(f0, f1) OVERLAPS (f2, f3)", true, (AbstractDataType<?>)DataTypes.BOOLEAN()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.TEMPORAL_OVERLAPS).onFieldsWithData(LocalDateTime.of(2011, 3, 10, 5, 2, 2), Duration.ofSeconds(0L), LocalDateTime.of(2011, 3, 10, 5, 2, 2), LocalDateTime.of(2011, 3, 10, 5, 2, 1), LocalDateTime.of(2011, 3, 10, 5, 2, 2, 1000000), LocalDateTime.of(2011, 3, 10, 5, 2, 2, 2000000)).andDataTypes(new AbstractDataType[]{DataTypes.TIMESTAMP(), DataTypes.INTERVAL((DataTypes.Resolution)DataTypes.SECOND()), DataTypes.TIMESTAMP(), DataTypes.TIMESTAMP(), DataTypes.TIMESTAMP(), DataTypes.TIMESTAMP()}).testResult((Expression)Expressions.temporalOverlaps((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f2"), (Object)Expressions.$((String)"f3")), "(f0, f1) OVERLAPS (f2, f3)", true, (AbstractDataType<?>)DataTypes.BOOLEAN()).testResult((Expression)Expressions.temporalOverlaps((Object)Expressions.$((String)"f4"), (Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f5"), (Object)Expressions.$((String)"f5")), "(f4, f1) OVERLAPS (f5, f5)", false, (AbstractDataType<?>)DataTypes.BOOLEAN()), BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.TEMPORAL_OVERLAPS).onFieldsWithData(1, LocalDateTime.of(2011, 3, 10, 5, 2, 2), LocalDate.of(2011, 3, 10)).andDataTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.TIMESTAMP(), DataTypes.DATE()}).testTableApiValidationError((Expression)Expressions.temporalOverlaps((Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f1")), "TEMPORAL_OVERLAPS requires 1st argument 'leftTimePoint' to be a DATETIME type, but is INT").testTableApiValidationError((Expression)Expressions.temporalOverlaps((Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1")), "TEMPORAL_OVERLAPS requires 3rd argument 'rightTimePoint' to be a DATETIME type, but is INT").testTableApiValidationError((Expression)Expressions.temporalOverlaps((Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f2"), (Object)Expressions.$((String)"f2")), "TEMPORAL_OVERLAPS requires 'leftTimePoint' and 'rightTimePoint' arguments to be of the same type, but is TIMESTAMP(6) != DATE").testTableApiValidationError((Expression)Expressions.temporalOverlaps((Object)Expressions.$((String)"f2"), (Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f2"), (Object)Expressions.$((String)"f2")), "TEMPORAL_OVERLAPS requires 'leftTemporal' and 'leftTimePoint' arguments to be of the same type if 'leftTemporal' is a DATETIME, but is TIMESTAMP(6) != DATE").testTableApiValidationError((Expression)Expressions.temporalOverlaps((Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f0"), (Object)Expressions.$((String)"f1"), (Object)Expressions.$((String)"f0")), "TEMPORAL_OVERLAPS requires 2nd argument 'leftTemporal' to be DATETIME or INTERVAL type, but is INT"));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> ceilTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.FLOOR).onFieldsWithData(LocalTime.of(11, 22, 33), LocalDate.of(1990, 10, 14), LocalDateTime.of(2020, 2, 29, 1, 56, 59, 987654321)).andDataTypes(new AbstractDataType[]{DataTypes.TIME(), DataTypes.DATE(), DataTypes.TIMESTAMP()}).testResult((Expression)Expressions.$((String)"f0").ceil(TimeIntervalUnit.MILLISECOND), "CEIL(f0 TO MILLISECOND)", LocalTime.of(11, 22, 33), DataTypes.TIME().nullable()).testResult((Expression)Expressions.$((String)"f1").ceil(TimeIntervalUnit.MILLISECOND), "CEIL(f1 TO MILLISECOND)", LocalDate.of(1990, 10, 14), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").ceil(TimeIntervalUnit.MILLISECOND), "CEIL(f2 TO MILLISECOND)", LocalDateTime.of(2020, 2, 29, 1, 56, 59, 988000000), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f0").ceil(TimeIntervalUnit.SECOND), "CEIL(f0 TO SECOND)", LocalTime.of(11, 22, 33), DataTypes.TIME().nullable()).testResult((Expression)Expressions.$((String)"f1").ceil(TimeIntervalUnit.SECOND), "CEIL(f1 TO SECOND)", LocalDate.of(1990, 10, 14), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").ceil(TimeIntervalUnit.SECOND), "CEIL(f2 TO SECOND)", LocalDateTime.of(2020, 2, 29, 1, 57), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f0").ceil(TimeIntervalUnit.MINUTE), "CEIL(f0 TO MINUTE)", LocalTime.of(11, 23), DataTypes.TIME().nullable()).testResult((Expression)Expressions.$((String)"f1").ceil(TimeIntervalUnit.MINUTE), "CEIL(f1 TO MINUTE)", LocalDate.of(1990, 10, 14), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").ceil(TimeIntervalUnit.MINUTE), "CEIL(f2 TO MINUTE)", LocalDateTime.of(2020, 2, 29, 1, 57), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f0").ceil(TimeIntervalUnit.HOUR), "CEIL(f0 TO HOUR)", LocalTime.of(12, 0), DataTypes.TIME().nullable()).testResult((Expression)Expressions.$((String)"f1").ceil(TimeIntervalUnit.HOUR), "CEIL(f1 TO HOUR)", LocalDate.of(1990, 10, 14), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").ceil(TimeIntervalUnit.HOUR), "CEIL(f2 TO HOUR)", LocalDateTime.of(2020, 2, 29, 2, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").ceil(TimeIntervalUnit.DAY), "CEIL(f1 TO DAY)", LocalDate.of(1990, 10, 15), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").ceil(TimeIntervalUnit.DAY), "CEIL(f2 TO DAY)", LocalDateTime.of(2020, 3, 1, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").ceil(TimeIntervalUnit.WEEK), "CEIL(f1 TO WEEK)", LocalDate.of(1990, 10, 14), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").ceil(TimeIntervalUnit.WEEK), "CEIL(f2 TO WEEK)", LocalDateTime.of(2020, 3, 1, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").ceil(TimeIntervalUnit.MONTH), "CEIL(f1 TO MONTH)", LocalDate.of(1990, 11, 1), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").ceil(TimeIntervalUnit.MONTH), "CEIL(f2 TO MONTH)", LocalDateTime.of(2020, 3, 1, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").ceil(TimeIntervalUnit.QUARTER), "CEIL(f1 TO QUARTER)", LocalDate.of(1991, 1, 1), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").ceil(TimeIntervalUnit.QUARTER), "CEIL(f2 TO QUARTER)", LocalDateTime.of(2020, 4, 1, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").ceil(TimeIntervalUnit.YEAR), "CEIL(f1 TO YEAR)", LocalDate.of(1991, 1, 1), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").ceil(TimeIntervalUnit.YEAR), "CEIL(f2 TO YEAR)", LocalDateTime.of(2021, 1, 1, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").ceil(TimeIntervalUnit.DECADE), "CEIL(f1 TO DECADE)", LocalDate.of(2000, 1, 1), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").ceil(TimeIntervalUnit.DECADE), "CEIL(f2 TO DECADE)", LocalDateTime.of(2030, 1, 1, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").ceil(TimeIntervalUnit.CENTURY), "CEIL(f1 TO CENTURY)", LocalDate.of(2001, 1, 1), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").ceil(TimeIntervalUnit.CENTURY), "CEIL(f2 TO CENTURY)", LocalDateTime.of(2101, 1, 1, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").ceil(TimeIntervalUnit.MILLENNIUM), "CEIL(f1 TO MILLENNIUM)", LocalDate.of(2001, 1, 1), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").ceil(TimeIntervalUnit.MILLENNIUM), "CEIL(f2 TO MILLENNIUM)", LocalDateTime.of(3001, 1, 1, 0, 0), DataTypes.TIMESTAMP().nullable()));
    }

    private Stream<BuiltInFunctionTestBase.TestSetSpec> floorTestCases() {
        return Stream.of(BuiltInFunctionTestBase.TestSetSpec.forFunction(BuiltInFunctionDefinitions.FLOOR).onFieldsWithData(LocalTime.of(11, 22, 33), LocalDate.of(1990, 10, 14), LocalDateTime.of(2020, 2, 29, 1, 56, 59, 987654321)).andDataTypes(new AbstractDataType[]{DataTypes.TIME(), DataTypes.DATE(), DataTypes.TIMESTAMP()}).testResult((Expression)Expressions.$((String)"f0").floor(TimeIntervalUnit.MILLISECOND), "FLOOR(f0 TO MILLISECOND)", LocalTime.of(11, 22, 33), DataTypes.TIME().nullable()).testResult((Expression)Expressions.$((String)"f1").floor(TimeIntervalUnit.MILLISECOND), "FLOOR(f1 TO MILLISECOND)", LocalDate.of(1990, 10, 14), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").floor(TimeIntervalUnit.MILLISECOND), "FLOOR(f2 TO MILLISECOND)", LocalDateTime.of(2020, 2, 29, 1, 56, 59, 987000000), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f0").floor(TimeIntervalUnit.SECOND), "FLOOR(f0 TO SECOND)", LocalTime.of(11, 22, 33), DataTypes.TIME().nullable()).testResult((Expression)Expressions.$((String)"f1").floor(TimeIntervalUnit.SECOND), "FLOOR(f1 TO SECOND)", LocalDate.of(1990, 10, 14), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").floor(TimeIntervalUnit.SECOND), "FLOOR(f2 TO SECOND)", LocalDateTime.of(2020, 2, 29, 1, 56, 59), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f0").floor(TimeIntervalUnit.MINUTE), "FLOOR(f0 TO MINUTE)", LocalTime.of(11, 22), DataTypes.TIME().nullable()).testResult((Expression)Expressions.$((String)"f1").floor(TimeIntervalUnit.MINUTE), "FLOOR(f1 TO MINUTE)", LocalDate.of(1990, 10, 14), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").floor(TimeIntervalUnit.MINUTE), "FLOOR(f2 TO MINUTE)", LocalDateTime.of(2020, 2, 29, 1, 56), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f0").floor(TimeIntervalUnit.HOUR), "FLOOR(f0 TO HOUR)", LocalTime.of(11, 0), DataTypes.TIME().nullable()).testResult((Expression)Expressions.$((String)"f1").floor(TimeIntervalUnit.HOUR), "FLOOR(f1 TO HOUR)", LocalDate.of(1990, 10, 14), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").floor(TimeIntervalUnit.HOUR), "FLOOR(f2 TO HOUR)", LocalDateTime.of(2020, 2, 29, 1, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").floor(TimeIntervalUnit.DAY), "FLOOR(f1 TO DAY)", LocalDate.of(1990, 10, 14), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").floor(TimeIntervalUnit.DAY), "FLOOR(f2 TO DAY)", LocalDateTime.of(2020, 2, 29, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").floor(TimeIntervalUnit.WEEK), "FLOOR(f1 TO WEEK)", LocalDate.of(1990, 10, 14), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").floor(TimeIntervalUnit.WEEK), "FLOOR(f2 TO WEEK)", LocalDateTime.of(2020, 2, 23, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").floor(TimeIntervalUnit.MONTH), "FLOOR(f1 TO MONTH)", LocalDate.of(1990, 10, 1), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").floor(TimeIntervalUnit.MONTH), "FLOOR(f2 TO MONTH)", LocalDateTime.of(2020, 2, 1, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").floor(TimeIntervalUnit.QUARTER), "FLOOR(f1 TO QUARTER)", LocalDate.of(1990, 10, 1), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").floor(TimeIntervalUnit.QUARTER), "FLOOR(f2 TO QUARTER)", LocalDateTime.of(2020, 1, 1, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").floor(TimeIntervalUnit.YEAR), "FLOOR(f1 TO YEAR)", LocalDate.of(1990, 1, 1), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").floor(TimeIntervalUnit.YEAR), "FLOOR(f2 TO YEAR)", LocalDateTime.of(2020, 1, 1, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").floor(TimeIntervalUnit.DECADE), "FLOOR(f1 TO DECADE)", LocalDate.of(1990, 1, 1), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").floor(TimeIntervalUnit.DECADE), "FLOOR(f2 TO DECADE)", LocalDateTime.of(2020, 1, 1, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").floor(TimeIntervalUnit.CENTURY), "FLOOR(f1 TO CENTURY)", LocalDate.of(1901, 1, 1), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").floor(TimeIntervalUnit.CENTURY), "FLOOR(f2 TO CENTURY)", LocalDateTime.of(2001, 1, 1, 0, 0), DataTypes.TIMESTAMP().nullable()).testResult((Expression)Expressions.$((String)"f1").floor(TimeIntervalUnit.MILLENNIUM), "FLOOR(f1 TO MILLENNIUM)", LocalDate.of(1001, 1, 1), DataTypes.DATE().nullable()).testResult((Expression)Expressions.$((String)"f2").floor(TimeIntervalUnit.MILLENNIUM), "FLOOR(f2 TO MILLENNIUM)", LocalDateTime.of(2001, 1, 1, 0, 0), DataTypes.TIMESTAMP().nullable()));
    }
}

