/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.planner.functions.aggfunctions.AggFunctionTestBase;
import org.apache.flink.table.runtime.functions.aggregate.FirstValueAggFunction;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public final class FirstValueAggFunctionWithoutOrderTest {

    public static abstract class NumberFirstValueAggFunctionWithoutOrderTest<T>
    extends FirstValueAggFunctionWithoutOrderTestBase<T> {
        protected abstract T getValue(String var1);

        @Override
        protected List<List<T>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(this.getValue("1"), null, this.getValue("-99"), this.getValue("3"), null), Arrays.asList(null, null, null, null), Arrays.asList(null, this.getValue("10"), null, this.getValue("3")));
        }

        @Override
        protected List<T> getExpectedResults() {
            return Arrays.asList(this.getValue("1"), null, this.getValue("10"));
        }
    }

    public static abstract class FirstValueAggFunctionWithoutOrderTestBase<T>
    extends AggFunctionTestBase<T, T, RowData> {
        @Override
        protected Class<?> getAccClass() {
            return RowData.class;
        }
    }

    public static final class StringFirstValueAggFunctionWithoutOrderTest
    extends FirstValueAggFunctionWithoutOrderTestBase<StringData> {
        @Override
        protected List<List<StringData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(StringData.fromString((String)"abc"), StringData.fromString((String)"def"), StringData.fromString((String)"ghi"), null, StringData.fromString((String)"jkl"), null, StringData.fromString((String)"zzz")), Arrays.asList(null, null), Arrays.asList(null, StringData.fromString((String)"a")), Arrays.asList(StringData.fromString((String)"x"), null, StringData.fromString((String)"e")));
        }

        @Override
        protected List<StringData> getExpectedResults() {
            return Arrays.asList(StringData.fromString((String)"abc"), null, StringData.fromString((String)"a"), StringData.fromString((String)"x"));
        }

        @Override
        protected AggregateFunction<StringData, RowData> getAggregator() {
            return new FirstValueAggFunction(DataTypes.STRING().getLogicalType());
        }
    }

    public static final class DecimalFirstValueAggFunctionWithoutOrderTest
    extends FirstValueAggFunctionWithoutOrderTestBase<DecimalData> {
        private int precision = 20;
        private int scale = 6;

        @Override
        protected List<List<DecimalData>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(DecimalDataUtils.castFrom((String)"1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"1000.000001", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-1", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.998999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale), DecimalDataUtils.castFrom((String)"-999.999", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"999.999", (int)this.precision, (int)this.scale)), Arrays.asList(null, null, null, null, null), Arrays.asList(null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale)));
        }

        @Override
        protected List<DecimalData> getExpectedResults() {
            return Arrays.asList(DecimalDataUtils.castFrom((String)"1", (int)this.precision, (int)this.scale), null, DecimalDataUtils.castFrom((String)"0", (int)this.precision, (int)this.scale));
        }

        @Override
        protected AggregateFunction<DecimalData, RowData> getAggregator() {
            return new FirstValueAggFunction(DataTypes.DECIMAL((int)this.precision, (int)this.scale).getLogicalType());
        }
    }

    public static final class BooleanFirstValueAggFunctionWithoutOrderTest
    extends FirstValueAggFunctionWithoutOrderTestBase<Boolean> {
        @Override
        protected List<List<Boolean>> getInputValueSets() {
            return Arrays.asList(Arrays.asList(false, false, false), Arrays.asList(true, true, true), Arrays.asList(true, false, null, true, false, true, null), Arrays.asList(null, null, null), Arrays.asList(null, true));
        }

        @Override
        protected List<Boolean> getExpectedResults() {
            return Arrays.asList(false, true, true, null, true);
        }

        @Override
        protected AggregateFunction<Boolean, RowData> getAggregator() {
            return new FirstValueAggFunction(DataTypes.BOOLEAN().getLogicalType());
        }
    }

    public static final class DoubleFirstValueAggFunctionWithoutOrderTest
    extends NumberFirstValueAggFunctionWithoutOrderTest<Double> {
        @Override
        protected Double getValue(String v) {
            return Double.valueOf(v);
        }

        @Override
        protected AggregateFunction<Double, RowData> getAggregator() {
            return new FirstValueAggFunction(DataTypes.DOUBLE().getLogicalType());
        }
    }

    public static final class FloatFirstValueAggFunctionWithoutOrderTest
    extends NumberFirstValueAggFunctionWithoutOrderTest<Float> {
        @Override
        protected Float getValue(String v) {
            return Float.valueOf(v);
        }

        @Override
        protected AggregateFunction<Float, RowData> getAggregator() {
            return new FirstValueAggFunction(DataTypes.FLOAT().getLogicalType());
        }
    }

    public static final class LongFirstValueAggFunctionWithoutOrderTest
    extends NumberFirstValueAggFunctionWithoutOrderTest<Long> {
        @Override
        protected Long getValue(String v) {
            return Long.valueOf(v);
        }

        @Override
        protected AggregateFunction<Long, RowData> getAggregator() {
            return new FirstValueAggFunction(DataTypes.BIGINT().getLogicalType());
        }
    }

    public static final class IntFirstValueAggFunctionWithoutOrderTest
    extends NumberFirstValueAggFunctionWithoutOrderTest<Integer> {
        @Override
        protected Integer getValue(String v) {
            return Integer.valueOf(v);
        }

        @Override
        protected AggregateFunction<Integer, RowData> getAggregator() {
            return new FirstValueAggFunction(DataTypes.INT().getLogicalType());
        }
    }

    public static final class ShortFirstValueAggFunctionWithoutOrderTest
    extends NumberFirstValueAggFunctionWithoutOrderTest<Short> {
        @Override
        protected Short getValue(String v) {
            return Short.valueOf(v);
        }

        @Override
        protected AggregateFunction<Short, RowData> getAggregator() {
            return new FirstValueAggFunction(DataTypes.SMALLINT().getLogicalType());
        }
    }

    public static final class ByteFirstValueAggFunctionWithoutOrderTest
    extends NumberFirstValueAggFunctionWithoutOrderTest<Byte> {
        @Override
        protected Byte getValue(String v) {
            return Byte.valueOf(v);
        }

        @Override
        protected AggregateFunction<Byte, RowData> getAggregator() {
            return new FirstValueAggFunction(DataTypes.TINYINT().getLogicalType());
        }
    }
}

