/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.sql.parser.dql.SqlRichExplain;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.BeginStatementSetOperation;
import org.apache.flink.table.operations.DeleteFromFilterOperation;
import org.apache.flink.table.operations.EndStatementSetOperation;
import org.apache.flink.table.operations.ExplainOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SinkModifyOperation;
import org.apache.flink.table.operations.StatementSetOperation;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.operations.SqlToOperationConverter;
import org.apache.flink.table.planner.operations.SqlToOperationConverterTestBase;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

public class SqlDmlToOperationConverterTest
extends SqlToOperationConverterTestBase {
    @Test
    public void testExplainWithSelect() {
        String sql = "explain select * from t1";
        this.checkExplainSql("explain select * from t1");
    }

    @Test
    public void testExplainWithInsert() {
        String sql = "explain insert into t2 select * from t1";
        this.checkExplainSql("explain insert into t2 select * from t1");
    }

    @Test
    public void testExplainWithUnion() {
        String sql = "explain select * from t1 union select * from t2";
        this.checkExplainSql("explain select * from t1 union select * from t2");
    }

    @Test
    public void testExplainWithExplainDetails() {
        String sql = "explain changelog_mode, estimated_cost, json_execution_plan select * from t1";
        this.checkExplainSql(sql);
    }

    @Test
    public void testSqlInsertWithStaticPartition() {
        String sql = "insert into t1 partition(a=1) select b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("insert into t1 partition(a=1) select b, c, d from t2", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(SinkModifyOperation.class);
        SinkModifyOperation sinkModifyOperation = (SinkModifyOperation)operation;
        HashMap<String, String> expectedStaticPartitions = new HashMap<String, String>();
        expectedStaticPartitions.put("a", "1");
        Assertions.assertThat((Map)sinkModifyOperation.getStaticPartitions()).isEqualTo(expectedStaticPartitions);
    }

    @Test
    public void testSqlInsertWithDynamicTableOptions() {
        String sql = "insert into t1 /*+ OPTIONS('k1'='v1', 'k2'='v2') */\nselect a, b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("insert into t1 /*+ OPTIONS('k1'='v1', 'k2'='v2') */\nselect a, b, c, d from t2", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(SinkModifyOperation.class);
        SinkModifyOperation sinkModifyOperation = (SinkModifyOperation)operation;
        Map dynamicOptions = sinkModifyOperation.getDynamicOptions();
        Assertions.assertThat((Map)dynamicOptions).isNotNull();
        Assertions.assertThat((int)dynamicOptions.size()).isEqualTo(2);
        Assertions.assertThat((String)dynamicOptions.toString()).isEqualTo("{k1=v1, k2=v2}");
    }

    @Test
    public void testDynamicTableWithInvalidOptions() {
        String sql = "select * from t1 /*+ OPTIONS('opt1', 'opt2') */";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.parse("select * from t1 /*+ OPTIONS('opt1', 'opt2') */", planner, parser)).isInstanceOf(AssertionError.class)).hasMessageContaining("Hint [OPTIONS] only support non empty key value options");
    }

    @Test
    public void testBeginStatementSet() {
        String sql = "BEGIN STATEMENT SET";
        Operation operation = this.parse("BEGIN STATEMENT SET");
        Assertions.assertThat((Object)operation).isInstanceOf(BeginStatementSetOperation.class);
        BeginStatementSetOperation beginStatementSetOperation = (BeginStatementSetOperation)operation;
        Assertions.assertThat((String)beginStatementSetOperation.asSummaryString()).isEqualTo("BEGIN STATEMENT SET");
    }

    @Test
    public void testEnd() {
        String sql = "END";
        Operation operation = this.parse("END");
        Assertions.assertThat((Object)operation).isInstanceOf(EndStatementSetOperation.class);
        EndStatementSetOperation endStatementSetOperation = (EndStatementSetOperation)operation;
        Assertions.assertThat((String)endStatementSetOperation.asSummaryString()).isEqualTo("END");
    }

    @Test
    public void testSqlRichExplainWithSelect() {
        String sql = "explain plan for select a, b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("explain plan for select a, b, c, d from t2", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(ExplainOperation.class);
    }

    @Test
    public void testSqlRichExplainWithInsert() {
        String sql = "explain plan for insert into t1 select a, b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("explain plan for insert into t1 select a, b, c, d from t2", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(ExplainOperation.class);
    }

    @Test
    public void testSqlRichExplainWithStatementSet() {
        String sql = "explain plan for statement set begin insert into t1 select a, b, c, d from t2 where a > 1;insert into t1 select a, b, c, d from t2 where a > 2;end";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("explain plan for statement set begin insert into t1 select a, b, c, d from t2 where a > 1;insert into t1 select a, b, c, d from t2 where a > 2;end", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(ExplainOperation.class);
    }

    @Test
    public void testExplainDetailsWithSelect() {
        String sql = "explain estimated_cost, changelog_mode, plan_advice select a, b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        this.assertExplainDetails(this.parse("explain estimated_cost, changelog_mode, plan_advice select a, b, c, d from t2", planner, parser));
    }

    @Test
    public void testExplainDetailsWithInsert() {
        String sql = "explain estimated_cost, changelog_mode, plan_advice insert into t1 select a, b, c, d from t2";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        this.assertExplainDetails(this.parse("explain estimated_cost, changelog_mode, plan_advice insert into t1 select a, b, c, d from t2", planner, parser));
    }

    @Test
    public void testExplainDetailsWithStatementSet() {
        String sql = "explain estimated_cost, changelog_mode, plan_advice statement set begin insert into t1 select a, b, c, d from t2 where a > 1;insert into t1 select a, b, c, d from t2 where a > 2;end";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        this.assertExplainDetails(this.parse("explain estimated_cost, changelog_mode, plan_advice statement set begin insert into t1 select a, b, c, d from t2 where a > 1;insert into t1 select a, b, c, d from t2 where a > 2;end", planner, parser));
    }

    private void assertExplainDetails(Operation operation) {
        HashSet<String> expectedDetail = new HashSet<String>();
        expectedDetail.add(ExplainDetail.ESTIMATED_COST.toString());
        expectedDetail.add(ExplainDetail.CHANGELOG_MODE.toString());
        expectedDetail.add(ExplainDetail.PLAN_ADVICE.toString());
        ((ObjectAssert)Assertions.assertThat((Object)operation).asInstanceOf(InstanceOfAssertFactories.type(ExplainOperation.class))).satisfies(new ThrowingConsumer[]{explain -> {
            AbstractCollectionAssert cfr_ignored_0 = (AbstractCollectionAssert)Assertions.assertThat((Collection)explain.getExplainDetails()).isEqualTo((Object)expectedDetail);
        }});
    }

    @Test
    public void testSqlExecuteWithStatementSet() {
        String sql = "execute statement set begin insert into t1 select a, b, c, d from t2 where a > 1;insert into t1 select a, b, c, d from t2 where a > 2;end";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("execute statement set begin insert into t1 select a, b, c, d from t2 where a > 1;insert into t1 select a, b, c, d from t2 where a > 2;end", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(StatementSetOperation.class);
    }

    @Test
    public void testSqlExecuteWithInsert() {
        String sql = "execute insert into t1 select a, b, c, d from t2 where a > 1";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("execute insert into t1 select a, b, c, d from t2 where a > 1", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(SinkModifyOperation.class);
    }

    @Test
    public void testSqlExecuteWithSelect() {
        String sql = "execute select a, b, c, d from t2 where a > 1";
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        Operation operation = this.parse("execute select a, b, c, d from t2 where a > 1", planner, parser);
        Assertions.assertThat((Object)operation).isInstanceOf(QueryOperation.class);
    }

    @Test
    public void testDelete() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "test-update-delete");
        CatalogTable catalogTable = CatalogTable.of((Schema)Schema.newBuilder().column("a", DataTypes.INT().notNull()).column("c", DataTypes.STRING().notNull()).build(), null, Collections.emptyList(), options);
        ObjectIdentifier tableIdentifier = ObjectIdentifier.of((String)"builtin", (String)"default", (String)"test_delete");
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, tableIdentifier, false);
        Operation operation = this.parse("DELETE FROM test_delete");
        SqlDmlToOperationConverterTest.checkDeleteFromFilterOperation(operation, "[]");
        operation = this.parse("DELETE FROM test_delete where a = 1 and c = '123'");
        SqlDmlToOperationConverterTest.checkDeleteFromFilterOperation(operation, "[equals(a, 1), equals(c, '123')]");
        operation = this.parse("DELETE FROM test_delete where a = 1 + 6 and a = 2");
        SqlDmlToOperationConverterTest.checkDeleteFromFilterOperation(operation, "[false]");
        operation = this.parse("DELETE FROM test_delete where a = (select count(*) from test_delete)");
        Assertions.assertThat((Object)operation).isInstanceOf(SinkModifyOperation.class);
        SinkModifyOperation modifyOperation = (SinkModifyOperation)operation;
        Assertions.assertThat((boolean)modifyOperation.isDelete()).isTrue();
    }

    @Test
    public void testUpdate() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "test-update-delete");
        CatalogTable catalogTable = CatalogTable.of((Schema)Schema.newBuilder().column("a", DataTypes.INT().notNull()).column("b", DataTypes.BIGINT().nullable()).column("c", DataTypes.STRING().notNull()).build(), null, Collections.emptyList(), options);
        ObjectIdentifier tableIdentifier = ObjectIdentifier.of((String)"builtin", (String)"default", (String)"test_update");
        this.catalogManager.createTable((CatalogBaseTable)catalogTable, tableIdentifier, false);
        Operation operation = this.parse("UPDATE test_update SET a = 1, c = '123'");
        SqlDmlToOperationConverterTest.checkUpdateOperation(operation);
        operation = this.parse("UPDATE test_update SET a = 1, c = '123' WHERE a = 3");
        SqlDmlToOperationConverterTest.checkUpdateOperation(operation);
        operation = this.parse("UPDATE test_update SET a = 1, c = '123' WHERE b = 2 and a = (select count(*) from test_update)");
        SqlDmlToOperationConverterTest.checkUpdateOperation(operation);
    }

    private void checkExplainSql(String sql) {
        FlinkPlannerImpl planner = this.getPlannerBySqlDialect(SqlDialect.DEFAULT);
        CalciteParser parser = this.getParserBySqlDialect(SqlDialect.DEFAULT);
        SqlNode node = parser.parse(sql);
        Assertions.assertThat((Object)node).isInstanceOf(SqlRichExplain.class);
        Operation operation = (Operation)SqlToOperationConverter.convert((FlinkPlannerImpl)planner, (CatalogManager)this.catalogManager, (SqlNode)node).get();
        Assertions.assertThat((Object)operation).isInstanceOf(ExplainOperation.class);
    }

    private static void checkDeleteFromFilterOperation(Operation operation, String expectedFilters) {
        Assertions.assertThat((Object)operation).isInstanceOf(DeleteFromFilterOperation.class);
        DeleteFromFilterOperation deleteFromFiltersOperation = (DeleteFromFilterOperation)operation;
        List filters = deleteFromFiltersOperation.getFilters();
        Assertions.assertThat((String)filters.toString()).isEqualTo(expectedFilters);
    }

    private static void checkUpdateOperation(Operation operation) {
        Assertions.assertThat((Object)operation).isInstanceOf(SinkModifyOperation.class);
        SinkModifyOperation sinkModifyOperation = (SinkModifyOperation)operation;
        Assertions.assertThat((boolean)sinkModifyOperation.isUpdate()).isTrue();
    }
}

