/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.CalcTest$;
import org.apache.flink.table.planner.plan.utils.MyPojo;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0001\u0003\u0001M\u0011\u0001bQ1mGR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003cCR\u001c\u0007N\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\tU$\u0018\u000e\\\u000b\u0002EA\u0011QcI\u0005\u0003IY\u0011!CQ1uG\"$\u0016M\u00197f)\u0016\u001cH/\u0016;jY\"1a\u0005\u0001Q\u0001\n\t\nQ!\u001e;jY\u0002BQ\u0001\u000b\u0001\u0005\u0002%\nQa]3ukB$\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0005+:LG\u000f\u000b\u0002(cA\u0011!'N\u0007\u0002g)\u0011A\u0007E\u0001\u0006UVt\u0017\u000e^\u0005\u0003mM\u0012aAQ3g_J,\u0007\"\u0002\u001d\u0001\t\u0003I\u0013a\u0004;fgR|e\u000e\\=Qe>TWm\u0019;)\u0005]R\u0004C\u0001\u001a<\u0013\ta4G\u0001\u0003UKN$\b\"\u0002 \u0001\t\u0003I\u0013!\u0006;fgR\u0004&o\u001c6fGR<\u0016\u000e\u001e5OC6Lgn\u001a\u0015\u0003{iBQ!\u0011\u0001\u0005\u0002%\n\u0011\u0003^3ti6+H\u000e^5Qe>TWm\u0019;tQ\t\u0001%\bC\u0003E\u0001\u0011\u0005\u0011&\u0001\buKN$xJ\u001c7z\r&dG/\u001a:)\u0005\rS\u0004\"B$\u0001\t\u0003I\u0013!\u0006;fgR$\u0015n\u001d6v]\u000e$\u0018N^3GS2$XM\u001d\u0015\u0003\rjBQA\u0013\u0001\u0005\u0002%\nQ\u0003^3ti\u000e{gN[;oGRLg/\u001a$jYR,'\u000f\u000b\u0002Ju!)Q\n\u0001C\u0001S\u0005\u0001B/Z:u\u001bVdG/\u001b$jYR,'o\u001d\u0015\u0003\u0019jBQ\u0001\u0015\u0001\u0005\u0002%\nA\u0003^3tiB\u0013xN[3di\u0006sGMR5mi\u0016\u0014\bFA(;\u0011\u0015\u0019\u0006\u0001\"\u0001*\u0003\u0019!Xm\u001d;J]\"\u0012!K\u000f\u0005\u0006-\u0002!\t!K\u0001\u0018i\u0016\u001cH/\u00138O_:\u001cuN\\:uC:$h+\u00197vKND#!\u0016\u001e\t\u000be\u0003A\u0011A\u0015\u0002\u0013Q,7\u000f\u001e(pi&s\u0007F\u0001-;\u0011\u0015a\u0006\u0001\"\u0001*\u0003Y!Xm\u001d;Nk2$\u0018\u000e\u001d7f\r2\fG\u000f^3oS:<\u0007FA.;\u0011\u0015y\u0006\u0001\"\u0001*\u0003E!Xm\u001d;J]Z\fG.\u001b3GS\u0016dGm\u001d\u0015\u0005=j\n'-\u0001\u0005fqB,7\r^3eG\u0005\u0019\u0007C\u00013h\u001b\u0005)'B\u00014\u000b\u0003\r\t\u0007/[\u0005\u0003Q\u0016\u00141CV1mS\u0012\fG/[8o\u000bb\u001cW\r\u001d;j_:DQA\u001b\u0001\u0005\u0002%\nA\u0003^3tiB\u0013\u0018.\\5uSZ,W*\u00199UsB,\u0007FA5;\u0011\u0015i\u0007\u0001\"\u0001*\u0003]!Xm\u001d;O_:\u0004&/[7ji&4X-T1q)f\u0004X\r\u000b\u0002mu!)\u0001\u000f\u0001C\u0001S\u0005YA/Z:u%><H+\u001f9fQ\ty'\bC\u0003t\u0001\u0011\u0005\u0011&A\u0007uKN$\u0018I\u001d:bsRK\b/\u001a\u0015\u0003ejBQA\u001e\u0001\u0005\u0002%\nq\u0003^3tiB\u0013xN[3di^KG\u000f\u001b#bi\u0016$\u0016\u0010]3)\u0005UT\u0004\"B=\u0001\t\u0003I\u0013A\u0006;fgR4\u0015\u000e\u001c;fe^KG\u000f\u001b#bi\u0016$\u0016\u0010]3)\u0005aT\u0004\"\u0002?\u0001\t\u0003I\u0013\u0001\u0004;fgR\u0004vN[8UsB,\u0007FA>;\u0011\u0015y\b\u0001\"\u0001*\u00035!Xm\u001d;NSb,G\rV=qK\"\u0012aP\u000f\u0005\u0007\u0003\u000b\u0001A\u0011A\u0015\u00023Q,7\u000f^\"pY2\fG/[8o\t\u0016\u0014\u0018N^3P]\u000e\u000bGn\u0019\u0015\u0004\u0003\u0007Q\u0004BBA\u0006\u0001\u0011\u0005\u0011&A\ruKN$xJ],ji\"L5OT;mYB\u0013X\rZ5dCR,\u0007fAA\u0005u!1\u0011\u0011\u0003\u0001\u0005\u0002%\nA\u0003^3ti>\u0013x+\u001b;i\u0013NtU\u000f\u001c7J]&3\u0007fAA\bu!1\u0011q\u0003\u0001\u0005\u0002%\na\u0005^3ti\u0012+7-[7bY\u0006\u0013(/Y=XSRDG)\u001b4gKJ,g\u000e\u001e)sK\u000eL7/[8oQ\r\t)B\u000f\u0005\u0007\u0003;\u0001A\u0011A\u0015\u0002IQ,7\u000f\u001e#fG&l\u0017\r\\'ba^KG\u000f\u001b#jM\u001a,'/\u001a8u!J,7-[:j_:D3!a\u0007;\u0011\u0019\t\u0019\u0003\u0001C\u0001S\u0005)C/Z:u\u0007\u0006d7-T3sO\u0016<\u0016\u000e\u001e5O_:$U\r^3s[&t\u0017n\u001d;jG\u0016C\bO\u001d\u0015\u0004\u0003CQ\u0004BBA\u0015\u0001\u0011\u0005\u0011&\u0001\u0014uKN$8)\u00197d\u001b\u0016\u0014x-Z,ji\"tuN\u001c#fi\u0016\u0014X.\u001b8jgRL7-\u0012=qeJB3!a\n;\u0001")
public class CalcTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void setup() {
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$9 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.CalcTest$$anon$9 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addFunction("random_udf", new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
    }

    @Test
    public void testOnlyProject() {
        this.util().verifyExecPlan("SELECT a, c FROM MyTable");
    }

    @Test
    public void testProjectWithNaming() {
        this.util().verifyExecPlan("SELECT `1-_./\u00dc`, b, c FROM (SELECT a as `1-_./\u00dc`, b, c FROM MyTable)");
    }

    @Test
    public void testMultiProjects() {
        this.util().verifyExecPlan("SELECT c FROM (SELECT a, c FROM MyTable)");
    }

    @Test
    public void testOnlyFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE b > 0");
    }

    @Test
    public void testDisjunctiveFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a < 10 OR a > 20");
    }

    @Test
    public void testConjunctiveFilter() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a < 10 AND b > 20");
    }

    @Test
    public void testMultiFilters() {
        this.util().verifyExecPlan("SELECT * FROM (SELECT * FROM MyTable WHERE b > 0) t WHERE a < 50");
    }

    @Test
    public void testProjectAndFilter() {
        this.util().verifyExecPlan("SELECT a, b + 1 FROM MyTable WHERE b > 2");
    }

    @Test
    public void testIn() {
        String sql = "SELECT * FROM MyTable WHERE b IN (1, 3, 4, 5, 6) AND c = 'xx'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testInNonConstantValues() {
        String sql = "SELECT * FROM MyTable WHERE b IN (1, 3, CAST(a AS INT), 5, 6) AND c = 'xx'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testNotIn() {
        String sql = "SELECT * FROM MyTable WHERE b NOT IN (1, 3, 4, 5, 6) OR c = 'xx'";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMultipleFlattening() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$10 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$6[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>> unused = new ScalaCaseClassSerializer<Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String>>(this, fieldSerializers){

                    public Tuple3<Tuple2<Object, Object>, Tuple2<String, Object>, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)((Tuple2)fields[0]), (Object)((Tuple2)fields[1]), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$6(org.apache.flink.table.planner.plan.batch.sql.CalcTest$$anon$10 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT MyTable2.a.*, c, MyTable2.b.* FROM MyTable2");
    }

    @Test(expected=ValidationException.class)
    public void testInvalidFields() {
        this.util().tableEnv().sqlQuery("SELECT a, foo FROM MyTable");
    }

    @Test
    public void testPrimitiveMapType() {
        this.util().verifyExecPlan("SELECT MAP[b, 30, 10, a] FROM MyTable");
    }

    @Test
    public void testNonPrimitiveMapType() {
        this.util().verifyExecPlan("SELECT MAP[a, c] FROM MyTable");
    }

    @Test
    public void testRowType() {
        this.util().verifyExecPlan("SELECT ROW(1, 'Hi', a) FROM MyTable");
    }

    @Test
    public void testArrayType() {
        this.util().verifyExecPlan("SELECT ARRAY['Hi', 'Hello', c] FROM MyTable");
    }

    @Test
    public void testProjectWithDateType() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b, c,\n        | DATE '1984-07-12',\n        | TIME '14:34:24',\n        | TIMESTAMP '1984-07-12 14:34:24'\n        |FROM MyTable\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testFilterWithDateType() {
        this.util().addTableSource("MyTable3", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, Date, Time, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Date, Time, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$7[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Date, Time, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Date, Time, Timestamp>>(this, fieldSerializers){

                    public Tuple4<Object, Date, Time, Timestamp> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[0])), (Object)((Date)fields[1]), (Object)((Time)fields[2]), (Object)((Timestamp)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$7(org.apache.flink.table.planner.plan.batch.sql.CalcTest$$anon$15 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM MyTable3\n        |WHERE b = DATE '1984-07-12' AND c = TIME '14:34:24' AND d = TIMESTAMP '1984-07-12 14:34:24'\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testPojoType() {
        this.util().addTableSource("MyTable4", (TypeInformation[])((Object[])new TypeInformation[]{TypeExtractor.createTypeInfo(MyPojo.class)}), (String[])((Object[])new String[]{"a"}));
        this.util().verifyExecPlan("SELECT a FROM MyTable4");
    }

    @Test
    public void testMixedType() {
        this.util().addTableSource("MyTable5", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$8[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple3<String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple3<String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple3((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)((Timestamp)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$8(org.apache.flink.table.planner.plan.batch.sql.CalcTest$$anon$16 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT ROW(a, b, c), ARRAY[12, b], MAP[a, c] FROM MyTable5 WHERE (a, b, c) = ('foo', 12, TIMESTAMP '1984-07-12 14:34:24')");
    }

    @Test
    public void testCollationDeriveOnCalc() {
        this.util().verifyExecPlan("SELECT CAST(a AS INT), CAST(b AS VARCHAR) FROM (VALUES (3, 'c')) T(a,b)");
    }

    @Test
    public void testOrWithIsNullPredicate() {
        this.util().verifyExecPlan("SELECT * FROM MyTable WHERE a = 1 OR a = 10 OR a IS NULL");
    }

    @Test
    public void testOrWithIsNullInIf() {
        this.util().verifyExecPlan("SELECT IF(c = '' OR c IS NULL, 'a', 'b') FROM MyTable");
    }

    @Test
    public void testDecimalArrayWithDifferentPrecision() {
        this.util().verifyExecPlan("SELECT ARRAY[0.12, 0.5, 0.99]");
    }

    @Test
    public void testDecimalMapWithDifferentPrecision() {
        this.util().verifyExecPlan("SELECT MAP['a', 0.12, 'b', 0.5]");
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr() {
        String sqlQuery = "SELECT a, a1 FROM (SELECT a, random_udf(b) AS a1 FROM MyTable) t WHERE a1 > 10";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr2() {
        String sqlQuery = "SELECT a FROM (SELECT a, b FROM MyTable) t WHERE random_udf(b) > 10";
        this.util().verifyRelPlan(sqlQuery);
    }
}

