/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.factories.TestManagedTableFactory;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001'\t92i\\7qC\u000e$X*\u00198bO\u0016$G+\u00192mKR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003cCR\u001c\u0007N\u0003\u0002\b\u0011\u0005!\u0001\u000f\\1o\u0015\tI!\"A\u0004qY\u0006tg.\u001a:\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/!\tQ!\u001e;jYNL!!\u0007\f\u0003\u001bQ\u000b'\r\\3UKN$()Y:f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011B\u0011\u0002\u001fQ\f'\r\\3JI\u0016tG/\u001b4jKJ,\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K)\tqaY1uC2|w-\u0003\u0002(I\t\u0001rJ\u00196fGRLE-\u001a8uS\u001aLWM\u001d\u0005\u0007S\u0001\u0001\u000b\u0011\u0002\u0012\u0002!Q\f'\r\\3JI\u0016tG/\u001b4jKJ\u0004\u0003bB\u0016\u0001\u0005\u0004%I\u0001L\u0001\ti\u0016\u001cH/\u0016;jYV\tQ\u0006\u0005\u0002\u0016]%\u0011qF\u0006\u0002\u0013\u0005\u0006$8\r\u001b+bE2,G+Z:u+RLG\u000e\u0003\u00042\u0001\u0001\u0006I!L\u0001\ni\u0016\u001cH/\u0016;jY\u0002BQa\r\u0001\u0005\u0002Q\naAY3g_J,G#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\tUs\u0017\u000e\u001e\u0015\u0003eq\u0002\"!\u0010!\u000e\u0003yR!a\u0010\t\u0002\u000b),h.\u001b;\n\u0005\u0005s$A\u0002\"fM>\u0014X\rC\u0003D\u0001\u0011\u0005A'A\u0003bMR,'\u000f\u000b\u0002C\u000bB\u0011QHR\u0005\u0003\u000fz\u0012Q!\u00114uKJDQ!\u0013\u0001\u0005\u0002Q\nQ\u0007^3ti\u0016C\b\u000f\\1j]\u0006cG/\u001a:UC\ndWmQ8na\u0006\u001cGoV5uQJ+7o\u001c7wK\u0012\u0004\u0016M\u001d;ji&|gn\u00159fG\"\u0012\u0001j\u0013\t\u0003{1K!!\u0014 \u0003\tQ+7\u000f\u001e\u0005\u0006\u001f\u0002!\t\u0001N\u00017i\u0016\u001cH/\u0012=qY\u0006Lg.\u00117uKJ$\u0016M\u00197f\u0007>l\u0007/Y2u/&$\b.\u00168pe\u0012,'/\u001a3QCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0015\u0003\u001d.CQA\u0015\u0001\u0005\u0002Q\n1\b^3ti\u0016C\b\u000f\\1j]\u0006cG/\u001a:UC\ndWmQ8na\u0006\u001cGoV5uQ>,HoU;c_J$\u0017N\\1uKB\u000b'\u000f^5uS>t7\u000b]3dQ\t\t6\nC\u0003V\u0001\u0011\u0005A'A\u001duKN$X\t\u001f9mC&t\u0017\t\u001c;feR\u000b'\r\\3D_6\u0004\u0018m\u0019;XSRDw.\u001e;TK\u000e|g\u000eZ1ssB\u000b'\u000f^5uS>t7\u000b]3dQ\t!6\nC\u0003Y\u0001\u0011\u0005A'\u0001\u0019uKN$X\t\u001f9mC&t\u0017\t\u001c;feR\u000b'\r\\3D_6\u0004\u0018m\u0019;XSRDw.\u001e;QCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0015\u0003/.\u0003")
public class CompactManagedTableTest
extends TableTestBase {
    private final ObjectIdentifier tableIdentifier = ObjectIdentifier.of((String)"default_catalog", (String)"default_database", (String)"ManagedTable");
    private final BatchTableTestUtil testUtil = this.batchTestUtil(this.batchTestUtil$default$1());

    private ObjectIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    private BatchTableTestUtil testUtil() {
        return this.testUtil;
    }

    @Before
    public void before() {
        AtomicReference tableRef = new AtomicReference();
        TestManagedTableFactory.MANAGED_TABLES.put(this.tableIdentifier(), tableRef);
        String ddl = new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TABLE ManagedTable (\n        |  a BIGINT,\n        |  b INT,\n        |  c VARCHAR\n        |) PARTITIONED BY (b, c)\n      ")).stripMargin();
        this.testUtil().tableEnv().executeSql(ddl);
        LinkedHashMap<String, String> partitionKVs = new LinkedHashMap<String, String>();
        partitionKVs.put("b", "0");
        partitionKVs.put("c", "flink");
        HashMap<CatalogPartitionSpec, List<Path>> managedTableFileEntries = new HashMap<CatalogPartitionSpec, List<Path>>();
        managedTableFileEntries.put(new CatalogPartitionSpec(partitionKVs), Collections.singletonList(new Path("/foo/bar/file")));
        AtomicReference<HashMap<CatalogPartitionSpec, List<Path>>> fileRef = new AtomicReference<HashMap<CatalogPartitionSpec, List<Path>>>();
        fileRef.set(managedTableFileEntries);
        TestManagedTableFactory.MANAGED_TABLE_FILE_ENTRIES.put(this.tableIdentifier(), fileRef);
    }

    @After
    public void after() {
        String ddl = "DROP TABLE ManagedTable";
        this.testUtil().tableEnv().executeSql(ddl);
        TestManagedTableFactory.MANAGED_TABLE_FILE_ENTRIES.remove(this.tableIdentifier());
    }

    @Test
    public void testExplainAlterTableCompactWithResolvedPartitionSpec() {
        String sql = "ALTER TABLE ManagedTable PARTITION (b = 0, c = 'flink') COMPACT";
        this.testUtil().verifyExplainSql(sql);
    }

    @Test
    public void testExplainAlterTableCompactWithUnorderedPartitionSpec() {
        String sql = "ALTER TABLE ManagedTable PARTITION (c = 'flink', b = 0) COMPACT";
        this.testUtil().verifyExplainSql(sql);
    }

    @Test
    public void testExplainAlterTableCompactWithoutSubordinatePartitionSpec() {
        String sql = "ALTER TABLE ManagedTable PARTITION (b = 0) COMPACT";
        this.testUtil().verifyExplainSql(sql);
    }

    @Test
    public void testExplainAlterTableCompactWithoutSecondaryPartitionSpec() {
        String sql = "ALTER TABLE ManagedTable PARTITION (c = 'flink') COMPACT";
        this.testUtil().verifyExplainSql(sql);
    }

    @Test
    public void testExplainAlterTableCompactWithoutPartitionSpec() {
        String sql = "ALTER TABLE ManagedTable COMPACT";
        this.testUtil().verifyExplainSql(sql);
    }
}

