/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.mocks.MockSource;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\u0001\u0003\u0001M\u0011\u0011$T;mi&\u0004H.Z%oaV$8I]3bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003\u0015\u0011\u0017\r^2i\u0015\t9\u0001\"\u0001\u0003qY\u0006t'BA\u0005\u000b\u0003\u001d\u0001H.\u00198oKJT!a\u0003\u0007\u0002\u000bQ\f'\r\\3\u000b\u00055q\u0011!\u00024mS:\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0006kRLGn]\u0005\u00033Y\u0011Q\u0002V1cY\u0016$Vm\u001d;CCN,\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0017MDWO\u001a4mK6{G-\u001a\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\naaY8n[>t'BA\u0011\r\u0003\r\t\u0007/[\u0005\u0003Gy\u0011\u0001CQ1uG\"\u001c\u0006.\u001e4gY\u0016lu\u000eZ3\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019\nQb]2iK\u0012,H.\u001a:UsB,\u0007CA\u00148\u001d\tACG\u0004\u0002*e9\u0011!&\r\b\u0003WAr!\u0001L\u0018\u000e\u00035R!A\f\n\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA\b\u0011\u0013\tia\"\u0003\u00024\u0019\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!!\u000e\u001c\u0002#){'-T1oC\u001e,'o\u00149uS>t7O\u0003\u00024\u0019%\u0011\u0001(\u000f\u0002\u000e'\u000eDW\rZ;mKJ$\u0016\u0010]3\u000b\u0005U2\u0004\"B\u001e\u0001\t\u0003a\u0014A\u0002\u001fj]&$h\bF\u0002>\u007f\u0001\u0003\"A\u0010\u0001\u000e\u0003\tAQa\u0007\u001eA\u0002qAQ!\n\u001eA\u0002\u0019BqA\u0011\u0001C\u0002\u0013%1)\u0001\u0003vi&dW#\u0001#\u0011\u0005U)\u0015B\u0001$\u0017\u0005I\u0011\u0015\r^2i)\u0006\u0014G.\u001a+fgR,F/\u001b7\t\r!\u0003\u0001\u0015!\u0003E\u0003\u0015)H/\u001b7!\u0011\u0015Q\u0005\u0001\"\u0001L\u0003\u0019\u0011WMZ8sKR\tA\n\u0005\u0002N!6\taJC\u0001P\u0003\u0015\u00198-\u00197b\u0013\t\tfJ\u0001\u0003V]&$\bFA%T!\t!v+D\u0001V\u0015\t1\u0006#A\u0003kk:LG/\u0003\u0002Y+\n1!)\u001a4pe\u0016DQA\u0017\u0001\u0005\u0002-\u000ba\u0003^3ti\n\u000b7/[2Nk2$\u0018\u000e\u001d7f\u0013:\u0004X\u000f\u001e\u0015\u00033r\u0003\"\u0001V/\n\u0005y+&\u0001\u0002+fgRDQ\u0001\u0019\u0001\u0005\u0002-\u000ba\u0003^3ti6\u000bg._'vYRL\u0007\u000f\\3J]B,Ho\u001d\u0015\u0003?rCQa\u0019\u0001\u0005\u0002-\u000ba\u0003^3ti*{\u0017N\\,ji\"\fumZ!t!J|'-\u001a\u0015\u0003ErCQA\u001a\u0001\u0005\u0002-\u000bA\u0007^3ti.+W\r]'vYRL\u0007\u000f\\3J]B,HoV5uQ>sW-T3nE\u0016\u0014hi\u001c:DQ\u0006Lg.\u00192mKN{WO]2fQ\t)G\fC\u0003j\u0001\u0011\u00051*\u0001\u0013uKN$\u0018I^8jI&s7\r\\;eS:<WK\\5p]\u001a\u0013x.\\%oaV$8+\u001b3fQ\tAG\fC\u0003m\u0001\u0011\u00051*\u0001\u0012uKN$\u0018J\\2mk\u0012,WK\\5p]\u001a{'o\u00115bS:\f'\r\\3T_V\u00148-\u001a\u0015\u0003WrCQa\u001c\u0001\u0005\u0002-\u000bQ\u0006^3ti\u00063x.\u001b3J]\u000edW\u000fZ5oO\u000e\u000bGnY!gi\u0016\u0014hj\u001c8DQ\u0006Lg.\u00192mKN{WO]2fQ\tqG\fC\u0003s\u0001\u0011\u00051*A\u0011uKN$\u0018J\\2mk\u0012,7)\u00197d\r>\u00148\t[1j]\u0006\u0014G.Z*pkJ\u001cW\r\u000b\u0002r9\")Q\u000f\u0001C\u0001\u0017\u0006YB/Z:u\u0003Z|\u0017\u000eZ%oG2,H-\u001b8h'&tw\r\\3u_:D#\u0001\u001e/\t\u000ba\u0004A\u0011A&\u00021Q,7\u000f\u001e(p!JLwN]5us\u000e{gn\u001d;sC&tG\u000f\u000b\u0002x9\")1\u0010\u0001C\u0001\u0017\u0006\tB/Z:u%\u0016d\u0017\r^3e\u0013:\u0004X\u000f^:)\u0005id\u0006\"\u0002@\u0001\t\u0003Y\u0015\u0001\u0007;fgR\u0014V\r\\1uK\u0012Le\u000e];ug^KG\u000f[!hO\"\u0012Q\u0010\u0018\u0005\u0007\u0003\u0007\u0001A\u0011A&\u00021Q,7\u000f\u001e*f[>4XMU3ek:$\u0017M\u001c;V]&|g\u000eK\u0002\u0002\u0002qCa!!\u0003\u0001\t\u0003Y\u0015A\t;fgR\u0014V-\\8wK>sW-\u00138qkR|\u0005/\u001a:bi>\u0014hI]8n%>|G\u000fK\u0002\u0002\bqCa!a\u0004\u0001\t\u0003Y\u0015!\n;fgR\u001cE.Z1o+BlU\u000f\u001c;ja2,\u0017J\u001c9vi^KG\u000f[(oK6+WNY3sQ\r\ti\u0001\u0018\u0005\u0007\u0003+\u0001A\u0011A&\u0002'Q,7\u000f^&fKB,6/\u001a4vYVs\u0017n\u001c8)\u0007\u0005MA\f\u0003\u0004\u0002\u001c\u0001!\taS\u0001'i\u0016\u001cH\u000fR3bI2|7m[\"bkN,GMQ=Fq\u000eD\u0017M\\4f\u0013:\fenY3ti>\u0014\bfAA\r9\"1\u0011\u0011\u0005\u0001\u0005\u0002-\u000b!d\u0019:fCR,7\t[1j]\u0006\u0014G.\u001a+bE2,7k\\;sG\u0016Ds\u0001AA\u0013\u0003c\t\u0019\u0004\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tY#V\u0001\u0007eVtg.\u001a:\n\t\u0005=\u0012\u0011\u0006\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\t\t)\u0004\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\r\tY$V\u0001\beVtg.\u001a:t\u0013\u0011\ty$!\u000f\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u000f\u001d\t\u0019E\u0001E\u0001\u0003\u000b\n\u0011$T;mi&\u0004H.Z%oaV$8I]3bi&|g\u000eV3tiB\u0019a(a\u0012\u0007\r\u0005\u0011\u0001\u0012AA%'\u0011\t9%a\u0013\u0011\u00075\u000bi%C\u0002\u0002P9\u0013a!\u00118z%\u00164\u0007bB\u001e\u0002H\u0011\u0005\u00111\u000b\u000b\u0003\u0003\u000bB\u0001\"a\u0016\u0002H\u0011\u0005\u0011\u0011L\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cHCAA.!\u0015i\u0015QLA1\u0013\r\tyF\u0014\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0006\u001b\u0006u\u00131\r\t\u0005\u0003K\ny'\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0014\u0001\u00026bm\u0006LA!!\u001d\u0002h\t1qJ\u00196fGRD\u0003\"!\u0016\u0002v\u0005-\u0015Q\u0012\t\u0005\u0003o\n)I\u0004\u0003\u0002z\u0005\u0005e\u0002BA>\u0003\u007fr1aKA?\u0013\t1\u0006#C\u0002\u0002<UKA!a!\u0002:\u0005i\u0001+\u0019:b[\u0016$XM]5{K\u0012LA!a\"\u0002\n\nQ\u0001+\u0019:b[\u0016$XM]:\u000b\t\u0005\r\u0015\u0011H\u0001\u0005]\u0006lW-\t\u0002\u0002\u0010\u0006!3\u000f[;gM2,Wj\u001c3fu\u0001Z\b' \u0017!g\u000eDW\rZ;mKJ$\u0016\u0010]3;Am\fT\u0010")
public class MultipleInputCreationTest
extends TableTestBase {
    private final BatchShuffleMode shuffleMode;
    private final JobManagerOptions.SchedulerType schedulerType;
    private final BatchTableTestUtil util;

    @Parameterized.Parameters(name="shuffleMode: {0}, schedulerType: {1}")
    public static Object[][] parameters() {
        return MultipleInputCreationTest$.MODULE$.parameters();
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        this.util().addTableSource("x", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "nx"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("y", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ny"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("z", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "g")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "h")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "i")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "nz"))}), new CaseClassTypeInfo<Tuple4<Object, Object, String, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$7 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Object, String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Object, String, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Object, String, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$$anon$7 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addDataStream("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$8 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.batch.sql.MultipleInputCreationTest$$anon$8 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().tableConfig().set(ExecutionOptions.BATCH_SHUFFLE_MODE, (Object)this.shuffleMode);
        this.util().tableConfig().set(JobManagerOptions.SCHEDULER, (Object)this.schedulerType);
    }

    @Test
    public void testBasicMultipleInput() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM x INNER JOIN y ON x.a = y.d) T1\n        |  INNER JOIN\n        |  (SELECT d FROM y INNER JOIN t ON y.d = t.a) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testManyMultipleInputs() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin,SortAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (\n        |    SELECT a, ny, nz FROM x\n        |      LEFT JOIN y ON x.a = y.ny\n        |      LEFT JOIN z ON x.a = z.nz),\n        |  T2 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN t ON T1.a = t.a\n        |      INNER JOIN y ON T1.a = y.d),\n        |  T3 AS (\n        |    SELECT T1.a AS a, t.b AS b, d, T1.ny AS ny, nz FROM T1\n        |      LEFT JOIN y ON T1.a = y.d\n        |      INNER JOIN t ON T1.a = t.a),\n        |  T4 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T2 GROUP BY b),\n        |  T5 AS (SELECT b, SUM(d) AS sd, SUM(ny) AS sy, SUM(nz) AS sz FROM T3 GROUP BY b)\n        |SELECT * FROM\n        |  (SELECT t.b, sd, sy, sz FROM T4 LEFT JOIN t ON T4.b = t.b)\n        |  UNION ALL\n        |  (SELECT y.e, sd, sy, sz FROM T5 LEFT JOIN y ON T5.b = y.e)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testJoinWithAggAsProbe() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T AS (SELECT a, d FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, COUNT(*) AS cnt FROM T GROUP BY a) T1\n        |  LEFT JOIN\n        |  (SELECT d, SUM(a) AS sm FROM T GROUP BY d) T2\n        |  ON T1.a = T2.d\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testKeepMultipleInputWithOneMemberForChainableSource() {
        this.createChainableTableSource();
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = "SELECT * FROM chainable LEFT JOIN x ON chainable.a = x.a";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAvoidIncludingUnionFromInputSide() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM (SELECT a FROM x) UNION ALL (SELECT a FROM t)) T1\n        |  LEFT JOIN y ON T1.a = y.d\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testIncludeUnionForChainableSource() {
        this.createChainableTableSource();
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM\n        |  (SELECT a FROM (SELECT a FROM chainable) UNION ALL (SELECT a FROM t)) T1\n        |  LEFT JOIN y ON T1.a = y.d\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAvoidIncludingCalcAfterNonChainableSource() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  LEFT JOIN y ON x.a = y.d\n        |  LEFT JOIN t ON x.a = t.a\n        |  WHERE x.b > 10\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testIncludeCalcForChainableSource() {
        this.createChainableTableSource();
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM chainable\n        |  LEFT JOIN y ON chainable.a = y.d\n        |  LEFT JOIN t ON chainable.a = t.a\n        |  WHERE chainable.a > 10\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testAvoidIncludingSingleton() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin,HashAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT COUNT(*) AS cnt FROM z),\n        |  T2 AS (\n        |    SELECT a FROM\n        |      (SELECT a FROM x INNER JOIN y ON x.a = y.d)\n        |      UNION ALL\n        |      (SELECT a FROM t FULL JOIN T1 ON t.a > T1.cnt))\n        |SELECT a FROM T2 LEFT JOIN z ON T2.a = z.g\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testNoPriorityConstraint() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM x\n        |  INNER JOIN y ON x.a = y.d\n        |  INNER JOIN t ON x.a = t.a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRelatedInputs() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT x.a AS a, x.b AS b FROM x))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRelatedInputsWithAgg() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin,SortAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT x.a AS a, y.d AS b FROM y LEFT JOIN x ON y.d = x.a),\n        |  T2 AS (\n        |    SELECT a, b FROM\n        |      (SELECT a, b FROM T1)\n        |      UNION ALL\n        |      (SELECT COUNT(x.a) AS a, x.b AS b FROM x GROUP BY x.b))\n        |SELECT * FROM T2 LEFT JOIN t ON T2.a = t.a\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRemoveRedundantUnion() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT COUNT(*) AS cnt FROM x GROUP BY a),\n        |  T2 AS (SELECT COUNT(*) AS cnt FROM y GROUP BY d),\n        |  T3 AS (SELECT a AS cnt FROM x INNER JOIN y ON x.a = y.d),\n        |  T4 AS (SELECT b AS cnt FROM x INNER JOIN y ON x.b = y.e)\n        |SELECT cnt FROM\n        |  (SELECT cnt FROM (SELECT cnt FROM T1) UNION ALL (SELECT cnt FROM T2))\n        |  UNION ALL\n        |  (SELECT cnt FROM (SELECT cnt FROM T3) UNION ALL (SELECT cnt FROM T4))\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testRemoveOneInputOperatorFromRoot() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT a FROM x INNER JOIN y ON x.a = y.d),\n        |  T2 AS (SELECT b FROM x INNER JOIN y ON x.b = y.e)\n        |SELECT * FROM\n        |  (SELECT a, b FROM T1 LEFT JOIN T2 ON T1.a = T2.b)\n        |  UNION ALL\n        |  (SELECT a, b FROM x)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testCleanUpMultipleInputWithOneMember() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT a FROM x INNER JOIN y ON x.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a, a + 1 FROM T1)\n        |  UNION ALL\n        |  (SELECT a, b FROM x)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testKeepUsefulUnion() {
        this.createChainableTableSource();
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH\n        |  T1 AS (SELECT chainable.a AS a FROM chainable LEFT JOIN x ON chainable.a = x.a),\n        |  T2 AS (SELECT chainable.a AS a FROM chainable LEFT JOIN y ON chainable.a = y.d)\n        |SELECT * FROM\n        |  (SELECT a FROM T1)\n        |  UNION ALL\n        |  (SELECT a FROM T2)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testDeadlockCausedByExchangeInAncestor() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH T1 AS (\n        |  SELECT x1.*, x2.a AS k, (x1.b + x2.b) AS v\n        |  FROM x x1 LEFT JOIN x x2 ON x1.a = x2.a WHERE x2.a > 0)\n        |SELECT x.a, x.b, T1.* FROM x LEFT JOIN T1 ON x.a = T1.k WHERE x.a > 0 AND T1.v = 0\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    public void createChainableTableSource() {
        DataStreamSource dataStream = this.util().getStreamEnv().fromSource((Source)new MockSource(Boundedness.BOUNDED, 1), WatermarkStrategy.noWatermarks(), "chainable");
        TableTestUtil$.MODULE$.createTemporaryView(this.util().tableEnv(), "chainable", dataStream, (Option<Expression[]>)new Some((Object)new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a"))}), TableTestUtil$.MODULE$.createTemporaryView$default$5(), TableTestUtil$.MODULE$.createTemporaryView$default$6());
    }

    public MultipleInputCreationTest(BatchShuffleMode shuffleMode, JobManagerOptions.SchedulerType schedulerType) {
        this.shuffleMode = shuffleMode;
        this.schedulerType = schedulerType;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

