/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.connector.sink.abilities.SupportsRowLevelUpdate;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.collection.Seq;

@RunWith(value=Parameterized.class)
public class RowLevelUpdateTest
extends TableTestBase {
    private final Seq<ExplainDetail> explainDetails = JavaScalaConversionUtil.toScala(Collections.singletonList(ExplainDetail.JSON_EXECUTION_PLAN));
    private final SupportsRowLevelUpdate.RowLevelUpdateMode updateMode;
    private BatchTableTestUtil util;

    @Parameterized.Parameters(name="updateMode = {0}")
    public static Collection<SupportsRowLevelUpdate.RowLevelUpdateMode> data() {
        return Arrays.asList(SupportsRowLevelUpdate.RowLevelUpdateMode.UPDATED_ROWS, SupportsRowLevelUpdate.RowLevelUpdateMode.ALL_ROWS);
    }

    public RowLevelUpdateTest(SupportsRowLevelUpdate.RowLevelUpdateMode updateMode) {
        this.updateMode = updateMode;
    }

    @Before
    public void before() {
        this.util = this.batchTestUtil(TableConfig.getDefault());
        this.util.tableEnv().getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)12);
    }

    @Test
    public void testUpdateWithoutFilter() {
        this.createTableForUpdate();
        this.util.verifyExplainInsert("UPDATE t SET b = 'n1', a = char_length(b) * a ", this.explainDetails);
    }

    @Test
    public void testUpdateWithFilter() {
        this.createTableForUpdate();
        this.util.verifyExplainInsert("UPDATE t SET b = 'v2' WHERE a = 123 AND b = 'v1'", this.explainDetails);
    }

    @Test
    public void testUpdateWithSubQuery() {
        this.createTableForUpdate();
        this.util.tableEnv().executeSql(String.format("CREATE TABLE t1 (a int, b string) WITH ('connector' = 'test-update-delete', 'update-mode' = '%s') ", this.updateMode));
        this.util.verifyExplainInsert("UPDATE t SET b = 'v2' WHERE a = (SELECT count(*) FROM t1)", this.explainDetails);
    }

    @Test
    public void testUpdateAllColsWithOnlyRequireUpdatedCols() {
        this.util.tableEnv().executeSql(String.format("CREATE TABLE t (a int, b string, c double) WITH ('connector' = 'test-update-delete', 'update-mode' = '%s', 'only-require-updated-columns-for-update' = 'true') ", this.updateMode));
        this.util.verifyExplainInsert("UPDATE t SET b = 'v2', a = 123, c = c + 1 WHERE c > 123", this.explainDetails);
    }

    @Test
    public void testUpdatePartColsWithOnlyRequireUpdatedCols() {
        this.util.tableEnv().executeSql(String.format("CREATE TABLE t (f0 string, f1 int, a int, b string, c double, f2 string, f3 int) WITH ('connector' = 'test-update-delete', 'update-mode' = '%s', 'only-require-updated-columns-for-update' = 'true') ", this.updateMode));
        this.util.verifyExplainInsert("UPDATE t SET b = 'v2', a = 123, c = c + 1 WHERE c > 123", this.explainDetails);
    }

    @Test
    public void testUpdateWithCustomColumns() {
        this.util.tableEnv().executeSql(String.format("CREATE TABLE t (a int, b string, c double) WITH ('connector' = 'test-update-delete', 'required-columns-for-update' = 'b;c', 'update-mode' = '%s') ", this.updateMode));
        this.util.verifyExplainInsert("UPDATE t SET b = 'v2' WHERE b = '123'", this.explainDetails);
    }

    @Test
    public void testUpdateWithMetaColumns() {
        this.util.tableEnv().executeSql(String.format("CREATE TABLE t (a int, b string, c double) WITH ('connector' = 'test-update-delete', 'required-columns-for-update' = 'meta_f1;meta_k2;a;b', 'update-mode' = '%s') ", this.updateMode));
        this.util.verifyExplainInsert("UPDATE t SET b = 'v2' WHERE b = '123'", this.explainDetails);
    }

    private void createTableForUpdate() {
        this.util.tableEnv().executeSql(String.format("CREATE TABLE t (a int, b string) WITH ('connector' = 'test-update-delete', 'update-mode' = '%s') ", this.updateMode));
    }
}

