/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.batch.sql.SubplanReuseTest$;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalSortMergeJoinRule$;
import org.apache.flink.table.planner.plan.rules.physical.batch.BatchPhysicalSortRule$;
import org.apache.flink.table.planner.plan.utils.OperatorType;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedTableFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.runtime.functions.aggregate.FirstValueAggFunction;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u0001M\u0011\u0001cU;ca2\fgNU3vg\u0016$Vm\u001d;\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006E\u0006$8\r\u001b\u0006\u0003\u000f!\tA\u0001\u001d7b]*\u0011\u0011BC\u0001\ba2\fgN\\3s\u0015\tYA\"A\u0003uC\ndWM\u0003\u0002\u000e\u001d\u0005)a\r\\5oW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]A\u0011!B;uS2\u001c\u0018BA\r\u0017\u00055!\u0016M\u00197f)\u0016\u001cHOQ1tK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0011)H/\u001b7\u0016\u0003\t\u0002\"!F\u0012\n\u0005\u00112\"A\u0005\"bi\u000eDG+\u00192mKR+7\u000f^+uS2DaA\n\u0001!\u0002\u0013\u0011\u0013!B;uS2\u0004\u0003\"\u0002\u0015\u0001\t\u0003I\u0013A\u00022fM>\u0014X\rF\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011)f.\u001b;)\u0005\u001d\n\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0011\u0003\u0015QWO\\5u\u0013\t14G\u0001\u0004CK\u001a|'/\u001a\u0005\u0006q\u0001!\t!K\u0001\u0018i\u0016\u001cH\u000fR5tC\ndWmU;ca2\fgNU3vg\u0016D#a\u000e\u001e\u0011\u0005IZ\u0014B\u0001\u001f4\u0005\u0011!Vm\u001d;\t\u000by\u0002A\u0011A\u0015\u0002IQ,7\u000f^*vEBd\u0017M\u001c*fkN,w+\u001b;i\t&4g-\u001a:f]R\u0014vn\u001e+za\u0016D#!\u0010\u001e\t\u000b\u0005\u0003A\u0011A\u0015\u00025Q,7\u000f^#oC\ndWMU3vg\u0016$\u0016M\u00197f'>,(oY3)\u0005\u0001S\u0004\"\u0002#\u0001\t\u0003I\u0013a\u0007;fgR$\u0015n]1cY\u0016\u0014V-^:f)\u0006\u0014G.Z*pkJ\u001cW\r\u000b\u0002Du!)q\t\u0001C\u0001S\u0005\tC/Z:u'V\u0014\u0007\u000f\\1o%\u0016,8/Z(o'>,(oY3XSRDG*[7ji\"\u0012aI\u000f\u0005\u0006\u0015\u0002!\t!K\u0001\"i\u0016\u001cHoU;ca2\fgNU3vg\u0016|e\u000eR1uCN#(/Z1n)\u0006\u0014G.\u001a\u0015\u0003\u0013jBQ!\u0014\u0001\u0005\u0002%\na\u0003^3tiN+(\r\u001d7b]J+Wo]3P]\u000e\u000bGn\u0019\u0015\u0003\u0019jBQ\u0001\u0015\u0001\u0005\u0002%\n\u0011\u0007^3tiN+(\r\u001d7b]J+Wo]3P]\u000e\u000bGnY,ji\"tuN\u001c#fi\u0016\u0014X.\u001b8jgRL7\r\u0015:pU\u0016\u001cG\u000f\u000b\u0002Pu!)1\u000b\u0001C\u0001S\u0005iC/Z:u'V\u0014\u0007\u000f\\1o%\u0016,8/Z(o\u0007\u0006d7mV5uQ:{g\u000eR3uKJl\u0017N\\5ti&\u001cW\u000b\u001a4)\u0005IS\u0004\"\u0002,\u0001\t\u0003I\u0013A\u0007;fgR\u001cVO\u00199mC:\u0014V-^:f\u001f:,\u0005p\u00195b]\u001e,\u0007FA+;\u0011\u0015I\u0006\u0001\"\u0001*\u0003}!Xm\u001d;Tk\n\u0004H.\u00198SKV\u001cXm\u00148ICND\u0017iZ4sK\u001e\fG/\u001a\u0015\u00031jBQ\u0001\u0018\u0001\u0005\u0002%\nq\u0004^3tiN+(\r\u001d7b]J+Wo]3P]N{'\u000f^!hOJ,w-\u0019;fQ\tY&\bC\u0003`\u0001\u0011\u0005\u0011&\u0001\u001cuKN$8+\u001e2qY\u0006t'+Z;tK>s\u0017iZ4sK\u001e\fG/Z,ji\"tuN\u001c#fi\u0016\u0014X.\u001b8jgRL7-Q4h\u0007\u0006dG\u000e\u000b\u0002_u!)!\r\u0001C\u0001S\u00051B/Z:u'V\u0014\u0007\u000f\\1o%\u0016,8/Z(o'>\u0014H\u000f\u000b\u0002bu!)Q\r\u0001C\u0001S\u00059B/Z:u'V\u0014\u0007\u000f\\1o%\u0016,8/Z(o\u0019&l\u0017\u000e\u001e\u0015\u0003IjBQ\u0001\u001b\u0001\u0005\u0002%\n1\u0004^3tiN+(\r\u001d7b]J+Wo]3P]N{'\u000f\u001e'j[&$\bFA4;\u0011\u0015Y\u0007\u0001\"\u0001*\u0003]!Xm\u001d;Tk\n\u0004H.\u00198SKV\u001cXm\u00148V]&|g\u000e\u000b\u0002ku!)a\u000e\u0001C\u0001S\u00051B/Z:u'V\u0014\u0007\u000f\\1o%\u0016,8/Z(o\u0015>Lg\u000e\u000b\u0002nu!)\u0011\u000f\u0001C\u0001S\u0005yB/Z:u'V\u0014\u0007\u000f\\1o%\u0016,8/Z(o'>\u0014H/T3sO\u0016Tu.\u001b8)\u0005AT\u0004\"\u0002;\u0001\t\u0003I\u0013A\u0007;fgR\u001cVO\u00199mC:\u0014V-^:f\u001f:D\u0015m\u001d5K_&t\u0007FA:;\u0011\u00159\b\u0001\"\u0001*\u0003\u0001\"Xm\u001d;Tk\n\u0004H.\u00198SKV\u001cXm\u00148OKN$X\r\u001a'p_BTu.\u001b8)\u0005YT\u0004\"\u0002>\u0001\t\u0003I\u0013a\r;fgR\u001cVO\u00199mC:\u0014V-^:f\u001f:Tu.\u001b8O_:$U\r^3s[&t\u0017n\u001d;jG*{\u0017N\\\"p]\u0012LG/[8oQ\tI(\bC\u0003~\u0001\u0011\u0005\u0011&\u0001\u000fuKN$8+\u001e2qY\u0006t'+Z;tK>swJ^3s/&tGm\\<)\u0005qT\u0004BBA\u0001\u0001\u0011\u0005\u0011&A\u001cuKN$8+\u001e2qY\u0006t'+Z;tK>swJ^3s/&tGm\\<XSRDgj\u001c8EKR,'/\\5oSN$\u0018nY!hO\u000e\u000bG\u000e\u001c\u0015\u0003\u007fjBa!a\u0002\u0001\t\u0003I\u0013a\u0007;fgR\u001cVO\u00199mC:\u0014V-^:f\u001f:\u001cuN\u001d:fY\u0006$X\rK\u0002\u0002\u0006iBa!!\u0004\u0001\t\u0003I\u0013a\r;fgR\u001cVO\u00199mC:\u0014V-^:f\u001f:\u001cuN\u001d:fY\u0006$XmV5uQ:{g\u000eR3uKJl\u0017N\\5ti&\u001cW\u000b\u0012+GQ\r\tYA\u000f\u0005\u0007\u0003'\u0001A\u0011A\u0015\u0002GQ,7\u000f^*vEBd\u0017M\u001c*fkN,w+\u001b;i\tft\u0017-\\5d\rVt7\r^5p]\"\u001a\u0011\u0011\u0003\u001e\t\r\u0005e\u0001\u0001\"\u0001*\u0003Y!Xm\u001d;OKN$X\rZ*vEBd\u0017M\u001c*fkN,\u0007fAA\fu!1\u0011q\u0004\u0001\u0005\u0002%\nQ\u0004^3ti\n\u0013X-Y6va\u0012+\u0017\r\u001a7pG.|e\u000eS1tQ*{\u0017N\u001c\u0015\u0004\u0003;Q\u0004BBA\u0013\u0001\u0011\u0005\u0011&A\u0012uKN$(I]3bWV\u0004H)Z1eY>\u001c7n\u00148OKN$X\r\u001a'p_BTu.\u001b8)\u0007\u0005\r\"\b\u0003\u0004\u0002,\u0001!\t!K\u0001&i\u0016\u001cH/\u00128bE2,'+Z;tKR\u000b'\r\\3T_V\u00148-Z(o\u001d\u0016<8k\\;sG\u0016D3!!\u000b;\u0011\u0019\t\t\u0004\u0001C\u0001S\u00051C/Z:u\t&\u001c\u0018M\u00197f%\u0016,8/\u001a+bE2,7k\\;sG\u0016|eNT3x'>,(oY3)\u0007\u0005=\"\b\u0003\u0004\u00028\u0001!I!K\u0001\u0015i\u0016\u001cHOU3vg\u0016|eNT3x'>,(oY3")
public class SubplanReuseTest
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.util().addTableSource("x", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.SubplanReuseTest$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("y", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "e")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "f"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.SubplanReuseTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    @Test
    public void testDisableSubplanReuse() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SUB_PLAN_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (\n        | SELECT a, SUM(b) as b, SUM(e) as e FROM x, y WHERE a = d AND c > 100 GROUP BY a\n        |)\n        |SELECT r1.a, r1.b, r2.e FROM r r1, r r2 WHERE r1.b > 10 AND r2.e < 20 AND r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reused"}));
    }

    @Test
    public void testSubplanReuseWithDifferentRowType() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t1 AS (SELECT CAST(a as BIGINT) AS a, SUM(b) AS b FROM x GROUP BY CAST(a as BIGINT)),\n        |     t2 AS (SELECT CAST(a as DOUBLE) AS a, SUM(b) AS b FROM x GROUP BY CAST(a as DOUBLE))\n        |SELECT t1.*, t2.* FROM t1, t2 WHERE t1.b = t2.b\n      ")).stripMargin();
        this.util().verifyRelPlanNotExpected(sqlQuery, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reused"}));
    }

    @Test
    public void testEnableReuseTableSource() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t AS (SELECT x.a AS a, x.b AS b, y.d AS d, y.e AS e FROM x, y WHERE x.a = y.d)\n        |SELECT t1.*, t2.* FROM t t1, t t2 WHERE t1.b = t2.e AND t1.a < 10 AND t2.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testDisableReuseTableSource() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t AS (SELECT * FROM x, y WHERE x.a = y.d)\n        |SELECT t1.*, t2.* FROM t t1, t t2 WHERE t1.b = t2.e AND t1.a < 10 AND t2.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSourceWithLimit() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b FROM x LIMIT 10)\n        |SELECT r1.a, r1.b, r2.a FROM r r1, r r2 WHERE r1.a = r2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnDataStreamTable() {
        this.util().addDataStream("t", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.SubplanReuseTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |(SELECT a FROM t WHERE a > 10)\n        |UNION ALL\n        |(SELECT a FROM t WHERE b > 10)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCalc() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, c FROM x WHERE c LIKE 'test%')\n        |(SELECT r.a, LOWER(c) AS c, y.e FROM r, y WHERE r.a = y.d)\n        |UNION ALL\n        |(SELECT r.a, LOWER(c) AS c, y.e FROM r, y WHERE r.a = y.d)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCalcWithNonDeterministicProject() {
        this.util().tableEnv().registerFunction("random_udf", (ScalarFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |(SELECT a, random_udf() FROM x WHERE a > 10)\n        |UNION ALL\n        |(SELECT a, random_udf() FROM x WHERE a > 10)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCalcWithNonDeterministicUdf() {
        this.util().tableEnv().registerFunction("random_udf", (ScalarFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |(SELECT a FROM x WHERE b > random_udf(a))\n        |UNION ALL\n        |(SELECT a FROM x WHERE b > random_udf(a))\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnExchange() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, c FROM x WHERE c LIKE 'test%')\n        |SELECT * FROM r, y WHERE a = d AND e > 10\n        |UNION ALL\n        |SELECT * FROM r, y WHERE a = d AND f <> ''\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnHashAggregate() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)OperatorType.SortAgg.toString());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM x GROUP BY c)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b AND r2.a > 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSortAggregate() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)OperatorType.HashAgg.toString());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM x GROUP BY c)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b AND r2.a > 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnAggregateWithNonDeterministicAggCall() {
        this.util().addTemporarySystemFunction("MyFirst", (UserDefinedFunction)new FirstValueAggFunction(DataTypes.INT().getLogicalType()));
        this.util().addTemporarySystemFunction("MyLast", (UserDefinedFunction)new FirstValueAggFunction(DataTypes.BIGINT().getLogicalType()));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, MyFirst(a) a, MyLast(b) b FROM x GROUP BY c)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b AND r2.a > 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSort() {
        this.util().tableEnv().getConfig().set(BatchPhysicalSortRule$.MODULE$.TABLE_EXEC_RANGE_SORT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM x GROUP BY c ORDER BY a, b DESC)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.a AND r1.a > 1 AND r2.b < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnLimit() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b FROM x LIMIT 10)\n        |SELECT r1.a, r1.b, r2.a FROM r r1, r r2 WHERE r1.a = r2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSortLimit() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT c, SUM(a) a, SUM(b) b FROM x GROUP BY c ORDER BY a, b DESC LIMIT 10)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.a AND r1.a > 1 AND r2.b < 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnUnion() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, c FROM x WHERE b > 10 UNION ALL SELECT d, f FROM y WHERE e < 100)\n        |SELECT r1.a, r1.c, r2.c FROM r r1, r r2 WHERE r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnJoin() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x FULL OUTER JOIN y ON ABS(a) = ABS(d) OR c = f\n        |           WHERE b > 1 and e < 2)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnSortMergeJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,NestedLoopJoin");
        this.util().tableEnv().getConfig().set(BatchPhysicalSortMergeJoinRule$.MODULE$.TABLE_OPTIMIZER_SMJ_REMOVE_SORT_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnHashJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnNestedLoopJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x, y WHERE a = d AND c LIKE 'He%')\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.d\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnJoinNonDeterministicJoinCondition() {
        this.util().tableEnv().registerFunction("random_udf", (ScalarFunction)new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT * FROM x FULL OUTER JOIN y ON random_udf(a) = random_udf(d) OR c = f\n        |           WHERE b > 1 and e < 2)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.b\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnOverWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, RANK() OVER (ORDER BY c DESC) FROM x)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.a AND r1.b < 100 AND r2.b > 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnOverWindowWithNonDeterministicAggCall() {
        this.util().addTemporarySystemFunction("MyFirst", (UserDefinedFunction)new FirstValueAggFunction(DataTypes.STRING().getLogicalType()));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, MyFirst(c) OVER (PARTITION BY c ORDER BY c DESC) FROM x)\n        |SELECT * FROM r r1, r r2 WHERE r1.a = r2.a AND r1.b < 100 AND r2.b > 10\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCorrelate() {
        this.util().addFunction("str_split", new JavaUserDefinedTableFunctions.StringSplit(), BasicTypeInfo.getInfoFor(String.class));
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, c, v FROM x, LATERAL TABLE(str_split(c, '-')) AS T(v))\n        |SELECT * FROM r r1, r r2 WHERE r1.v = r2.v\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseOnCorrelateWithNonDeterministicUDTF() {
        this.util().addFunction("TableFun", new JavaUserDefinedTableFunctions.NonDeterministicTableFunc(), BasicTypeInfo.getInfoFor(String.class));
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a, b, c, s FROM x, LATERAL TABLE(TableFun(c)) AS T(s))\n        |SELECT * FROM r r1, r r2 WHERE r1.c = r2.s\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSubplanReuseWithDynamicFunction() {
        Table sqlQuery = this.util().tableEnv().sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n                                            |(SELECT a AS random FROM x ORDER BY rand() LIMIT 1)\n                                            |INTERSECT\n                                            |(SELECT a AS random FROM x ORDER BY rand() LIMIT 1)\n                                            |INTERSECT\n                                            |(SELECT a AS random FROM x ORDER BY rand() LIMIT 1)\n      ")).stripMargin());
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testNestedSubplanReuse() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin,SortAgg");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH v1 AS (\n        | SELECT\n        |   SUM(b) sum_b,\n        |   AVG(SUM(b)) OVER (PARTITION BY c, e) avg_b,\n        |   RANK() OVER (PARTITION BY c, e ORDER BY c, e) rn,\n        |   c, e\n        | FROM x, y\n        | WHERE x.a = y.d AND c IS NOT NULl AND e > 10\n        | GROUP BY c, e\n        |),\n        |   v2 AS (\n        | SELECT\n        |    v11.c,\n        |    v11.e,\n        |    v11.avg_b,\n        |    v11.sum_b,\n        |    v12.sum_b psum,\n        |    v13.sum_b nsum,\n        |    v12.avg_b avg_b2\n        |  FROM v1 v11, v1 v12, v1 v13\n        |  WHERE v11.c = v12.c AND v11.c = v13.c AND\n        |    v11.e = v12.e AND v11.e = v13.e AND\n        |    v11.rn = v12.rn + 1 AND\n        |    v11.rn = v13.rn - 1\n        |)\n        |SELECT * from v2 WHERE c <> '' AND sum_b - avg_b > 3\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testBreakupDeadlockOnHashJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"NestedLoopJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a FROM x LIMIT 10)\n        |SELECT r1.a FROM r r1, r r2 WHERE r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testBreakupDeadlockOnNestedLoopJoin() {
        this.util().tableEnv().getConfig().set(ExecutionConfigOptions.TABLE_EXEC_DISABLED_OPERATORS, (Object)"HashJoin,SortMergeJoin");
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH r AS (SELECT a FROM x LIMIT 10)\n        |SELECT r1.a FROM r r1, r r2 WHERE r1.a = r2.a\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testEnableReuseTableSourceOnNewSource() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.testReuseOnNewSource();
    }

    @Test
    public void testDisableReuseTableSourceOnNewSource() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_REUSE_SOURCE_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.testReuseOnNewSource();
    }

    private void testReuseOnNewSource() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table newX(\n                     |  a int,\n                     |  b bigint,\n                     |  c varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |create table newY(\n                     |  d int,\n                     |  e bigint,\n                     |  f varchar\n                     |) with (\n                     |  'connector' = 'values',\n                     |  'bounded' = 'true'\n                     |)\n       ")).stripMargin());
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH t AS (\n        |  SELECT newX.a AS a, newX.b AS b, newY.d AS d, newY.e AS e\n        |  FROM newX, newY\n        |  WHERE newX.a = newY.d)\n        |SELECT t1.*, t2.* FROM t t1, t t2 WHERE t1.b = t2.e AND t1.a < 10 AND t2.a > 5\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }
}

