/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.TableSinkTest$;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlockPlanBuilder$;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001'\tiA+\u00192mKNKgn\u001b+fgRT!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005)!-\u0019;dQ*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0005\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0003\t\u0013\u0001\u0002'P\u001d\u001e+\u0012A\t\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nq\u0001\\8hS\u000e\fGN\u0003\u0002(\u0015\u0005)A/\u001f9fg&\u0011\u0011\u0006\n\u0002\u000b\u0005&<\u0017J\u001c;UsB,\u0007BB\u0016\u0001A\u0003%!%A\u0003M\u001f:;\u0005\u0005C\u0004.\u0001\t\u0007I\u0011\u0001\u0018\u0002\u0007%sE+F\u00010!\t\u0019\u0003'\u0003\u00022I\t9\u0011J\u001c;UsB,\u0007BB\u001a\u0001A\u0003%q&\u0001\u0003J\u001dR\u0003\u0003bB\u001b\u0001\u0005\u0004%IAN\u0001\u0005kRLG.F\u00018!\t)\u0002(\u0003\u0002:-\t\u0011\")\u0019;dQR\u000b'\r\\3UKN$X\u000b^5m\u0011\u0019Y\u0004\u0001)A\u0005o\u0005)Q\u000f^5mA!)Q\b\u0001C\u0001}\u0005qA/Z:u'&tw\r\\3TS:\\G#A \u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\tUs\u0017\u000e\u001e\u0015\u0003y\u0019\u0003\"a\u0012&\u000e\u0003!S!!\u0013\t\u0002\u000b),h.\u001b;\n\u0005-C%\u0001\u0002+fgRDQ!\u0014\u0001\u0005\u0002y\na\u0002^3ti6+H\u000e^5TS:\\7\u000f\u000b\u0002M\r\")\u0001\u000b\u0001C\u0001}\u0005QB/Z:u\tft\u0017-\\5d!\u0006\u0014HoV5uQ>\u0013H-\u001a:Cs\"\u0012qJ\u0012\u0005\u0006'\u0002!\tAP\u0001\u000fi\u0016\u001cH\u000fV1cY\u0016D\u0015N\u001c;tQ\t\u0011f\tC\u0003W\u0001\u0011\u0005a(\u0001\u0017uKN$X*\u00198bO\u0016$G+\u00192mKNKgn[,ji\"$\u0015n]1cY\u0016\u001c\u0005.Z2la>Lg\u000e^5oO\"\u0012QK\u0012\u0005\u00063\u0002!\tAP\u0001,i\u0016\u001cH/T1oC\u001e,G\rV1cY\u0016\u001c\u0016N\\6XSRDWI\\1cY\u0016\u001c\u0005.Z2la>Lg\u000e^5oO\"\u0012\u0001L\u0012")
public class TableSinkTest
extends TableTestBase {
    private final BigIntType LONG = new BigIntType();
    private final IntType INT = new IntType();
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    public BigIntType LONG() {
        return this.LONG;
    }

    public IntType INT() {
        return this.INT;
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testSingleSink() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` BIGINT\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT COUNT(*) AS cnt FROM MyTable GROUP BY a");
        this.util().verifyRelPlan(stmtSet);
    }

    @Test
    public void testMultiSinks() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink1 (\n                     |  `total_sum` INT\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink2 (\n                     |  `total_min` INT\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        this.util().tableEnv().getConfig().set(RelNodeBlockPlanBuilder$.MODULE$.TABLE_OPTIMIZER_REUSE_OPTIMIZE_BLOCK_WITH_DIGEST_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        Table table1 = this.util().tableEnv().sqlQuery("SELECT SUM(a) AS sum_a, c FROM MyTable GROUP BY c");
        this.util().tableEnv().createTemporaryView("table1", table1);
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink1 SELECT SUM(sum_a) AS total_sum FROM table1");
        stmtSet.addInsertSql("INSERT INTO sink2 SELECT MIN(sum_a) AS total_min FROM table1");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testDynamicPartWithOrderBy() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` INT,\n                     |  `b` BIGINT\n                     |) PARTITIONED BY (\n                     |  `b`\n                     |) WITH (\n                     |  'connector' = 'values'\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT a,b FROM MyTable ORDER BY a");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testTableHints() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MyTable (\n                                |  `a` INT,\n                                |  `b` BIGINT,\n                                |  `c` STRING\n                                |) WITH (\n                                |  'connector' = 'values',\n                                |  'bounded' = 'true'\n                                |)\n       ")).stripMargin());
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |CREATE TABLE MySink (\n                                |  `a` INT,\n                                |  `b` BIGINT,\n                                |  `c` STRING\n                                |) WITH (\n                                |  'connector' = 'filesystem',\n                                |  'format' = 'testcsv',\n                                |  'path' = '/tmp/test'\n                                |)\n       ")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("insert into MySink /*+ OPTIONS('path' = '/tmp1') */ select * from MyTable");
        stmtSet.addInsertSql("insert into MySink /*+ OPTIONS('path' = '/tmp2') */ select * from MyTable");
        this.util().verifyExecPlan(stmtSet);
    }

    @Test
    public void testManagedTableSinkWithDisableCheckpointing() {
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` INT,\n                     |  `b` BIGINT,\n                     |  `c` STRING\n                     |) WITH(\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT * FROM MyTable");
        this.util().verifyAstPlan(stmtSet);
    }

    @Test
    public void testManagedTableSinkWithEnableCheckpointing() {
        this.util().getStreamEnv().enableCheckpointing(10L);
        this.util().addTable(new StringOps(Predef$.MODULE$.augmentString("\n                     |CREATE TABLE sink (\n                     |  `a` INT,\n                     |  `b` BIGINT,\n                     |  `c` STRING\n                     |) WITH(\n                     |)\n                     |")).stripMargin());
        StatementSet stmtSet = this.util().tableEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO sink SELECT * FROM MyTable");
        this.util().verifyAstPlan(stmtSet);
    }

    public TableSinkTest() {
        this.util().addDataStream("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.TableSinkTest$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

