/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.agg.AggregateTestBase$;
import org.apache.flink.table.planner.plan.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001=4Q!\u0001\u0002\u0002\u0002U\u0011\u0011#Q4he\u0016<\u0017\r^3UKN$()Y:f\u0015\t\u0019A!A\u0002bO\u001eT!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)!-\u0019;dQ*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0006\u0002\u000bU$\u0018\u000e\\:\n\u0005mA\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0005!9!\u0005\u0001b\u0001\n#\u0019\u0013\u0001B;uS2,\u0012\u0001\n\t\u0003/\u0015J!A\n\r\u0003%\t\u000bGo\u00195UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007Q\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b)\u0002A\u0011A\u0016\u0002\u000fQ,7\u000f^!wOR\tA\u0006\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0003V]&$\bFA\u00154!\t!t'D\u00016\u0015\t1$#A\u0003kk:LG/\u0003\u00029k\t!A+Z:u\u0011\u0015Q\u0004\u0001\"\u0001,\u0003\u001d!Xm\u001d;Tk6D#!O\u001a\t\u000bu\u0002A\u0011A\u0016\u0002\u0013Q,7\u000f^\"pk:$\bF\u0001\u001f4\u0011\u0015\u0001\u0005\u0001\"\u0001,\u00039!Xm\u001d;D_VtGo\u0015;beRD#aP\u001a\t\u000b\r\u0003A\u0011A\u0016\u0002CQ,7\u000f^\"pk:$8\u000b^1si^KG\u000f\u001b)s_*,7\r\u001e)vg\"$un\u001e8)\u0005\t\u001b\u0004\"\u0002$\u0001\t\u0003Y\u0013\u0001\b;fgR\u001c\u0015M\u001c8pi\u000e{WO\u001c;P]6+H\u000e^5GS\u0016dGm\u001d\u0015\u0003\u000bNBQ!\u0013\u0001\u0005\u0002-\n\u0001\u0004^3ti6KgnV5uQ\u001aK\u0007\u0010T3oORDG+\u001f9fQ\tA5\u0007C\u0003M\u0001\u0011\u00051&A\u000fuKN$X*\u001b8XSRDg+\u0019:jC\ndW\rT3oORDG+\u001f9fQ\tY5\u0007C\u0003P\u0001\u0011\u00051&\u0001\ruKN$X*\u0019=XSRDg)\u001b=MK:<G\u000f\u001b+za\u0016D#AT\u001a\t\u000bI\u0003A\u0011A\u0016\u0002;Q,7\u000f^'bq^KG\u000f\u001b,be&\f'\r\\3MK:<G\u000f\u001b+za\u0016D#!U\u001a\t\u000bU\u0003A\u0011A\u0016\u00029Q,7\u000f^!hOJ,w-\u0019;f/&$\bn\\;u\rVt7\r^5p]\"\u0012Ak\r\u0005\u00061\u0002!\taK\u0001\u001ci\u0016\u001cH/Q4he\u0016<\u0017\r^3XSRDw.\u001e;He>,\bOQ=)\u0005]\u001b\u0004\"B.\u0001\t\u0003Y\u0013a\u0006;fgR\fum\u001a:fO\u0006$XmV5uQ\u001aKG\u000e^3sQ\tQ6\u0007C\u0003_\u0001\u0011\u00051&A\u0013uKN$\u0018iZ4sK\u001e\fG/Z,ji\"4\u0015\u000e\u001c;fe>sg*Z:uK\u00124\u0015.\u001a7eg\"\u0012Ql\r\u0005\u0006C\u0002!\taK\u0001\u0013i\u0016\u001cHo\u0012:pkB\fum\u001a:fO\u0006$X\r\u000b\u0002ag!)A\r\u0001C\u0001W\u0005aB/Z:u\u000fJ|W\u000f]!hOJ,w-\u0019;f/&$\bNR5mi\u0016\u0014\bFA24\u0011\u00159\u0007\u0001\"\u0001,\u0003Y!Xm\u001d;BO\u001etu\u000e^*vaB|'\u000f^'fe\u001e,\u0007F\u000144\u0011\u0015Q\u0007\u0001\"\u0001,\u0003M!Xm\u001d;Q_*|\u0017iY2v[Vd\u0017\r^8sQ\tI7\u0007C\u0003n\u0001\u0011\u00051&\u0001\u000euKN$xI]8va\nKx+\u001b;i\u0007>t7\u000f^1oi.+\u0017\u0010\u000b\u0002mg\u0001")
public abstract class AggregateTestBase
extends TableTestBase {
    private final BatchTableTestUtil util = this.batchTestUtil(this.batchTestUtil$default$1());

    public BatchTableTestUtil util() {
        return this.util;
    }

    @Test
    public void testAvg() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT AVG(`byte`),\n                                 |       AVG(`short`),\n                                 |       AVG(`int`),\n                                 |       AVG(`long`),\n                                 |       AVG(`float`),\n                                 |       AVG(`double`),\n                                 |       AVG(`decimal3020`),\n                                 |       AVG(`decimal105`)\n                                 |FROM MyTable\n      ")).stripMargin());
    }

    @Test
    public void testSum() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT SUM(`byte`),\n                                 |       SUM(`short`),\n                                 |       SUM(`int`),\n                                 |       SUM(`long`),\n                                 |       SUM(`float`),\n                                 |       SUM(`double`),\n                                 |       SUM(`decimal3020`),\n                                 |       SUM(`decimal105`)\n                                 |FROM MyTable\n      ")).stripMargin());
    }

    @Test
    public void testCount() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT COUNT(`byte`),\n                                 |       COUNT(`short`),\n                                 |       COUNT(`int`),\n                                 |       COUNT(`long`),\n                                 |       COUNT(`float`),\n                                 |       COUNT(`double`),\n                                 |       COUNT(`decimal3020`),\n                                 |       COUNT(`decimal105`),\n                                 |       COUNT(`boolean`),\n                                 |       COUNT(`date`),\n                                 |       COUNT(`time`),\n                                 |       COUNT(`timestamp`),\n                                 |       COUNT(`string`)\n                                 |FROM MyTable\n      ")).stripMargin());
    }

    @Test
    public void testCountStart() {
        this.util().verifyRelPlanWithType("SELECT COUNT(*) FROM MyTable");
    }

    @Test
    public void testCountStartWithProjectPushDown() {
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                               |CREATE TABLE src (\n                               | id VARCHAR,\n                               | cnt BIGINT\n                               |) WITH (\n                               | 'connector' = 'values'\n                               | ,'bounded' = 'true'\n                               |)\n                               |")).stripMargin());
        this.util().verifyRelPlanWithType("SELECT COUNT(*) FROM src");
    }

    @Test
    public void testCannotCountOnMultiFields() {
        String sql = "SELECT b, COUNT(a, c) FROM MyTable1 GROUP BY b";
        this.thrown().expect(TableException.class);
        this.thrown().expectMessage("We now only support the count of one field");
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testMinWithFixLengthType() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT MIN(`byte`),\n                                 |       MIN(`short`),\n                                 |       MIN(`int`),\n                                 |       MIN(`long`),\n                                 |       MIN(`float`),\n                                 |       MIN(`double`),\n                                 |       MIN(`decimal3020`),\n                                 |       MIN(`decimal105`),\n                                 |       MIN(`boolean`),\n                                 |       MIN(`date`),\n                                 |       MIN(`time`),\n                                 |       MIN(`timestamp`)\n                                 |FROM MyTable\n      ")).stripMargin());
    }

    @Test
    public void testMinWithVariableLengthType() {
        this.util().verifyRelPlanWithType("SELECT MIN(`string`) FROM MyTable");
    }

    @Test
    public void testMaxWithFixLengthType() {
        this.util().verifyRelPlanWithType(new StringOps(Predef$.MODULE$.augmentString("\n                                 |SELECT MAX(`byte`),\n                                 |       MAX(`short`),\n                                 |       MAX(`int`),\n                                 |       MAX(`long`),\n                                 |       MAX(`float`),\n                                 |       MAX(`double`),\n                                 |       MAX(`decimal3020`),\n                                 |       MAX(`decimal105`),\n                                 |       MAX(`boolean`),\n                                 |       MAX(`date`),\n                                 |       MAX(`time`),\n                                 |       MAX(`timestamp`)\n                                 |FROM MyTable\n      ")).stripMargin());
    }

    @Test
    public void testMaxWithVariableLengthType() {
        this.util().verifyRelPlanWithType("SELECT MAX(`string`) FROM MyTable");
    }

    @Test
    public void testAggregateWithoutFunction() {
        this.util().verifyExecPlan("SELECT a, b FROM MyTable1 GROUP BY a, b");
    }

    @Test
    public void testAggregateWithoutGroupBy() {
        this.util().verifyExecPlan("SELECT AVG(a), SUM(b), COUNT(c) FROM MyTable1");
    }

    @Test
    public void testAggregateWithFilter() {
        this.util().verifyExecPlan("SELECT AVG(a), SUM(b), COUNT(c) FROM MyTable1 WHERE a = 1");
    }

    @Test
    public void testAggregateWithFilterOnNestedFields() {
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, Tuple2<Object, Object>>>(this){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Tuple2<Object, Object>>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$4[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Tuple2<Object, Object>>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Tuple2<Object, Object>>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Tuple2<Object, Object>> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((Tuple2)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$4(org.apache.flink.table.planner.plan.batch.sql.agg.AggregateTestBase$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().verifyExecPlan("SELECT AVG(a), SUM(b), COUNT(c), SUM(c._1) FROM MyTable2 WHERE a = 1");
    }

    @Test
    public void testGroupAggregate() {
        this.util().verifyExecPlan("SELECT a, SUM(b), COUNT(c) FROM MyTable1 GROUP BY a");
    }

    @Test
    public void testGroupAggregateWithFilter() {
        this.util().verifyExecPlan("SELECT a, SUM(b), count(c) FROM MyTable1 WHERE a = 1 GROUP BY a");
    }

    @Test
    public void testAggNotSupportMerge() {
        this.util().addFunction("var_sum", new JavaUserDefinedAggFunctions.VarSum2AggFunction(), BasicTypeInfo.getInfoFor(Long.class), BasicTypeInfo.getInfoFor(Long.class));
        this.util().verifyExecPlan("SELECT b, var_sum(a) FROM MyTable1 GROUP BY b");
    }

    @Test
    public void testPojoAccumulator() {
        this.util().addFunction("var_sum", new JavaUserDefinedAggFunctions.VarSum1AggFunction(), BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.VarSumAcc.class));
        this.util().verifyExecPlan("SELECT b, var_sum(a) FROM MyTable1 GROUP BY b");
    }

    @Test
    public void testGroupByWithConstantKey() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, MAX(b), c FROM (SELECT a, 'test' AS c, b FROM MyTable1) t GROUP BY a, c\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    public AggregateTestBase() {
        this.util().addTableSource("MyTable", (TypeInformation[])((Object[])new TypeInformation[]{Types.BYTE(), Types.SHORT(), Types.INT(), Types.LONG(), Types.FLOAT(), Types.DOUBLE(), Types.BOOLEAN(), Types.STRING(), Types.LOCAL_DATE(), Types.LOCAL_TIME(), Types.LOCAL_DATE_TIME(), DecimalDataTypeInfo.of((int)30, (int)20), DecimalDataTypeInfo.of((int)10, (int)5)}), (String[])((Object[])new String[]{"byte", "short", "int", "long", "float", "double", "boolean", "string", "date", "time", "timestamp", "decimal3020", "decimal105"}));
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, String>>(this, fieldSerializers){

                    public Tuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.agg.AggregateTestBase$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }
}

