/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.batch.sql.agg;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Timestamp;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.plan.batch.sql.agg.GroupWindowTest$;
import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedAggFunctions;
import org.apache.flink.table.planner.utils.AggregatePhaseStrategy;
import org.apache.flink.table.planner.utils.BatchTableTestUtil;
import org.apache.flink.table.planner.utils.CountAccumulator;
import org.apache.flink.table.planner.utils.CountAggFunction;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0001\u0003\u0001U\u0011qb\u0012:pkB<\u0016N\u001c3poR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1!Y4h\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000b\t\fGo\u00195\u000b\u0005%Q\u0011\u0001\u00029mC:T!a\u0003\u0007\u0002\u000fAd\u0017M\u001c8fe*\u0011QBD\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u001fA\tQA\u001a7j].T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9\"$D\u0001\u0019\u0015\tI\"\"A\u0003vi&d7/\u0003\u0002\u001c1\tiA+\u00192mKR+7\u000f\u001e\"bg\u0016D\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\fC\u001e<7\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0002\u0018?%\u0011\u0001\u0005\u0007\u0002\u0017\u0003\u001e<'/Z4bi\u0016\u0004\u0006.Y:f'R\u0014\u0018\r^3hs\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001\n\u0014\u0011\u0005\u0015\u0002Q\"\u0001\u0002\t\u000bu\t\u0003\u0019\u0001\u0010\t\u000f!\u0002!\u0019!C\u0005S\u0005!Q\u000f^5m+\u0005Q\u0003CA\f,\u0013\ta\u0003D\u0001\nCCR\u001c\u0007\u000eV1cY\u0016$Vm\u001d;Vi&d\u0007B\u0002\u0018\u0001A\u0003%!&A\u0003vi&d\u0007\u0005C\u00031\u0001\u0011\u0005\u0011'\u0001\u0004cK\u001a|'/\u001a\u000b\u0002eA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t!QK\\5uQ\ty\u0013\b\u0005\u0002;{5\t1H\u0003\u0002=%\u0005)!.\u001e8ji&\u0011ah\u000f\u0002\u0007\u0005\u00164wN]3\t\u000b\u0001\u0003A\u0011A\u0019\u0002+Q,7\u000f\u001e%pa^Kg\u000eZ8x\u001d>|eMZ:fi\"\u0012qH\u0011\t\u0003u\rK!\u0001R\u001e\u0003\tQ+7\u000f\u001e\u0005\u0006\r\u0002!\t!M\u0001\u001ai\u0016\u001cHoU3tg&|gnV5oI><hj\\(gMN,G\u000f\u000b\u0002F\u0005\")\u0011\n\u0001C\u0001c\u00051B/Z:u-\u0006\u0014\u0018.\u00192mK^Kg\u000eZ8x'&TX\r\u000b\u0002I\u0005\")A\n\u0001C\u0001c\u0005!C/Z:u)Vl'\r\\3XS:$wn^,ji\"LeN^1mS\u0012,F-Q4h\u0003J<7\u000f\u000b\u0002L\u0005\")q\n\u0001C\u0001c\u0005\u0011B/Z:u/&tGm\\<Qe>\u001cG/[7fQ\tq%\tC\u0003S\u0001\u0011\u0005\u0011'\u0001\u000euKN$x+\u001b8e_^\fumZ,ji\"<%o\\;q'\u0016$8\u000f\u000b\u0003R\u0005R+\u0016\u0001C3ya\u0016\u001cG/\u001a3$\u0003Y\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\t1\fgn\u001a\u0006\u00027\u0006!!.\u0019<b\u0013\ti\u0006L\u0001\bBgN,'\u000f^5p]\u0016\u0013(o\u001c:\t\u000b}\u0003A\u0011A\u0019\u00029Q,7\u000f\u001e(p\u000fJ|W\u000f]5oOR+XN\u00197j]\u001e<\u0016N\u001c3po\"\u0012aL\u0011\u0005\u0006E\u0002!\t!M\u0001\u001bi\u0016\u001cH\u000fV;nE2LgnZ,j]\u0012|woU8si\u0006;w-\r\u0015\u0003C\nCQ!\u001a\u0001\u0005\u0002E\n!\u0004^3tiR+XN\u00197j]\u001e<\u0016N\u001c3poN{'\u000f^!hOJB#\u0001\u001a\"\t\u000b!\u0004A\u0011A\u0019\u00025Q,7\u000f\u001e+v[\nd\u0017N\\4XS:$wn\u001e%bg\"\fumZ\u0019)\u0005\u001d\u0014\u0005\"B6\u0001\t\u0003\t\u0014A\u0007;fgR$V/\u001c2mS:<w+\u001b8e_^D\u0015m\u001d5BO\u001e\u0014\u0004F\u00016C\u0011\u0015q\u0007\u0001\"\u00012\u0003\u0001\"Xm\u001d;O_:\u0004\u0016M\u001d;ji&|g.\u001a3Uk6\u0014G.\u001b8h/&tGm\\<)\u00055\u0014\u0005\"B9\u0001\t\u0003\t\u0014!\b;fgR\u0004\u0016M\u001d;ji&|g.\u001a3Uk6\u0014G.\u001b8h/&tGm\\<)\u0005A\u0014\u0005\"\u0002;\u0001\t\u0003\t\u0014a\u0007;fgR$V/\u001c2mS:<w+\u001b8e_^<\u0016\u000e\u001e5VI\u0006;w\r\u000b\u0002t\u0005\")q\u000f\u0001C\u0001c\u0005qB/Z:u)Vl'\r\\5oO^Kg\u000eZ8x/&$\b\u000e\u0015:pGRLW.\u001a\u0015\u0003m\nCQA\u001f\u0001\u0005\u0002E\n1\u0004^3ti:{wI]8va&twm\u00157jI&twmV5oI><\bFA=C\u0011\u0015i\b\u0001\"\u00012\u0003e!Xm\u001d;TY&$\u0017N\\4XS:$wn^*peR\fumZ\u0019)\u0005q\u0014\u0005BBA\u0001\u0001\u0011\u0005\u0011'A\ruKN$8\u000b\\5eS:<w+\u001b8e_^\u001cvN\u001d;BO\u001e\u0014\u0004FA@C\u0011\u0019\t9\u0001\u0001C\u0001c\u0005IB/Z:u'2LG-\u001b8h/&tGm\\<T_J$\u0018iZ44Q\r\t)A\u0011\u0005\u0007\u0003\u001b\u0001A\u0011A\u0019\u0002YQ,7\u000f^*mS\u0012LgnZ,j]\u0012|woU8si\u0006;wmV5uQB\u000bg.Z(qi&l\u0017N_1uS>t\u0007fAA\u0006\u0005\"1\u00111\u0003\u0001\u0005\u0002E\n\u0001\u0004^3tiNc\u0017\u000eZ5oO^Kg\u000eZ8x\u0011\u0006\u001c\b.Q4hQ\r\t\tB\u0011\u0005\u0007\u00033\u0001A\u0011A\u0019\u0002?Q,7\u000f\u001e(p]B\u000b'\u000f^5uS>tW\rZ*mS\u0012LgnZ,j]\u0012|w\u000fK\u0002\u0002\u0018\tCa!a\b\u0001\t\u0003\t\u0014\u0001\b;fgR\u0004\u0016M\u001d;ji&|g.\u001a3TY&$\u0017N\\4XS:$wn\u001e\u0015\u0004\u0003;\u0011\u0005BBA\u0013\u0001\u0011\u0005\u0011'A\u000fuKN$8\u000b\\5eS:<w+\u001b8e_^<\u0016\u000e\u001e5Qe>\u001cG/[7fQ\r\t\u0019C\u0011\u0005\u0007\u0003W\u0001A\u0011A\u0019\u0002?Q,7\u000f\u001e(p]B\u000b'\u000f^5uS>tW\rZ*fgNLwN\\,j]\u0012|w\u000fK\u0002\u0002*\tCa!!\r\u0001\t\u0003\t\u0014\u0001\b;fgR\u0004\u0016M\u001d;ji&|g.\u001a3TKN\u001c\u0018n\u001c8XS:$wn\u001e\u0015\u0004\u0003_\u0011\u0005BBA\u001c\u0001\u0011\u0005\u0011'A\u000fuKN$8+Z:tS>tw+\u001b8e_^<\u0016\u000e\u001e5Qe>\u001cG/[7fQ\r\t)D\u0011\u0005\u0007\u0003{\u0001A\u0011A\u0019\u0002#Q,7\u000f^,j]\u0012|w/\u00128e\u001f:d\u0017\u0010K\u0002\u0002<\tCa!a\u0011\u0001\t\u0003\t\u0014\u0001\n;fgR,\u0005\u0010\u001d:fgNLwN\\(o/&tGm\\<ICZLgn\u001a$v]\u000e$\u0018n\u001c8)\u0007\u0005\u0005#\t\u0003\u0004\u0002J\u0001!\t!M\u0001\u001di\u0016\u001cH\u000fR3d_6\u0004xn]1cY\u0016\fum\u001a$v]\u000e$\u0018n\u001c8tQ\r\t9E\u0011\u0005\u0007\u0003\u001f\u0002A\u0011A\u0019\u0002GQ,7\u000f\u001e*fiV\u0014h\u000eV=qK&sg-\u001a:f]\u000e,gi\u001c:XS:$wn^!hO\"\u001a\u0011Q\n\"\t\r\u0005U\u0003\u0001\"\u00012\u0003\u001d\"Xm\u001d;XS:$wn^!hOJ,w-\u0019;f/&$\b\u000eR5gM\u0016\u0014XM\u001c;XS:$wn^:)\u0007\u0005M#\tK\u0004\u0001\u00037\n9'!\u001b\u0011\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u0019<\u0003\u0019\u0011XO\u001c8fe&!\u0011QMA0\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c#!a\u001b\u0011\t\u00055\u00141O\u0007\u0003\u0003_R1!!\u001d<\u0003\u001d\u0011XO\u001c8feNLA!!\u001e\u0002p\ti\u0001+\u0019:b[\u0016$XM]5{K\u0012<q!!\u001f\u0003\u0011\u0003\tY(A\bHe>,\boV5oI><H+Z:u!\r)\u0013Q\u0010\u0004\u0007\u0003\tA\t!a \u0014\t\u0005u\u0014\u0011\u0011\t\u0004g\u0005\r\u0015bAACi\t1\u0011I\\=SK\u001aDqAIA?\t\u0003\tI\t\u0006\u0002\u0002|!A\u0011QRA?\t\u0003\ty)\u0001\u0006qCJ\fW.\u001a;feN$\"!!%\u0011\u000b\u0005M\u0015q\u0013\u0010\u000e\u0005\u0005U%B\u0001\u0015[\u0013\u0011\tI*!&\u0003\u0015\r{G\u000e\\3di&|g\u000e\u000b\u0005\u0002\f\u0006u\u00151VAW!\u0011\ty*!*\u000f\t\u00055\u0014\u0011U\u0005\u0005\u0003G\u000by'A\u0007QCJ\fW.\u001a;fe&TX\rZ\u0005\u0005\u0003O\u000bIK\u0001\u0006QCJ\fW.\u001a;feNTA!a)\u0002p\u0005!a.Y7fC\t\ty+A\bbO\u001e\u001cFO]1uK\u001eLXh\u001f\u0019~\u0001")
public class GroupWindowTest
extends TableTestBase {
    private final AggregatePhaseStrategy aggStrategy;
    private final BatchTableTestUtil util;

    @Parameterized.Parameters(name="aggStrategy={0}")
    public static Collection<AggregatePhaseStrategy> parameters() {
        return GroupWindowTest$.MODULE$.parameters();
    }

    private BatchTableTestUtil util() {
        return this.util;
    }

    @Before
    public void before() {
        this.util().tableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_AGG_PHASE_STRATEGY, (Object)this.aggStrategy.toString());
        .colon.colon fields = new .colon.colon((Object)BasicTypeInfo.getInfoFor(Long.class), (List)Nil$.MODULE$);
        Class<CountAccumulator> clazz = CountAccumulator.class;
        this.util().addFunction("countFun", new CountAggFunction(), BasicTypeInfo.getInfoFor(Long.class), new TupleTypeInfo(clazz, (TypeInformation[])fields.toArray(ClassTag$.MODULE$.apply(BasicTypeInfo.class))));
        this.util().addTableSource("MyTable", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d"))}), new CaseClassTypeInfo<Tuple4<Object, Timestamp, Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$4 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Object, Timestamp, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Object, Timestamp, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple4<Object, Timestamp, Object, Object>>(this, fieldSerializers){

                    public Tuple4<Object, Timestamp, Object, Object> createInstance(Object[] fields) {
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)((Timestamp)fields[1]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.planner.plan.batch.sql.agg.GroupWindowTest$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable1", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c"))}), new CaseClassTypeInfo<Tuple4<Timestamp, Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple4<Timestamp, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple4<Timestamp, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple4<Timestamp, Object, Object, String>>(this, fieldSerializers){

                    public Tuple4<Timestamp, Object, Object, String> createInstance(Object[] fields) {
                        return new Tuple4((Object)((Timestamp)fields[0]), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[2])), (Object)((String)fields[3]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.table.planner.plan.batch.sql.agg.GroupWindowTest$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().addTableSource("MyTable2", (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "a")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "b")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "c")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "d")), package$.MODULE$.symbol2FieldExpression((Symbol)SymbolLiteral.bootstrap("apply", "ts"))}), new CaseClassTypeInfo<Tuple5<Object, Object, String, Object, Timestamp>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple5<Object, Object, String, Object, Timestamp>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$3[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Timestamp>> unused = new ScalaCaseClassSerializer<Tuple5<Object, Object, String, Object, Timestamp>>(this, fieldSerializers){

                    public Tuple5<Object, Object, String, Object, Timestamp> createInstance(Object[] fields) {
                        return new Tuple5((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (Object)((String)fields[2]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[3])), (Object)((Timestamp)fields[4]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$3(org.apache.flink.table.planner.plan.batch.sql.agg.GroupWindowTest$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
        this.util().tableEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString("\n                                |create table MyTable3 (\n                                |  a int,\n                                |  b bigint,\n                                |  c as proctime()\n                                |) with (\n                                |  'connector' = 'COLLECTION'\n                                |)\n                                |")).stripMargin());
    }

    @Test
    public void testHopWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable2 GROUP BY HOP(ts, INTERVAL '1' HOUR, INTERVAL '2' HOUR, TIME '10:00:00')";
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("HOP window with alignment is not supported yet.");
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSessionWindowNoOffset() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable2 GROUP BY SESSION(ts, INTERVAL '2' HOUR, TIME '10:00:00')";
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("SESSION window with alignment is not supported yet.");
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testVariableWindowSize() {
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Only constant window descriptors are supported");
        this.util().verifyExecPlan("SELECT COUNT(*) FROM MyTable2 GROUP BY TUMBLE(ts, b * INTERVAL '1' MINUTE)");
    }

    @Test
    public void testTumbleWindowWithInvalidUdAggArgs() {
        JavaUserDefinedAggFunctions.WeightedAvgWithMerge weightedAvg = new JavaUserDefinedAggFunctions.WeightedAvgWithMerge();
        this.util().addFunction("weightedAvg", weightedAvg, BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class));
        String sql = "SELECT weightedAvg(c, a) AS wAvg FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE)";
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("SQL validation failed. Given parameters of function 'weightedAvg' do not match any signature.");
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowProctime() {
        String sqlQuery = "SELECT TUMBLE_PROCTIME(ts, INTERVAL '4' MINUTE) FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE), c";
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("PROCTIME window property is not supported in batch queries.");
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test(expected=AssertionError.class)
    public void testWindowAggWithGroupSets() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    TUMBLE_END(ts, INTERVAL '15' MINUTE) + INTERVAL '1' MINUTE\n        |FROM MyTable1\n        |    GROUP BY rollup(TUMBLE(ts, INTERVAL '15' MINUTE), b)\n    ")).stripMargin();
        this.util().verifyRelPlanNotExpected(sql, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TUMBLE(ts"}));
    }

    @Test
    public void testNoGroupingTumblingWindow() {
        String sqlQuery = "SELECT AVG(c), SUM(a) FROM MyTable GROUP BY TUMBLE(b, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testTumblingWindowSortAgg1() {
        String sqlQuery = "SELECT MAX(c) FROM MyTable1 GROUP BY a, TUMBLE(ts, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testTumblingWindowSortAgg2() {
        String sqlQuery = "SELECT AVG(c), countFun(a) FROM MyTable GROUP BY a, d, TUMBLE(b, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testTumblingWindowHashAgg1() {
        String sqlQuery = "SELECT COUNT(c) FROM MyTable1 GROUP BY a, TUMBLE(ts, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testTumblingWindowHashAgg2() {
        String sql = "SELECT AVG(c), COUNT(a) FROM MyTable GROUP BY a, d, TUMBLE(b, INTERVAL '3' SECOND)";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testNonPartitionedTumblingWindow() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '2' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testPartitionedTumblingWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TUMBLE_START(ts, INTERVAL '4' MINUTE),\n        |    TUMBLE_END(ts, INTERVAL '4' MINUTE),\n        |    TUMBLE_ROWTIME(ts, INTERVAL '4' MINUTE),\n        |    c,\n        |    SUM(a) AS sumA,\n        |    MIN(b) AS minB\n        |FROM MyTable2\n        |    GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE), c\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testTumblingWindowWithUdAgg() {
        this.util().addFunction("weightedAvg", new JavaUserDefinedAggFunctions.WeightedAvgWithMerge(), BasicTypeInfo.getInfoFor(Long.class), TypeExtractor.createTypeInfo(JavaUserDefinedAggFunctions.WeightedAvgAccum.class));
        String sql = "SELECT weightedAvg(b, a) AS wAvg FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE)";
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testTumblingWindowWithProctime() {
        String sql = "select sum(a), max(b) from MyTable3 group by TUMBLE(c, INTERVAL '1' SECOND)";
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Window can not be defined over a proctime attribute column for batch mode");
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testNoGroupingSlidingWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT SUM(a),\n        |    HOP_START(b, INTERVAL '3' SECOND, INTERVAL '3' SECOND),\n        |    HOP_END(b, INTERVAL '3' SECOND, INTERVAL '3' SECOND)\n        |FROM MyTable\n        |    GROUP BY HOP(b, INTERVAL '3' SECOND, INTERVAL '3' SECOND)\n      ")).stripMargin();
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSlidingWindowSortAgg1() {
        String sqlQuery = "SELECT MAX(c) FROM MyTable1 GROUP BY a, HOP(ts, INTERVAL '3' SECOND, INTERVAL '1' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSlidingWindowSortAgg2() {
        String sqlQuery = "SELECT MAX(c) FROM MyTable1 GROUP BY b, HOP(ts, INTERVAL '0.111' SECOND(1,3), INTERVAL '1' SECOND)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSlidingWindowSortAgg3() {
        String sqlQuery = "SELECT countFun(c) FROM MyTable  GROUP BY a, d, HOP(b, INTERVAL '3' SECOND, INTERVAL '1' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSlidingWindowSortAggWithPaneOptimization() {
        String sqlQuery = "SELECT COUNT(c) FROM MyTable1 GROUP BY a, HOP(ts, INTERVAL '3' SECOND, INTERVAL '1' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSlidingWindowHashAgg() {
        String sqlQuery = "SELECT count(c) FROM MyTable1 GROUP BY b, HOP(ts, INTERVAL '3' SECOND, INTERVAL '1' HOUR)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testNonPartitionedSlidingWindow() {
        String sqlQuery = "SELECT SUM(a) AS sumA, COUNT(b) AS cntB FROM MyTable2 GROUP BY HOP(ts, INTERVAL '15' MINUTE, INTERVAL '90' MINUTE)";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testPartitionedSlidingWindow() {
        String sqlQuery = "SELECT   c,   HOP_END(ts, INTERVAL '1' HOUR, INTERVAL '3' HOUR),   HOP_START(ts, INTERVAL '1' HOUR, INTERVAL '3' HOUR),   HOP_ROWTIME(ts, INTERVAL '1' HOUR, INTERVAL '3' HOUR),   SUM(a) AS sumA,   AVG(b) AS avgB FROM MyTable2 GROUP BY HOP(ts, INTERVAL '1' HOUR, INTERVAL '3' HOUR), d, c";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSlidingWindowWithProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select sum(a), max(b)\n         |from MyTable3\n         |group by HOP(c, INTERVAL '1' SECOND, INTERVAL '1' MINUTE)\n         |")).stripMargin();
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Window can not be defined over a proctime attribute column for batch mode");
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testNonPartitionedSessionWindow() {
        String sqlQuery = "SELECT COUNT(*) AS cnt FROM MyTable2 GROUP BY SESSION(ts, INTERVAL '30' MINUTE)";
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Cannot generate a valid execution plan for the given query");
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testPartitionedSessionWindow() {
        String sqlQuery = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT c, d,\n        |    SESSION_START(ts, INTERVAL '12' HOUR),\n        |    SESSION_END(ts, INTERVAL '12' HOUR),\n        |    SESSION_ROWTIME(ts, INTERVAL '12' HOUR),\n        |    SUM(a) AS sumA,\n        |    MIN(b) AS minB\n        |FROM MyTable2\n        |    GROUP BY SESSION(ts, INTERVAL '12' HOUR), c, d\n      ")).stripMargin();
        this.expectedException().expect(TableException.class);
        this.expectedException().expectMessage("Cannot generate a valid execution plan for the given query");
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testSessionWindowWithProctime() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |select sum(a), max(b)\n         |from MyTable3\n         |group by SESSION(c, INTERVAL '1' MINUTE)\n         |")).stripMargin();
        this.expectedException().expect(ValidationException.class);
        this.expectedException().expectMessage("Window can not be defined over a proctime attribute column for batch mode");
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowEndOnly() {
        String sqlQuery = "SELECT TUMBLE_END(ts, INTERVAL '4' MINUTE) FROM MyTable2 GROUP BY TUMBLE(ts, INTERVAL '4' MINUTE), c";
        this.util().verifyExecPlan(sqlQuery);
    }

    @Test
    public void testExpressionOnWindowHavingFunction() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT COUNT(*),\n        |    HOP_START(ts, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)\n        |FROM MyTable2\n        |    GROUP BY HOP(ts, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)\n        |    HAVING\n        |     SUM(a) > 0 AND\n        |     QUARTER(HOP_START(ts, INTERVAL '15' MINUTE, INTERVAL '1' MINUTE)) = 1\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testDecomposableAggFunctions() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT VAR_POP(b),\n        |    VAR_SAMP(b),\n        |    STDDEV_POP(b),\n        |    STDDEV_SAMP(b),\n        |    TUMBLE_START(ts, INTERVAL '15' MINUTE),\n        |    TUMBLE_END(ts, INTERVAL '15' MINUTE)\n        |FROM MyTable1\n        |    GROUP BY TUMBLE(ts, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testReturnTypeInferenceForWindowAgg() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  SUM(correct) AS s,\n        |  AVG(correct) AS a,\n        |  TUMBLE_START(b, INTERVAL '15' MINUTE) AS wStart\n        |FROM (\n        |  SELECT CASE a\n        |      WHEN 1 THEN 1\n        |      ELSE 99\n        |    END AS correct, b\n        |  FROM MyTable\n        |)\n        |GROUP BY TUMBLE(b, INTERVAL '15' MINUTE)\n      ")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    @Test
    public void testWindowAggregateWithDifferentWindows() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n        |WITH window_1h AS (\n        |    SELECT 1\n        |    FROM MyTable2\n        |    GROUP BY HOP(`ts`, INTERVAL '1' HOUR, INTERVAL '1' HOUR)\n        |),\n        |\n        |window_2h AS (\n        |    SELECT 1\n        |    FROM MyTable2\n        |    GROUP BY HOP(`ts`, INTERVAL '1' HOUR, INTERVAL '2' HOUR)\n        |)\n        |\n        |(SELECT * FROM window_1h)\n        |UNION ALL\n        |(SELECT * FROM window_2h)\n        |")).stripMargin();
        this.util().verifyExecPlan(sql);
    }

    public GroupWindowTest(AggregatePhaseStrategy aggStrategy) {
        this.aggStrategy = aggStrategy;
        this.util = this.batchTestUtil(this.batchTestUtil$default$1());
    }
}

