/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import org.apache.flink.table.planner.runtime.utils.JavaUserDefinedScalarFunctions;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Before;
import org.junit.Test;

public abstract class CalcMergeTestBase
extends TableTestBase {
    private TableTestUtil util;

    protected abstract boolean isBatchMode();

    protected abstract TableTestUtil getTableTestUtil();

    @Before
    public void setup() {
        this.util = this.getTableTestUtil();
        this.util.tableEnv().executeSql("CREATE TABLE MyTable (\n a INTEGER,\n b INTEGER,\n c VARCHAR\n) WITH (\n 'connector' = 'values'\n ,'bounded' = '" + this.isBatchMode() + "'\n)");
        this.util.addFunction("random_udf", new JavaUserDefinedScalarFunctions.NonDeterministicUdf());
    }

    @Test
    public void testCalcMergeWithSameDigest() {
        this.util.verifyExecPlan("SELECT a, b FROM (SELECT * FROM MyTable WHERE a = b) t WHERE b = a");
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr1() {
        this.util.verifyExecPlan("SELECT a, a1 FROM (SELECT a, random_udf(a) AS a1 FROM MyTable) t WHERE a1 > 10");
    }

    @Test
    public void testCalcMergeWithNonDeterministicExpr2() {
        this.util.verifyExecPlan("SELECT random_udf(a1) as a2 FROM (SELECT random_udf(a) as a1, b FROM MyTable) t WHERE b > 10");
    }

    @Test
    public void testCalcMergeWithTopMultiNonDeterministicExpr() {
        this.util.verifyExecPlan("SELECT random_udf(a1) as a2, random_udf(a1) as a3 FROM (SELECT random_udf(a) as a1, b FROM MyTable) t WHERE b > 10");
    }

    @Test
    public void testCalcMergeTopFilterHasNonDeterministicExpr() {
        this.util.verifyExecPlan("SELECT a, c FROM (SELECT a, random_udf(b) as b1, c FROM MyTable) t WHERE b1 > 10");
    }

    @Test
    public void testCalcMergeWithBottomMultiNonDeterministicExpr() {
        this.util.verifyExecPlan("SELECT a1, b2 FROM (SELECT random_udf(a) as a1, random_udf(b) as b2, c FROM MyTable) t WHERE c > 10");
    }

    @Test
    public void testCalcMergeWithBottomMultiNonDeterministicInConditionExpr() {
        this.util.verifyExecPlan("SELECT c FROM (SELECT random_udf(a) as a1, random_udf(b) as b2, c FROM MyTable) t WHERE a1 > b2");
    }

    @Test
    public void testCalcMergeWithoutInnerNonDeterministicExpr() {
        this.util.verifyExecPlan("SELECT a, c FROM (SELECT a, random_udf(a) as a1, c FROM MyTable) t WHERE c > 10");
    }

    @Test
    public void testCalcMergeWithNonDeterministicNestedExpr() {
        this.util.verifyExecPlan("SELECT a, a1 FROM (SELECT a, substr(cast(random_udf(a) as varchar), 1, 2) AS a1 FROM MyTable) t WHERE a1 > '10'");
    }
}

