/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.common;

import java.util.Collection;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.plan.common.JoinReorderTestBase$;
import org.apache.flink.table.planner.plan.rules.logical.JoinDeriveNullFilterRule$;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.utils.TableTestBase;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mc!B\u0001\u0003\u0003\u0003\t\"a\u0005&pS:\u0014Vm\u001c:eKJ$Vm\u001d;CCN,'BA\u0002\u0005\u0003\u0019\u0019w.\\7p]*\u0011QAB\u0001\u0005a2\fgN\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u0015!\u0018M\u00197f\u0015\tYA\"A\u0003gY&t7N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ!!\u0006\u0004\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"!\u0004+bE2,G+Z:u\u0005\u0006\u001cX\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003II7OQ;tQfTu.\u001b8SK>\u0014H-\u001a:\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f\t{w\u000e\\3b]\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u0013\u0011\u0005\u0011\u0002Q\"\u0001\u0002\t\u000be\u0001\u0003\u0019\u0001\u000e\t\u000f\u001d\u0002!\u0019!C\tQ\u0005!Q\u000f^5m+\u0005I\u0003CA\n+\u0013\tYCCA\u0007UC\ndW\rV3tiV#\u0018\u000e\u001c\u0005\u0007[\u0001\u0001\u000b\u0011B\u0015\u0002\u000bU$\u0018\u000e\u001c\u0011\t\u000b=\u0002a\u0011\u0003\u0015\u0002!\u001d,G\u000fV1cY\u0016$Vm\u001d;Vi&d\u0007\"B\u0019\u0001\t\u0003\u0011\u0014!B:fiV\u0004H#A\u001a\u0011\u0005m!\u0014BA\u001b\u001d\u0005\u0011)f.\u001b;)\u0005A:\u0004C\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u000f\u0003\u0015QWO\\5u\u0013\ta\u0014H\u0001\u0004CK\u001a|'/\u001a\u0005\u0006}\u0001!\tAM\u0001\u0017i\u0016\u001cHo\u0015;be*{\u0017N\\\"p]\u0012LG/[8oc!\u0012Q\b\u0011\t\u0003q\u0005K!AQ\u001d\u0003\tQ+7\u000f\u001e\u0005\u0006\t\u0002!\tAM\u0001\u0017i\u0016\u001cHo\u0015;be*{\u0017N\\\"p]\u0012LG/[8oe!\u00121\t\u0011\u0005\u0006\u000f\u0002!\tAM\u0001\u0018i\u0016\u001cHOQ;tQfTu.\u001b8D_:$\u0017\u000e^5p]FB#A\u0012!\t\u000b)\u0003A\u0011\u0001\u001a\u0002/Q,7\u000f\u001e\"vg\"L(j\\5o\u0007>tG-\u001b;j_:\u0014\u0004FA%A\u0011\u0015i\u0005\u0001\"\u00013\u0003Y!Xm\u001d;XSRDw.\u001e;D_2,XN\\*uCR\u001c\bF\u0001'A\u0011\u0015\u0001\u0006\u0001\"\u00013\u0003M!Xm\u001d;K_&tw+\u001b;i!J|'.Z2uQ\ty\u0005\tC\u0003T\u0001\u0011\u0005!'\u0001\nuKN$(j\\5o/&$\bNR5mi\u0016\u0014\bF\u0001*A\u0011\u00151\u0006\u0001\"\u00013\u0003A!Xm\u001d;BY2LeN\\3s\u0015>Lg\u000e\u000b\u0002V\u0001\")\u0011\f\u0001C\u0001e\u0005IB/Z:u\u0013:tWM]!oI2+g\r^(vi\u0016\u0014(j\\5oQ\tA\u0006\tC\u0003]\u0001\u0011\u0005!'\u0001\u000euKN$\u0018J\u001c8fe\u0006sGMU5hQR|U\u000f^3s\u0015>Lg\u000e\u000b\u0002\\\u0001\")q\f\u0001C\u0001e\u0005IB/Z:u\u0013:tWM]!oI\u001a+H\u000e\\(vi\u0016\u0014(j\\5oQ\tq\u0006\tC\u0003c\u0001\u0011\u0005!'\u0001\u000buKN$\u0018\t\u001c7MK\u001a$x*\u001e;fe*{\u0017N\u001c\u0015\u0003C\u0002CQ!\u001a\u0001\u0005\u0002I\nQ\u0003^3ti\u0006cGNU5hQR|U\u000f^3s\u0015>Lg\u000e\u000b\u0002e\u0001\")\u0001\u000e\u0001C\u0001e\u0005!B/Z:u\u00032dg)\u001e7m\u001fV$XM\u001d&pS:D#a\u001a!\t\u000b-\u0004A\u0011\u0001\u001a\u0002aQ,7\u000f^%o]\u0016\u0014(j\\5o\u0019\u00164GoT;uKJTu.\u001b8J]:,'OS8j]2+g\r^(vi\u0016\u0014(j\\5oQ\tQ\u0007\tC\u0003o\u0001\u0011\u0005!'\u0001\u0019uKN$H*\u001a4u\u001fV$XM\u001d&pS:LeN\\3s\u0015>Lg\u000eT3gi>+H/\u001a:K_&t\u0017J\u001c8fe*{\u0017N\u001c\u0015\u0003[\u0002CQ!\u001d\u0001\u0005\u0002I\n!\u0007^3ti&sg.\u001a:K_&t'+[4ii>+H/\u001a:K_&t\u0017J\u001c8fe*{\u0017N\u001c*jO\"$x*\u001e;fe*{\u0017N\u001c\u0015\u0003a\u0002CQ\u0001\u001e\u0001\u0005\u0002I\n!\u0007^3tiJKw\r\u001b;PkR,'OS8j]&sg.\u001a:K_&t'+[4ii>+H/\u001a:K_&t\u0017J\u001c8fe*{\u0017N\u001c\u0015\u0003g\u0002CQa\u001e\u0001\u0005\u0002I\nQ\u0003^3ti&sg.\u001a:K_&t7+Z7j\u0015>Lg\u000e\u000b\u0002w\u0001\")!\u0010\u0001C\u0001e\u0005)B/Z:u\u0013:tWM\u001d&pS:\fe\u000e^5K_&t\u0007FA=A\u0011\u0015i\b\u0001\"\u00013\u00035!Xm\u001d;De>\u001c8OS8j]\"\u0012A\u0010\u0011\u0005\u0007\u0003\u0003\u0001A\u0011\u0001\u001a\u0002-Q,7\u000f^%o]\u0016\u0014(j\\5o\u0007J|7o\u001d&pS:D#a !\t\r\u0005\u001d\u0001\u0001\"\u00013\u0003\r\"Xm\u001d;J]:,'OS8j]2+g\r^(vi\u0016\u0014(j\\5o\u0007J|7o\u001d&pS:D3!!\u0002A\u0011\u0019\ti\u0001\u0001C\u0001e\u00059C/Z:u\u0013:tWM\u001d&pS:<\u0016\u000e\u001e5CkND\u0017\u0010V=qK*{\u0017N\\\"p]\u0012LG/[8oQ\r\tY\u0001\u0011\u0005\u0007\u0003'\u0001A\u0011\u0001\u001a\u0002IQ,7\u000f\u001e#fe&4XMT;mY\u001aKG\u000e^3s\u0003\u001a$XM\u001d&pS:\u0014Vm\u001c:eKJD3!!\u0005A\u000f\u001d\tIB\u0001E\u0001\u00037\t1CS8j]J+wN\u001d3feR+7\u000f\u001e\"bg\u0016\u00042\u0001JA\u000f\r\u0019\t!\u0001#\u0001\u0002 M!\u0011QDA\u0011!\rY\u00121E\u0005\u0004\u0003Ka\"AB!osJ+g\rC\u0004\"\u0003;!\t!!\u000b\u0015\u0005\u0005m\u0001\u0002CA\u0017\u0003;!\t!a\f\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0006\u0002\u00022A)\u00111GA\u001e55\u0011\u0011Q\u0007\u0006\u0004O\u0005]\"BAA\u001d\u0003\u0011Q\u0017M^1\n\t\u0005u\u0012Q\u0007\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0006CA\u0016\u0003\u0003\n)&a\u0016\u0011\t\u0005\r\u0013q\n\b\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)\u0019\u0011\u0011J\u001d\u0002\u000fI,hN\\3sg&!\u0011QJA$\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!\u0011\u0011KA*\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0005\u0003\u001b\n9%\u0001\u0003oC6,\u0017EAA-\u0003YI7OQ;tQfTu.\u001b8SK>\u0014H-\u001a:>wBj\b")
public abstract class JoinReorderTestBase
extends TableTestBase {
    private final boolean isBushyJoinReorder;
    private final TableTestUtil util;

    @Parameterized.Parameters(name="isBushyJoinReorder={0}")
    public static Collection<Object> parameters() {
        return JoinReorderTestBase$.MODULE$.parameters();
    }

    public TableTestUtil util() {
        return this.util;
    }

    public abstract TableTestUtil getTableTestUtil();

    @Before
    public void setup() {
        TypeInformation[] types = (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG(), Types.STRING()});
        this.util().addTableSource("T1", types, (String[])((Object[])new String[]{"a1", "b1", "c1"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a1"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(1000000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b1"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(50L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T2", types, (String[])((Object[])new String[]{"a2", "b2", "c2"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(10000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a2"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(100L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b2"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(500000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T3", types, (String[])((Object[])new String[]{"a3", "b3", "c3"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(1000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a3"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b3"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(50L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T4", types, (String[])((Object[])new String[]{"a4", "b4", "c4"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(100L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a4"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(100L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b4"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(500000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().addTableSource("T5", types, (String[])((Object[])new String[]{"a5", "b5", "c5"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(500000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a5"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(200000L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(4.0), Predef$.MODULE$.int2Integer(4), null, null)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b5"), (Object)new ColumnStats(Predef$.MODULE$.long2Long(200L), Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.double2Double(8.0), Predef$.MODULE$.int2Integer(8), null, null))}))))).build());
        this.util().getTableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_JOIN_REORDER_ENABLED, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (!this.isBushyJoinReorder) {
            this.util().getTableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BUSHY_JOIN_REORDER_THRESHOLD, (Object)3);
        } else {
            this.util().getTableEnv().getConfig().set(OptimizerConfigOptions.TABLE_OPTIMIZER_BUSHY_JOIN_REORDER_THRESHOLD, (Object)1000);
        }
    }

    @Test
    public void testStarJoinCondition1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE a1 = a2 AND a1 = a3 AND a1 = a4 AND a1 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testStarJoinCondition2() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE b1 = b2 AND b1 = b3 AND b1 = b4 AND b1 = b5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testBushyJoinCondition1() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE a1 = a2 AND a2 = a3 AND a1 = a4 AND a3 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testBushyJoinCondition2() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE b1 = b2 AND b2 = b3 AND b1 = b4 AND b3 = b5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testWithoutColumnStats() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1, T2, T3, T4, T5\n         |WHERE c1 = c2 AND c1 = c3 AND c2 = c4 AND c1 = c5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testJoinWithProject() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |WITH V1 AS (SELECT b1, a1, a2, c2 FROM T1 JOIN T2 ON a1 = a2),\n         |     V2 AS (SELECT a3, b1, a1, c2, c3 FROM V1 JOIN T3 ON a2 = a3),\n         |     V3 AS (SELECT a3, b1, a1, c2, c3, a4, b4 FROM T4 JOIN V2 ON a1 = a4)\n         |\n         |SELECT * FROM V3, T5 where a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testJoinWithFilter() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |WITH V1 AS (SELECT * FROM T1 JOIN T2 ON a1 = a2 WHERE b1 * b2 > 10),\n         |     V2 AS (SELECT * FROM V1 JOIN T3 ON a2 = a3 WHERE b1 * b3 < 2000),\n         |     V3 AS (SELECT * FROM T4 JOIN V2 ON a3 = a4 WHERE b2 + b4 > 100)\n         |\n         |SELECT * FROM V3, T5 WHERE a4 = a5 AND b5 < 15\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testAllInnerJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a2 = a4\n         |   JOIN T5 ON a1 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testInnerAndLeftOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   LEFT OUTER JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a1 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testInnerAndRightOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   RIGHT OUTER JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a2 = a4\n         |   JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testInnerAndFullOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   FULL OUTER JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testAllLeftOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   LEFT OUTER JOIN T2 ON a1 = a2\n         |   LEFT OUTER JOIN T3 ON a1 = a3\n         |   LEFT OUTER JOIN T4 ON a1 = a4\n         |   LEFT OUTER JOIN T5 ON a1 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testAllRightOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   RIGHT OUTER JOIN T2 ON a1 = a2\n         |   RIGHT OUTER JOIN T3 ON a2 = a3\n         |   RIGHT OUTER JOIN T4 ON a1 = a4\n         |   RIGHT OUTER JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testAllFullOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   FULL OUTER JOIN T2 ON a1 = a2\n         |   FULL OUTER JOIN T3 ON a1 = a3\n         |   FULL OUTER JOIN T4 ON a1 = a4\n         |   FULL OUTER JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testInnerJoinLeftOuterJoinInnerJoinLeftOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   LEFT OUTER JOIN T3 ON a1 = a3\n         |   JOIN T4 ON a1 = a4\n         |   LEFT OUTER JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testLeftOuterJoinInnerJoinLeftOuterJoinInnerJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   LEFT OUTER JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a1 = a3\n         |   LEFT OUTER JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testInnerJoinRightOuterJoinInnerJoinRightOuterJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   RIGHT OUTER JOIN T3 ON a1 = a3\n         |   JOIN T4 ON a1 = a4\n         |   RIGHT OUTER JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testRightOuterJoinInnerJoinRightOuterJoinInnerJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   RIGHT OUTER JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a1 = a3\n         |   RIGHT OUTER JOIN T4 ON a1 = a4\n         |   JOIN T5 ON a4 = a5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testInnerJoinSemiJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a1 = a4\n         |   WHERE a1 IN (SELECT a5 FROM T5)\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testInnerJoinAntiJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1\n         |   JOIN T2 ON a1 = a2\n         |   JOIN T3 ON a2 = a3\n         |   JOIN T4 ON a1 = a4\n         |   WHERE NOT EXISTS (SELECT a5 FROM T5 WHERE a1 = a5)\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testCrossJoin() {
        String sql = "SELECT * FROM T1, T2, T3, T4, T5";
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testInnerJoinCrossJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1,\n         |   (SELECT * FROM T2 JOIN T3 ON a2 = a3) tab1, T4\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testInnerJoinLeftOuterJoinCrossJoin() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T1,\n         |   (SELECT * FROM T2 LEFT JOIN T3 ON a2 = a3 JOIN T4 ON a2 = a4) tab1, T5\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testInnerJoinWithBushyTypeJoinCondition() {
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM\n         |(SELECT * FROM T1 JOIN T2 ON T1.b1 = T2.b2) tab1 JOIN\n         |(SELECT * FROM T3 JOIN T4 ON T3.b3 = T4.b4) tab2\n         |ON tab1.b2 = tab2.b4\n         ")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    @Test
    public void testDeriveNullFilterAfterJoinReorder() {
        TypeInformation[] types = (TypeInformation[])((Object[])new TypeInformation[]{Types.INT(), Types.LONG()});
        ColumnStats.Builder builderA = ColumnStats.Builder.builder().setNdv(Predef$.MODULE$.long2Long(200000L)).setNullCount(Predef$.MODULE$.long2Long(50000L)).setAvgLen(Predef$.MODULE$.double2Double(4.0)).setMaxLen(Predef$.MODULE$.int2Integer(4));
        ColumnStats.Builder builderB = ColumnStats.Builder.builder().setNdv(Predef$.MODULE$.long2Long(100000L)).setNullCount(Predef$.MODULE$.long2Long(0L)).setAvgLen(Predef$.MODULE$.double2Double(8.0)).setMaxLen(Predef$.MODULE$.int2Integer(8));
        this.util().addTableSource("T6", types, (String[])((Object[])new String[]{"a6", "b6"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(500000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a6"), (Object)builderA.build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b6"), (Object)builderB.build())}))))).build());
        this.util().addTableSource("T7", types, (String[])((Object[])new String[]{"a7", "b7"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(500000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a7"), (Object)builderA.build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b7"), (Object)builderB.build())}))))).build());
        this.util().addTableSource("T8", types, (String[])((Object[])new String[]{"a8", "b8"}), FlinkStatistic$.MODULE$.builder().tableStats(new TableStats(500000L, JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a8"), (Object)builderA.build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b8"), (Object)builderB.build())}))))).build());
        this.util().getTableEnv().getConfig().set(JoinDeriveNullFilterRule$.MODULE$.TABLE_OPTIMIZER_JOIN_NULL_FILTER_THRESHOLD(), (Object)BoxesRunTime.boxToLong((long)10000L));
        String sql = new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT * FROM T6\n         |   INNER JOIN T7 ON b6 = b7\n         |   INNER JOIN T8 ON a6 = a8\n         |")).stripMargin();
        this.util().verifyRelPlan(sql);
    }

    public JoinReorderTestBase(boolean isBushyJoinReorder) {
        this.isBushyJoinReorder = isBushyJoinReorder;
        this.util = this.getTableTestUtil();
    }
}

