/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.metadata;

import java.io.Serializable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMdHandlerTestBase;
import org.apache.flink.table.planner.plan.nodes.calcite.Expand;
import org.apache.flink.table.planner.plan.nodes.calcite.Rank;
import org.apache.flink.table.planner.plan.nodes.common.CommonCalc;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalRank;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil$;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001#\tqb\t\\5oWJ+G.\u00143ESN$\u0018N\\2u%><8i\\;oiR+7\u000f\u001e\u0006\u0003\u0007\u0011\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003\u000b\u0019\tA\u0001\u001d7b]*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!!\u0007$mS:\\'+\u001a7NI\"\u000bg\u000e\u001a7feR+7\u000f\u001e\"bg\u0016DQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005M\u0001\u0001\"B\u000e\u0001\t\u0003a\u0012A\t;fgR<U\r\u001e#jgRLgn\u0019;S_^\u001cu.\u001e8u\u001f:$\u0016M\u00197f'\u000e\fg\u000eF\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0011)f.\u001b;)\u0005i!\u0003CA\u0013)\u001b\u00051#BA\u0014\u000f\u0003\u0015QWO\\5u\u0013\tIcE\u0001\u0003UKN$\b\"B\u0016\u0001\t\u0003a\u0012a\b;fgR<U\r\u001e#jgRLgn\u0019;S_^\u001cu.\u001e8u\u001f:4\u0016\r\\;fg\"\u0012!\u0006\n\u0005\u0006]\u0001!\t\u0001H\u0001!i\u0016\u001cHoR3u\t&\u001cH/\u001b8diJ{woQ8v]R|e\u000e\u0015:pU\u0016\u001cG\u000f\u000b\u0002.I!)\u0011\u0007\u0001C\u00019\u0005yB/Z:u\u000f\u0016$H)[:uS:\u001cGOU8x\u0007>,h\u000e^(o\r&dG/\u001a:)\u0005A\"\u0003\"\u0002\u001b\u0001\t\u0003a\u0012!\b;fgR<U\r\u001e#jgRLgn\u0019;S_^\u001cu.\u001e8u\u001f:\u001c\u0015\r\\2)\u0005M\"\u0003\"B\u001c\u0001\t\u0003a\u0012a\b;fgR<U\r\u001e#jgRLgn\u0019;S_^\u001cu.\u001e8u\u001f:,\u0005\u0010]1oI\"\u0012a\u0007\n\u0005\u0006u\u0001!\t\u0001H\u0001\"i\u0016\u001cHoR3u\t&\u001cH/\u001b8diJ{woQ8v]R|e.\u0012=dQ\u0006tw-\u001a\u0015\u0003s\u0011BQ!\u0010\u0001\u0005\u0002q\tQ\u0004^3ti\u001e+G\u000fR5ti&t7\r\u001e*po\u000e{WO\u001c;P]J\u000bgn\u001b\u0015\u0003y\u0011BQ\u0001\u0011\u0001\u0005\u0002q\tQ\u0004^3ti\u001e+G\u000fR5ti&t7\r\u001e*po\u000e{WO\u001c;P]N{'\u000f\u001e\u0015\u0003\u007f\u0011BQa\u0011\u0001\u0005\u0002q\t\u0011\u0005^3ti\u001e+G\u000fR5ti&t7\r\u001e*po\u000e{WO\u001c;P]\u0006;wM]3bi\u0016D#A\u0011\u0013\t\u000b\u0019\u0003A\u0011\u0001\u000f\u0002EQ,7\u000f^$fi\u0012K7\u000f^5oGR\u0014vn^\"pk:$xJ\\,j]\u0012|w/Q4hQ\t)E\u0005C\u0003J\u0001\u0011\u0005A$\u0001\u0011uKN$x)\u001a;ESN$\u0018N\\2u%><8i\\;oi>swJ^3s\u0003\u001e<\u0007F\u0001%%\u0011\u0015a\u0005\u0001\"\u0001\u001d\u0003u!Xm\u001d;HKR$\u0015n\u001d;j]\u000e$(k\\<D_VtGo\u00148K_&t\u0007FA&%\u0011\u0015y\u0005\u0001\"\u0001\u001d\u0003y!Xm\u001d;HKR$\u0015n\u001d;j]\u000e$(k\\<D_VtGo\u00148V]&|g\u000e\u000b\u0002OI!)!\u000b\u0001C\u00019\u0005\u0001C/Z:u\u000f\u0016$H)[:uS:\u001cGOU8x\u0007>,h\u000e^(o\t\u00164\u0017-\u001e7uQ\t\tF\u0005C\u0003V\u0001\u0011\u0005A$\u0001\u0015uKN$x)\u001a;ESN$\u0018N\\2u%><8i\\;oi>sG*\u0019:hK\u0012{W.Y5o'&TX\r\u000b\u0002UI\u0001")
public class FlinkRelMdDistinctRowCountTest
extends FlinkRelMdHandlerTestBase {
    @Test
    public void testGetDistinctRowCountOnTableScan() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.studentLogicalScan(), this.studentBatchScan(), this.studentStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnTableScan$1(this, scan);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new TableScan[]{this.empLogicalScan(), this.empBatchScan(), this.empStreamScan()})).foreach((Function1 & Serializable & scala.Serializable)scan -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnTableScan$2(this, scan);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetDistinctRowCountOnValues() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalValues(), ImmutableBitSet.of(), null));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.logicalValues().getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)FlinkRelMdUtil$.MODULE$.numDistinctVals(2.0, 2.0)), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{idx}), null)));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)FlinkRelMdUtil$.MODULE$.numDistinctVals(2.0, 2.0)), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalValues(), ImmutableBitSet.of((int[])new int[]{0, 1}), null));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.logicalValues().getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.emptyValues(), ImmutableBitSet.of((int[])new int[]{idx}), null)));
    }

    @Test
    public void testGetDistinctRowCountOnProject() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)48.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((double)17.13, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{2}), null)), (double)0.01);
        Assert.assertEquals((double)6.99, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{3}), null)), (double)0.01);
        Assert.assertEquals((double)21.9, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{4}), null)), (double)0.01);
        Assert.assertEquals((double)21.9, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{5}), null)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)35.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{6}), null));
        Assert.assertEquals((double)5.0, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{7}), null)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{8}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{9}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{10}), null));
        Assert.assertEquals((double)17.13, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{11}), null)), (double)0.01);
        RexNode expr1 = this.relBuilder().push((RelNode)this.logicalProject()).call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10))});
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of(), expr1));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)25.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{0}), expr1));
        Assert.assertEquals((double)24.68, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{1}), expr1)), (double)0.01);
        Assert.assertEquals((double)17.13, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{2}), expr1)), (double)0.01);
        Assert.assertEquals((double)6.99, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{3}), expr1)), (double)0.01);
        Assert.assertEquals((double)21.9, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{4}), expr1)), (double)0.01);
        Assert.assertEquals((double)21.9, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{5}), expr1)), (double)0.01);
        Assert.assertEquals((double)22.0, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{6}), expr1)), (double)0.01);
        Assert.assertEquals((double)5.0, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{7}), expr1)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{8}), expr1));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{9}), expr1));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{10}), expr1));
        Assert.assertEquals((double)17.13, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{11}), expr1)), (double)0.01);
        RexNode expr2 = this.relBuilder().push((RelNode)this.logicalProject()).call((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(4), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)15))}), this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(6), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)5))})});
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of(), expr2));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{0}), expr2));
        Assert.assertEquals((double)1.0, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{1}), expr2)), (double)0.01);
        Assert.assertEquals((double)17.13, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{2}), expr2)), (double)0.01);
        Assert.assertEquals((double)6.99, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{3}), expr2)), (double)0.01);
        Assert.assertEquals((double)21.9, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{4}), expr2)), (double)0.01);
        Assert.assertEquals((double)21.9, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{5}), expr2)), (double)0.01);
        Assert.assertEquals((double)1.0, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{6}), expr2)), (double)0.01);
        Assert.assertEquals((double)5.0, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{7}), expr2)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{8}), expr2));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{9}), expr2));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{10}), expr2));
        Assert.assertEquals((double)17.13, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{11}), expr2)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.logicalProject(), ImmutableBitSet.of((int[])new int[]{0, 1}), expr2));
    }

    @Test
    public void testGetDistinctRowCountOnFilter() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)25.0), (Object)this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((double)24.68, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{1}), null)), (double)0.01);
        Assert.assertEquals((double)16.46, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{2}), null)), (double)0.01);
        Assert.assertEquals((double)6.95, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{3}), null)), (double)0.01);
        Assert.assertEquals((double)21.99, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{4}), null)), (double)0.01);
        Assert.assertEquals((double)2.0, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{5}), null)), (double)0.01);
        Assert.assertNull((Object)this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{6}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)25.0), (Object)this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{0, 1}), null));
        this.relBuilder().push(this.logicalFilter());
        RexNode expr1 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.relBuilder().field(6), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)5))});
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of(), expr1));
        Assert.assertEquals((double)3.75, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{0}), expr1)), (double)0.01);
        Assert.assertEquals((double)3.74, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{1}), expr1)), (double)0.01);
        Assert.assertEquals((double)3.54, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{2}), expr1)), (double)0.01);
        Assert.assertEquals((double)2.99, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{3}), expr1)), (double)0.01);
        Assert.assertEquals((double)3.69, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{4}), expr1)), (double)0.01);
        Assert.assertEquals((double)1.71, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{5}), expr1)), (double)0.01);
        Assert.assertNull((Object)this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{6}), expr1));
        Assert.assertEquals((double)3.75, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFilter(), ImmutableBitSet.of((int[])new int[]{0, 1}), expr1)), (double)0.01);
    }

    @Test
    public void testGetDistinctRowCountOnCalc() {
        this.relBuilder().push((RelNode)this.studentLogicalScan());
        RexNode expr1 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{this.relBuilder().field(0), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10))});
        Calc calc = this.createLogicalCalc((RelNode)this.studentLogicalScan(), this.logicalProject().getRowType(), this.logicalProject().getProjects(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)expr1, (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)25.0), (Object)this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((double)24.68, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{1}), null)), (double)0.01);
        Assert.assertEquals((double)11.22, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{2}), null)), (double)0.01);
        Assert.assertEquals((double)6.67, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{3}), null)), (double)0.01);
        Assert.assertEquals((double)12.3, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{4}), null)), (double)0.01);
        Assert.assertEquals((double)12.3, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{5}), null)), (double)0.01);
        Assert.assertEquals((double)22.0, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{6}), null)), (double)0.01);
        Assert.assertEquals((double)2.5, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{7}), null)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{8}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{9}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{10}), null));
        Assert.assertEquals((double)11.22, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{11}), null)), (double)0.01);
        this.relBuilder().push((RelNode)calc);
        RexNode expr2 = this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(11), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)170))});
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of(), expr2));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)12.5), (Object)this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{0}), expr2));
        Assert.assertEquals((double)12.43, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{1}), expr2)), (double)0.01);
        Assert.assertEquals((double)11.22, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{2}), expr2)), (double)0.01);
        Assert.assertEquals((double)6.67, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{3}), expr2)), (double)0.01);
        Assert.assertEquals((double)12.3, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{4}), expr2)), (double)0.01);
        Assert.assertEquals((double)12.3, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{5}), expr2)), (double)0.01);
        Assert.assertEquals((double)11.79, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{6}), expr2)), (double)0.01);
        Assert.assertEquals((double)2.5, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{7}), expr2)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{8}), expr2));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{9}), expr2));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{10}), expr2));
        Assert.assertEquals((double)11.22, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount((RelNode)calc, ImmutableBitSet.of((int[])new int[]{11}), expr2)), (double)0.01);
    }

    @Test
    public void testGetDistinctRowCountOnExpand() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Expand[]{this.logicalExpand(), this.flinkLogicalExpand(), this.batchExpand(), this.streamExpand()})).foreach((Function1 & Serializable & scala.Serializable)expand -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnExpand$1(this, expand);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetDistinctRowCountOnExchange() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.batchExchange(), this.streamExchange()})).foreach((Function1 & Serializable & scala.Serializable)exchange -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnExchange$1(this, exchange);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetDistinctRowCountOnRank() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalRank(), this.flinkLogicalRank(), this.batchLocalRank(), this.streamRank()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnRank$1(this, rank);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount(this.batchGlobalRank(), ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount(this.batchGlobalRank(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount(this.batchGlobalRank(), ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals(null, (Object)this.mq().getDistinctRowCount(this.batchGlobalRank(), ImmutableBitSet.of((int[])new int[]{6}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount(this.batchGlobalRank(), ImmutableBitSet.of((int[])new int[]{7}), null));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Rank[]{this.logicalRank2(), this.flinkLogicalRank2(), this.batchGlobalRank2(), this.streamRank2()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnRank$2(this, rank);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalRank2(), ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)35.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalRank2(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)35.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalRank2(), ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalRank2(), ImmutableBitSet.of((int[])new int[]{2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalRank2(), ImmutableBitSet.of((int[])new int[]{3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)35.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalRank2(), ImmutableBitSet.of((int[])new int[]{4}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalRank2(), ImmutableBitSet.of((int[])new int[]{5}), null));
        Assert.assertEquals(null, (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalRank2(), ImmutableBitSet.of((int[])new int[]{6}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)35.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalRank2(), ImmutableBitSet.of((int[])new int[]{0, 1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)14.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalRank2(), ImmutableBitSet.of((int[])new int[]{3, 5}), null));
        RexNode expr = this.relBuilder().push((RelNode)this.studentLogicalScan()).call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{this.relBuilder().field(4), this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)170.0))});
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Rank[]{this.logicalRank2(), this.flinkLogicalRank2(), this.batchGlobalRank2(), this.streamRank2()})).foreach((Function1 & Serializable & scala.Serializable)rank -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnRank$3(this, expr, rank);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetDistinctRowCountOnSort() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSort(), this.flinkLogicalSort(), this.batchSort(), this.streamSort()})).foreach((Function1 & Serializable & scala.Serializable)sort -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnSort$1(this, sort);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalSortLimit(), this.flinkLogicalSortLimit(), this.batchGlobalSortLimit(), this.streamSortLimit(), this.logicalLimit(), this.flinkLogicalLimit(), this.batchLimit(), this.streamLimit()})).foreach((Function1 & Serializable & scala.Serializable)sort -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnSort$2(this, sort);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetDistinctRowCountOnAggreate() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalAgg(), this.flinkLogicalAgg(), this.batchGlobalAggWithoutLocal(), this.batchGlobalAggWithLocal()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnAggreate$1(this, agg);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalAgg(), this.flinkLogicalAgg(), this.batchGlobalAggWithoutLocal(), this.batchGlobalAggWithLocal()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnAggreate$2(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetDistinctRowCountOnWindowAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAgg(), this.flinkLogicalWindowAgg(), this.batchGlobalWindowAggWithoutLocalAgg(), this.batchGlobalWindowAggWithLocalAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnWindowAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)30.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{0, 1}), null));
        Assert.assertEquals(null, (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{0, 2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)10.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{0, 3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{1, 3}), null));
        Assert.assertEquals(null, (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAgg(), ImmutableBitSet.of((int[])new int[]{2, 3}), null));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new SingleRel[]{this.logicalWindowAggWithAuxGroup(), this.flinkLogicalWindowAggWithAuxGroup(), this.batchGlobalWindowAggWithoutLocalAggWithAuxGroup(), this.batchGlobalWindowAggWithLocalAggWithAuxGroup()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnWindowAgg$2(this, agg);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertNull((Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertNull((Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{0, 1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{0, 2}), null));
        Assert.assertNull((Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{1, 2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)10.0), (Object)this.mq().getDistinctRowCount((RelNode)this.batchLocalWindowAggWithAuxGroup(), ImmutableBitSet.of((int[])new int[]{3}), null));
    }

    @Test
    public void testGetDistinctRowCountOnOverAgg() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new CommonCalc[]{this.flinkLogicalOverAgg(), this.batchOverAgg()})).foreach((Function1 & Serializable & scala.Serializable)agg -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnOverAgg$1(this, agg);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetDistinctRowCountOnJoin() {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.mq().getDistinctRowCount(this.logicalLeftJoinNotOnUniqueKeys(), ImmutableBitSet.of(), null));
        Assert.assertEquals((double)49.999938, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}), null)), (double)1.0E-6);
        Assert.assertEquals((double)49.999998, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalInnerJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}), null)), (double)1.0E-6);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getDistinctRowCount(this.logicalInnerJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((double)5.0569644545E8, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalInnerJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}), null)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getDistinctRowCount(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((double)5.0569644545E8, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalLeftJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}), null)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getDistinctRowCount(this.logicalLeftJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((double)5.0569644545E8, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalLeftJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}), null)), (double)0.01);
        Assert.assertEquals((double)49.999938, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}), null)), (double)1.0E-6);
        Assert.assertEquals((double)49.999998, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalRightJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}), null)), (double)1.0E-6);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getDistinctRowCount(this.logicalRightJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((double)5.0569644545E8, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalRightJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}), null)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getDistinctRowCount(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((double)5.0569644545E8, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFullJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}), null)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getDistinctRowCount(this.logicalFullJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((double)5.0569644545E8, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalFullJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}), null)), (double)0.01);
        Assert.assertEquals((double)50.0, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalSemiJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}), null)), (double)0.01);
        Assert.assertEquals((double)50.0, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalSemiJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}), null)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getDistinctRowCount(this.logicalSemiJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E8), (Object)this.mq().getDistinctRowCount(this.logicalSemiJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0E7), (Object)this.mq().getDistinctRowCount(this.logicalAntiJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.9999995E8), (Object)this.mq().getDistinctRowCount(this.logicalAntiJoinOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((double)1.970438234E7, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(this.logicalAntiJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{0}), null)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.0E7), (Object)this.mq().getDistinctRowCount(this.logicalAntiJoinNotOnUniqueKeys(), ImmutableBitSet.of((int[])new int[]{1}), null));
    }

    @Test
    public void testGetDistinctRowCountOnUnion() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new RelNode[]{this.logicalUnion(), this.logicalUnionAll()})).foreach((Function1 & Serializable & scala.Serializable)union -> {
            FlinkRelMdDistinctRowCountTest.$anonfun$testGetDistinctRowCountOnUnion$1(this, union);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetDistinctRowCountOnDefault() {
        Assert.assertEquals(null, (Object)this.mq().getDistinctRowCount((RelNode)this.testRel(), ImmutableBitSet.of(), null));
        Assert.assertEquals(null, (Object)this.mq().getDistinctRowCount((RelNode)this.testRel(), ImmutableBitSet.of((int[])new int[]{0}), null));
    }

    @Test
    public void testGetDistinctRowCountOnLargeDomainSize() {
        this.relBuilder().clear();
        RelNode rel = this.relBuilder().scan(new String[]{"MyTable1"}).project(new RexNode[]{this.relBuilder().field(0), this.relBuilder().field(1), this.relBuilder().call((SqlOperator)SqlStdOperatorTable.SUBSTRING, new RexNode[]{this.relBuilder().field(3), this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10))})}).build();
        Assert.assertEquals((double)7.999999964933156E8, (double)Predef$.MODULE$.Double2double(this.mq().getDistinctRowCount(rel, ImmutableBitSet.of((int[])new int[]{0, 1, 2}), null)), (double)0.01);
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnTableScan$1(FlinkRelMdDistinctRowCountTest $this, TableScan scan) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)48.0), (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.0), (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)35.0), (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{4}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{5}), null));
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{6}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{2, 3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)40.0), (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{2, 5}), null));
        RexNode expr = $this.relBuilder().push((RelNode)$this.studentLogicalScan()).call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(3), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)16))});
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of(), expr));
        Assert.assertEquals((double)7.14, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0}), expr)), (double)0.01);
        Assert.assertEquals((double)7.12, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{1}), expr)), (double)0.01);
        Assert.assertEquals((double)6.39, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{2}), expr)), (double)0.01);
        Assert.assertEquals((double)4.67, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{3}), expr)), (double)0.01);
        Assert.assertEquals((double)6.92, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{4}), expr)), (double)0.01);
        Assert.assertEquals((double)1.96, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{5}), expr)), (double)0.01);
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{6}), expr));
        Assert.assertEquals((double)7.14, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{2, 3}), expr)), (double)0.01);
        Assert.assertEquals((double)7.01, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{2, 5}), expr)), (double)0.01);
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnTableScan$2(FlinkRelMdDistinctRowCountTest $this, TableScan scan) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of(), null));
        Assert.assertNull((Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0}), null));
        RexNode condition = $this.relBuilder().push((RelNode)$this.studentLogicalScan()).call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(0), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))});
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of(), condition));
        Assert.assertNull((Object)$this.mq().getDistinctRowCount((RelNode)scan, ImmutableBitSet.of((int[])new int[]{0}), condition));
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnExpand$1(FlinkRelMdDistinctRowCountTest $this, Expand expand) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)48.0), (Object)$this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.0), (Object)$this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)35.0), (Object)$this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{4}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)$this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{5}), null));
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{6}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)3.0), (Object)$this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{7}), null));
        $this.relBuilder().clear();
        $this.relBuilder().push((RelNode)expand);
        RexNode expr = $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(6), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)5))});
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of(), expr));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.5), (Object)$this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{0}), expr));
        Assert.assertEquals((double)7.47, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{1}), expr)), (double)0.01);
        Assert.assertEquals((double)6.67, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{2}), expr)), (double)0.01);
        Assert.assertEquals((double)4.8, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{3}), expr)), (double)0.01);
        Assert.assertEquals((double)7.25, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{4}), expr)), (double)0.01);
        Assert.assertEquals((double)1.97, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{5}), expr)), (double)0.01);
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{6}), expr));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)3.0), (Object)$this.mq().getDistinctRowCount((RelNode)expand, ImmutableBitSet.of((int[])new int[]{7}), expr));
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnExchange$1(FlinkRelMdDistinctRowCountTest $this, RelNode exchange) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)48.0), (Object)$this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.0), (Object)$this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)35.0), (Object)$this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{4}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)$this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{5}), null));
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{6}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{2, 3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)40.0), (Object)$this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{2, 5}), null));
        RexNode expr = $this.relBuilder().push((RelNode)$this.studentLogicalScan()).call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(3), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)16))});
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of(), expr));
        Assert.assertEquals((double)7.14, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{0}), expr)), (double)0.01);
        Assert.assertEquals((double)7.12, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{1}), expr)), (double)0.01);
        Assert.assertEquals((double)6.39, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{2}), expr)), (double)0.01);
        Assert.assertEquals((double)4.67, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{3}), expr)), (double)0.01);
        Assert.assertEquals((double)6.92, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{4}), expr)), (double)0.01);
        Assert.assertEquals((double)1.96, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{5}), expr)), (double)0.01);
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{6}), expr));
        Assert.assertEquals((double)7.14, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{2, 3}), expr)), (double)0.01);
        Assert.assertEquals((double)7.01, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount(exchange, ImmutableBitSet.of((int[])new int[]{2, 5}), expr)), (double)0.01);
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnRank$1(FlinkRelMdDistinctRowCountTest $this, RelNode rank) {
        BatchPhysicalRank batchPhysicalRank;
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount(rank, ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)$this.mq().getDistinctRowCount(rank, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)$this.mq().getDistinctRowCount(rank, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)$this.mq().getDistinctRowCount(rank, ImmutableBitSet.of((int[])new int[]{2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)$this.mq().getDistinctRowCount(rank, ImmutableBitSet.of((int[])new int[]{3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)$this.mq().getDistinctRowCount(rank, ImmutableBitSet.of((int[])new int[]{4}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)$this.mq().getDistinctRowCount(rank, ImmutableBitSet.of((int[])new int[]{5}), null));
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount(rank, ImmutableBitSet.of((int[])new int[]{6}), null));
        RelNode relNode = rank;
        if (relNode instanceof BatchPhysicalRank && !(batchPhysicalRank = (BatchPhysicalRank)relNode).isGlobal()) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)$this.mq().getDistinctRowCount(rank, ImmutableBitSet.of((int[])new int[]{7}), null));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)$this.mq().getDistinctRowCount(rank, ImmutableBitSet.of((int[])new int[]{0, 1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)$this.mq().getDistinctRowCount(rank, ImmutableBitSet.of((int[])new int[]{3, 5}), null));
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnRank$2(FlinkRelMdDistinctRowCountTest $this, Rank rank) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)21.0), (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)21.0), (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.0), (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)21.0), (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{4}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{5}), null));
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{6}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)3.0), (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{7}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)21.0), (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{0, 1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)14.0), (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{3, 5}), null));
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnRank$3(FlinkRelMdDistinctRowCountTest $this, RexNode expr$1, Rank rank) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of(), expr$1));
        Assert.assertEquals((double)9.46, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{0}), expr$1)), (double)0.01);
        Assert.assertEquals((double)9.42, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{1}), expr$1)), (double)0.01);
        Assert.assertEquals((double)8.16, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{2}), expr$1)), (double)0.01);
        Assert.assertEquals((double)5.43, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{3}), expr$1)), (double)0.01);
        Assert.assertEquals((double)9.06, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{4}), expr$1)), (double)0.01);
        Assert.assertEquals((double)1.99, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{5}), expr$1)), (double)0.01);
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{6}), expr$1));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)3.0), (Object)$this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{7}), expr$1));
        Assert.assertEquals((double)9.46, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)rank, ImmutableBitSet.of((int[])new int[]{0, 1}), expr$1)), (double)0.01);
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnSort$1(FlinkRelMdDistinctRowCountTest $this, RelNode sort) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)48.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)35.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{4}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{5}), null));
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{6}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{2, 3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)40.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{2, 5}), null));
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnSort$2(FlinkRelMdDistinctRowCountTest $this, RelNode sort) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{4}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{5}), null));
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{6}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{2, 3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getDistinctRowCount(sort, ImmutableBitSet.of((int[])new int[]{2, 5}), null));
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnAggreate$1(FlinkRelMdDistinctRowCountTest $this, SingleRel agg) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)3.5), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)3.5), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{4}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)10.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{5}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 5}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 5}), null));
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnAggreate$2(FlinkRelMdDistinctRowCountTest $this, SingleRel agg) {
        $this.relBuilder().clear();
        RexNode expr1 = $this.relBuilder().push((RelNode)agg).call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(1), $this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)3.5))});
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of(), expr1));
        Assert.assertEquals((double)4.33, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}), expr1)), (double)0.01);
        Assert.assertEquals((double)1.93, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1}), expr1)), (double)0.01);
        Assert.assertEquals((double)1.93, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{2}), expr1)), (double)0.01);
        Assert.assertEquals((double)2.99, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3}), expr1)), (double)0.01);
        Assert.assertEquals((double)2.99, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{4}), expr1)), (double)0.01);
        Assert.assertEquals((double)4.33, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{5}), expr1)), (double)0.01);
        Assert.assertEquals((double)4.33, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}), expr1)), (double)0.01);
        Assert.assertEquals((double)4.33, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 5}), expr1)), (double)0.01);
        Assert.assertEquals((double)4.33, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 5}), expr1)), (double)0.01);
        RexNode expr2 = $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(0), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)15))});
        Assert.assertEquals((double)4.67, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}), expr2)), (double)0.01);
        Assert.assertEquals((double)1.0, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1}), expr2)), (double)0.01);
        Assert.assertEquals((double)10.0, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{5}), expr2)), (double)0.01);
        Assert.assertEquals((double)4.67, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}), expr2)), (double)0.01);
        Assert.assertEquals((double)10.0, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 5}), expr2)), (double)0.01);
        RexNode expr3 = $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{$this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(0), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)15))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(3), $this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)170.0))})});
        Assert.assertEquals((double)1.75, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}), expr3)), (double)0.01);
        Assert.assertEquals((double)1.53, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3}), expr3)), (double)0.01);
        Assert.assertEquals((double)1.75, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{5}), expr3)), (double)0.01);
        Assert.assertEquals((double)1.75, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 3}), expr3)), (double)0.01);
        Assert.assertEquals((double)1.75, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3, 5}), expr3)), (double)0.01);
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnWindowAgg$1(FlinkRelMdDistinctRowCountTest $this, SingleRel agg) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)30.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}), null));
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3}), null));
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 3}), null));
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 3}), null));
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{2, 3}), null));
        $this.relBuilder().clear();
        RexNode pred = $this.relBuilder().push((RelNode)agg).call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(1), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10))});
        Assert.assertEquals((double)Predef$.MODULE$.Double2double(FlinkRelMdUtil$.MODULE$.adaptNdvBasedOnSelectivity(Predef$.MODULE$.double2Double(50.0), Predef$.MODULE$.double2Double(5.0), Predef$.MODULE$.double2Double(0.5))), (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1}), pred)), (double)1.0E-6);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)25.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}), pred));
        RexNode pred1 = $this.relBuilder().push((RelNode)agg).and(new RexNode[]{$this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(1), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(2), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(4), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)100000))})});
        Assert.assertEquals((double)Predef$.MODULE$.Double2double(FlinkRelMdUtil$.MODULE$.adaptNdvBasedOnSelectivity(Predef$.MODULE$.double2Double(50.0), Predef$.MODULE$.double2Double(5.0), Predef$.MODULE$.double2Double(0.075))), (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1}), pred1)), (double)1.0E-6);
        Assert.assertEquals((double)3.75, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}), pred1)), (double)0.01);
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnWindowAgg$2(FlinkRelMdDistinctRowCountTest $this, SingleRel agg) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)48.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1, 2}), null));
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3}), null));
        $this.relBuilder().clear();
        RexNode pred = $this.relBuilder().push((RelNode)agg).call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(1), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10))});
        Assert.assertEquals((double)Predef$.MODULE$.Double2double(FlinkRelMdUtil$.MODULE$.adaptNdvBasedOnSelectivity(Predef$.MODULE$.double2Double(50.0), Predef$.MODULE$.double2Double(48.0), Predef$.MODULE$.double2Double(0.8))), (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1}), pred)), (double)1.0E-6);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)40.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}), pred));
        RexNode pred1 = $this.relBuilder().push((RelNode)agg).and(new RexNode[]{$this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(1), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)10))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(2), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)1))}), $this.relBuilder().call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{$this.relBuilder().field(4), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)100000))})});
        Assert.assertEquals((double)Predef$.MODULE$.Double2double(FlinkRelMdUtil$.MODULE$.adaptNdvBasedOnSelectivity(Predef$.MODULE$.double2Double(50.0), Predef$.MODULE$.double2Double(48.0), Predef$.MODULE$.double2Double(0.12))), (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1}), pred1)), (double)1.0E-6);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)6.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 1}), pred1));
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnOverAgg$1(FlinkRelMdDistinctRowCountTest $this, CommonCalc agg) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)48.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)20.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)7.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{3}), null));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(4), agg.getRowType().getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> Assert.assertNull((Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{idx}), null)));
        Assert.assertNull((Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 5}), null));
        $this.relBuilder().clear();
        RexNode expr1 = $this.relBuilder().push((RelNode)agg).call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(8), $this.relBuilder().literal((Object)BoxesRunTime.boxToDouble((double)3.5))});
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of(), expr1));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)25.0), (Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0}), expr1));
        Assert.assertEquals((double)24.68, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{1}), expr1)), (double)0.01);
        Assert.assertNull((Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{5}), expr1));
        Assert.assertNull((Object)$this.mq().getDistinctRowCount((RelNode)agg, ImmutableBitSet.of((int[])new int[]{0, 5}), expr1));
    }

    public static final /* synthetic */ void $anonfun$testGetDistinctRowCountOnUnion$1(FlinkRelMdDistinctRowCountTest $this, RelNode union) {
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)$this.mq().getDistinctRowCount(union, ImmutableBitSet.of(), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)4.0E7), (Object)$this.mq().getDistinctRowCount(union, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)8.00002556E8), (Object)$this.mq().getDistinctRowCount(union, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2263.0), (Object)$this.mq().getDistinctRowCount(union, ImmutableBitSet.of((int[])new int[]{2}), null));
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2.45748586E8), (Object)$this.mq().getDistinctRowCount(union, ImmutableBitSet.of((int[])new int[]{3}), null));
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount(union, ImmutableBitSet.of((int[])new int[]{4}), null));
        $this.relBuilder().clear();
        RexNode expr1 = $this.relBuilder().push(union).call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{$this.relBuilder().field(4), $this.relBuilder().literal((Object)BoxesRunTime.boxToInteger((int)20))});
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)4.0E7), (Object)$this.mq().getDistinctRowCount(union, ImmutableBitSet.of((int[])new int[]{0}), expr1));
        Assert.assertEquals((double)6.4646720246E8, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount(union, ImmutableBitSet.of((int[])new int[]{1}), expr1)), (double)0.01);
        Assert.assertEquals((Object)BoxesRunTime.boxToDouble((double)2263.0), (Object)$this.mq().getDistinctRowCount(union, ImmutableBitSet.of((int[])new int[]{2}), expr1));
        Assert.assertEquals((double)2.4461260135E8, (double)Predef$.MODULE$.Double2double($this.mq().getDistinctRowCount(union, ImmutableBitSet.of((int[])new int[]{3}), expr1)), (double)0.01);
        Assert.assertEquals(null, (Object)$this.mq().getDistinctRowCount(union, ImmutableBitSet.of((int[])new int[]{4}), expr1));
    }
}

